/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.aseplugin.bo.dlg;

import com.sybase.aseplugin.ASEImages;
import com.sybase.aseplugin.ASEMessageText;
import com.sybase.aseplugin.ASEUtils;
import com.sybase.central.editor.PrinterJobListener;
import com.sybase.central.editor.SCEditor;
import com.sybase.util.DialogUtils;
import com.sybase.util.UIUtils;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class PrintingDialog
extends JDialog
implements PrinterJobListener,
ActionListener,
Runnable,
WindowListener {
    private SCEditor _editor;
    private JLabel _status;
    private JButton _cancel;
    private boolean _isPrinting = false;
    private int _currentPage;

    public static void create(Frame frame, String string, SCEditor sCEditor) {
        PrintingDialog printingDialog = new PrintingDialog(frame, string, sCEditor);
        sCEditor.print(string, (PrinterJobListener)printingDialog);
    }

    private PrintingDialog(Frame frame, String string, SCEditor sCEditor) {
        super(frame, string, true);
        this._editor = sCEditor;
        this.createUI(frame);
    }

    private void createUI(Component component) {
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        this._status = new JLabel(ASEUtils.getString("PRINT_SENT_STARTING_PRINT_JOB"), new ImageIcon(ASEImages.getExecuteImage()), 2);
        Dimension dimension = this._status.getPreferredSize();
        if (dimension.width < 300) {
            dimension.width = 300;
            this._status.setPreferredSize(dimension);
        }
        jPanel.add(this._status);
        jPanel.add(Box.createVerticalStrut(10));
        this._cancel = new JButton(ASEUtils.getString("MSG_CANCEL"));
        this._cancel.addActionListener(this);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        jPanel2.add(Box.createHorizontalGlue());
        jPanel2.add(this._cancel);
        jPanel2.add(Box.createHorizontalGlue());
        jPanel2.setAlignmentX(0.0f);
        jPanel.add(jPanel2);
        this.getContentPane().add(jPanel);
        this.addWindowListener(this);
        this.pack();
        this.setLocationRelativeTo(component);
        this.setResizable(false);
    }

    private void destroy() {
        this.removeWindowListener(this);
        if (this._cancel != null) {
            this._cancel.removeActionListener(this);
            this._cancel = null;
        }
        this._editor = null;
        this._status = null;
        DialogUtils.removeComponents((Container)this);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this._cancel) {
            this.handleCancel();
        }
    }

    private void handleCancel() {
        this._editor.cancelPrint();
        this.setVisible(false);
        this.destroy();
    }

    public void printingStarted() {
    }

    public void printingStopped() {
        this._isPrinting = false;
        SwingUtilities.invokeLater(this);
    }

    public void printingPage(int n) {
        this._isPrinting = true;
        this._currentPage = n;
        SwingUtilities.invokeLater(this);
    }

    @Override
    public void run() {
        if (this._isPrinting) {
            if (!this.isVisible()) {
                UIUtils.ensureWindowIsVisible((Window)this);
                this.setVisible(true);
            }
            if (this._status != null) {
                ASEMessageText aSEMessageText = new ASEMessageText(ASEUtils.getString("PRINT_SENT_PRINTING_PAGE"), Integer.toString(this._currentPage));
                this._status.setText(aSEMessageText.toString());
            }
        } else {
            this.setVisible(false);
            this.destroy();
        }
    }

    @Override
    public void windowClosing(WindowEvent windowEvent) {
        if (this._isPrinting) {
            this.handleCancel();
        }
    }

    @Override
    public void windowActivated(WindowEvent windowEvent) {
    }

    @Override
    public void windowClosed(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeactivated(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeiconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowIconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowOpened(WindowEvent windowEvent) {
    }
}

