/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.aseplugin.bo.dlg;

import com.sybase.aseplugin.ASEUtils;
import com.sybase.aseplugin.bo.DatabaseDeviceBO;
import com.sybase.aseplugin.bo.DatabaseDevicesCtrBO;
import com.sybase.aseplugin.bo.Support;
import com.sybase.aseplugin.bo.dlg.ASEPageController;
import com.sybase.aseplugin.go.dlg.ResizeDeviceDlgGOPage;
import com.sybase.aseplugin.so.DatabaseDeviceSO;
import com.sybase.aseplugin.so.Utility;
import com.sybase.central.SCDialogSupport;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

class ResizeDeviceDialogBOPage
extends ASEPageController
implements DocumentListener,
ActionListener {
    private ResizeDeviceDlgGOPage _go;
    private SCDialogSupport _ds;
    private DatabaseDeviceSO _so;
    private DatabaseDeviceBO _bo;
    private String _sizeUnit;

    public ResizeDeviceDialogBOPage(SCDialogSupport sCDialogSupport, ResizeDeviceDlgGOPage resizeDeviceDlgGOPage, DatabaseDeviceBO databaseDeviceBO, DatabaseDeviceSO databaseDeviceSO) {
        super(sCDialogSupport, (JPanel)((Object)resizeDeviceDlgGOPage));
        this._go = resizeDeviceDlgGOPage;
        this._ds = sCDialogSupport;
        this._bo = databaseDeviceBO;
        this._so = databaseDeviceSO;
        this._go.sizeTextLabel.setText(this._so.getSize() + "  " + ASEUtils.getString("MSG_MB"));
    }

    @Override
    public String getHelpID() {
        return "HELP_DATABASE_DEVICE_DLG_RESIZE_1252";
    }

    @Override
    public void init() {
        this.enableOkButton(false);
        this._go.incrementalSizeText.getDocument().addDocumentListener(this);
        this._go.unitComboBox.setSelectedIndex(2);
        this._go.unitComboBox.addActionListener((ActionListener)this);
        this._sizeUnit = ASEUtils.getString("MSG_MB");
        this._ds.setDefaultButtonById(2);
        if (this._so.isSkipAllocApplicable()) {
            this._go.skipAllocCheckBox.setSelected(true);
            this._go.skipAllocCheckBox.addActionListener((ActionListener)this);
            this._so.setSkipAlloc(true);
        } else {
            this._go.skipAllocCheckBox.setVisible(false);
        }
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.textValueChanged();
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.textValueChanged();
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.textValueChanged();
    }

    public void textValueChanged() {
        this.enableOkButton(this._go.incrementalSizeText.getText().length() > 0);
        this._ds.setDefaultButtonById(1);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this._so.setSkipAlloc(this._go.skipAllocCheckBox.isSelected());
        if (actionEvent.getSource() == this._go.unitComboBox) {
            String string = (String)this._go.unitComboBox.getSelectedItem();
            if (this._go.incrementalSizeText.getText().length() > 0) {
                String string2 = this._go.incrementalSizeText.getText();
                double d = new Double(string2);
                if (this._sizeUnit.equals(ASEUtils.getString("MSG_MB"))) {
                    if (ASEUtils.getString("MSG_PAGES").equals(string)) {
                        d = Utility.getMBToPageSize(this._so.getConnection(), d);
                    } else if (ASEUtils.getString("MSG_KB").equals(string)) {
                        d = Utility.getMBToKB(d);
                    } else if (ASEUtils.getString("MSG_GB").equals(string)) {
                        d = Utility.getMBToGB(d);
                    }
                } else if (this._sizeUnit.equals(ASEUtils.getString("MSG_GB"))) {
                    if (ASEUtils.getString("MSG_PAGES").equals(string)) {
                        d = Utility.getGBToPageSize(this._so.getConnection(), d);
                    } else if (ASEUtils.getString("MSG_KB").equals(string)) {
                        d = Utility.getGBToKB(d);
                    } else if (ASEUtils.getString("MSG_MB").equals(string)) {
                        d = Utility.getKBToMB(Utility.getGBToKB(d));
                    }
                } else if (this._sizeUnit.equals(ASEUtils.getString("MSG_KB"))) {
                    if (ASEUtils.getString("MSG_PAGES").equals(string)) {
                        d = Utility.getKBToPageSize(this._so.getConnection(), d);
                    } else if (ASEUtils.getString("MSG_GB").equals(string)) {
                        d = Utility.getKBToGB(d);
                    } else if (ASEUtils.getString("MSG_MB").equals(string)) {
                        d = Utility.getKBToMB(d);
                    }
                } else if (this._sizeUnit.equals(ASEUtils.getString("MSG_PAGES"))) {
                    if (ASEUtils.getString("MSG_MB").equals(string)) {
                        d = Utility.getPageSizeToMB(this._so.getConnection(), d);
                    } else if (ASEUtils.getString("MSG_GB").equals(string)) {
                        d = Utility.getPageSizeToGB(this._so.getConnection(), d);
                    } else if (ASEUtils.getString("MSG_KB").equals(string)) {
                        d = Utility.getPageSizeToKB(this._so.getConnection(), d);
                    }
                }
                this._go.incrementalSizeText.setText(Double.toString(d));
            }
            this._sizeUnit = string;
        }
    }

    public boolean onOk() {
        String string = this._go.incrementalSizeText.getText();
        double d = new Double(string);
        String string2 = (String)this._go.unitComboBox.getSelectedItem();
        if (ASEUtils.getString("MSG_PAGES").equals(string2)) {
            d = Utility.getPageSizeToMB(this._so.getConnection(), d);
        } else if (ASEUtils.getString("MSG_KB").equals(string2)) {
            d /= 1024.0;
        } else if (ASEUtils.getString("MSG_GB").equals(string2)) {
            d *= 1024.0;
        }
        try {
            if (d >= 0.0) {
                this._so.increaseDiskSize(d);
                ((DatabaseDevicesCtrBO)this._bo.getParent()).refresh();
            }
        }
        catch (SQLException sQLException) {
            Support.showDetailsError(this._so.getConnection(), this.getClass(), (Container)this.getJDialog(), sQLException.getMessage(), sQLException);
            return false;
        }
        return true;
    }
}

