/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.aseplugin.bo.dlg;

import com.sybase.aseplugin.ASEUtils;
import com.sybase.aseplugin.bo.ContainerViewBO;
import com.sybase.aseplugin.bo.RoleBO;
import com.sybase.aseplugin.bo.ServerBO;
import com.sybase.aseplugin.bo.Support;
import com.sybase.aseplugin.bo.dlg.ASEDialogController;
import com.sybase.aseplugin.bo.dlg.ASEPageController;
import com.sybase.aseplugin.go.dlg.RoleActivationDialogGOPage;
import com.sybase.aseplugin.so.ServerSO;
import com.sybase.aseplugin.sql.SQLs;
import com.sybase.central.SCDialogController;
import com.sybase.central.SCDialogSupport;
import com.sybase.central.SCPageController;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class RoleActivationDialog
extends ASEDialogController {
    private SCDialogSupport _ds;
    private ServerBO _srvBO;
    private ServerSO _srvSO;
    boolean populated = false;
    boolean canAccessSyTbl = false;

    public RoleActivationDialog(SCDialogSupport sCDialogSupport, ServerBO serverBO) {
        super(sCDialogSupport, new SCPageController[1]);
        this._pageControllers[0] = new RoleActivationDialogBOPage(sCDialogSupport);
        this._ds = sCDialogSupport;
        this._srvBO = serverBO;
        this._srvSO = (ServerSO)serverBO.getSO();
        sCDialogSupport.setDialogController((SCDialogController)this);
        sCDialogSupport.setTitle(ASEUtils.getString("CONTEXT_MENU_ROLE_ACTIVATION"));
        sCDialogSupport.setResizable(true);
        sCDialogSupport.setModal(false);
    }

    class RoleActivationDialogBOPage
    extends ASEPageController
    implements ListSelectionListener,
    ActionListener {
        private RoleActivationDialogGOPage _go;
        String yes;
        String no;
        String activeRole;
        String deactiveRole;
        String roleName;
        String active;
        String def;
        String pwText;

        public RoleActivationDialogBOPage(SCDialogSupport sCDialogSupport) {
            super(sCDialogSupport, (JPanel)((Object)new RoleActivationDialogGOPage()));
            this.yes = ASEUtils.getString("MSG_YES");
            this.no = ASEUtils.getString("MSG_NO");
            this.activeRole = ASEUtils.getString("BTTN_ACTIVATE_ROLE");
            this.deactiveRole = ASEUtils.getString("BTTN_DEACTIVATE_ROLE");
            this.roleName = ASEUtils.getString("MSG_ROLE_TYPE");
            this.active = ASEUtils.getString("MSG_ACTIVE");
            this.def = ASEUtils.getString("MSG_DEFAULT_TYPE");
            this.pwText = ASEUtils.getString("DISP_PASSWORD_TEXT");
            this._go = (RoleActivationDialogGOPage)((Object)this.getJPanel());
            this._go.rolesMultiList.addListSelectionListener((ListSelectionListener)this);
            this._go.propertiesButton.addActionListener((ActionListener)this);
        }

        @Override
        public String getHelpID() {
            return "SERVER_DLG_ROLE_ACTIVATION_15";
        }

        @Override
        public void init() {
            int n;
            RoleActivationDialog.this._ds.getStandardButtonById(2).setText(ASEUtils.getString("MENU_CLOSE"));
            this.populateData();
            SCDialogSupport sCDialogSupport = RoleActivationDialog.this._ds;
            RoleActivationDialog.this._ds;
            FontMetrics fontMetrics = this._go.getFontMetrics(sCDialogSupport.getStandardButtonById(1).getFont());
            if (fontMetrics.stringWidth(this.deactiveRole) > fontMetrics.stringWidth(this.activeRole)) {
                int n2 = fontMetrics.stringWidth(this.deactiveRole);
                SCDialogSupport sCDialogSupport2 = RoleActivationDialog.this._ds;
                RoleActivationDialog.this._ds;
                n = n2 + (int)sCDialogSupport2.getStandardButtonById(1).getPreferredSize().getWidth();
            } else {
                int n3 = fontMetrics.stringWidth(this.activeRole);
                SCDialogSupport sCDialogSupport3 = RoleActivationDialog.this._ds;
                RoleActivationDialog.this._ds;
                n = n3 + (int)sCDialogSupport3.getStandardButtonById(1).getPreferredSize().getWidth();
            }
            int n4 = n;
            SCDialogSupport sCDialogSupport4 = RoleActivationDialog.this._ds;
            RoleActivationDialog.this._ds;
            int n5 = (int)sCDialogSupport4.getStandardButtonById(1).getPreferredSize().getHeight();
            SCDialogSupport sCDialogSupport5 = RoleActivationDialog.this._ds;
            RoleActivationDialog.this._ds;
            sCDialogSupport5.getStandardButtonById(1).setPreferredSize(new Dimension(n4, n5));
            RoleActivationDialog.this._ds.getStandardButtonById(1).setText(this.activeRole);
            this._go.propertiesButton.setEnabled(false);
            SCDialogSupport sCDialogSupport6 = RoleActivationDialog.this._ds;
            RoleActivationDialog.this._ds;
            sCDialogSupport6.getStandardButtonById(1).setMnemonic(ASEUtils.getMnemonic("MNEM_ACTIVATE_ROLE"));
            this.setOKText();
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            this.setOKText();
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int[] nArray = this._go.rolesMultiList.getSelectedRows();
            for (int i = 0; i < nArray.length; ++i) {
                String string = this._go.rolesMultiList.getStringAt(nArray[i], 0);
                ContainerViewBO.openRoleProperties(RoleActivationDialog.this._srvBO, string);
            }
        }

        @Override
        public void populateData() {
            this.populateData(-1, -1);
        }

        public void populateData(int n, int n2) {
            try {
                Vector vector = RoleActivationDialog.this._srvSO.getActivationRoles();
                this._go.rolesMultiList.clear();
                for (int i = 0; i < vector.size(); ++i) {
                    Vector vector2 = (Vector)vector.elementAt(i);
                    if (i == 0 && !RoleActivationDialog.this.populated) {
                        if (vector2.size() == 4) {
                            RoleActivationDialog.this.canAccessSyTbl = true;
                            this._go.rolesMultiList.setColumnHeadings((Object[])new String[]{this.roleName, this.active, this.def, this.pwText});
                        } else {
                            RoleActivationDialog.this.canAccessSyTbl = false;
                            this._go.rolesMultiList.setColumnHeadings((Object[])new String[]{this.roleName, this.active});
                            this._go.propertiesButton.setVisible(false);
                        }
                        RoleActivationDialog.this.populated = true;
                    }
                    this._go.rolesMultiList.setColumnHasIconTextData(0, true);
                    this._go.rolesMultiList.addRowWithIcon((Icon)RoleBO.ROLE_ICON, (Vector)vector.elementAt(i));
                }
                this._go.rolesMultiList.setInitialColumnWidths();
                this._go.passwdField.setText("");
                if (n != -1) {
                    this._go.rolesMultiList.setRowSelectionInterval(n, n2);
                }
            }
            catch (SQLException sQLException) {
                Support.showDetailsError(RoleActivationDialog.this._srvSO.getConnection(), this.getClass(), (Container)this.getJDialog(), sQLException.getMessage(), sQLException);
            }
        }

        public void setOKText() {
            int n;
            int[] nArray = this._go.rolesMultiList.getSelectedRows();
            if (nArray.length > 1) {
                for (n = 0; n < nArray.length - 1; ++n) {
                    String string = this._go.rolesMultiList.getStringAt(nArray[n], 1);
                    for (int i = n + 1; i < nArray.length; ++i) {
                        String string2 = this._go.rolesMultiList.getStringAt(nArray[i], 1);
                        if (string.equals(string2)) continue;
                        this.enableOkButton(false);
                        return;
                    }
                }
            }
            if (nArray.length > 0 && nArray[0] != -1) {
                n = this._go.rolesMultiList.getStringAt(nArray[0], 1).equals(this.yes) ? 1 : 0;
                if (n != 0) {
                    RoleActivationDialog.this._ds.getStandardButtonById(1).setText(this.deactiveRole);
                } else {
                    RoleActivationDialog.this._ds.getStandardButtonById(1).setText(this.activeRole);
                }
                SCDialogSupport sCDialogSupport = RoleActivationDialog.this._ds;
                RoleActivationDialog.this._ds;
                sCDialogSupport.getStandardButtonById(1).setMnemonic(ASEUtils.getMnemonic("MNEM_ACTIVATE_ROLE"));
                this._go.propertiesButton.setEnabled(true);
                this.enableOkButton(true);
                if (n == 0) {
                    if (RoleActivationDialog.this.canAccessSyTbl) {
                        boolean bl = this._go.rolesMultiList.getStringAt(nArray[0], 3).equals(this.yes);
                        this._go.passwdLabel.setEnabled(bl);
                        this._go.passwdField.setEnabled(bl);
                    } else {
                        this._go.passwdLabel.setEnabled(true);
                        this._go.passwdField.setEnabled(true);
                    }
                } else {
                    this._go.passwdLabel.setEnabled(false);
                    this._go.passwdField.setEnabled(false);
                }
            } else {
                this.enableOkButton(false);
                this._go.passwdLabel.setEnabled(false);
                this._go.passwdField.setEnabled(false);
            }
        }

        @Override
        public boolean closeDialogWhenPreviewIsSuccessful() {
            return false;
        }

        public boolean onOk() {
            String string = new String("");
            int[] nArray = this._go.rolesMultiList.getSelectedRows();
            for (int i = 0; i < nArray.length; ++i) {
                if (nArray[i] == -1) continue;
                String string2 = this._go.rolesMultiList.getStringAt(nArray[i], 0);
                String string3 = RoleActivationDialog.this._ds.getStandardButtonById(1).getText().equals(this.deactiveRole) ? SQLs.getString("set role {0} off", string2) : (this._go.passwdField.isEnabled() && this._go.passwdField.getPassword().length > 0 ? SQLs.getString("set role {0} with passwd ''{1}'' on", string2, new String(this._go.passwdField.getPassword()).trim()) : SQLs.getString("set role {0} on", string2));
                try {
                    RoleActivationDialog.this._srvSO.getConnection().executeCommand(string3);
                    continue;
                }
                catch (SQLException sQLException) {
                    if (string.length() > 0) {
                        string = string + "\n\n";
                    }
                    string = string + sQLException.getMessage();
                }
            }
            if (string.length() > 0) {
                Support.showError(RoleActivationDialog.this._srvSO.getConnection(), this.getClass(), this.getJDialog(), string);
            }
            if (Support.getEnableSQLPreview()) {
                return true;
            }
            if (nArray.length > 0) {
                this.populateData(nArray[0], nArray[nArray.length - 1]);
                this._go.propertiesButton.setEnabled(true);
            } else {
                this.populateData();
                this._go.propertiesButton.setEnabled(false);
            }
            return false;
        }
    }
}

