/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.aseplugin.bo.dlg;

import com.sybase.asa.ASASpinBox;
import com.sybase.asa.ASASpinBoxChangeEvent;
import com.sybase.asa.ASASpinBoxChangeListener;
import com.sybase.ase.sdcadmin.config.ICluster;
import com.sybase.ase.sdcadmin.config.IServer;
import com.sybase.ase.sdcadmin.util.PortUtil;
import com.sybase.aseplugin.ASEMessageText;
import com.sybase.aseplugin.ASEUtils;
import com.sybase.aseplugin.bo.ContainerViewBO;
import com.sybase.aseplugin.bo.ServerBO;
import com.sybase.aseplugin.bo.Support;
import com.sybase.aseplugin.bo.dlg.ASEDocPageController;
import com.sybase.aseplugin.bo.dlg.MessageDialogWithOption;
import com.sybase.aseplugin.bo.wiz.SDCClusterWizard;
import com.sybase.aseplugin.go.dlg.SDCClusterInstanceDlgGOPage;
import com.sybase.aseplugin.so.SDCClusterSO;
import com.sybase.aseplugin.so.ServerSO;
import com.sybase.aseplugin.util.DeviceValidator;
import com.sybase.aseplugin.util.SDCClusterAgentProxy;
import com.sybase.aseplugin.util.SDCClusterAgentUtils;
import com.sybase.central.SCDialogSupport;
import com.sybase.ua.AgentConnectionException;
import com.sybase.ua.AuthorizationException;
import com.sybase.ua.JMXException;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.rmi.RemoteException;
import java.util.List;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.text.Document;

class SDCClusterInstanceDialogBOPage
extends ASEDocPageController
implements ItemListener,
ActionListener,
ASASpinBoxChangeListener {
    private SDCClusterInstanceDlgGOPage _go;
    private IServer _server;
    private SDCClusterSO _so;
    private boolean editMode;
    private boolean isQueryPortValidated = false;
    private boolean isNetworkPortsValidated = false;
    private boolean _isBackupServerPortValidated = false;
    private boolean _isXPServerPortValidated = false;
    private boolean _isMonitorServerPortValidated = false;
    private boolean userSetStartPort = false;
    private List clusterNodes = null;
    private int wizardFlag;
    private String initName = "";
    private boolean _isMultiBackupServersActive = false;
    private boolean _isXPServerActive = false;
    private boolean _isMonitorServerActive = false;
    private boolean _isLocalInstallActive = false;
    private boolean _isLDAPActive = false;
    private boolean _isUpgradeActive = false;
    private int _currentQueryPort;
    private int _currentBSPort;
    private int _currentXPPort;
    private int _currentMSPort;
    private SDCClusterWizard _wiz;
    public static final int ON_ERR_EXIT = 999;
    public static final String LLT_PREFIX = "LLT";

    public SDCClusterInstanceDialogBOPage(SCDialogSupport sCDialogSupport, IServer iServer, SDCClusterSO sDCClusterSO, SDCClusterInstanceDlgGOPage sDCClusterInstanceDlgGOPage, int n, boolean bl, SDCClusterWizard sDCClusterWizard) {
        super(sCDialogSupport, (JPanel)((Object)sDCClusterInstanceDlgGOPage));
        this._go = sDCClusterInstanceDlgGOPage;
        this._server = iServer;
        this._so = sDCClusterSO;
        this.wizardFlag = n;
        this.editMode = bl;
        this._wiz = sDCClusterWizard;
        this.initLocalInstallationActive();
        this.initAuxServerActive();
        this.initLDAPActive();
        this.initUpgradeActive();
    }

    private void initLDAPActive() {
        this._isLDAPActive = this._so.isLDAPConfigured();
        this._go.interfaceLabel.setVisible(!this._isLDAPActive);
        this._go.interfaceTextField.setVisible(!this._isLDAPActive);
    }

    private void initUpgradeActive() {
        this._isUpgradeActive = this.wizardFlag == 2;
        this._go.queryPortSpinBox.setEnabled(!this._isUpgradeActive);
        this._go.checkPortButton.setEnabled(!this._isUpgradeActive);
    }

    private void initLocalInstallationActive() {
        try {
            this._isLocalInstallActive = this._so.isLocalInstallation();
        }
        catch (AuthorizationException authorizationException) {
            Support.showError(null, this.getClass(), ASEUtils.getString("MSG_NEED_AGENT_AUTHENTICATION"));
        }
        catch (Exception exception) {
            Support.showError(null, this.getClass(), this.getJDialog(), exception.toString());
        }
        this._go.setLocalPanelVisible(this._isLocalInstallActive);
    }

    private void initAuxServerActive() {
        if (this.wizardFlag == 1) {
            this._isMultiBackupServersActive = this._so.isMultiBackupServersActive();
            this._so.getCluster().setMultipleBackupServersPresent(this._isMultiBackupServersActive);
            this._isMonitorServerActive = this._so.isMonitorServerActive();
            this._isXPServerActive = this._so.isXPServerActive();
        }
        this._go.setBackupServerPortSettingVisible(this._isMultiBackupServersActive);
        this._go.setXPServerPortSettingVisible(this._isXPServerActive);
        this._go.setMonitorServerPortSettingVisible(this._isMonitorServerActive);
    }

    private void resetPorts() {
        this._currentQueryPort = this.getQueryPort();
        this._currentBSPort = this.getBackupServerPort();
        this._currentXPPort = this.getXPServerPort();
        this._currentMSPort = this.getMonitorServerPort();
    }

    @Override
    public void init() {
        this.clusterNodes = this._so.getParticipatingNodeNames();
        this._go.nameTextField.requestFocus();
        this._go.nameTextField.selectAll();
        this.resetPorts();
    }

    @Override
    public boolean onSetActive() {
        this._go.removeListeners(this);
        this.loadControls(this.clusterNodes);
        if (this.editMode) {
            this.isQueryPortValidated = true;
        }
        this.displayServerValues(false);
        if (this.editMode) {
            this.initName = this._go.getInstanceName();
            this.setInstanceEditValue();
        }
        this._go.addListeners(this);
        this.enableComponents();
        return super.onSetActive();
    }

    private void setInstanceEditValue() {
        String string;
        String string2 = this._server.getPrimaryAddress();
        if (string2 != null && string2.length() > 0) {
            string = "(LLT)" + string2;
            if (this._go.primAddrComboBox.findItem(string) >= 0) {
                this._go.setSelectedPrimAddr(string);
            } else {
                this._go.setSelectedPrimAddr(string2);
            }
        }
        if ((string = this._server.getSecondaryAddress()) != null && string.length() > 0) {
            String string3 = "(LLT)" + string;
            if (this._go.secAddrComboBox.findItem(string3) >= 0) {
                this._go.setSelectedSecAddr(string3);
            } else {
                this._go.setSelectedSecAddr(string);
            }
        }
    }

    protected SDCClusterAgentProxy getAgent(String string) throws Exception {
        SDCClusterAgentProxy sDCClusterAgentProxy = null;
        String[] stringArray = SDCClusterAgentUtils.getAgentNodePort(string);
        if (stringArray != null && stringArray.length > 1) {
            sDCClusterAgentProxy = this._so.getParticipatingAgent(SDCClusterSO.getMapKey(stringArray[0], stringArray[1]));
        }
        return sDCClusterAgentProxy;
    }

    protected SDCClusterAgentProxy getAgent(String string, int n) throws Exception {
        SDCClusterAgentProxy sDCClusterAgentProxy = null;
        if (string != null) {
            sDCClusterAgentProxy = this._so.getParticipatingAgent(SDCClusterSO.getMapKey(string, n + ""));
        }
        return sDCClusterAgentProxy;
    }

    private void loadControls(List list) {
        if (list != null && !list.isEmpty()) {
            this._go.loadNodesCombo(list);
        }
        this._go.showStartingPort(this.wizardFlag == 1);
        this._go.enableStartingPort(false);
    }

    private void displayServerValues(boolean bl) {
        String string;
        if (!bl) {
            this._go.setInstanceName(this._server.getName());
        }
        String string2 = this._server.getNode();
        if (bl) {
            string2 = null;
        }
        if (string2 != null && string2.trim().length() > 0) {
            string = string2 + ":" + this._server.getAgentPort();
            this._go.setSelectedNode(string);
        } else {
            this._server.setNode(this._go.getSelectedNode());
            string = this._go.getSelectedNode();
        }
        SDCClusterAgentProxy sDCClusterAgentProxy = null;
        try {
            sDCClusterAgentProxy = this.getAgent(string);
            this.fillNodeAddresses(sDCClusterAgentProxy);
            this.fillNodeLocalConfig(sDCClusterAgentProxy, !this.editMode);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this._go.customizeAddresses(this._so.hasSecondaryNetwork());
        if (this.wizardFlag == 1 && (bl || !this.editMode)) {
            this._server.setQueryPort(null);
            this._server.setBackupServerPort(null);
            this._server.setMonitorServerPort(null);
            this._server.setXpServerPort(null);
            this._so.dispatchDiscoveredPorts(this._server);
        }
        if (this._server.getQueryPort() != null && this._server.getQueryPort().trim().length() > 0) {
            int n = Integer.parseInt(this._server.getQueryPort().trim());
            this.setQueryPort(n);
        } else {
            this.setQueryPort(5000);
        }
        if (this.wizardFlag == 1) {
            ICluster iCluster = this._so.getCluster();
            PortUtil.calculateInstancePortNumbers((ICluster)iCluster, (IServer)this._server);
            try {
                this.setStartingPort(Integer.parseInt(this._server.getPrimaryPortStart()));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (this._isMultiBackupServersActive) {
                if (this._server.getBackupServerPort() != null && this._server.getBackupServerPort().trim().length() > 0) {
                    int n = Integer.parseInt(this._server.getBackupServerPort().trim());
                    this.setBackupServerPort(n);
                } else {
                    this.setBackupServerPort(this.getQueryPort() + 1);
                }
            }
            if (this._isXPServerActive) {
                if (this._server.getXpServerPort() != null && this._server.getXpServerPort().trim().length() > 0) {
                    int n = Integer.parseInt(this._server.getXpServerPort().trim());
                    this.setXPServerPort(n);
                } else {
                    this.setXPServerPort(this.getQueryPort() + (this._isMultiBackupServersActive ? 2 : 1));
                }
            }
            if (this._isMonitorServerActive) {
                if (this._server.getMonitorServerPort() != null && this._server.getMonitorServerPort().trim().length() > 0) {
                    int n = Integer.parseInt(this._server.getMonitorServerPort().trim());
                    this.setMonitorServerPort(n);
                } else {
                    int n = this._isMultiBackupServersActive && this._isXPServerActive ? 3 : (this._isMultiBackupServersActive || this._isXPServerActive ? 2 : 1);
                    this.setMonitorServerPort(this.getQueryPort() + n);
                }
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        boolean bl;
        if (actionEvent.getSource() == this._go.checkPortButton) {
            boolean bl2 = this.validatePortAvailability(this._go.queryPortSpinBox);
            if (bl2) {
                ASEMessageText aSEMessageText = new ASEMessageText(ASEUtils.getString("SDC_MSG_PORT_AVAILABLE"), this.getQueryPort() + "");
                Support.getViewerSupport().messageBoxString((Container)this.getJDialog(), aSEMessageText.toString(), 1);
                this.isQueryPortValidated = true;
            }
        } else if (actionEvent.getSource() == this._go.checkBSPortButton) {
            boolean bl3 = this.validatePortAvailability(this._go.backupServerPortSpinBox);
            if (bl3) {
                ASEMessageText aSEMessageText = new ASEMessageText(ASEUtils.getString("SDC_MSG_PORT_AVAILABLE"), this.getBackupServerPort() + "");
                Support.getViewerSupport().messageBoxString((Container)this.getJDialog(), aSEMessageText.toString(), 1);
                this._isBackupServerPortValidated = true;
            }
        } else if (actionEvent.getSource() == this._go.checkXPPortButton) {
            boolean bl4 = this.validatePortAvailability(this._go.xpServerPortSpinBox);
            if (bl4) {
                ASEMessageText aSEMessageText = new ASEMessageText(ASEUtils.getString("SDC_MSG_PORT_AVAILABLE"), this.getXPServerPort() + "");
                Support.getViewerSupport().messageBoxString((Container)this.getJDialog(), aSEMessageText.toString(), 1);
                this._isXPServerPortValidated = true;
            }
        } else if (actionEvent.getSource() == this._go.checkMSPortButton && (bl = this.validatePortAvailability(this._go.monitorServerPortSpinBox))) {
            ASEMessageText aSEMessageText = new ASEMessageText(ASEUtils.getString("SDC_MSG_PORT_AVAILABLE"), this.getMonitorServerPort() + "");
            Support.getViewerSupport().messageBoxString((Container)this.getJDialog(), aSEMessageText.toString(), 1);
            this._isMonitorServerPortValidated = true;
        }
    }

    @Override
    public void textValueChanged(DocumentEvent documentEvent) {
        try {
            Document document = documentEvent.getDocument();
            Document document2 = this._go.nameTextField.getDocument();
            SDCClusterAgentProxy sDCClusterAgentProxy = this.getAgent(this._go.getSelectedNode());
            if (document == document2 && sDCClusterAgentProxy != null) {
                String string = this.buildLogFileName(sDCClusterAgentProxy.getAseHome(), this._so.getCluster().getName(), this._go.getInstanceName());
                this._go.setLogFile(string);
            }
            this.enableComponents();
        }
        catch (Exception exception) {
            ASEMessageText aSEMessageText = new ASEMessageText(ASEUtils.getString("SDC_ERROR"), exception.getMessage());
            Support.addLogEntry(0, this.getClass().getName(), aSEMessageText.toString(), ASEUtils.getStackTrace(exception));
        }
    }

    private int getQueryPort() {
        return this._go.queryPortSpinBox.getValue();
    }

    private void setQueryPort(int n) {
        this._go.queryPortSpinBox.setValue(n);
    }

    private int getStartingPort() {
        return this._go.startingPortSpinBox.getValue();
    }

    private void setStartingPort(int n) {
        this._go.startingPortSpinBox.setValue(n);
    }

    private int getBackupServerPort() {
        if (this._go.backupServerPortSpinBox.isVisible()) {
            return this._go.backupServerPortSpinBox.getValue();
        }
        return -1;
    }

    private void setBackupServerPort(int n) {
        this._go.backupServerPortSpinBox.setValue(n);
    }

    private int getXPServerPort() {
        if (this._go.xpServerPortSpinBox.isVisible()) {
            return this._go.xpServerPortSpinBox.getValue();
        }
        return -1;
    }

    private void setXPServerPort(int n) {
        this._go.xpServerPortSpinBox.setValue(n);
    }

    private int getMonitorServerPort() {
        if (this._go.monitorServerPortSpinBox.isVisible()) {
            return this._go.monitorServerPortSpinBox.getValue();
        }
        return -1;
    }

    private void setMonitorServerPort(int n) {
        this._go.monitorServerPortSpinBox.setValue(n);
    }

    public void valueChanged(ASASpinBoxChangeEvent aSASpinBoxChangeEvent) {
        Object object = aSASpinBoxChangeEvent.getSource();
        if (object == this._go.backupServerPortSpinBox) {
            this._isBackupServerPortValidated = false;
        } else if (object == this._go.xpServerPortSpinBox) {
            this._isXPServerPortValidated = false;
        } else if (object == this._go.monitorServerPortSpinBox) {
            this._isMonitorServerPortValidated = false;
        } else if (object == this._go.queryPortSpinBox) {
            this.isQueryPortValidated = false;
        } else if (object == this._go.startingPortSpinBox) {
            this.isNetworkPortsValidated = false;
        }
        this.autoChangeDuplicatedPort((ASASpinBox)object);
    }

    private int getCurrentPort(ASASpinBox aSASpinBox) {
        if (aSASpinBox == this._go.backupServerPortSpinBox) {
            return this._currentBSPort;
        }
        if (aSASpinBox == this._go.xpServerPortSpinBox) {
            return this._currentXPPort;
        }
        if (aSASpinBox == this._go.monitorServerPortSpinBox) {
            return this._currentMSPort;
        }
        if (aSASpinBox == this._go.queryPortSpinBox) {
            return this._currentQueryPort;
        }
        return 0;
    }

    private void autoChangeDuplicatedPort(ASASpinBox aSASpinBox) {
        aSASpinBox.removeSpinBoxChangeListener((ASASpinBoxChangeListener)this);
        int n = this.getCurrentPort(aSASpinBox);
        if (n == 0) {
            return;
        }
        int n2 = aSASpinBox.getValue();
        if (!this.isDuplicated(n2) && !this.existsInInstances(n2)) {
            return;
        }
        this.resetPorts();
        aSASpinBox.addSpinBoxChangeListener((ASASpinBoxChangeListener)this);
    }

    private boolean existsInInstances(int n) {
        ICluster iCluster = this._so.getCluster();
        IServer[] iServerArray = iCluster.getServersArray();
        String string = SDCClusterAgentUtils.getAgentNodeName(this._go.getSelectedNode());
        IServer iServer = null;
        String[] stringArray = null;
        for (int i = 0; i < iServerArray.length; ++i) {
            iServer = iServerArray[i];
            if (iServer.getName().equals(this._go.getInstanceName()) || !iServer.getNode().equals(string)) continue;
            stringArray = new String[]{iServer.getQueryPort(), iServer.getXpServerPort(), iServer.getMonitorServerPort(), iServer.getPrimaryPortStart(), iServer.getSecondaryPortStart()};
            for (int j = 0; j < stringArray.length; ++j) {
                if (!String.valueOf(n).equals(stringArray[j])) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isDuplicated(int n) {
        int[] nArray = new int[]{this.getQueryPort(), this.getXPServerPort(), this.getMonitorServerPort()};
        int n2 = 0;
        for (int i = 0; i < nArray.length; ++i) {
            if (n != nArray[i]) continue;
            ++n2;
        }
        return n2 > 1;
    }

    private boolean validatePortAvailability(ASASpinBox aSASpinBox) {
        ASEMessageText aSEMessageText = null;
        int n = aSASpinBox.getValue();
        String string = String.valueOf(n);
        SDCClusterAgentProxy sDCClusterAgentProxy = null;
        try {
            sDCClusterAgentProxy = this.getAgent(this._go.getSelectedNode());
            if (sDCClusterAgentProxy != null) {
                if (!sDCClusterAgentProxy.isPortAvailable(n)) {
                    aSEMessageText = new ASEMessageText(ASEUtils.getString("SDC_MSG_PORT_UNAVAILABLE"), string, sDCClusterAgentProxy.getNodeName());
                    return this.validatePortAvailabilityAux(aSEMessageText, aSASpinBox);
                }
                if (this.existsInInstances(n)) {
                    aSEMessageText = new ASEMessageText(ASEUtils.getString("SDC_MSG_PORT_USED_INSTANCES"), string);
                    return this.validatePortAvailabilityAux(aSEMessageText, aSASpinBox);
                }
                if (this.wizardFlag == 1) {
                    if (this.isDuplicated(n)) {
                        aSEMessageText = new ASEMessageText(ASEUtils.getString("SDC_MSG_PORT_DUPLICATED"), string);
                        return this.validatePortAvailabilityAux(aSEMessageText, aSASpinBox);
                    }
                    ICluster iCluster = this._so.getCluster();
                    ServerBO serverBO = ContainerViewBO.getServerBO(this._so.getConnection());
                    ServerSO serverSO = (ServerSO)serverBO.getSO();
                    if (serverSO.isUAFMonitored() && serverSO.doesHostPortExistInInterface(iCluster, sDCClusterAgentProxy.getHost(), n)) {
                        aSEMessageText = new ASEMessageText(ASEUtils.getString("ERR_PORT_NUMBER_EXISTS"), string, sDCClusterAgentProxy.getNodeName());
                        return this.validatePortAvailabilityAux(aSEMessageText, aSASpinBox);
                    }
                }
            }
        }
        catch (JMXException jMXException) {
            SDCClusterWizard.handleJMXException(jMXException, sDCClusterAgentProxy, this.getClass(), this.getJDialog());
            return false;
        }
        catch (Exception exception) {
            aSEMessageText = new ASEMessageText(ASEUtils.getString("SDC_ERROR"), exception.getMessage());
            Support.showError(null, this.getClass(), this.getJDialog(), aSEMessageText.toString());
            return false;
        }
        return true;
    }

    private boolean validatePortAvailabilityAux(ASEMessageText aSEMessageText, ASASpinBox aSASpinBox) {
        Support.showError(null, this.getClass(), this.getJDialog(), aSEMessageText.toString());
        aSASpinBox.requestFocusInWindow();
        return false;
    }

    private void onNodeChanged() {
        SDCClusterAgentProxy sDCClusterAgentProxy = null;
        String string = this._go.getSelectedNode();
        try {
            sDCClusterAgentProxy = this.getAgent(string);
        }
        catch (Exception exception) {
            ASEMessageText aSEMessageText = new ASEMessageText(ASEUtils.getString("SDC_ERROR"), exception.getMessage());
            Support.addLogEntry(0, this.getClass().getName(), aSEMessageText.toString(), ASEUtils.getStackTrace(exception));
        }
        if (sDCClusterAgentProxy != null) {
            this.fillNodeAddresses(sDCClusterAgentProxy);
            this.fillNodeLocalConfig(sDCClusterAgentProxy, true);
        }
    }

    private void fillNodeAddresses(SDCClusterAgentProxy sDCClusterAgentProxy) {
        if (sDCClusterAgentProxy != null) {
            String[] stringArray = this.retrieveNodeAddresses(sDCClusterAgentProxy.getHost());
            if (stringArray != null && stringArray.length > 0) {
                String string;
                this._go.loadPrimAddrCombo(stringArray);
                if (this._so.hasSecondaryNetwork()) {
                    this._go.loadSecAddrCombo(stringArray);
                }
                if ((string = sDCClusterAgentProxy.getHost()) != null) {
                    this._go.setSelectedPrimAddr(string);
                    if (this._so.hasSecondaryNetwork()) {
                        this._go.setSelectedSecAddr(string);
                    }
                }
            }
        } else {
            this._go.loadPrimAddrCombo(null);
            this._go.loadSecAddrCombo(null);
        }
    }

    private void updateAgentInfo(SDCClusterAgentProxy sDCClusterAgentProxy) {
        if (sDCClusterAgentProxy != null) {
            try {
                List list;
                String string = sDCClusterAgentProxy.getSybaseHome();
                if (!(string != null && string.trim().length() != 0 || (list = sDCClusterAgentProxy.getSybaseHomeList()) == null || list.isEmpty())) {
                    string = (String)sDCClusterAgentProxy.getSybaseHomeList().get(0);
                    sDCClusterAgentProxy.setSybaseHome(string);
                    String string2 = sDCClusterAgentProxy.getASEHome(string);
                    sDCClusterAgentProxy.setAseHome(string2);
                    sDCClusterAgentProxy.setInterfacesFileHome(string);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void fillNodeLocalConfig(SDCClusterAgentProxy sDCClusterAgentProxy, boolean bl) {
        String string = sDCClusterAgentProxy.getServerFileSeparator();
        String string2 = this._server.getSybaseHome();
        String string3 = this._server.getAseHome();
        String string4 = this._server.getInterfacesPath();
        String string5 = this._server.getConfigFile();
        String string6 = this._server.getEnvShellPath();
        String string7 = this._server.getLogFile();
        if (bl) {
            try {
                this.updateAgentInfo(sDCClusterAgentProxy);
                string2 = sDCClusterAgentProxy.getSybaseHome();
                string3 = sDCClusterAgentProxy.getAseHome();
                string4 = string2;
                string5 = string2 + string + this._so.getCluster().getName() + ".cfg";
                string6 = string2 + string + "SYBASE.sh";
                string7 = this.buildLogFileName(string3, this._so.getCluster().getName(), this._go.getInstanceName());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this._go.sybaseHomeTextField.setText(string2);
        this._go.aseHomeTextField.setText(string3);
        this._go.interfaceTextField.setText(string4);
        this._go.configTextField.setText(string5);
        this._go.envScriptTextField.setText(string6);
        this._go.setLogFile(string7);
        this._go.setStartParameters(this._server.getAddlRunParameters());
        this._go.setTraceFlags(this._server.getTraceflagsString());
    }

    private String buildLogFileName(String string, String string2, String string3) {
        String string4 = string + "/install/" + string3 + "." + "log";
        return string4;
    }

    private String[] retrieveNodeAddresses(String string) {
        List list;
        if (string == null) {
            return null;
        }
        String[] stringArray = (String[])this._so.getLocalAddressesMap().get(string);
        if (this._so.isVCSMode() && null != (list = (List)this._so.getLLTAddressesMap().get(string)) && list.size() > 0) {
            for (int i = 0; i < stringArray.length; ++i) {
                if (!list.contains(stringArray[i])) continue;
                stringArray[i] = "(LLT)" + stringArray[i];
            }
        }
        return stringArray;
    }

    private String pickDefaultAddress(String[] stringArray) {
        String string = null;
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                InetAddress inetAddress = InetAddress.getByName(stringArray[i]);
                if (!(inetAddress instanceof Inet4Address) || inetAddress.isLoopbackAddress()) continue;
                string = stringArray[i];
                break;
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
        }
        if (string == null) {
            string = stringArray[0];
        }
        return string;
    }

    protected String[] getLocalAddresses(SDCClusterAgentProxy sDCClusterAgentProxy) throws Exception {
        String string = sDCClusterAgentProxy.getHost();
        String[] stringArray = (String[])this._so.getLocalAddressesMap().get(string);
        if (stringArray == null && (stringArray = sDCClusterAgentProxy.getLocalAddresses()) != null) {
            this._so.addLocalAddressesMap(string, stringArray);
        }
        return stringArray;
    }

    protected List getLLTAddress(SDCClusterAgentProxy sDCClusterAgentProxy) {
        String string = sDCClusterAgentProxy.getHost();
        List list = (List)this._so.getLLTAddressesMap().get(string);
        if (list == null && (list = sDCClusterAgentProxy.getVCSClusterInterconnects()) != null) {
            this._so.addLLTAddressesMap(string, list);
        }
        return list;
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        if (this._go.isNodeCombo(itemEvent.getSource())) {
            this.onNodeChanged();
        } else {
            this.enableComponents();
        }
    }

    @Override
    public void enableComponents() {
        boolean bl = !(this._go.getInstanceName().length() <= 0 || this._go.getSelectedNode().length() <= 0 || this.getQueryPort() <= 0 || this._isMultiBackupServersActive && this.getBackupServerPort() <= 0 || this._isXPServerActive && this.getXPServerPort() <= 0 || this._isMonitorServerActive && this.getMonitorServerPort() <= 0 || this._isLocalInstallActive && this._go.getSybaseHome().length() <= 0 || this._isLocalInstallActive && this._go.getASEHome().length() <= 0 || this._isLocalInstallActive && this._go.getConfigFile().length() <= 0 || !this._isLDAPActive && this._go.getInterfacesDir().length() <= 0 || this._go.getEnvScript().length() <= 0 || this._go.getLogFile().length() <= 0);
        this.enableOkButton(bl);
    }

    private boolean isEditMode() {
        return this.editMode;
    }

    private boolean validateTraceFlags(String string) {
        boolean bl = true;
        if (string != null && string.trim().length() > 0) {
            if ((string = string.trim()).startsWith(",") || string.endsWith(",") || string.indexOf(",,") > -1) {
                return false;
            }
            String[] stringArray = string.split(",");
            for (int i = 0; i < stringArray.length; ++i) {
                try {
                    int n = Integer.parseInt(stringArray[i]);
                    if (n <= Integer.MAX_VALUE) continue;
                    return false;
                }
                catch (NumberFormatException numberFormatException) {
                    return false;
                }
            }
        }
        return bl;
    }

    protected String getHostNameWithMultiInstance() {
        IServer[] iServerArray = this._so.getCluster().getServersArray();
        IServer[] iServerArray2 = null;
        if (null == iServerArray || iServerArray.length == 0) {
            return null;
        }
        if (this.isEditMode()) {
            iServerArray2 = new IServer[iServerArray.length];
            System.arraycopy(iServerArray, 0, iServerArray2, 0, iServerArray.length);
        } else {
            iServerArray2 = new IServer[iServerArray.length + 1];
            iServerArray2[0] = this._server;
            System.arraycopy(iServerArray, 0, iServerArray2, 1, iServerArray.length);
        }
        Vector<String> vector = new Vector<String>();
        for (int i = 0; i < iServerArray2.length; ++i) {
            String string = iServerArray2[i].getNode();
            if (vector.contains(string)) {
                return string;
            }
            vector.add(string);
        }
        return null;
    }

    private String getFormatedLLTAddr(String string) {
        return string.replaceAll("\\(LLT\\)", "");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean onOk() {
        Object object;
        int n;
        ASEMessageText aSEMessageText;
        String string = this._go.getSelectedNode();
        SDCClusterAgentProxy sDCClusterAgentProxy = null;
        try {
            sDCClusterAgentProxy = this.getAgent(string);
        }
        catch (Exception exception) {
            aSEMessageText = new ASEMessageText(ASEUtils.getString("SDC_ERROR"), exception.getMessage());
            Support.showError(null, this.getClass(), this.getJDialog(), aSEMessageText.toString());
        }
        if (sDCClusterAgentProxy == null) {
            return false;
        }
        String string2 = this._go.getInstanceName();
        if (!SDCClusterSO.validateIdentifier(string2)) {
            aSEMessageText = new ASEMessageText(ASEUtils.getString("SDC_ERROR_INVALID_NAME"), string2);
            Support.showError(null, this.getClass(), this.getJDialog(), aSEMessageText.toString());
            return false;
        }
        boolean bl = false;
        bl = this.editMode && this._go.getInstanceName().equals(this.initName) ? false : this._so.containsServer(string2);
        if (bl) {
            ASEMessageText aSEMessageText2 = new ASEMessageText(ASEUtils.getString("SDC_ERROR_INSTANCE_ALREADY_DEFINED"), string2);
            Support.showError(null, this.getClass(), this.getJDialog(), aSEMessageText2.toString());
            return false;
        }
        boolean bl2 = false;
        try {
            bl2 = sDCClusterAgentProxy.doesEntriesExistInInterfaces(this._go.getInstanceName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (bl2) {
            ASEMessageText aSEMessageText3 = new ASEMessageText(ASEUtils.getString("ERR_INSTANCE_NAME_EXISTS"), string2, sDCClusterAgentProxy.getHostPort());
            Support.showError(null, this.getClass(), this.getJDialog(), aSEMessageText3.toString());
            this._go.nameTextField.requestFocus();
            this._go.nameTextField.selectAll();
            return false;
        }
        boolean bl3 = this.validateAndSaveSettings(sDCClusterAgentProxy, this._go.getSybaseHome(), this._go.getASEHome(), this._go.getInterfacesDir(), this._go.getConfigFile(), this._go.getEnvScript(), this._go.getStartParameters(), this.formatTraceFlags(this._go.getTraceFlags()));
        if (!bl3) {
            return false;
        }
        this._server.setName(string2);
        String string3 = SDCClusterAgentUtils.getAgentNodeName(string);
        this._server.setNode(string3);
        this._server.setPublicAddress(string3);
        this._server.setSybaseHome(sDCClusterAgentProxy.getSybaseHome());
        this._server.setAseHome(sDCClusterAgentProxy.getAseHome());
        this._server.setAgentPort(sDCClusterAgentProxy.getPort());
        if (!this._so.isLDAPConfigured()) {
            this._server.setInterfacesPath(sDCClusterAgentProxy.getInterfacesFileHome());
        }
        this._server.setConfigFile(sDCClusterAgentProxy.getClusterConfigFile());
        this._server.setEnvShellPath(sDCClusterAgentProxy.getEnvironmentScript());
        this._server.setAddlRunParameters(sDCClusterAgentProxy.getStartParameters());
        this._server.setTraceflags(sDCClusterAgentProxy.getTraceFlags());
        this._server.setQueryTransport("tcp");
        if (this._isUpgradeActive) {
            this.isQueryPortValidated = true;
        }
        if (this._isUpgradeActive) {
            this.isQueryPortValidated = true;
        }
        if (!this.isQueryPortValidated) {
            boolean bl4 = this.validatePortAvailability(this._go.queryPortSpinBox);
            if (!bl4) {
                return false;
            }
            this.isQueryPortValidated = true;
        }
        String string4 = this._go.getSelectedPrimAddr().trim();
        String string5 = this._go.getSelectedSecAddr().trim();
        this._server.setQueryPort(this.getQueryPort() + "");
        if (this._so.isVCSMode()) {
            String string6 = ASEUtils.getString("MSG_VCS_CLUSTER_NO_LLT_PRIMARY_INTERCONNECT");
            if (string4.indexOf(LLT_PREFIX) < 0) {
                if (Support.showQuestionYesNo(string6) != 0) {
                    this._go.primAddrComboBox.requestFocus();
                    return false;
                }
                this._server.setPrimaryAddress(string4);
            } else {
                this._server.setPrimaryAddress(this.getFormatedLLTAddr(string4));
            }
            if (this._so.hasSecondaryNetwork()) {
                string6 = ASEUtils.getString("MSG_VCS_CLUSTER_NO_LLT_SECONDARY_INTERCONNECT");
                if (string5.indexOf(LLT_PREFIX) < 0) {
                    if (Support.showQuestionYesNo(string6) != 0) {
                        this._go.secAddrComboBox.requestFocus();
                        return false;
                    }
                    this._server.setSecondaryAddress(string5);
                } else {
                    this._server.setSecondaryAddress(this.getFormatedLLTAddr(string5));
                }
            }
        } else {
            this._server.setPrimaryAddress(string4);
            if (this._so.hasSecondaryNetwork()) {
                this._server.setSecondaryAddress(string5);
            }
        }
        if (this.wizardFlag == 1 && !this.isNetworkPortsValidated) {
            int n2 = this.getStartingPort();
            try {
                n = 0;
                this._server.setPrimaryPortStart(n2 + "");
                object = this._so.validatePortRangeAvailability(this._server, string);
                n = object == null ? 1 : 0;
                int n3 = this._so.getPortsNeededPerInstance();
                if (n == 0) {
                    ASEMessageText aSEMessageText4 = new ASEMessageText(ASEUtils.getString("SDC_MSG_SYS_PORTS_UNAVAILABLE_DLG"), object, this._server.getNode(), String.valueOf(n3));
                    Support.showError(this._so.getConnection(), this.getClass(), this.getJDialog(), aSEMessageText4.toString());
                    this.userSetStartPort = true;
                    this._go.enableStartingPort(true);
                    this._go.setFocusOnStartPort();
                    return false;
                }
                if (this.userSetStartPort && this._so.hasSecondaryNetwork()) {
                    int n4 = n2 + n3 / 2;
                    this._server.setSecondaryPortStart(n4 + "");
                }
            }
            catch (Exception exception) {
                ASEMessageText aSEMessageText5 = new ASEMessageText(ASEUtils.getString("SDC_ERROR_FAIL_TO_CHECK_PORTS"), exception.getMessage(), sDCClusterAgentProxy.getNodeName());
                Support.showError(null, this.getClass(), this.getJDialog(), aSEMessageText5.toString());
                return false;
            }
            this.isNetworkPortsValidated = true;
        }
        if (this.wizardFlag == 1 && (this._isMultiBackupServersActive || this._isXPServerActive || this._isMonitorServerActive)) {
            if (this._isMultiBackupServersActive) {
                if (!this._isBackupServerPortValidated) {
                    boolean bl5 = this.validatePortAvailability(this._go.backupServerPortSpinBox);
                    if (!bl5) {
                        return false;
                    }
                    this._isBackupServerPortValidated = true;
                }
                ServerBO serverBO = ContainerViewBO.getServerBO(this._so.getConnection());
                ServerSO serverSO = (ServerSO)serverBO.getSO();
                object = null;
                try {
                    object = serverSO.getFileSeparator();
                }
                catch (AgentConnectionException agentConnectionException) {
                    agentConnectionException.printStackTrace();
                }
                catch (RemoteException remoteException) {
                    remoteException.printStackTrace();
                }
                this._server.setBackupServerPort(this.getBackupServerPort() + "");
                this._server.setBackupServerName(string2 + "_BS");
                this._server.setBackupServerLogFile(sDCClusterAgentProxy.getAseHome() + (String)object + "install" + (String)object + string2 + "_BS.log");
            }
            if (this._isXPServerActive) {
                if (!this._isXPServerPortValidated) {
                    boolean bl6 = this.validatePortAvailability(this._go.xpServerPortSpinBox);
                    if (!bl6) {
                        return false;
                    }
                    this._isXPServerPortValidated = true;
                }
                this._server.setXpServerPort(this.getXPServerPort() + "");
            }
            if (this._isMonitorServerActive) {
                if (!this._isMonitorServerPortValidated) {
                    boolean bl7 = this.validatePortAvailability(this._go.monitorServerPortSpinBox);
                    if (!bl7) {
                        return false;
                    }
                    this._isMonitorServerPortValidated = true;
                }
                this._server.setMonitorServerPort(this.getMonitorServerPort() + "");
            }
        }
        String string7 = this._go.getLogFile();
        n = 0;
        object = null;
        try {
            n = DeviceValidator.validateDevicePath(sDCClusterAgentProxy, string7);
        }
        catch (AgentConnectionException agentConnectionException) {
            object = new ASEMessageText(ASEUtils.getString("SDC_ERROR"), agentConnectionException.getMessage());
            Support.showError(null, this.getClass(), this.getJDialog(), ((ASEMessageText)object).toString());
            return false;
        }
        if (n != 0) {
            if (n != 200) {
                this.displayError(n, string7, string3);
                return false;
            }
            try {
                n = DeviceValidator.isDevicePathWritable(sDCClusterAgentProxy, string7);
            }
            catch (AgentConnectionException agentConnectionException) {
                object = new ASEMessageText(ASEUtils.getString("SDC_ERROR"), agentConnectionException.getMessage());
                Support.showError(null, this.getClass(), this.getJDialog(), ((ASEMessageText)object).toString());
                return false;
            }
            if (n != 3) {
                this.displayError(n, string7, string3);
                return false;
            }
        }
        this._server.setLogFile(string7);
        String string8 = this.getHostNameWithMultiInstance();
        if (string8 != null && string8.length() > 0) {
            ASEMessageText aSEMessageText6 = null;
            if (this._so.isVCSMode()) {
                aSEMessageText6 = new ASEMessageText(ASEUtils.getString("SDC_MSG_MANY_INSTANCE_ON_ONE_HOST_FOR_VCS"), string8);
                Support.showError(null, this.getClass(), this.getJDialog(), aSEMessageText6.toString());
                return false;
            }
            if (this._wiz.needCheckManyInstanceOnOneHost) {
                aSEMessageText6 = new ASEMessageText(ASEUtils.getString("SDC_MSG_MANY_INSTANCE_ON_ONE_HOST_FOR_IOFENCING"), string8);
                MessageDialogWithOption messageDialogWithOption = new MessageDialogWithOption(Support.getViewerFrame(), ASEUtils.getString("MSG_SYBASE_CENTRAL_TITLE"), aSEMessageText6.toString() + ASEUtils.getString("SDC_IOFENCING_CONFIRM"));
                int n5 = messageDialogWithOption.getResult();
                if (n5 != 0) {
                    return false;
                }
                this._wiz.needCheckManyInstanceOnOneHost = false;
            }
        }
        return true;
    }

    private String formatTraceFlags(String string) {
        String string2 = string;
        if (string != null && string.trim().length() > 0) {
            if ((string = string.trim()).indexOf(",,") > -1) {
                Pattern pattern = Pattern.compile(",,+");
                Matcher matcher = pattern.matcher(string);
                string2 = matcher.replaceAll(",");
            }
            if (string2.startsWith(",")) {
                string2 = string2.replaceFirst(",", "");
            }
            if (string2.endsWith(",")) {
                string2 = string2.substring(0, string2.length() - 1);
            }
        }
        return string2;
    }

    private boolean validateAndSaveSettings(SDCClusterAgentProxy sDCClusterAgentProxy, String string, String string2, String string3, String string4, String string5, String string6, String string7) {
        ASEMessageText aSEMessageText;
        String string8 = SDCClusterAgentUtils.getNodeAddress(sDCClusterAgentProxy.getHost(), sDCClusterAgentProxy.getPort());
        int n = 0;
        boolean bl = false;
        n = this.validateDirectory(string, string8, sDCClusterAgentProxy);
        if (n != 4) {
            this.displayError(n, string, string8);
            bl = true;
        }
        try {
            sDCClusterAgentProxy.getASEHome(string);
        }
        catch (Exception exception) {
            ASEMessageText aSEMessageText2 = new ASEMessageText(ASEUtils.getString("SDC_ERROR"), exception.getMessage());
            Support.showError(null, this.getClass(), this.getJDialog(), aSEMessageText2.toString());
            bl = true;
        }
        if (bl) {
            this._go.sybaseHomeTextField.selectAll();
            this._go.sybaseHomeTextField.requestFocus();
            return false;
        }
        n = this.isAbsolutePath(string2, string8, sDCClusterAgentProxy);
        if (n == 204) {
            this.displayError(n, string2, string8);
            bl = true;
        }
        if (!bl && (n = this.validateFileDirectory(string2, string8, sDCClusterAgentProxy)) == 999) {
            bl = true;
        }
        if (n == 201) {
            if (!bl && (n = this.isDevicePathReadable(string2, string8, sDCClusterAgentProxy)) != 2) {
                this.displayError(n, string2, string8);
                bl = true;
            }
            if (!bl && (n = this.isDevicePathWritable(string2, string8, sDCClusterAgentProxy)) != 3) {
                this.displayError(n, string2, string8);
                bl = true;
            }
        } else if (!bl) {
            aSEMessageText = new ASEMessageText(ASEUtils.getString("ERROR_DIRECTORY_IS_FILE"), string2, string8);
            Support.showError(null, this.getClass(), this.getJDialog(), aSEMessageText.toString());
            bl = true;
        }
        if (bl) {
            this._go.aseHomeTextField.selectAll();
            this._go.aseHomeTextField.requestFocus();
            return false;
        }
        if (!this._so.isLDAPConfigured()) {
            n = this.isAbsolutePath(string3, string8, sDCClusterAgentProxy);
            if (n == 204) {
                this.displayError(n, string3, string8);
                bl = true;
            }
            if (!bl && (n = this.validateFileDirectory(string3, string8, sDCClusterAgentProxy)) == 999) {
                bl = true;
            }
            if (n == 201) {
                if (!bl && (n = this.isDevicePathReadable(string3, string8, sDCClusterAgentProxy)) != 2) {
                    this.displayError(n, string3, string8);
                    bl = true;
                }
                if (!bl && (n = this.isDevicePathWritable(string3, string8, sDCClusterAgentProxy)) != 3) {
                    this.displayError(n, string3, string8);
                    bl = true;
                }
            } else if (!bl) {
                aSEMessageText = new ASEMessageText(ASEUtils.getString("ERROR_DIRECTORY_IS_FILE"), string3, string8);
                Support.showError(null, this.getClass(), this.getJDialog(), aSEMessageText.toString());
                bl = true;
            }
            if (bl) {
                this._go.interfaceTextField.selectAll();
                this._go.interfaceTextField.requestFocus();
                return false;
            }
        }
        if ((n = this.isAbsolutePath(string4, string8, sDCClusterAgentProxy)) == 204) {
            this.displayError(n, string4, string8);
            bl = true;
        }
        if (!bl && (n = this.validateFileDirectory(string4, string8, sDCClusterAgentProxy)) == 999) {
            bl = true;
        }
        if (!bl && string4.trim().length() >= 255) {
            aSEMessageText = new ASEMessageText(ASEUtils.getString("ERROR_CONFIG_FILE_LENGTH"));
            Support.showError(null, this.getClass(), this.getJDialog(), aSEMessageText.toString());
            bl = true;
        }
        if (n == 200) {
            if (this.wizardFlag == 1) {
                if (!bl && (n = this.isDevicePathReadable(string4, string8, sDCClusterAgentProxy)) != 2) {
                    this.displayError(n, string4, string8);
                    bl = true;
                }
                if (!bl && (n = this.isDevicePathWritable(string4, string8, sDCClusterAgentProxy)) != 3) {
                    this.displayError(n, string4, string8);
                    bl = true;
                }
            } else if (!bl) {
                this.displayError(n, string4, string8);
                this._go.configTextField.selectAll();
                this._go.configTextField.requestFocus();
                bl = true;
            }
        } else if (!bl && n != 0) {
            this.displayError(n, string4, string8);
            bl = true;
        }
        if (bl) {
            this._go.configTextField.selectAll();
            this._go.configTextField.requestFocus();
            return false;
        }
        n = this.validateFileReadable(string5, string8, sDCClusterAgentProxy);
        if (n != 2) {
            if (n != 999) {
                this.displayError(n, string5, string8);
            }
            bl = true;
        }
        if (bl) {
            this._go.envScriptTextField.selectAll();
            this._go.envScriptTextField.requestFocus();
            return false;
        }
        this.updateAgentProxySettings(sDCClusterAgentProxy, string, string2, string3, string4, string5, string6, string7);
        return true;
    }

    private void updateAgentProxySettings(SDCClusterAgentProxy sDCClusterAgentProxy, String string, String string2, String string3, String string4, String string5, String string6, String string7) {
        sDCClusterAgentProxy.setSybaseHome(string);
        sDCClusterAgentProxy.setAseHome(string2);
        sDCClusterAgentProxy.setInterfacesFileHome(string3);
        sDCClusterAgentProxy.setClusterConfigFile(string4);
        sDCClusterAgentProxy.setEnvironmentScript(string5);
        String string8 = sDCClusterAgentProxy.getServerFileSeparator();
        sDCClusterAgentProxy.setEnvironmentScript(string + string8 + "SYBASE.sh");
        sDCClusterAgentProxy.setStartParameters(string6);
        sDCClusterAgentProxy.setTraceFlags(string7);
        try {
            if (!sDCClusterAgentProxy.getSybaseHomeList().contains(string)) {
                sDCClusterAgentProxy.addSybaseHome(string);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private int isDevicePathReadable(String string, String string2, SDCClusterAgentProxy sDCClusterAgentProxy) {
        int n = 102;
        try {
            n = DeviceValidator.isDevicePathReadable(sDCClusterAgentProxy, string);
        }
        catch (AgentConnectionException agentConnectionException) {
            ASEMessageText aSEMessageText = new ASEMessageText(ASEUtils.getString("SDC_ERROR"), agentConnectionException.getMessage());
            Support.showError(null, this.getClass(), this.getJDialog(), aSEMessageText.toString());
        }
        return n;
    }

    private int isDevicePathWritable(String string, String string2, SDCClusterAgentProxy sDCClusterAgentProxy) {
        int n = 103;
        try {
            n = DeviceValidator.isDevicePathWritable(sDCClusterAgentProxy, string);
        }
        catch (AgentConnectionException agentConnectionException) {
            ASEMessageText aSEMessageText = new ASEMessageText(ASEUtils.getString("SDC_ERROR"), agentConnectionException.getMessage());
            Support.showError(null, this.getClass(), this.getJDialog(), aSEMessageText.toString());
        }
        return n;
    }

    private int validateFileReadable(String string, String string2, SDCClusterAgentProxy sDCClusterAgentProxy) {
        int n = 999;
        try {
            n = DeviceValidator.validateFileReadable(sDCClusterAgentProxy, string);
        }
        catch (AgentConnectionException agentConnectionException) {
            ASEMessageText aSEMessageText = new ASEMessageText(ASEUtils.getString("SDC_ERROR"), agentConnectionException.getMessage());
            Support.showError(null, this.getClass(), this.getJDialog(), aSEMessageText.toString());
        }
        return n;
    }

    private int validateDirectory(String string, String string2, SDCClusterAgentProxy sDCClusterAgentProxy) {
        int n = 999;
        try {
            n = DeviceValidator.validateDirectoryPath(sDCClusterAgentProxy, string);
        }
        catch (AgentConnectionException agentConnectionException) {
            ASEMessageText aSEMessageText = new ASEMessageText(ASEUtils.getString("SDC_ERROR"), agentConnectionException.getMessage());
            Support.showError(null, this.getClass(), this.getJDialog(), aSEMessageText.toString());
        }
        return n;
    }

    private int validateFileDirectory(String string, String string2, SDCClusterAgentProxy sDCClusterAgentProxy) {
        int n = 999;
        try {
            n = DeviceValidator.validateDevicePath(sDCClusterAgentProxy, string);
        }
        catch (AgentConnectionException agentConnectionException) {
            ASEMessageText aSEMessageText = new ASEMessageText(ASEUtils.getString("SDC_ERROR"), agentConnectionException.getMessage());
            Support.showError(null, this.getClass(), this.getJDialog(), aSEMessageText.toString());
        }
        return n;
    }

    private int validateDirectoryPath(String string, String string2, SDCClusterAgentProxy sDCClusterAgentProxy) {
        int n = 999;
        try {
            n = DeviceValidator.validateDirectoryPath(sDCClusterAgentProxy, string);
        }
        catch (AgentConnectionException agentConnectionException) {
            ASEMessageText aSEMessageText = new ASEMessageText(ASEUtils.getString("SDC_ERROR"), agentConnectionException.getMessage());
            Support.showError(null, this.getClass(), this.getJDialog(), aSEMessageText.toString());
        }
        return n;
    }

    private int isAbsolutePath(String string, String string2, SDCClusterAgentProxy sDCClusterAgentProxy) {
        try {
            String string3 = DeviceValidator.getAbsolutePath(sDCClusterAgentProxy, string);
            if (string3.equals(string)) {
                return 0;
            }
        }
        catch (AgentConnectionException agentConnectionException) {
            ASEMessageText aSEMessageText = new ASEMessageText(ASEUtils.getString("SDC_ERROR"), agentConnectionException.getMessage());
            Support.showError(null, this.getClass(), this.getJDialog(), aSEMessageText.toString());
        }
        return 204;
    }

    private void displayError(int n, String string, String string2) {
        ASEMessageText aSEMessageText = null;
        switch (n) {
            case 203: {
                aSEMessageText = new ASEMessageText(ASEUtils.getString("ERROR_FILE_PARENT_DIR_NOT_WRITABLE"), string, string2);
                break;
            }
            case 209: {
                aSEMessageText = new ASEMessageText(ASEUtils.getString("ERROR_FILE_PARENT_DIR_NOT_READABLE"), string, string2);
                break;
            }
            case 202: {
                aSEMessageText = new ASEMessageText(ASEUtils.getString("ERROR_FILE_PARENT_DIR_NOT_EXIST"), string, string2);
                break;
            }
            case 200: {
                aSEMessageText = new ASEMessageText(ASEUtils.getString("ERROR_FILE_ALREADY_EXISTS"), string, string2);
                break;
            }
            case 201: {
                aSEMessageText = new ASEMessageText(ASEUtils.getString("ERROR_FILE_IS_DIRECTORY"), string, string2);
                break;
            }
            case 100: {
                aSEMessageText = new ASEMessageText(ASEUtils.getString("ERROR_RAW_DEVICE_NOT_READABLE"), string, string2);
                break;
            }
            case 101: {
                aSEMessageText = new ASEMessageText(ASEUtils.getString("ERROR_RAW_DEVICE_NOT_WRITABLE"), string, string2);
                break;
            }
            case 104: {
                aSEMessageText = new ASEMessageText(ASEUtils.getString("ERROR_PATH_NOT_EXIST"), string, string2);
                break;
            }
            case 102: {
                aSEMessageText = new ASEMessageText(ASEUtils.getString("ERROR_PATH_NOT_READABLE"), string, string2);
                break;
            }
            case 103: {
                aSEMessageText = new ASEMessageText(ASEUtils.getString("ERROR_PATH_NOT_WRITABLE"), string, string2);
                break;
            }
            case 204: {
                aSEMessageText = new ASEMessageText(ASEUtils.getString("ERROR_INVALID_ABSOLUTE_PATH"), string, string2);
                break;
            }
            case 205: {
                aSEMessageText = new ASEMessageText(ASEUtils.getString("ERROR_DIRECTORY_NOT_EXIST"), string, string2);
                break;
            }
            case 206: {
                aSEMessageText = new ASEMessageText(ASEUtils.getString("ERROR_IS_NOT_DIRECTORY"), string, string2);
                break;
            }
            case 210: {
                aSEMessageText = new ASEMessageText(ASEUtils.getString("ERROR_IS_NOT_FILE"), string, string2);
                break;
            }
            case 207: {
                aSEMessageText = new ASEMessageText(ASEUtils.getString("ERROR_PATH_NOT_READABLE"), string, string2);
                break;
            }
            case 208: {
                aSEMessageText = new ASEMessageText(ASEUtils.getString("ERROR_PATH_NOT_WRITABLE"), string, string2);
                break;
            }
            default: {
                aSEMessageText = new ASEMessageText(ASEUtils.getString("SDC_ERROR_UNKNOWN"), string);
            }
        }
        Support.showError(null, this.getClass(), this.getJDialog(), aSEMessageText.toString());
    }

    class InitAgentInfoTask
    implements Runnable {
        private SDCClusterAgentProxy _agentProxy;

        public InitAgentInfoTask(SDCClusterAgentProxy sDCClusterAgentProxy) {
            this._agentProxy = sDCClusterAgentProxy;
        }

        @Override
        public void run() {
            if (this._agentProxy != null) {
                try {
                    List list;
                    String string = this._agentProxy.getSybaseHome();
                    if (!(string != null && string.trim().length() != 0 || (list = this._agentProxy.getSybaseHomeList()) == null || list.isEmpty())) {
                        string = (String)this._agentProxy.getSybaseHomeList().get(0);
                        this._agentProxy.setSybaseHome(string);
                        String string2 = this._agentProxy.getASEHome(string);
                        this._agentProxy.setAseHome(string2);
                        this._agentProxy.setInterfacesFileHome(string);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }
}

