/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.aseplugin.bo.dlg;

import com.sybase.aseplugin.ASEMessageText;
import com.sybase.aseplugin.ASEUtils;
import com.sybase.aseplugin.bo.Support;
import com.sybase.aseplugin.bo.dlg.ASEDocPageController;
import com.sybase.aseplugin.bo.wiz.SDCClusterWizard;
import com.sybase.aseplugin.go.dlg.SDCCreateDeviceDlgGOPage;
import com.sybase.aseplugin.so.DatabaseDeviceSO;
import com.sybase.aseplugin.so.SDCClusterSO;
import com.sybase.aseplugin.util.DBSizeUtil;
import com.sybase.aseplugin.util.DeviceValidator;
import com.sybase.aseplugin.util.SDCClusterAgentProxy;
import com.sybase.central.SCDialogSupport;
import com.sybase.ua.AgentConnectionException;
import java.io.File;
import java.util.Map;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.text.Document;

class SDCCreateDeviceDialogBOPage
extends ASEDocPageController {
    private SDCCreateDeviceDlgGOPage _go;
    private SDCClusterSO _so;
    private DatabaseDeviceSO _deviceSO;
    private int _rowCount;
    private String _sep;
    private SDCClusterWizard _wiz;

    public SDCCreateDeviceDialogBOPage(SCDialogSupport sCDialogSupport, SDCCreateDeviceDlgGOPage sDCCreateDeviceDlgGOPage, SDCClusterSO sDCClusterSO, DatabaseDeviceSO databaseDeviceSO, int n, SDCClusterWizard sDCClusterWizard) {
        super(sCDialogSupport, (JPanel)((Object)sDCCreateDeviceDlgGOPage));
        this._go = sDCCreateDeviceDlgGOPage;
        this._so = sDCClusterSO;
        this._deviceSO = databaseDeviceSO;
        this._rowCount = n;
        this._wiz = sDCClusterWizard;
        this._go.deviceNameTextField.getDocument().addDocumentListener(this);
        this._go.devicePathTextField.getDocument().addDocumentListener(this);
    }

    @Override
    public void init() {
        this._go.descLabel.setVisible(!this._so.isVCSMode());
        this._go.noteVCSLabel.setVisible(this._so.isVCSMode());
        this._go.deviceSizeSpinBox.setMinimum(1);
        this._go.deviceSizeSpinBox.setValue(30 * this._rowCount);
        this._go.devicePathTextField.setText(this.getDefaultMasterDevPath());
        this.enableOkButton(false);
    }

    public String getDefaultMasterDevPath() {
        String string = "";
        SDCClusterSO sDCClusterSO = this._so;
        SDCClusterAgentProxy sDCClusterAgentProxy = null;
        try {
            sDCClusterAgentProxy = sDCClusterSO.getAnyParticipatingAgent();
            if (sDCClusterAgentProxy != null) {
                String string2;
                this._sep = string2 = sDCClusterAgentProxy.getServerFileSeparator();
                if (!sDCClusterSO.isLocalInstallation()) {
                    string = sDCClusterAgentProxy.getSybaseHome() + string2 + "data" + string2 + sDCClusterSO.getClusterName() + string2;
                    this._go.devicePathTextField.setText(string);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string;
    }

    public String getQualifiedDevicePath() {
        String string = this._go.devicePathTextField.getText().trim();
        int n = string.lastIndexOf("/");
        if (n == -1) {
            n = string.lastIndexOf("\\");
        }
        return string.substring(0, n + 1);
    }

    @Override
    public void textValueChanged(DocumentEvent documentEvent) {
        Document document;
        Document document2 = documentEvent.getDocument();
        if (document2 == (document = this._go.deviceNameTextField.getDocument())) {
            String string = this._go.deviceNameTextField.getText().trim();
            string = string.replaceAll("\\\\", "");
            string = string.replaceAll("\\/", "");
            String string2 = this.getQualifiedDevicePath() + string + "." + "dat";
            this._go.devicePathTextField.setText(string2);
        }
        this.updateButtonStates();
    }

    private void updateButtonStates() {
        String string = this._go.devicePathTextField.getText().trim();
        boolean bl = this._go.deviceNameTextField.getText().trim().length() > 0 && string.length() > 0 && !string.endsWith(this._sep);
        this.enableOkButton(bl);
    }

    public boolean onOk() {
        int n;
        boolean bl;
        String string = this._go.deviceNameTextField.getText().trim();
        if (string != null) {
            string = string.trim();
        }
        String string2 = this._go.devicePathTextField.getText().trim();
        int n2 = this._go.deviceSizeSpinBox.getValue();
        String string3 = (String)this._go.unitComboBox.getSelectedItem();
        String string4 = null;
        try {
            string4 = DBSizeUtil.toString(n2, string3);
        }
        catch (Exception exception) {
            Support.showError(null, this.getClass(), this.getJDialog(), exception.getMessage());
            return false;
        }
        int n3 = DBSizeUtil.toIntMB(n2, string3);
        if (n3 <= 0) {
            this._wiz.showErrorDialog(ASEUtils.getString("SDC_ERROR_INVALID_DEVICE_SIZE"));
            return false;
        }
        if (!SDCClusterSO.validateIdentifier(string)) {
            ASEMessageText aSEMessageText = new ASEMessageText(ASEUtils.getString("SDC_ERROR_INVALID_NAME"), string);
            Support.showError(null, this.getClass(), this.getJDialog(), aSEMessageText.toString());
            return false;
        }
        if (string.equalsIgnoreCase(SDCClusterSO.INVALID_DEVICE_NAME)) {
            ASEMessageText aSEMessageText = new ASEMessageText(ASEUtils.getString("ERR_INVALID_NAME_ENTRY"), string);
            Support.showError(null, this.getClass(), this.getJDialog(), aSEMessageText.toString());
            this._go.deviceNameTextField.requestFocus();
            this._go.deviceNameTextField.selectAll();
            return false;
        }
        if (this._so.hasDevice(string)) {
            ASEMessageText aSEMessageText = new ASEMessageText(ASEUtils.getString("SDC_ERROR_DEVICE_NAME_EXISTS"), string);
            Support.showError(null, this.getClass(), this.getJDialog(), aSEMessageText.toString());
            return false;
        }
        String string5 = new File(string2).getParent();
        if (string5 != null) {
            string5 = string5.replace('\\', '/');
            this.mkdirs(this._so, string5);
        }
        if (!(bl = this.validateDevicePath(string2))) {
            return false;
        }
        String string6 = this._so.getCluster().getPageSize();
        if (null != string6 && string6.length() > 0 && n3 < (n = this.getMinLSTDBSize(string6))) {
            ASEMessageText aSEMessageText = new ASEMessageText(ASEUtils.getString("SDC_ERROR_DEVICE_SIZE_LESS_THAN_MIN"), new Integer(n), new Integer(string6));
            Support.showError(null, this.getClass(), this.getJDialog(), aSEMessageText.toString());
            return false;
        }
        n = 0;
        n = !this._so.isVCSMode() ? this._wiz.getUsrConfirmForIOFencing(string2, false) : this._wiz.getUsrConfirmForVCS(string2, false);
        if (n != 0) {
            this._go.devicePathTextField.selectAll();
            this._go.devicePathTextField.requestFocus();
            return false;
        }
        this._deviceSO.setName(string);
        this._deviceSO.setMirrorPath(string2);
        this._deviceSO.setDatabaseDeviceSize(string4);
        this._so.addDevice(this._deviceSO);
        return true;
    }

    public boolean mkdirs(SDCClusterSO sDCClusterSO, String string) {
        for (Map.Entry entry : sDCClusterSO.getParticipatingAgents().entrySet()) {
            SDCClusterAgentProxy sDCClusterAgentProxy = (SDCClusterAgentProxy)entry.getValue();
            try {
                return DeviceValidator.mkdirs(sDCClusterAgentProxy, string);
            }
            catch (AgentConnectionException agentConnectionException) {
                ASEMessageText aSEMessageText = new ASEMessageText(ASEUtils.getString("SDC_ERROR"), agentConnectionException.getMessage());
                Support.showError(null, this.getClass(), this.getJDialog(), aSEMessageText.toString());
            }
        }
        return false;
    }

    public int getMinLSTDBSize(String string) {
        int n = 3;
        int n2 = 2;
        try {
            n2 = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            return n;
        }
        switch (n2) {
            case 2: {
                n = 3;
                break;
            }
            case 4: {
                n = 6;
                break;
            }
            case 8: {
                n = 12;
                break;
            }
            case 16: {
                n = 24;
                break;
            }
        }
        return n;
    }

    private boolean validateDevicePath(String string) {
        SDCClusterSO sDCClusterSO = this._so;
        return DeviceValidator.validateDevicePathOnAllNodes(string, sDCClusterSO, this.getClass(), this.getJDialog());
    }

    @Override
    public void releaseResources() {
        if (null != this._go) {
            this._go.deviceNameTextField.getDocument().removeDocumentListener(this);
            this._go.devicePathTextField.getDocument().removeDocumentListener(this);
            this._go = null;
        }
        super.releaseResources();
    }
}

