/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.aseplugin.bo.dlg;

import com.sybase.aseplugin.ASEUtils;
import com.sybase.aseplugin.bo.ASEBaseContainer2;
import com.sybase.aseplugin.bo.ContainerViewBO;
import com.sybase.aseplugin.bo.PreviewTracer;
import com.sybase.aseplugin.bo.RJSScheduledJobsBO;
import com.sybase.aseplugin.bo.ServerBO;
import com.sybase.aseplugin.bo.Support;
import com.sybase.aseplugin.bo.dlg.ASEDialogController;
import com.sybase.aseplugin.bo.dlg.ASEPageController;
import com.sybase.aseplugin.go.dlg.SQLPreviewDlgGOPage;
import com.sybase.aseplugin.sql.ASConnection;
import com.sybase.aseplugin.sql.SQLListener;
import com.sybase.central.SCDialogController;
import com.sybase.central.SCDialogSupport;
import com.sybase.central.SCPageController;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.sql.SQLException;
import java.util.Enumeration;
import javax.swing.JDialog;
import javax.swing.JPanel;

public class SQLPreviewDialog
extends ASEDialogController {
    public final int DLG_CANCEL = 0;
    public final int DLG_OK = 1;
    private int _closeState = 0;
    private boolean status = true;
    private PreviewTracer tracer = null;
    private ASConnection _conn;
    private SQLPreviewDialogBOPage _page;
    private static SCDialogSupport _ds;
    private static final int SY_CHANGE_CACHE_TYPE_SUCCESSFUL = 10861;

    SQLPreviewDialog(SCDialogSupport sCDialogSupport, ASConnection aSConnection) {
        super(sCDialogSupport, new SCPageController[1]);
        this._conn = aSConnection;
        this._page = new SQLPreviewDialogBOPage();
        this._pageControllers[0] = this._page;
        this._page.startLogging();
    }

    public static SQLPreviewDialog initDialog(ASConnection aSConnection, JDialog jDialog) {
        _ds = Support.createDialogSupport(jDialog);
        SQLPreviewDialog sQLPreviewDialog = new SQLPreviewDialog(_ds, aSConnection);
        ServerBO serverBO = ContainerViewBO.getServerBO(aSConnection);
        RJSScheduledJobsBO rJSScheduledJobsBO = ContainerViewBO.getRJSScheduledJobsBO(serverBO);
        sQLPreviewDialog.enableSchedule(rJSScheduledJobsBO != null && rJSScheduledJobsBO.showScheduleButton());
        _ds.setDialogController((SCDialogController)sQLPreviewDialog);
        _ds.setTitle(ASEUtils.getString("MSG_SQL_PREVIEW_TITLE"));
        _ds.setResizable(true);
        _ds.setModal(true);
        return sQLPreviewDialog;
    }

    public boolean render() {
        if (!this.tracer.available()) {
            return false;
        }
        return _ds.render();
    }

    public int getCloseState() {
        return this._closeState;
    }

    public boolean getStatus() {
        return this.status;
    }

    public void enableSchedule(boolean bl) {
        this._page.enableSchedule(bl);
    }

    class SQLPreviewDialogBOPage
    extends ASEPageController
    implements ActionListener,
    Printable {
        private SQLPreviewDlgGOPage _go;

        public SQLPreviewDialogBOPage() {
            super(_ds, (JPanel)((Object)new SQLPreviewDlgGOPage()));
            this._go = (SQLPreviewDlgGOPage)((Object)this.getJPanel());
        }

        @Override
        public void init() {
            FontMetrics fontMetrics = this._go.getFontMetrics(_ds.getStandardButtonById(1).getFont());
            int n = fontMetrics.stringWidth(_ds.getStandardButtonById(1).getText());
            _ds.getStandardButtonById(1).setText(ASEUtils.getString("MSG_EXECUTE"));
            _ds.getStandardButtonById(2).setText(ASEUtils.getString("MENU_CLOSE"));
            int n2 = fontMetrics.stringWidth(_ds.getStandardButtonById(1).getText());
            int n3 = (int)_ds.getStandardButtonById(1).getPreferredSize().getWidth() + (n2 > n ? (n2 - n) / 2 : 0);
            int n4 = (int)_ds.getStandardButtonById(1).getPreferredSize().getHeight();
            _ds.getStandardButtonById(1).setPreferredSize(new Dimension(n3, n4));
            this._go.saveButton.addActionListener((ActionListener)this);
            this._go.scheduleButton.addActionListener((ActionListener)this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            String string;
            if (actionEvent.getSource() == this._go.saveButton && (string = Support.browseForNewFile(Support.getViewerFrame(), null, ASEUtils.getString("MSG_SQL_PREVIEW_TITLE"), 2)) != null) {
                if (string.indexOf(".") == -1) {
                    string = string + ".sql";
                }
                PrintWriter printWriter = null;
                try {
                    printWriter = new PrintWriter(new BufferedWriter(new FileWriter(string)));
                    printWriter.println(this._go.previewEditor.getText());
                    printWriter.flush();
                    printWriter.close();
                }
                catch (IOException iOException) {
                    Support.showDetailsError(SQLPreviewDialog.this._conn, this.getClass(), (Container)this.getJDialog(), iOException.getMessage(), iOException);
                }
                finally {
                    printWriter.close();
                }
            }
            if (actionEvent.getSource() == this._go.scheduleButton) {
                Support.setEnableScheduling(true);
                SQLPreviewDialog.this.tracer.stopTracing();
                if (Support.initRemoteJSWizard(SQLPreviewDialog.this._conn, this._go.previewEditor.getText(), Support.getRefreshContainer())) {
                    Support.showRemoteJSWizard(this.getJDialog());
                }
                Support.setEnableScheduling(false);
            }
        }

        @Override
        public String getHelpID() {
            return "HELP_ASEP_DLG_PREVIEW_15";
        }

        private boolean startLogging() {
            SQLPreviewDialog.this.tracer = new PreviewTracer(SQLPreviewDialog.this._conn, this._go.previewEditor);
            SQLPreviewDialog.this.tracer.init();
            SQLPreviewDialog.this._conn.addSQLPreviewListener(SQLPreviewDialog.this.tracer);
            return true;
        }

        public boolean onOk() {
            SQLPreviewDialog.this._closeState = 1;
            if (this.processQuery()) {
                SQLPreviewDialog.this.status = true;
                this.removeListeners();
                this.refresh();
                return this.closeDialog(true);
            }
            SQLPreviewDialog.this.status = false;
            return false;
        }

        public boolean onCancel() {
            SQLPreviewDialog.this.status = false;
            SQLPreviewDialog.this._closeState = 0;
            this.removeListeners();
            return this.closeDialog(false);
        }

        private boolean closeDialog(boolean bl) {
            _ds.closeDialog(bl);
            return true;
        }

        public void removeListeners() {
            if (SQLPreviewDialog.this._conn.hasSQLPreviewListeners()) {
                Enumeration enumeration = SQLPreviewDialog.this._conn.getSQLPreviewListeners();
                while (enumeration.hasMoreElements()) {
                    SQLListener sQLListener = (SQLListener)enumeration.nextElement();
                    sQLListener.stopTracing();
                }
            }
        }

        public void refresh() {
            ASEBaseContainer2 aSEBaseContainer2 = Support.getRefreshContainer();
            if (aSEBaseContainer2 != null) {
                aSEBaseContainer2.refresh();
                Support.setRefreshContainer(null);
            }
        }

        public boolean processQuery() {
            try {
                String string = this._go.previewEditor.getText();
                string = string.replaceAll("\\bGO\\b", "go");
                string = string.replaceAll("\\bGo\\b", "go");
                string = string.replaceAll("\\bgO\\b", "go");
                string = string.replaceAll("\r", "");
                String[] stringArray = string.split("\n");
                String string2 = new String();
                for (int i = 0; i < stringArray.length; ++i) {
                    String string3 = stringArray[i].trim();
                    if (string3.length() == 0) {
                        string2 = string2 + string3 + "\n";
                        continue;
                    }
                    if (string3.equals("go")) {
                        if (string2.length() != 0) {
                            SQLPreviewDialog.this._conn.executeCommand(string2, false);
                        }
                        string2 = new String();
                        continue;
                    }
                    string2 = string2 + string3 + "\n";
                }
                if (string2.length() != 0) {
                    SQLPreviewDialog.this._conn.executeCommand(string2, false);
                }
            }
            catch (SQLException sQLException) {
                if (sQLException.getErrorCode() != 10861) {
                    Support.showDetailsError(SQLPreviewDialog.this._conn, this.getClass(), sQLException.getMessage(), sQLException);
                    return false;
                }
                return true;
            }
            return true;
        }

        @Override
        public int print(Graphics graphics, PageFormat pageFormat, int n) {
            this._go.previewEditor.printAll(graphics);
            graphics.dispose();
            return 0;
        }

        public void enableSchedule(boolean bl) {
            this._go.scheduleButton.setVisible(bl);
        }
    }
}

