/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.aseplugin.bo.dlg;

import com.sybase.asa.ASAIconTextData;
import com.sybase.aseplugin.ASEMessageText;
import com.sybase.aseplugin.ASEUtils;
import com.sybase.aseplugin.bo.ProcessBO;
import com.sybase.aseplugin.bo.dlg.ASEPageController;
import com.sybase.aseplugin.go.dlg.ShutdownConfirmDlgGOPage;
import com.sybase.aseplugin.so.ProcessSO;
import com.sybase.aseplugin.so.ProcessesCtrSO;
import com.sybase.aseplugin.so.ServerSO;
import com.sybase.aseplugin.sql.ASConnection;
import com.sybase.central.SCDialogSupport;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.sql.SQLException;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.UIManager;

class ShutdownConfirmDialogPage
extends ASEPageController
implements ItemListener {
    private ShutdownConfirmDlgGOPage _go = (ShutdownConfirmDlgGOPage)((Object)this.getJPanel());
    private ServerSO _serverSO;
    private boolean _hasPermission = true;

    ShutdownConfirmDialogPage(SCDialogSupport sCDialogSupport, ServerSO serverSO) {
        super(sCDialogSupport, (JPanel)((Object)new ShutdownConfirmDlgGOPage()));
        this._serverSO = serverSO;
        ASEMessageText aSEMessageText = new ASEMessageText(ASEUtils.getString("SHUTDOWN_DLG_QUES_SHUTDOWN"), this._serverSO.getName());
        this._go.questionMultiLineLabel.setText(aSEMessageText.toString());
        aSEMessageText = new ASEMessageText(ASEUtils.getString("SHUTDOWN_DLG_CHKB_NO_WAIT"), this._serverSO.getName());
        this._go.noWaitRadioButton.setText(aSEMessageText.toString());
        aSEMessageText = new ASEMessageText(ASEUtils.getString("SHUTDOWN_DLG_RADB_REMINDER"), this._serverSO.getName());
        this._go.reminderRadioButton.setText(aSEMessageText.toString());
    }

    @Override
    public String getHelpID() {
        return "HELP_SERVER_DLG_SHUTDOWN_1252";
    }

    @Override
    public void init() throws SQLException {
        JButton jButton = this._dialogSupport.getStandardButtonById(1);
        jButton.setText(ASEUtils.getString("MSG_YES"));
        JButton jButton2 = this._dialogSupport.getStandardButtonById(2);
        jButton2.setText(ASEUtils.getString("MSG_NO"));
        if (this._serverSO.getConnection() == null) {
            return;
        }
        this._go.reminderRadioButton.setSelected(true);
        this._go.reminderRadioButton.addItemListener((ItemListener)this);
        this._go.noWaitRadioButton.addItemListener((ItemListener)this);
        ProcessesCtrSO processesCtrSO = new ProcessesCtrSO(this._serverSO.getConnection());
        boolean bl = this._serverSO.getConnection().hasSARole();
        if (!bl) {
            this._hasPermission = false;
            this._go.processMultiList.setEnabled(false);
            this._go.currentProcessLabel.setEnabled(false);
            this._go.reminderComboBox.setEnabled(false);
            this._go.reminderRadioButton.setEnabled(false);
            this._go.noWaitRadioButton.setEnabled(false);
            jButton.setText(ASEUtils.getString("MSG_OK"));
            jButton2.setText(ASEUtils.getString("MSG_CANCEL"));
            jButton.setEnabled(false);
            this._go.iconLabel.setIcon(UIManager.getIcon("OptionPane.errorIcon"));
            this._go.questionMultiLineLabel.setText(ASEUtils.getString("MSG_NEED_SA_ROLE_TO_SHUTDOWN"));
        }
        List list = processesCtrSO.open(1, null);
        for (ProcessSO processSO : list) {
            String string = processSO.getLogin();
            if (string == null || string.length() <= 0) continue;
            String string2 = processSO.getID();
            String string3 = processSO.getProgram();
            String string4 = processSO.getCommand();
            String string5 = processSO.getStatus();
            String string6 = processSO.getHostName();
            ASAIconTextData aSAIconTextData = new ASAIconTextData((Icon)ProcessBO.PROCESS_ICON, string2);
            this._go.processMultiList.addRow(new Object[]{aSAIconTextData, string3, string4, string, string5, string6});
        }
        this._go.processMultiList.setInitialColumnWidths();
        if (ASConnection.isShutdownServer(this._serverSO.getName())) {
            this._go.noWaitRadioButton.setSelected(true);
        }
    }

    public boolean isNoWait() {
        return this._go.noWaitRadioButton.isSelected();
    }

    int getReminderMinutes() {
        int n = this._go.reminderComboBox.getSelectedIndex();
        if (n == 0) {
            return 1;
        }
        return n * 5;
    }

    public boolean onOk() {
        return this.closeDialog(this._hasPermission);
    }

    public boolean onCancel() {
        return this.closeDialog(false);
    }

    private boolean closeDialog(boolean bl) {
        this._dialogSupport.closeDialog(bl);
        return true;
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource() == this._go.reminderRadioButton || itemEvent.getSource() == this._go.noWaitRadioButton) {
            this.enableComponents();
        }
    }

    @Override
    public void enableComponents() {
        if (this._hasPermission) {
            this._go.reminderComboBox.setEnabled(!this.isNoWait());
        }
    }
}

