/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.aseplugin.bo.dlg;

import com.sybase.aseplugin.ASEUtils;
import com.sybase.aseplugin.so.ProcedureSO;
import com.sybase.aseplugin.so.StoredProcedureSO;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.table.AbstractTableModel;

class StoredProcedureParameterTableModel
extends AbstractTableModel {
    private static final short NAME_COLUMN = 0;
    private static final short VALUE_COLUMN = 1;
    private static final short DATATYPE_COLUMN = 2;
    protected ArrayList _inputs;
    protected ArrayList _paramList;
    protected String[] _columnNames;
    protected ProcedureSO _pso;

    StoredProcedureParameterTableModel(ProcedureSO procedureSO) throws SQLException {
        this._pso = procedureSO;
        this._columnNames = new String[]{ASEUtils.getString("MSG_COLUMN_TYPE"), ASEUtils.getString("DISP_VALUE_TEXT"), ASEUtils.getString("DISP_DATA_TYPE_TEXT")};
        List list = procedureSO.getParamList();
        this._inputs = new ArrayList();
        this._paramList = new ArrayList();
        for (String[] stringArray : list) {
            String string = stringArray[0];
            String string2 = stringArray[1];
            String string3 = stringArray[2];
            int n = Integer.valueOf(stringArray[3]);
            Parameter parameter = new Parameter(string, string2, string3, n);
            this._paramList.add(parameter);
            if (!string3.equals("in")) continue;
            this._inputs.add(parameter);
        }
    }

    @Override
    public int getRowCount() {
        return this._inputs.size();
    }

    @Override
    public int getColumnCount() {
        return 3;
    }

    @Override
    public String getColumnName(int n) {
        return this._columnNames[n];
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return n2 == 1;
    }

    @Override
    public Object getValueAt(int n, int n2) {
        if (n > this._inputs.size()) {
            throw new IllegalArgumentException("Row " + n + " is invalid. It must be between 0 and " + this._inputs.size());
        }
        Parameter parameter = (Parameter)this._inputs.get(n);
        String string = n2 == 0 ? parameter.name : (n2 == 1 ? parameter.value : (n2 == 2 ? parameter.datatype : null));
        return string;
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        if (n > this._inputs.size()) {
            throw new IllegalArgumentException("Row " + n + " is invalid. It must be between 0 and " + this._inputs.size());
        }
        if (n2 != 1) {
            throw new IllegalArgumentException("Column " + n2 + " is invalid. It must be " + 1);
        }
        Parameter parameter = (Parameter)this._inputs.get(n);
        parameter.value = object == null ? null : object.toString();
    }

    String getCallStatement() {
        StoredProcedureSO storedProcedureSO;
        Object object;
        int n;
        StringBuffer stringBuffer = new StringBuffer(256);
        for (n = 0; n < this._paramList.size(); ++n) {
            object = (Parameter)this._paramList.get(n);
            if (!((Parameter)object).mode.equals("out")) continue;
            stringBuffer.append("declare " + ((Parameter)object).name + " " + ((Parameter)object).datatype + "\n");
        }
        stringBuffer.append("exec ");
        if (this._pso.getOwner() != null && this._pso.getOwner().length() > 0) {
            stringBuffer.append(this._pso.getOwner());
            stringBuffer.append('.');
        }
        stringBuffer.append(this._pso.getName());
        if (this._pso instanceof StoredProcedureSO && !((String)(object = (storedProcedureSO = (StoredProcedureSO)this._pso).getGroupNumber())).equals("1")) {
            stringBuffer.append(";" + (String)object);
        }
        stringBuffer.append(' ');
        for (n = 0; n < this._paramList.size(); ++n) {
            object = (Parameter)this._paramList.get(n);
            if (n > 0 && stringBuffer.length() > 0) {
                stringBuffer.append(", ");
            }
            if (((Parameter)object).mode.equals("in")) {
                String string = this.getInputValue(((Parameter)object).order);
                stringBuffer.append(string == null ? "null" : string);
                continue;
            }
            stringBuffer.append(((Parameter)object).name + " output");
        }
        return stringBuffer.toString();
    }

    private String getInputValue(int n) {
        for (int i = 0; i < this._inputs.size(); ++i) {
            Parameter parameter = (Parameter)this._inputs.get(i);
            if (parameter.order != n) continue;
            return parameter.value;
        }
        return null;
    }

    static class Parameter {
        String name;
        String value;
        String datatype;
        String mode;
        int order;

        Parameter(String string, String string2, String string3, int n) {
            this.name = string;
            this.value = null;
            this.datatype = string2;
            this.mode = string3;
            this.order = n;
        }
    }
}

