/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.aseplugin.bo.dlg;

import com.sybase.asa.ASAButton;
import com.sybase.asa.ASAGOConstants;
import com.sybase.asa.ASALabel;
import com.sybase.aseplugin.ASEMessageText;
import com.sybase.aseplugin.ASEUtils;
import com.sybase.aseplugin.bo.Support;
import com.sybase.aseplugin.go.ASEMnemGridBagPanel;
import com.sybase.aseplugin.go.ASETable;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

class TabularRSPanel
extends JPanel
implements ActionListener,
ASAGOConstants,
ListSelectionListener {
    private ASETable _table;
    private ASAButton _selectAllButton = null;
    private ASAButton _copyButton = null;
    private ASALabel _selectedLabel = null;
    private ASALabel _rowLabel = null;
    private GridBagConstraints _gbc = null;
    private ASEMnemGridBagPanel _panel = null;
    private GridBagLayout _layout = null;

    TabularRSPanel(ASETable aSETable) {
        this._table = aSETable;
        this._selectAllButton = new ASAButton(ASEUtils.getString("BTTN_SELECT_ALL"));
        this._selectAllButton.setMnemonic(Support.getMnemonic("MNEM_SELECT_ALL"));
        this._copyButton = new ASAButton(ASEUtils.getString("DATA_DTLSPANEL_BTTN_COPY_ROW"));
        this._copyButton.setMnemonic(Support.getMnemonic("DATA_DTLSPANEL_MNEM_COPY_ROW"));
        this._selectedLabel = new ASALabel();
        this._rowLabel = new ASALabel();
        this._copyButton.setToolTipText(ASEUtils.getString("DATA_DTLSPANEL_TTIP_COPY_ROW"));
        this._copyButton.setEnabled(false);
        this._selectAllButton.addActionListener((ActionListener)this);
        this._copyButton.addActionListener((ActionListener)this);
        this._table.getSelectionModel().addListSelectionListener(this);
        this._panel = new ASEMnemGridBagPanel(INSETS_NONE);
        int n = 0;
        this._panel.add((Component)this._selectAllButton, n, 0, 1, 1, 0.0, 0.0, 17, 0, INSETS, 0, 0);
        this._panel.add((Component)this._copyButton, ++n, 0, 1, 1, 0.0, 0.0, 17, 0, INSETS, 0, 0);
        this._panel.add((Component)this._selectedLabel, ++n, 0, 1, 1, 0.5, 0.0, 17, 2, INSETS, 0, 0);
        this._panel.add((Component)this._rowLabel, ++n, 0, 1, 1, 0.5, 0.0, 17, 2, INSETS, 0, 0);
        this._layout = new GridBagLayout();
        this.setLayout(this._layout);
        this._gbc = new GridBagConstraints();
        this._gbc.anchor = 18;
        this._gbc.fill = 2;
        this._gbc.gridheight = 1;
        this._gbc.gridwidth = 0;
        this._gbc.gridx = 0;
        this._gbc.gridy = 0;
        this._gbc.ipadx = 0;
        this._gbc.ipady = 0;
        this._gbc.weightx = 0.0;
        this._gbc.weighty = 0.0;
        this.add((Component)((Object)this._panel), this._gbc);
        this._gbc.anchor = 18;
        this._gbc.fill = 1;
        this._gbc.gridheight = 0;
        this._gbc.gridwidth = 0;
        this._gbc.gridx = 0;
        this._gbc.gridy = 1;
        this._gbc.ipadx = 0;
        this._gbc.ipady = 0;
        this._gbc.weightx = 1.0;
        this._gbc.weighty = 1.0;
        this.add((Component)new JScrollPane(this._table), this._gbc);
        ASEMessageText aSEMessageText = new ASEMessageText(ASEUtils.getString("MSG_NUM_ROWS"), new Integer(this._table.getRowCount()));
        this._rowLabel.setText(aSEMessageText.toString());
        this.updateToolbarButtons();
    }

    private void updateToolbarButtons() {
        this._copyButton.setEnabled(this._table.getSelectedRow() > -1);
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        int n = this._table.getSelectedRows().length;
        if (n > 0) {
            String string = n > 1 ? ASEUtils.getString("DATA_DTLSPANEL_LABC_ROWS_SELECTED") : ASEUtils.getString("DATA_DTLSPANEL_LABC_ONE_ROW_SELECTED");
            ASEMessageText aSEMessageText = new ASEMessageText(string, new Integer(n));
            this._selectedLabel.setText(aSEMessageText.toString());
            this.updateToolbarButtons();
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this._selectAllButton) {
            this._table.selectAll();
        } else if (actionEvent.getSource() == this._copyButton) {
            this._table.copy();
        }
    }
}

