/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.aseplugin.bo.dlg;

import com.sybase.asa.ASABaseGridBagPanel;
import com.sybase.asa.ASAButton;
import com.sybase.asa.ASAGOConstants;
import com.sybase.asa.ASALabel;
import com.sybase.asa.ASAProgressBar;
import com.sybase.aseplugin.ASEUtils;
import com.sybase.util.DialogUtils;
import com.sybase.util.UIUtils;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import javax.swing.JDialog;
import javax.swing.UIManager;

public class WorkingDialogWithCancel
extends JDialog
implements Runnable,
ActionListener {
    private Runnable _client;
    private boolean _done;
    private String _message;
    private String _title;
    private ASALabel _messageLabel;
    private ASAButton _cancelButton;
    private Thread _workerThread;
    private boolean _isCancelled;

    public WorkingDialogWithCancel(Dialog dialog, Runnable runnable, String string, String string2) {
        super(dialog, true);
        this._title = string;
        this._message = string2;
        this.init(dialog, runnable);
    }

    private void init(Window window, Runnable runnable) {
        this._client = runnable;
        this.createGUI();
        this.setLocationRelativeTo(window);
        this._cancelButton.addActionListener((ActionListener)this);
        this._isCancelled = false;
        this._done = false;
        this._workerThread = new Thread((Runnable)this, "WorkingDialogWithCancel thread");
        this._workerThread.start();
        if (!this._done) {
            UIUtils.ensureWindowIsVisible((Window)this);
            this.setVisible(true);
            this.destroyGUI();
        }
        this._client = null;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this._cancelButton) {
            this._isCancelled = true;
            this.setVisible(false);
            this.destroyGUI();
        }
    }

    @Override
    protected void processWindowEvent(WindowEvent windowEvent) {
        super.processWindowEvent(windowEvent);
        if (windowEvent.getID() == 201) {
            this._isCancelled = true;
            this.setVisible(false);
            this.destroyGUI();
        }
    }

    private void createGUI() {
        ASABaseGridBagPanel aSABaseGridBagPanel = new ASABaseGridBagPanel();
        this._messageLabel = new ASALabel(this._message, UIManager.getIcon("OptionPane.informationIcon"), 2);
        ASAProgressBar aSAProgressBar = new ASAProgressBar();
        aSAProgressBar.setIndeterminate(true);
        this._cancelButton = new ASAButton(ASEUtils.getString("MSG_CANCEL"));
        aSABaseGridBagPanel.add((Component)this._messageLabel, 0, 0, 1, 1, 0.0, 0.0, 17, 0, ASAGOConstants.INSETS, 0, 0);
        aSABaseGridBagPanel.add((Component)aSAProgressBar, 0, 1, 1, 1, 1.0, 0.0, 17, 2, ASAGOConstants.INSETS, 0, 0);
        aSABaseGridBagPanel.add((Component)this._cancelButton, 0, 2, 1, 1, 0.0, 0.0, 10, 0, ASAGOConstants.INSETS, 0, 0);
        this.setTitle(this._title);
        this.getContentPane().add((Component)aSABaseGridBagPanel);
        this.pack();
        this.setDefaultCloseOperation(0);
        this.setResizable(false);
    }

    private void destroyGUI() {
        this._cancelButton.removeActionListener((ActionListener)this);
        DialogUtils.removeComponents((Container)this);
    }

    public void setNote(String string) {
        this._messageLabel.setText(string);
    }

    @Override
    public void run() {
        this._client.run();
        this._done = true;
        this.setVisible(false);
    }

    public boolean isCancelled() {
        return this._isCancelled;
    }
}

