/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.aseplugin.bo.prop;

import com.sybase.asa.ASAIconTextData;
import com.sybase.asa.ASASpinBoxChangeEvent;
import com.sybase.asa.ASASpinBoxChangeListener;
import com.sybase.ase.sdcadmin.config.ICluster;
import com.sybase.ase.sdcadmin.config.IServer;
import com.sybase.aseplugin.ASEUtils;
import com.sybase.aseplugin.bo.ContainerViewBO;
import com.sybase.aseplugin.bo.SDCInstanceBO;
import com.sybase.aseplugin.bo.ServerBO;
import com.sybase.aseplugin.bo.Support;
import com.sybase.aseplugin.bo.dlg.AddNodesToAuxServerDialog;
import com.sybase.aseplugin.bo.prop.ASEBasePropertiesPage2;
import com.sybase.aseplugin.bo.prop.BackupServerPropertiesBase;
import com.sybase.aseplugin.bo.wiz.BackupServerWizardBase;
import com.sybase.aseplugin.go.prop.BackupServerPropGOGeneralPage;
import com.sybase.aseplugin.so.BackupServerSO;
import com.sybase.aseplugin.so.SDCInstanceSO;
import com.sybase.aseplugin.so.SOItemInterface;
import com.sybase.aseplugin.so.ServerSO;
import com.sybase.central.SCContainer2;
import com.sybase.central.SCPageController;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class BackupServerProperties
extends BackupServerPropertiesBase {
    public BackupServerProperties(BackupServerSO backupServerSO, SCContainer2 sCContainer2) {
        super((SOItemInterface)backupServerSO, sCContainer2);
    }

    @Override
    public SCPageController[] getPages() {
        return new SCPageController[]{new BackupServerPropGeneralPage(this)};
    }

    class BackupServerPropGeneralPage
    extends ASEBasePropertiesPage2
    implements ActionListener,
    ListSelectionListener,
    ASASpinBoxChangeListener {
        BackupServerPropGOGeneralPage _go;

        public BackupServerPropGeneralPage(BackupServerProperties backupServerProperties2) {
            super(backupServerProperties2, (JPanel)((Object)new BackupServerPropGOGeneralPage()), ASEUtils.getString("MSG_GENERAL"));
            this._go = (BackupServerPropGOGeneralPage)((Object)this.getJPanel());
            this._go.portSpinBoxCellEditor.addASASpinBoxChangeListener(this);
            this._go.hostsMultiList.addListSelectionListener((ListSelectionListener)this);
            this._go.addButton.addActionListener((ActionListener)this);
            this._go.removeButton.addActionListener((ActionListener)this);
        }

        @Override
        public void init() throws Exception {
            this._go.nameTextField.setText(((BackupServerSO)this.getSO()).getName());
            this._go.typeTextLabel.setText(((BackupServerSO)this.getSO()).getDisplayType());
            this._go.removeButton.setEnabled(false);
            this._goPanel.getPreviewButton().setEnabled(false);
            this._goPanel.getPreviewButton().setVisible(false);
            this._go.hostsMultiList.clear();
            Vector vector = ((BackupServerSO)this.getSO()).getNodes();
            Object[] objectArray = null;
            for (int i = 0; i < vector.size(); ++i) {
                objectArray = (Object[])vector.get(i);
                SDCInstanceSO sDCInstanceSO = BackupServerProperties.this.getAuxServerUtilities().getSDCInstanceSOByHost(objectArray[0].toString());
                this._go.hostsMultiList.addRow(new Object[]{new ASAIconTextData((Icon)SDCInstanceBO.getIcon(this.getConnection().getServerServerName(), sDCInstanceSO), objectArray[0].toString()), objectArray[1]});
            }
            this.setAddButtonEnabled();
        }

        private void enableApplyBtn(boolean bl) {
            super.enableApplyButton(bl);
            this._goPanel.getPreviewButton().setEnabled(false);
            this._goPanel.getScheduleButton().setEnabled(false);
            this._goPanel.getPreviewButton().setVisible(false);
            this._goPanel.getScheduleButton().setVisible(false);
        }

        public void valueChanged(ASASpinBoxChangeEvent aSASpinBoxChangeEvent) {
            this.enableApplyBtn(true);
        }

        private void setAddButtonEnabled() {
            this._go.addButton.setEnabled(this.getUnSelectedNodes().length != 0);
        }

        private void setRemoveButtonEnabled() {
            this._go.removeButton.setEnabled(this._go.hostsMultiList.getSelectedRowCount() > 0 && this._go.hostsMultiList.getRowCount() > 1);
        }

        private boolean containsNode(String string) {
            for (int i = 0; i < this._go.hostsMultiList.getRowCount(); ++i) {
                if (!string.equals(this._go.hostsMultiList.getRowAsArray(i)[0].toString())) continue;
                return true;
            }
            return false;
        }

        private IServer[] getUnSelectedNodes() {
            Hashtable<String, IServer> hashtable = new Hashtable<String, IServer>();
            ICluster iCluster = BackupServerProperties.this.getAuxServerUtilities().getCluster();
            IServer[] iServerArray = iCluster.getServersArray();
            IServer iServer = null;
            for (int i = 0; i < iServerArray.length; ++i) {
                iServer = iServerArray[i];
                if (this.containsNode(iServer.getNode()) || hashtable.containsKey(iServer.getNode())) continue;
                hashtable.put(iServer.getNode(), iServer);
            }
            IServer[] iServerArray2 = new IServer[hashtable.size()];
            hashtable.values().toArray(iServerArray2);
            return iServerArray2;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            IServer[] iServerArray;
            AddNodesToAuxServerDialog addNodesToAuxServerDialog;
            if (actionEvent.getSource() == this._go.removeButton) {
                this._go.hostsMultiList.removeRow(this._go.hostsMultiList.getSelectedRow());
                this.enableApplyBtn(true);
            }
            if (actionEvent.getSource() == this._go.addButton && (addNodesToAuxServerDialog = AddNodesToAuxServerDialog.getDialog(Support.getViewerFrame(), ASEUtils.getString("BACKUP_SERVER_PROP_ADD_HOSTS_TITLE"), ASEUtils.getString("BACKUP_SERVER_PROP_ADD_HOSTS_LABEL"), this.getConnection(), this.getUnSelectedNodes())).render() && (iServerArray = addNodesToAuxServerDialog.getSelectedNodes()) != null && iServerArray.length > 0) {
                try {
                    BackupServerPropertiesBase.DiscoveryPortNumberTask discoveryPortNumberTask = new BackupServerPropertiesBase.DiscoveryPortNumberTask(iServerArray){

                        @Override
                        public void onPortNumberDiscovered(IServer iServer, String string) {
                            BackupServerPropGeneralPage.this._go.hostsMultiList.addRow(new Object[]{new ASAIconTextData((Icon)SDCInstanceBO.getIcon(BackupServerPropGeneralPage.this.getConnection().getServerServerName(), BackupServerProperties.this.getAuxServerUtilities().getSDCInstanceSO(iServer.getName())), iServer.getNode()), Integer.valueOf(string)});
                        }
                    };
                    BackupServerProperties.this.discoveryPortNumber(discoveryPortNumberTask, this.getJDialog());
                }
                catch (Exception exception) {
                    Support.showDetailsError(this.getConnection(), this.getClass(), (Container)this.getJDialog(), exception.getMessage(), exception);
                }
                this.enableApplyBtn(true);
            }
            this.setAddButtonEnabled();
            this.setRemoveButtonEnabled();
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            super.enableOkButton(true);
            this.setRemoveButtonEnabled();
        }

        @Override
        public String getHelpID() {
            return "HELP_BACKUP_SERVER_PROP_GENERAL_151";
        }

        @Override
        public boolean deploy() throws Exception {
            if (!this.getDialogSupport().getStandardButtonById(4).isEnabled()) {
                return true;
            }
            boolean bl = false;
            BackupServerProperties.this.updateNewSO(this._go.hostsMultiList);
            if (!BackupServerProperties.this.isChanged()) {
                return true;
            }
            ServerBO serverBO = ContainerViewBO.getServerBO(this.getConnection());
            ServerSO serverSO = (ServerSO)serverBO.getSO();
            if (serverSO.isLocalInstallation() && !serverBO.supportInLocalInstallation()) {
                Support.showDetailsError(this.getConnection(), this.getClass(), (Container)this.getJDialog(), ASEUtils.getString("SDC_CLUSTER_INVALID_LDAP_IN_LOCAL_MODE_ERROR"), new UnsupportedOperationException(ASEUtils.getString("SDC_CLUSTER_INVALID_LDAP_IN_LOCAL_MODE_ERROR_DETAILS")));
                return true;
            }
            if (BackupServerProperties.this.validateNewSO(BackupServerWizardBase.SERVER_TYPE_BACKUP)) {
                BackupServerPropertiesBase.UpdateServerTask updateServerTask = new BackupServerPropertiesBase.UpdateServerTask(){

                    @Override
                    void updateAuxServer(List list, List list2, List list3) throws Exception {
                        ((BackupServerSO)BackupServerProperties.this.getNewSO()).updateServer(list, list2, list3);
                        BackupServerProperties.this.setSO(BackupServerProperties.this.getNewSO());
                    }
                };
                String string = ASEUtils.getString("AUXILIARY_SERVER_UPDATE_BS_TASK_TITLE");
                bl = BackupServerProperties.this.updateAuxServer(updateServerTask, this.getJDialog(), string);
            }
            return bl;
        }

        @Override
        public void releaseResources() {
            this._go.portSpinBoxCellEditor.removeASASpinBoxChangeListener(this);
            this._go.hostsMultiList.removeListSelectionListener((ListSelectionListener)this);
            this._go.addButton.removeActionListener((ActionListener)this);
            this._go.removeButton.removeActionListener((ActionListener)this);
        }
    }
}

