/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.aseplugin.bo.prop;

import com.sybase.asa.ASAMultiList;
import com.sybase.ase.sdcadmin.config.ICluster;
import com.sybase.ase.sdcadmin.config.IServer;
import com.sybase.aseplugin.ASEMessageText;
import com.sybase.aseplugin.ASEUtils;
import com.sybase.aseplugin.bo.ContainerViewBO;
import com.sybase.aseplugin.bo.Support;
import com.sybase.aseplugin.bo.dlg.WorkingDialogRunnable;
import com.sybase.aseplugin.bo.dlg.WorkingDialogWithMsgChangable;
import com.sybase.aseplugin.bo.dlg.WorkingDialogWithSkipCancel;
import com.sybase.aseplugin.bo.prop.ASEBasePropertiesDialog2;
import com.sybase.aseplugin.bo.wiz.BackupServerWizardBase;
import com.sybase.aseplugin.so.BackupServerSO;
import com.sybase.aseplugin.so.BackupServerSO2;
import com.sybase.aseplugin.so.BackupServerSOBase;
import com.sybase.aseplugin.so.MonitorServerSO;
import com.sybase.aseplugin.so.MonitorServersCtrSO;
import com.sybase.aseplugin.so.SOItemInterface;
import com.sybase.aseplugin.so.ServerSO;
import com.sybase.aseplugin.so.XPServerSO;
import com.sybase.aseplugin.util.PortsDiscoveryUtil;
import com.sybase.central.SCContainer2;
import com.sybase.central.SCPageController;
import com.sybase.ua.AgentConnectionException;
import java.awt.Container;
import java.awt.Dialog;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import javax.swing.JDialog;

public abstract class BackupServerPropertiesBase
extends ASEBasePropertiesDialog2 {
    private BackupServerWizardBase _auxServerUtilities;
    private BackupServerSOBase _newSO;
    private List _addedNodes = new ArrayList();
    private List _removedNodes = new ArrayList();
    private List _changedNodes = new ArrayList();

    public BackupServerPropertiesBase(SOItemInterface sOItemInterface, SCContainer2 sCContainer2) {
        super(sOItemInterface, sCContainer2);
    }

    protected BackupServerWizardBase getAuxServerUtilities() {
        if (this._auxServerUtilities == null) {
            this._auxServerUtilities = new BackupServerWizardBase(this.getSO(), this.getParent(), ""){

                @Override
                public SCPageController[] getPages() {
                    return null;
                }
            };
            this._auxServerUtilities.setDialogSupport(this.getDialogSupport());
        }
        return this._auxServerUtilities;
    }

    @Override
    public abstract SCPageController[] getPages();

    protected boolean isChanged() {
        return this._addedNodes.size() > 0 || this._changedNodes.size() > 0 || this._removedNodes.size() > 0;
    }

    protected BackupServerSOBase getNewSO() {
        return this._newSO;
    }

    protected void updateNewSO(ASAMultiList aSAMultiList) throws CloneNotSupportedException {
        int n;
        this._addedNodes.clear();
        this._removedNodes.clear();
        this._changedNodes.clear();
        BackupServerSOBase backupServerSOBase = (BackupServerSOBase)this.getSO();
        this._newSO = (BackupServerSOBase)backupServerSOBase.clone();
        this._newSO.clearNodes();
        Object[] objectArray = null;
        for (n = 0; n < aSAMultiList.getRowCount(); ++n) {
            objectArray = aSAMultiList.getRowAsArray(n);
            objectArray[0] = objectArray[0].toString();
            this._newSO.addNode(objectArray);
            if (!backupServerSOBase.isNodeExists(objectArray[0].toString())) {
                this._addedNodes.add(objectArray);
                continue;
            }
            Object[] objectArray2 = backupServerSOBase.getNode(objectArray[0].toString());
            if (objectArray2[1].equals(objectArray[1])) continue;
            this._changedNodes.add(objectArray);
        }
        for (n = 0; n < backupServerSOBase.getNodes().size(); ++n) {
            objectArray = (Object[])backupServerSOBase.getNodes().get(n);
            if (this._newSO.isNodeExists(objectArray[0].toString())) continue;
            this._removedNodes.add(objectArray);
        }
    }

    protected boolean validateNewSO(int n) throws AgentConnectionException, RemoteException {
        Object[] objectArray = null;
        String string = "";
        Integer n2 = null;
        ArrayList arrayList = new ArrayList(this._addedNodes);
        arrayList.addAll(this._changedNodes);
        for (int i = 0; i < arrayList.size(); ++i) {
            objectArray = (Object[])arrayList.get(i);
            string = objectArray[0].toString();
            n2 = Integer.valueOf(objectArray[1].toString());
            if (!(n == BackupServerWizardBase.SERVER_TYPE_BACKUP && !this._newSO.isEnableMBS() ? !this.getAuxServerUtilities().validatePortForHost(string, n2) : !this.getAuxServerUtilities().validateDuplicatePort(this._newSO.getNodes(), string, n2) || !this.getAuxServerUtilities().validatePortForInstance(string, n2))) continue;
            return false;
        }
        return true;
    }

    protected int getServerType(BackupServerSOBase backupServerSOBase) {
        if (backupServerSOBase instanceof BackupServerSO) {
            return BackupServerWizardBase.SERVER_TYPE_BACKUP;
        }
        if (backupServerSOBase instanceof BackupServerSO2) {
            return BackupServerWizardBase.SERVER_TYPE_MULTIBACKUP;
        }
        if (backupServerSOBase instanceof XPServerSO) {
            return BackupServerWizardBase.SERVER_TYPE_XP;
        }
        if (backupServerSOBase instanceof MonitorServerSO) {
            return BackupServerWizardBase.SERVER_TYPE_MONITOR;
        }
        return -1;
    }

    private boolean checkServerExist() {
        boolean bl = false;
        int n = this.getServerType(this.getNewSO());
        ServerSO serverSO = (ServerSO)ContainerViewBO.getServerBO(this.getConnection()).getSO();
        try {
            if (BackupServerWizardBase.SERVER_TYPE_BACKUP == n) {
                bl = serverSO.isBackupServerActive(this.getAuxServerUtilities().getCluster());
            } else if (BackupServerWizardBase.SERVER_TYPE_MULTIBACKUP == n) {
                bl = serverSO.areMultipleBackupServersPresent();
            } else if (BackupServerWizardBase.SERVER_TYPE_MONITOR == n) {
                bl = MonitorServersCtrSO.isHaveTrue(serverSO.isMonitorServerActive(this.getAuxServerUtilities().getCluster()));
            } else if (BackupServerWizardBase.SERVER_TYPE_XP == n) {
                bl = MonitorServersCtrSO.isHaveTrue(serverSO.isXPServerActive(this.getAuxServerUtilities().getCluster()));
            }
        }
        catch (Exception exception) {
            Support.showDetailsError(this.getConnection(), this.getClass(), (Container)this.getJDialog(), exception.getMessage(), exception);
        }
        if (!bl) {
            ASEMessageText aSEMessageText = new ASEMessageText(ASEUtils.getString("ERR_AUXILIARY_SERVER_NOT_EXIST"), this.getNewSO().getName());
            Support.showError(this.getConnection(), this.getClass(), this.getJDialog(), aSEMessageText.toString());
        }
        return bl;
    }

    protected boolean updateAuxServer(UpdateServerTask updateServerTask, JDialog jDialog, String string) {
        if (!this.checkServerExist()) {
            return false;
        }
        ASEMessageText aSEMessageText = new ASEMessageText(ASEUtils.getString("AUXILIARY_SERVER_UPDATE_TASK_CONTENT"), this.getAuxServerUtilities().getClusterName());
        WorkingDialogWithMsgChangable workingDialogWithMsgChangable = new WorkingDialogWithMsgChangable((Dialog)jDialog, (WorkingDialogRunnable)updateServerTask, string, aSEMessageText.toString());
        workingDialogWithMsgChangable.dispose();
        return updateServerTask.isSucceed();
    }

    protected void discoveryPortNumber(DiscoveryPortNumberTask discoveryPortNumberTask, JDialog jDialog) {
        ASEMessageText aSEMessageText = new ASEMessageText(ASEUtils.getString("AUXILIARY_SERVER_DISCOVER_SELECTED_NODES_ENV"), this.getAuxServerUtilities().getClusterName());
        WorkingDialogWithSkipCancel workingDialogWithSkipCancel = new WorkingDialogWithSkipCancel((Dialog)jDialog, discoveryPortNumberTask, ASEUtils.getString("AUXILIARY_SERVER_DISCOVER_AVAILABLE_PORT_TITLE"), aSEMessageText.toString());
        workingDialogWithSkipCancel.dispose();
        Hashtable<IServer, Integer[]> hashtable = discoveryPortNumberTask.getResult();
        if (workingDialogWithSkipCancel.isSkipped()) {
            hashtable = discoveryPortNumberTask.discoverWithoutAgent();
        }
        if (!workingDialogWithSkipCancel.isCancelled() && hashtable.size() > 0) {
            Enumeration<IServer> enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                IServer iServer = enumeration.nextElement();
                Integer[] integerArray = hashtable.get(iServer);
                if (integerArray == null || integerArray.length <= 0) continue;
                discoveryPortNumberTask.onPortNumberDiscovered(iServer, integerArray[0].toString());
            }
        }
    }

    abstract class DiscoveryPortNumberTask
    implements Runnable {
        private IServer[] _nodes;
        private PortsDiscoveryUtil _portsUtil;
        private Hashtable<IServer, Integer[]> _result;

        public DiscoveryPortNumberTask(IServer[] iServerArray) {
            this._nodes = iServerArray;
            this._result = new Hashtable();
            ICluster iCluster = BackupServerPropertiesBase.this.getAuxServerUtilities().getCluster();
            this._portsUtil = new PortsDiscoveryUtil(iCluster, ContainerViewBO.getServerBO(BackupServerPropertiesBase.this.getConnection()));
        }

        public Hashtable<IServer, Integer[]> getResult() {
            return this._result;
        }

        public abstract void onPortNumberDiscovered(IServer var1, String var2);

        public Hashtable<IServer, Integer[]> discoverWithoutAgent() {
            try {
                return this.discover(false);
            }
            catch (Exception exception) {
                BackupServerPropertiesBase.this.getAuxServerUtilities().showThreadDetailError(exception.getMessage(), BackupServerPropertiesBase.this.getJDialog(), exception);
                return null;
            }
        }

        private Hashtable<IServer, Integer[]> discover(boolean bl) throws AgentConnectionException, RemoteException {
            return this._portsUtil.discoverPortsForInstance(this._nodes, 1, bl);
        }

        @Override
        public void run() {
            try {
                this._result = this.discover(true);
            }
            catch (Exception exception) {
                BackupServerPropertiesBase.this.getAuxServerUtilities().showThreadDetailError(exception.getMessage(), BackupServerPropertiesBase.this.getJDialog(), exception);
            }
        }
    }

    abstract class UpdateServerTask
    implements WorkingDialogRunnable {
        protected WorkingDialogWithMsgChangable _dlg;
        protected boolean _isSucceed = false;

        UpdateServerTask() {
        }

        public boolean isSucceed() {
            return this._isSucceed;
        }

        @Override
        public void setWorkingDialogWithMsgChangable(WorkingDialogWithMsgChangable workingDialogWithMsgChangable) {
            this._dlg = workingDialogWithMsgChangable;
        }

        abstract void updateAuxServer(List var1, List var2, List var3) throws Exception;

        @Override
        public void run() {
            try {
                this.updateAuxServer(BackupServerPropertiesBase.this._addedNodes, BackupServerPropertiesBase.this._changedNodes, BackupServerPropertiesBase.this._removedNodes);
                this._isSucceed = true;
            }
            catch (Exception exception) {
                BackupServerPropertiesBase.this.getAuxServerUtilities().showThreadDetailError(exception.getMessage(), BackupServerPropertiesBase.this.getJDialog(), exception);
            }
        }
    }
}

