/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.aseplugin.bo.prop;

import com.sybase.aseplugin.ASEMessageText;
import com.sybase.aseplugin.ASEUtils;
import com.sybase.aseplugin.RLImages;
import com.sybase.aseplugin.bo.ASEBaseDialog2;
import com.sybase.aseplugin.bo.ArticleBO;
import com.sybase.aseplugin.bo.RepArticleBO;
import com.sybase.aseplugin.bo.ReplicationBO;
import com.sybase.aseplugin.bo.Support;
import com.sybase.aseplugin.bo.prop.ASEBasePropertiesDialog2;
import com.sybase.aseplugin.bo.prop.ASEBasePropertiesPage2;
import com.sybase.aseplugin.bo.prop.ArticleProp;
import com.sybase.aseplugin.bo.prop.RepArticleProp;
import com.sybase.aseplugin.go.ASETable;
import com.sybase.aseplugin.go.prop.ConnPropGOPage1;
import com.sybase.aseplugin.go.prop.ConnPropGOPage2;
import com.sybase.aseplugin.so.ArticleSO;
import com.sybase.aseplugin.so.ConnectionSO;
import com.sybase.aseplugin.so.RepArticleSO;
import com.sybase.aseplugin.so.SOItemInterface;
import com.sybase.aseplugin.util.Debug;
import com.sybase.aseplugin.util.ui.JLabelTableModel;
import com.sybase.aseplugin.util.ui.MyCellRenderer;
import com.sybase.central.SCContainer2;
import com.sybase.central.SCPageController;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;

public class ConnectionProp
extends ASEBasePropertiesDialog2 {
    private JFrame _frame;
    private ReplicationBO _repBO = null;
    private static final String HELP_MAP_ID = "HELP_ASE_REPLICATOR_PROP_CONN_1252";

    public ConnectionProp(ConnectionSO connectionSO, SCContainer2 sCContainer2, JFrame jFrame) {
        super((SOItemInterface)connectionSO, sCContainer2);
        this._frame = jFrame;
    }

    @Override
    public SCPageController[] getPages() {
        String string = ((ConnectionSO)this.getSO()).isPrimary() ? ASEUtils.getString("DISP_CONN_PARTS") : ASEUtils.getString("DISP_CONN_RARTS");
        return new SCPageController[]{new ConnPropGeneralPage(this), new ConnPropArticlesPage(this, string)};
    }

    @Override
    public void releaseResources() {
        this._frame = null;
        this._repBO = null;
        super.releaseResources();
    }

    class ConnPropArticlesPage
    extends ASEBasePropertiesPage2
    implements ActionListener {
        private ConnPropGOPage2 _panel;
        private JTable _table;
        private JLabelTableModel _tableModel;

        public ConnPropArticlesPage(ConnectionProp connectionProp2, String string) {
            super(connectionProp2, (JPanel)((Object)new ConnPropGOPage2()), string);
            this._panel = (ConnPropGOPage2)((Object)this.getJPanel());
            this._panel.buttonProp.addActionListener((ActionListener)this);
        }

        @Override
        public void init() throws SQLException {
            Vector vector;
            Vector vector2;
            if (((ConnectionSO)this.getSO()).isPrimary()) {
                vector2 = this.getPrimaryHeadings();
                vector = this.getPrimaryArticles();
            } else {
                vector2 = this.getReplicateHeadings();
                vector = this.getReplicateArticles();
            }
            this._tableModel = new JLabelTableModel(vector2, vector);
            this._table = new ASETable(this._tableModel);
            this._table.setDefaultRenderer(new JLabel().getClass(), new MyCellRenderer());
            this._panel.scrollpArticles.getViewport().setView(this._table);
            this._table.setSelectionMode(0);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == this._panel.buttonProp) {
                try {
                    int n = this._table.getSelectedRow();
                    if (n >= 0) {
                        if (((ConnectionSO)this.getSO()).isPrimary()) {
                            this.DisplayPrimaryArticle(n);
                        } else {
                            this.DisplayReplicateArticle(n);
                        }
                    }
                }
                catch (Exception exception) {
                    Support.showDetailsError(this.getConnection(), this.getClass(), (Container)this.getJDialog(), ASEMessageText.toString(exception), exception);
                }
            }
        }

        protected Vector getPrimaryHeadings() {
            Vector<String> vector = new Vector<String>();
            vector.addElement(ASEUtils.getString("DISP_ARTICLE_HDR"));
            vector.addElement(ASEUtils.getString("DISP_OWNER_HDR"));
            return vector;
        }

        protected Vector getPrimaryArticles() throws SQLException {
            Enumeration enumeration = ArticleSO.getPrimaryArticles(this.getConnection(), ((ConnectionSO)this.getSO()).getDDB(), ((ConnectionSO)this.getSO()).getServer(), ((ConnectionSO)this.getSO()).getDatabase());
            Vector vector = new Vector();
            while (enumeration.hasMoreElements()) {
                ArticleSO articleSO = (ArticleSO)enumeration.nextElement();
                JLabel jLabel = null;
                jLabel = articleSO.isTable() ? new JLabel(articleSO.getDisplayName(), ArticleBO.PRIMARY_ARTICLE_TABLE_ICON, 0) : new JLabel(articleSO.getDisplayName(), ArticleBO.PRIMARY_ARTICLE_PROC_ICON, 0);
                Vector<Object> vector2 = new Vector<Object>(3);
                vector2.add(jLabel);
                vector2.add(articleSO.getOwner());
                vector2.add(articleSO);
                vector.add(vector2);
            }
            return vector;
        }

        protected Vector getReplicateHeadings() {
            Vector<String> vector = new Vector<String>();
            vector.addElement(ASEUtils.getString("DISP_ARTICLE_HDR"));
            vector.addElement(ASEUtils.getString("DISP_OWNER_HDR"));
            vector.addElement(ASEUtils.getString("DISP_SUB_HDR"));
            return vector;
        }

        protected Vector getReplicateArticles() throws SQLException {
            Enumeration enumeration = RepArticleSO.getReplicateArticles(this.getSO().getConnection(), ((ConnectionSO)this.getSO()).getDDB(), ((ConnectionSO)this.getSO()).getServer(), ((ConnectionSO)this.getSO()).getDatabase(), (ConnectionSO)this.getSO());
            Vector vector = new Vector();
            while (enumeration.hasMoreElements()) {
                RepArticleSO repArticleSO = (RepArticleSO)enumeration.nextElement();
                JLabel jLabel = null;
                jLabel = repArticleSO.isTable() ? new JLabel(repArticleSO.getDisplayName(), RepArticleBO.REPLICATE_ARTICLE_TABLE_ICON, 0) : new JLabel(repArticleSO.getDisplayName(), RepArticleBO.REPLICATE_ARTICLE_PROC_ICON, 0);
                Vector<Object> vector2 = new Vector<Object>(4);
                vector2.add(jLabel);
                vector2.add(repArticleSO.getOwner());
                vector2.add(repArticleSO.getSubscription());
                vector2.add(repArticleSO);
                vector.add(vector2);
            }
            return vector;
        }

        protected void DisplayPrimaryArticle(int n) throws Exception {
            ArticleSO articleSO = (ArticleSO)this._tableModel.getValueAt(n, 2);
            Debug.wassert(articleSO != null, this, "Unexpected null ArticleSO");
            ArticleProp articleProp = new ArticleProp(articleSO, (SCContainer2)ConnectionProp.this._repBO);
            ASEBaseDialog2.showDialog(ConnectionProp.this._frame, articleProp);
        }

        protected void DisplayReplicateArticle(int n) throws Exception {
            RepArticleSO repArticleSO = (RepArticleSO)this._tableModel.getValueAt(n, 3);
            Debug.wassert(repArticleSO != null, this, "Unexpected null RepArticleSO");
            RepArticleProp repArticleProp = new RepArticleProp(repArticleSO, this.getParent().getParent());
            ASEBaseDialog2.showDialog(ConnectionProp.this._frame, repArticleProp);
        }

        @Override
        public String getHelpID() {
            return ConnectionProp.HELP_MAP_ID;
        }

        @Override
        public void releaseResources() {
            if (this._panel != null) {
                this._panel.buttonProp.removeActionListener((ActionListener)this);
                this._panel.releaseResources();
                this._panel = null;
            }
            super.releaseResources();
        }
    }

    class ConnPropGeneralPage
    extends ASEBasePropertiesPage2 {
        private ConnPropGOPage1 _panel;

        public ConnPropGeneralPage(ConnectionProp connectionProp2) {
            super(connectionProp2, (JPanel)((Object)new ConnPropGOPage1()), ASEUtils.getString("MSG_GENERAL"));
            this._panel = (ConnPropGOPage1)((Object)this.getJPanel());
            if (((ConnectionSO)this.getSO()).isPrimary()) {
                this._panel.label1.setIcon((Icon)new ImageIcon(RLImages.getPConnLargeImage()));
            } else {
                this._panel.label1.setIcon((Icon)new ImageIcon(RLImages.getRConnLargeImage()));
            }
        }

        @Override
        public void init() {
            this._panel.connection.setText(((ConnectionSO)this.getSO()).getDisplayName());
            this._panel.type.setText(((ConnectionSO)this.getSO()).getTypeString());
            this._panel.user.setText(((ConnectionSO)this.getSO()).getMaintUser());
            this._panel.reason.setText(((ConnectionSO)this.getSO()).getReasonCode());
            if (((ConnectionSO)this.getSO()).isPrimary()) {
                this._panel.labelProxy.setVisible(false);
                this._panel.proxy.setVisible(false);
            } else {
                this._panel.proxy.setText(((ConnectionSO)this.getSO()).getLastCommitTable());
            }
        }

        @Override
        public String getHelpID() {
            return ConnectionProp.HELP_MAP_ID;
        }

        @Override
        public void releaseResources() {
            if (this._panel != null) {
                this._panel.releaseResources();
                this._panel = null;
            }
            super.releaseResources();
        }
    }
}

