/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.aseplugin.bo.prop;

import com.sybase.aseplugin.ASEUtils;
import com.sybase.aseplugin.bo.ASEBaseContainer2;
import com.sybase.aseplugin.bo.ContainerViewBO;
import com.sybase.aseplugin.bo.DBsCtrBO;
import com.sybase.aseplugin.bo.DatabaseDeviceBO;
import com.sybase.aseplugin.bo.ServerBO;
import com.sybase.aseplugin.bo.Support;
import com.sybase.aseplugin.bo.dlg.AddDeviceToDatabaseDialog;
import com.sybase.aseplugin.bo.dlg.EditDeviceSizeOfDatabaseDialog;
import com.sybase.aseplugin.bo.prop.ASEBasePropertiesPage2;
import com.sybase.aseplugin.bo.prop.DatabaseProperties;
import com.sybase.aseplugin.go.ASETable;
import com.sybase.aseplugin.go.prop.DatabasePropGODevicesPage;
import com.sybase.aseplugin.so.DatabaseDeviceSO;
import com.sybase.aseplugin.so.DatabaseDevicesCtrSO;
import com.sybase.aseplugin.so.DatabaseSO;
import com.sybase.aseplugin.so.TempDBSO;
import com.sybase.aseplugin.util.ui.JLabelTableModel;
import com.sybase.aseplugin.util.ui.MyCellRenderer;
import com.sybase.aseplugin.util.ui.TableSelectionListener;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;

class DatabasePropDevicesPage
extends ASEBasePropertiesPage2
implements ActionListener {
    private JLabelTableModel _tableModel;
    Vector heading = new Vector();
    private int numofdata = 0;
    private int numofdevices = 0;
    private JTable _table;
    private Map _initDBSizeMap = new HashMap();
    final String MSG_DATA = ASEUtils.getString("MSG_DATA");
    final String MSG_LOG = ASEUtils.getString("MSG_LOG");
    private DatabasePropGODevicesPage _go = (DatabasePropGODevicesPage)((Object)this.getJPanel());

    public DatabasePropDevicesPage(DatabaseProperties databaseProperties) {
        super(databaseProperties, (JPanel)((Object)new DatabasePropGODevicesPage()), ASEUtils.getString("MSG_DEVICES"));
        this._go.removeButton.setEnabled(false);
        this._go.editButton.setEnabled(false);
        this._go.propertiesButton.setEnabled(false);
        this._go.moveLogButton.setEnabled(false);
        this.heading.addElement(ASEUtils.getString("DISP_NAME_TEXT"));
        this.heading.addElement(ASEUtils.getString("DISP_SIZE_MB_TEXT"));
        this.heading.addElement(ASEUtils.getString("MSG_FUTURE_ALLOCATIONS"));
    }

    private void removeListeners() {
        this._go.addButton.removeActionListener((ActionListener)this);
        this._go.editButton.removeActionListener((ActionListener)this);
        this._go.removeButton.removeActionListener((ActionListener)this);
        this._go.moveLogButton.removeActionListener((ActionListener)this);
        this._go.propertiesButton.removeActionListener((ActionListener)this);
        this._go.overrideCheckBox.removeActionListener((ActionListener)this);
    }

    private void addListeners() {
        this._go.addButton.addActionListener((ActionListener)this);
        this._go.editButton.addActionListener((ActionListener)this);
        this._go.removeButton.addActionListener((ActionListener)this);
        this._go.moveLogButton.addActionListener((ActionListener)this);
        this._go.propertiesButton.addActionListener((ActionListener)this);
        this._go.overrideCheckBox.addActionListener((ActionListener)this);
    }

    @Override
    public String getHelpID() {
        return "HELP_DATABASE_PROP_DEVICES_1252";
    }

    @Override
    public void init() throws SQLException {
        this.removeListeners();
        this._initDBSizeMap.clear();
        this._tableModel = new JLabelTableModel(this.heading, ((DatabaseSO)this.getSO()).fillDevicesForDB());
        this._table = new ASETable(this._tableModel);
        this._table.setDefaultRenderer(new JLabel().getClass(), new MyCellRenderer());
        this._go.devicesScrollPane.getViewport().setView(this._table);
        this._table.setSelectionMode(0);
        this.numofdata = 0;
        this.numofdevices = this._tableModel.getData().size();
        for (int i = 0; i < this._tableModel.getData().size(); ++i) {
            String string = ((JLabel)this._tableModel.getValueAt(i, 0)).getText();
            String string2 = (String)this._tableModel.getValueAt(i, 2);
            if (string2.indexOf(this.MSG_DATA) >= 0) {
                ++this.numofdata;
            }
            double d = 0.0;
            double d2 = 0.0;
            try {
                d = Double.parseDouble(this._tableModel.getValueAt(i, 1).toString());
                d2 = Double.parseDouble(this._initDBSizeMap.get(string).toString());
            }
            catch (Exception exception) {
                // empty catch block
            }
            this._initDBSizeMap.put(string, new Double(d2 + d).toString());
        }
        TableSelectionListener tableSelectionListener = new TableSelectionListener(){

            @Override
            public void deSelectAction() {
                ((DatabasePropDevicesPage)DatabasePropDevicesPage.this)._go.removeButton.setEnabled(false);
                ((DatabasePropDevicesPage)DatabasePropDevicesPage.this)._go.editButton.setEnabled(false);
                ((DatabasePropDevicesPage)DatabasePropDevicesPage.this)._go.propertiesButton.setEnabled(false);
                ((DatabasePropDevicesPage)DatabasePropDevicesPage.this)._go.moveLogButton.setEnabled(false);
            }

            @Override
            public void selectAction() {
                DatabasePropDevicesPage.this.updateButtonsState();
            }
        };
        this._table.getSelectionModel().addListSelectionListener(tableSelectionListener);
        this.addListeners();
    }

    public void updateButtonsState() {
        int n = this._table.getSelectedRow();
        this._go.editButton.setEnabled(true);
        this._go.propertiesButton.setEnabled(true);
        if (n >= 0) {
            if (n < this.numofdevices) {
                this._go.removeButton.setEnabled(false);
                String string = (String)this._tableModel.getValueAt(n, 2);
                if (string.indexOf(this.MSG_DATA) >= 0 && this.numofdata > 1) {
                    this._go.moveLogButton.setEnabled(true);
                } else {
                    this._go.moveLogButton.setEnabled(false);
                }
            } else {
                this._go.removeButton.setEnabled(true);
                this._go.moveLogButton.setEnabled(false);
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this._go.addButton) {
            Vector vector = new Vector();
            try {
                vector = (Vector)this.getDatabaseDeviceList().clone();
            }
            catch (SQLException sQLException) {
                Support.showDetailsError(this.getConnection(), this.getClass(), (Container)this.getJDialog(), sQLException.toString(), sQLException);
            }
            AddDeviceToDatabaseDialog addDeviceToDatabaseDialog = new AddDeviceToDatabaseDialog(Support.createDialogSupport(this.getJDialog()), (DatabaseSO)this.getSO(), vector, this._tableModel, this._table, true, this._initDBSizeMap, ((DatabaseProperties)this.getParent())._ignoreDevList);
            this.enableApplyButton(true);
        } else if (actionEvent.getSource() == this._go.removeButton) {
            int[] nArray = this._table.getSelectedRows();
            for (int i = 0; i < nArray.length; ++i) {
                this._tableModel.removeRow(nArray[i]);
            }
            this._table.tableChanged(new TableModelEvent(this._tableModel));
        } else if (actionEvent.getSource() == this._go.moveLogButton) {
            int[] nArray = this._table.getSelectedRows();
            for (int i = 0; i < nArray.length; ++i) {
                this._tableModel.setValueAt(this.MSG_LOG, nArray[i], 2);
            }
            --this.numofdata;
            this._table.tableChanged(new TableModelEvent(this._tableModel));
            this.enableApplyButton(true);
        } else if (actionEvent.getSource() == this._go.editButton) {
            int[] nArray = this._table.getSelectedRows();
            for (int i = 0; i < nArray.length; ++i) {
                long l = ((Double)this._tableModel.getValueAt(nArray[i], 1)).longValue();
                String string = ((JLabel)this._tableModel.getValueAt(nArray[i], 0)).getText();
                DatabaseDeviceSO databaseDeviceSO = null;
                try {
                    databaseDeviceSO = this.getEditingDatabaseDevice(string);
                }
                catch (SQLException sQLException) {
                    Support.showDetailsError(this.getConnection(), this.getClass(), (Container)this.getJDialog(), sQLException.toString(), sQLException);
                }
                String string2 = (String)this._initDBSizeMap.get(string);
                EditDeviceSizeOfDatabaseDialog editDeviceSizeOfDatabaseDialog = new EditDeviceSizeOfDatabaseDialog(Support.createDialogSupport(this.getJDialog()), string, databaseDeviceSO.getSize(), databaseDeviceSO.getUnusedSize(), l, this._tableModel, this._table, nArray[i], true, string2);
            }
            this.enableApplyButton(true);
        } else if (actionEvent.getSource() == this._go.propertiesButton) {
            int[] nArray = this._table.getSelectedRows();
            for (int i = 0; i < nArray.length; ++i) {
                String string = ((JLabel)this._tableModel.getValueAt(nArray[i], 0)).getText();
                ServerBO serverBO = ContainerViewBO.getServerBO(((DatabaseSO)this.getSO()).getConnection());
                ContainerViewBO.openDatabaseDeviceProperties(serverBO, string);
            }
        } else {
            this.enableApplyButton(true);
        }
    }

    public Vector getDatabaseDeviceList() throws SQLException {
        DatabaseSO databaseSO = (DatabaseSO)this.getSO();
        DatabaseDevicesCtrSO databaseDevicesCtrSO = new DatabaseDevicesCtrSO(databaseSO.getConnection());
        if (databaseSO.isInIMDBFamily()) {
            String string = databaseSO.getIMCacheName();
            return (Vector)databaseDevicesCtrSO.getAvailableIMDevicesByIMCache(string);
        }
        Vector vector = new Vector();
        vector.addAll(databaseDevicesCtrSO.open(1));
        DBsCtrBO dBsCtrBO = (DBsCtrBO)this.getParent().getParent();
        if (dBsCtrBO.getDatabaseCtrType() == 7) {
            TempDBSO tempDBSO = (TempDBSO)this.getSO();
            DatabaseDevicesCtrSO databaseDevicesCtrSO2 = new DatabaseDevicesCtrSO(tempDBSO.getConnection(), tempDBSO.getSDCInstanceName());
            vector.addAll(databaseDevicesCtrSO2.open(1));
        }
        return vector;
    }

    private DatabaseDeviceSO getEditingDatabaseDevice(String string) throws SQLException {
        ServerBO serverBO = ContainerViewBO.getServerBO(((DatabaseSO)this.getSO()).getConnection());
        DatabaseDeviceBO databaseDeviceBO = ContainerViewBO.getDatabaseDeviceBO(serverBO, string);
        return ((DatabaseDeviceSO)databaseDeviceBO.getSO()).findObject();
    }

    public int getMaxSizeDD(Vector vector, String string) {
        for (int i = 0; i < vector.size(); ++i) {
            DatabaseDeviceSO databaseDeviceSO = (DatabaseDeviceSO)vector.elementAt(i);
            String string2 = databaseDeviceSO.getName();
            if (string2.compareTo(string) != 0) continue;
            return Integer.parseInt(databaseDeviceSO.getSize());
        }
        return -1;
    }

    @Override
    public boolean deploy() throws SQLException {
        Object object;
        Vector vector = ((DatabaseSO)this.getSO()).fillDevicesForDB();
        Vector vector2 = (Vector)this._tableModel.getData().clone();
        for (int i = 0; i < vector2.size(); ++i) {
            String string;
            Object object2;
            if (i < vector.size()) {
                object = (Vector)vector.elementAt(i);
                object2 = (Vector)vector2.elementAt(i);
                string = ((JLabel)((Vector)object).elementAt(0)).getText();
                double d = (Double)((Vector)object).elementAt(1);
                double d2 = (Double)((Vector)object2).elementAt(1);
                String string2 = (String)((Vector)object).elementAt(2);
                String string3 = (String)((Vector)object2).elementAt(2);
                if (d != d2) {
                    if (string3.indexOf(this.MSG_DATA) >= 0) {
                        ((DatabaseSO)this.getSO()).addDBDSize(string, d2 - d, 0);
                    } else {
                        ((DatabaseSO)this.getSO()).addDBDSize(string, d2 - d, 1);
                    }
                }
                if (string2.compareTo(string3) == 0) continue;
                ((DatabaseSO)this.getSO()).moveLogToData(string);
                continue;
            }
            object = (Vector)vector2.elementAt(i);
            object2 = ((JLabel)((Vector)object).elementAt(0)).getText();
            string = new Integer(((Double)((Vector)object).elementAt(1)).intValue()).toString();
            String string4 = (String)((Vector)object).elementAt(2);
            if (string4.indexOf(this.MSG_DATA) >= 0) {
                ((DatabaseSO)this.getSO()).newDBD((String)object2, string, this._go.overrideCheckBox.isSelected(), 0);
                continue;
            }
            ((DatabaseSO)this.getSO()).newDBD((String)object2, string, this._go.overrideCheckBox.isSelected(), 1);
        }
        ServerBO serverBO = ContainerViewBO.getServerBO(((DatabaseSO)this.getSO()).getConnection());
        object = null;
        object = ((DatabaseSO)this.getSO()).isInIMDBFamily() ? ContainerViewBO.getIMDatabaseDevicesCtrBO(serverBO) : ContainerViewBO.getDatabaseDevicesCtrBO(serverBO);
        if (null != object) {
            ((ASEBaseContainer2)object).refresh();
        }
        return true;
    }

    @Override
    public void releaseResources() {
        if (this._go != null) {
            this.removeListeners();
            this._go.releaseResources();
            this._go = null;
        }
        super.releaseResources();
    }
}

