/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.aseplugin.bo.prop;

import com.sybase.aseplugin.ASEImages;
import com.sybase.aseplugin.ASEMessageText;
import com.sybase.aseplugin.ASEUtils;
import com.sybase.aseplugin.bo.CacheBO;
import com.sybase.aseplugin.bo.DBsCtrBO;
import com.sybase.aseplugin.bo.Support;
import com.sybase.aseplugin.bo.dlg.ChangeUserPageDialog;
import com.sybase.aseplugin.bo.prop.ASEBasePropertiesPage2;
import com.sybase.aseplugin.bo.prop.DatabaseProperties;
import com.sybase.aseplugin.go.prop.DatabasePropGOGeneralPage;
import com.sybase.aseplugin.so.CacheSO;
import com.sybase.aseplugin.so.DatabaseSO;
import com.sybase.aseplugin.so.DatabasesCtrSO;
import com.sybase.aseplugin.so.Utility;
import com.sybase.aseplugin.util.ui.MyCellRenderer;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

class DatabasePropGeneralPage
extends ASEBasePropertiesPage2
implements ActionListener,
DocumentListener {
    private int cacheindex;
    private final boolean _transfer = false;
    private DatabaseSO _dbSO;
    private DatabasePropGOGeneralPage _go = (DatabasePropGOGeneralPage)((Object)this.getJPanel());

    public DatabasePropGeneralPage(DatabaseProperties databaseProperties) {
        super(databaseProperties, (JPanel)((Object)new DatabasePropGOGeneralPage()), ASEUtils.getString("MSG_GENERAL"));
        this._dbSO = (DatabaseSO)this.getSO();
        this._go.cacheComboBox.setRenderer((ListCellRenderer)new MyCellRenderer());
        this._go.nameTextLabel.setText(this._dbSO.getName());
    }

    @Override
    public String getHelpID() {
        if (this._dbSO.isProxy()) {
            return "HELP_PROXY_DATABASE_PROP_GENERAL_1252";
        }
        return "HELP_DATABASE_PROP_GENERAL_1252";
    }

    private void setComboDefault() throws SQLException {
        List list = this._dbSO.getActiveCaches();
        ImageIcon imageIcon = CacheBO.CACHE_ICON;
        this._go.cacheComboBox.clear();
        for (CacheSO cacheSO : list) {
            JLabel jLabel = new JLabel(cacheSO.getName(), imageIcon, 0);
            this._go.cacheComboBox.addItem((Object)jLabel);
        }
        this.cacheindex = Utility.getOrigSelection(this._dbSO.getBoundCache(), (JComboBox)this._go.cacheComboBox);
        this._go.cacheComboBox.setSelectedIndex(this.cacheindex);
    }

    private void removeListeners() {
        this._go.changeButton.removeActionListener((ActionListener)this);
        this._go.durabilityComboBox.removeActionListener((ActionListener)this);
        this._go.templateDBComboBox.removeActionListener((ActionListener)this);
        this._go.cacheComboBox.removeActionListener((ActionListener)this);
        this._go.guestCheckBox.removeActionListener((ActionListener)this);
        this._go.dmlLoggingCheckBox.removeActionListener((ActionListener)this);
        this._go.syncProxyCheckBox.removeActionListener((ActionListener)this);
        this._go.defaultLocationTextField.getDocument().removeDocumentListener(this);
    }

    private void addListeners() {
        this._go.changeButton.addActionListener((ActionListener)this);
        this._go.durabilityComboBox.addActionListener((ActionListener)this);
        this._go.templateDBComboBox.addActionListener((ActionListener)this);
        this._go.cacheComboBox.addActionListener((ActionListener)this);
        this._go.guestCheckBox.addActionListener((ActionListener)this);
        this._go.dmlLoggingCheckBox.addActionListener((ActionListener)this);
        this._go.syncProxyCheckBox.addActionListener((ActionListener)this);
        this._go.defaultLocationTextField.getDocument().addDocumentListener(this);
    }

    private void setDefLocOptionVisible(boolean bl) {
        this._go.defaultLocationLabel.setVisible(bl);
        this._go.defaultLocationTextField.setVisible(bl);
        this._go.syncProxyCheckBox.setVisible(bl);
    }

    private void setTemplateOptionVisible(boolean bl) {
        this._go.templateDBLabel.setVisible(bl);
        this._go.templateDBComboBox.setVisible(bl);
    }

    private void setDurabilityOptionVisible(boolean bl) {
        this._go.durabilityLabel.setVisible(bl);
        this._go.durabilityComboBox.setVisible(bl);
    }

    @Override
    public void init() throws SQLException {
        this.removeListeners();
        ImageIcon imageIcon = this._dbSO.isSuspect() ? new ImageIcon(ASEImages.getDatabaseSuspectLargeImage()) : (this._dbSO.isForLoad() ? new ImageIcon(ASEImages.getDatabaseForLoadLargeImage()) : (this._dbSO.getType().equals("TDB") ? new ImageIcon(ASEImages.getDatabaseTempLargeImage()) : (this._dbSO.isOffline() ? new ImageIcon(ASEImages.getDatabaseWarnLargeImage()) : (this._dbSO.isProxy() ? new ImageIcon(ASEImages.getProxyDatabaseLargeImage()) : new ImageIcon(ASEImages.getDatabaseLargeImage())))));
        this._go.iconLabel.setIcon((Icon)imageIcon);
        boolean bl = this._dbSO.isForLoad();
        this._go.guestCheckBox.setEnabled(!bl);
        this._go.cacheComboBox.setEnabled(!bl);
        this._go.changeButton.setEnabled(!bl);
        this._dbSO.load(true);
        this._go.nameTextLabel.setText(this._dbSO.getName());
        this._go.creationDateTextLabel.setText(this._dbSO.getCreationDate());
        this._go.lastDumpTextLabel.setText(this._dbSO.getLastDumpDate());
        this._go.ownerTextLabel.setText(this._dbSO.getOwner());
        this.setComboDefault();
        if (this._dbSO.isMaster()) {
            this._go.changeButton.setEnabled(false);
        }
        this._go.guestCheckBox.setSelected(this._dbSO.hasGuest());
        this._go.transferLabel.setText("");
        if (this._dbSO.isDurabilityApplicable()) {
            this.setDurabilityOptionVisible(true);
            this.initDurabilityOption();
        } else {
            this.setDurabilityOptionVisible(false);
        }
        if (this._dbSO.isTemplateDBApplicable()) {
            this.setTemplateOptionVisible(true);
            this.setDefLocOptionVisible(false);
            this._go.syncProxyCheckBox.setVisible(false);
            this.initTemplateOption();
            this._go.templateDBComboBox.setEnabled(this._dbSO.isTemplateDBAlterable());
        } else {
            this.setTemplateOptionVisible(false);
            this.setDefLocOptionVisible(!this._dbSO.isInIMDBFamily());
            String string = this._dbSO.getDefaultRemoteLocation();
            string = string == null ? "" : string;
            this._go.defaultLocationTextField.setText(string);
            this._go.syncProxyCheckBox.setEnabled(string.length() != 0);
        }
        if (this._dbSO.isInIMDBFamily()) {
            this.initIMDB();
        }
        if (this.getConnection().isDMLLoggingApplicable()) {
            this._go.dmlLoggingCheckBox.setVisible(true);
            this._go.dmlLoggingCheckBox.setSelected(this._dbSO.getSettingForDMLLOGGING());
            if (this._dbSO.isDMLLoggingAlterable()) {
                this._go.dmlLoggingCheckBox.setEnabled(true);
            } else {
                this._go.dmlLoggingCheckBox.setEnabled(false);
            }
        }
        this.addListeners();
    }

    private void initIMDB() {
        this._go.typeTextLabel.setText(ASEUtils.getString("DNAME_IM_DATABASE"));
        if (this._dbSO.isTempInMemoryDB()) {
            this._go.typeTextLabel.setText(ASEUtils.getString("DNAME_TEMP_IM_DATABASE"));
        }
        this._go.cacheLabel.setVisible(false);
        this._go.cacheComboBox.setVisible(false);
    }

    protected void initDurabilityOption() {
        if (this._dbSO.isSystem() || this._dbSO.isSDCGlobalTempDB()) {
            this._go.durabilityComboBox.setSelectedItem("FULL");
            this._go.durabilityComboBox.setEnabled(false);
        } else if (this._dbSO.isTempDB() || this._dbSO.isInIMDBFamily() || this._dbSO.isSDCLocalTempDB()) {
            this._go.durabilityComboBox.setSelectedItem("NO_RECOVERY");
            this._go.durabilityComboBox.setEnabled(false);
        } else {
            try {
                this._dbSO.loadDurability();
                this._go.durabilityComboBox.setSelectedItem(this._dbSO.getDurability());
                this._go.durabilityComboBox.setEnabled(true);
            }
            catch (SQLException sQLException) {
                Support.showError(this.getConnection(), this.getClass(), this.getJDialog(), sQLException.toString());
            }
        }
    }

    protected void fillTemplateDBCombox() throws SQLException {
        DatabasesCtrSO databasesCtrSO = new DatabasesCtrSO(this._dbSO.getConnection());
        List<String> list = databasesCtrSO.getTemplateDBList();
        this._go.templateDBComboBox.clear();
        for (String string : list) {
            this._go.templateDBComboBox.addItem((Object)string);
        }
    }

    protected void initTemplateOption() {
        try {
            this.fillTemplateDBCombox();
            this._dbSO.loadTemplateDB();
            this._go.templateDBComboBox.setSelectedItem(this._dbSO.getTemplateDB());
        }
        catch (SQLException sQLException) {
            Support.showError(this.getConnection(), this.getClass(), this.getJDialog(), sQLException.toString());
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this._go.changeButton) {
            try {
                new ChangeUserPageDialog(Support.createDialogSupport(this.getJDialog()), this._dbSO, this._dbSO.getLoginNameList(), this._dbSO.getOwner(), (JLabel)this._go.transferLabel, (JTextField)((Object)this._go.ownerTextLabel));
                this.enableApplyButton(true);
            }
            catch (SQLException sQLException) {
                Support.showDetailsError(this.getConnection(), this.getClass(), (Container)this.getJDialog(), ASEMessageText.toString(sQLException), sQLException);
            }
        } else if (actionEvent.getSource() == this._go.durabilityComboBox) {
            if (this._go.durabilityComboBox.getSelectedItem().toString().equals("FULL")) {
                this._go.dmlLoggingCheckBox.setEnabled(false);
                this._go.dmlLoggingCheckBox.setSelected(true);
            } else {
                this._go.dmlLoggingCheckBox.setEnabled(true);
            }
            this.enableApplyButton(true);
        } else {
            this.enableApplyButton(true);
        }
    }

    public void textChanged() {
        boolean bl = this.getDialogSupport().getStandardButtonById(4).isEnabled();
        if (!bl && !this._go.defaultLocationTextField.getText().equals(this._dbSO.getDefaultRemoteLocation())) {
            this.enableApplyButton(true);
        }
        this._go.syncProxyCheckBox.setEnabled(this._go.defaultLocationTextField.getText().length() != 0);
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.textChanged();
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.textChanged();
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.textChanged();
    }

    @Override
    public boolean deploy() throws SQLException {
        Object object;
        if (this._go.cacheComboBox.getSelectedIndex() != this.cacheindex) {
            object = (JLabel)this._go.cacheComboBox.getSelectedItem();
            this._dbSO.setCache(((JLabel)object).getText());
            if (((DBsCtrBO)((DatabaseProperties)this.getParent()).getParent()).getDatabaseCtrType() == 3) {
                Support.showInfo(this.getConnection(), this.getClass(), ASEUtils.getString("MSG_INFO_CACHE_BIND_TEMP_DB"));
            }
        }
        if (this._dbSO.getOwner().compareTo(this._go.ownerTextLabel.getText()) != 0) {
            this._dbSO.setOwnerSQL(this._go.ownerTextLabel.getText(), this._go.transferLabel.getText().equals(ASEUtils.getString("MSG_TRANSFER_ALIASES")));
        }
        if (this._dbSO.hasGuest() != this._go.guestCheckBox.isSelected()) {
            this._dbSO.setGuestAccountSQL(this._go.guestCheckBox.isSelected());
        }
        if (this.getConnection().isDMLLoggingApplicable() && this._dbSO.getSettingForDMLLOGGING() != this._go.dmlLoggingCheckBox.isSelected()) {
            this._dbSO.setDMLLOGINGSQL(this._go.dmlLoggingCheckBox.isSelected());
        }
        if (this._dbSO.isDurabilityApplicable() && this._dbSO.isDurabilityAlterable()) {
            object = this._go.durabilityComboBox.getSelectedItem().toString();
            if (!this._dbSO.getDurability().equalsIgnoreCase((String)object)) {
                this._dbSO.alterDurability((String)object);
                if (((String)object).equals("FULL")) {
                    this._dbSO.setDMLLOGINGSQL(true);
                }
            }
        }
        if (this._dbSO.isTemplateDBAlterable()) {
            object = this._go.templateDBComboBox.getSelectedItem().toString();
            if (!this._dbSO.getTemplateDB().equalsIgnoreCase((String)object)) {
                this._dbSO.alterTemplateDB((String)object);
            }
        } else if (!this._dbSO.isInIMDBFamily()) {
            if (!this._go.defaultLocationTextField.getText().equals(this._dbSO.getDefaultRemoteLocation())) {
                this._dbSO.alterDefaultLocation(this._go.defaultLocationTextField.getText());
            }
            if (this._go.syncProxyCheckBox.isSelected()) {
                this._dbSO.syncProxyTables();
                this._go.syncProxyCheckBox.setSelected(false);
            }
        }
        return true;
    }

    @Override
    public void releaseResources() {
        if (this._go != null) {
            this.removeListeners();
            this._go = null;
        }
        super.releaseResources();
    }
}

