/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.aseplugin.bo.prop;

import com.sybase.aseplugin.ASEMessageText;
import com.sybase.aseplugin.ASEUtils;
import com.sybase.aseplugin.bo.Support;
import com.sybase.aseplugin.bo.prop.ASEBasePropertiesPage2;
import com.sybase.aseplugin.bo.prop.DatabaseProperties;
import com.sybase.aseplugin.go.prop.DatabasePropGOUsagePage;
import com.sybase.aseplugin.so.DatabaseSO;
import com.sybase.aseplugin.so.Utility;
import com.sybase.aseplugin.sql.ASConnection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import javax.swing.JComboBox;
import javax.swing.JPanel;

class DatabasePropUsagePage
extends ASEBasePropertiesPage2
implements ActionListener {
    private DatabasePropGOUsagePage _go = (DatabasePropGOUsagePage)((Object)this.getJPanel());
    private double _total;
    private double _reserved;
    private double _data;
    private double _index;
    private double _unused;
    private double _unreserved;

    public DatabasePropUsagePage(DatabaseProperties databaseProperties) {
        super(databaseProperties, (JPanel)((Object)new DatabasePropGOUsagePage()), ASEUtils.getString("MSG_USAGE"));
    }

    @Override
    public String getHelpID() {
        return "HELP_DATABASE_PROP_USAGE_1252";
    }

    @Override
    public void init() throws SQLException {
        this.removeListeners();
        Support.fillUnitList((JComboBox)this._go.showInComboBox);
        this._go.showInComboBox.setSelectedIndex(2);
        DatabaseSO databaseSO = (DatabaseSO)this.getSO();
        databaseSO.refreshAllocations();
        String string = databaseSO.getUnreservedSpace();
        this._unreserved = Double.valueOf(string);
        String string2 = " " + ASEUtils.getString("MSG_MB");
        string = String.valueOf(Utility.getPrecision(Utility.getKBToMB(this._unreserved), 2)) + string2;
        ASEMessageText aSEMessageText = new ASEMessageText(ASEUtils.getString("DB_PROP_SENT_SPACE"), string);
        this._go.infoMultiLineLabel.setText(aSEMessageText.toString());
        this._go.unreservedTextLabel.setText(string);
        this._total = databaseSO.getTotalSpaceinMB();
        this._go.databaseSizeTextLabel.setText(this._total + string2);
        String string3 = databaseSO.getReserveSpace();
        string3 = string3.substring(0, string3.length() - 3);
        this._reserved = Double.valueOf(string3);
        string3 = String.valueOf(Utility.getPrecision(Utility.getKBToMB(this._reserved), 2)) + string2;
        this._go.reservedTextLabel.setText(string3);
        String string4 = databaseSO.getSpaceUsedByData();
        string4 = string4.substring(0, string4.length() - 3);
        this._data = Double.valueOf(string4);
        string4 = String.valueOf(Utility.getPrecision(Utility.getKBToMB(this._data), 2)) + string2;
        this._go.dataTextLabel.setText(string4);
        String string5 = databaseSO.getSpaceUsedByIndex();
        string5 = string5.substring(0, string5.length() - 3);
        this._index = Double.valueOf(string5);
        string5 = String.valueOf(Utility.getPrecision(Utility.getKBToMB(this._index), 2)) + string2;
        this._go.indexTextLabel.setText(string5);
        String string6 = databaseSO.getUnusedSpace();
        string6 = string6.substring(0, string6.length() - 3);
        this._unused = Double.valueOf(string6);
        string6 = String.valueOf(Utility.getPrecision(Utility.getKBToMB(this._unused), 2)) + string2;
        this._go.unusedTextLabel.setText(string6);
        this.addListeners();
    }

    private void removeListeners() {
        this._go.showInComboBox.removeActionListener((ActionListener)this);
    }

    private void addListeners() {
        this._go.showInComboBox.addActionListener((ActionListener)this);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this._go.showInComboBox) {
            this.updateSpaceText();
        }
    }

    private void updateSpaceText() {
        int n = this._go.showInComboBox.getSelectedIndex();
        String string = " " + ASEUtils.getString("MSG_PAGES");
        String string2 = " " + ASEUtils.getString("MSG_KB");
        String string3 = " " + ASEUtils.getString("MSG_MB");
        String string4 = " " + ASEUtils.getString("MSG_GB");
        ASConnection aSConnection = this.getConnection();
        if (n == 0) {
            String string5 = String.valueOf(Utility.getPrecision(Utility.getKBToPageSize(aSConnection, this._unreserved), 2)) + string;
            ASEMessageText aSEMessageText = new ASEMessageText(ASEUtils.getString("DB_PROP_SENT_SPACE"), string5);
            this._go.infoMultiLineLabel.setText(aSEMessageText.toString());
            this._go.unreservedTextLabel.setText(string5);
            this._go.databaseSizeTextLabel.setText(String.valueOf(Utility.getPrecision(Utility.getMBToPageSize(aSConnection, this._total), 2)) + string);
            this._go.reservedTextLabel.setText(String.valueOf(Utility.getPrecision(Utility.getKBToPageSize(aSConnection, this._reserved), 2)) + string);
            this._go.dataTextLabel.setText(String.valueOf(Utility.getPrecision(Utility.getKBToPageSize(aSConnection, this._data), 2)) + string);
            this._go.indexTextLabel.setText(String.valueOf(Utility.getPrecision(Utility.getKBToPageSize(aSConnection, this._index), 2)) + string);
            this._go.unusedTextLabel.setText(String.valueOf(Utility.getPrecision(Utility.getKBToPageSize(aSConnection, this._unused), 2)) + string);
        } else if (n == 1) {
            String string6 = String.valueOf(Utility.getPrecision(this._unreserved, 2)) + string2;
            ASEMessageText aSEMessageText = new ASEMessageText(ASEUtils.getString("DB_PROP_SENT_SPACE"), string6);
            this._go.infoMultiLineLabel.setText(aSEMessageText.toString());
            this._go.unreservedTextLabel.setText(string6);
            this._go.databaseSizeTextLabel.setText(String.valueOf(Utility.getPrecision(Utility.getMBToKB(this._total), 2)) + string2);
            this._go.reservedTextLabel.setText(String.valueOf(Utility.getPrecision(this._reserved, 2)) + string2);
            this._go.dataTextLabel.setText(String.valueOf(Utility.getPrecision(this._data, 2)) + string2);
            this._go.indexTextLabel.setText(String.valueOf(Utility.getPrecision(this._index, 2)) + string2);
            this._go.unusedTextLabel.setText(String.valueOf(Utility.getPrecision(this._unused, 2)) + string2);
        } else if (n == 2) {
            String string7 = String.valueOf(Utility.getPrecision(Utility.getKBToMB(this._unreserved), 2)) + string3;
            ASEMessageText aSEMessageText = new ASEMessageText(ASEUtils.getString("DB_PROP_SENT_SPACE"), string7);
            this._go.infoMultiLineLabel.setText(aSEMessageText.toString());
            this._go.unreservedTextLabel.setText(string7);
            this._go.databaseSizeTextLabel.setText(String.valueOf(Utility.getPrecision(this._total, 2)) + string3);
            this._go.reservedTextLabel.setText(String.valueOf(Utility.getPrecision(Utility.getKBToMB(this._reserved), 2)) + string3);
            this._go.dataTextLabel.setText(String.valueOf(Utility.getPrecision(Utility.getKBToMB(this._data), 2)) + string3);
            this._go.indexTextLabel.setText(String.valueOf(Utility.getPrecision(Utility.getKBToMB(this._index), 2)) + string3);
            this._go.unusedTextLabel.setText(String.valueOf(Utility.getPrecision(Utility.getKBToMB(this._unused), 2)) + string3);
        } else {
            String string8 = String.valueOf(Utility.getPrecision(Utility.getKBToGB(this._unreserved), 2)) + string4;
            ASEMessageText aSEMessageText = new ASEMessageText(ASEUtils.getString("DB_PROP_SENT_SPACE"), string8);
            this._go.infoMultiLineLabel.setText(aSEMessageText.toString());
            this._go.unreservedTextLabel.setText(string8);
            this._go.databaseSizeTextLabel.setText(String.valueOf(Utility.getPrecision(Utility.getMBToGB(this._total), 2)) + string4);
            this._go.reservedTextLabel.setText(String.valueOf(Utility.getPrecision(Utility.getKBToGB(this._reserved), 2)) + string4);
            this._go.dataTextLabel.setText(String.valueOf(Utility.getPrecision(Utility.getKBToGB(this._data), 2)) + string4);
            this._go.indexTextLabel.setText(String.valueOf(Utility.getPrecision(Utility.getKBToGB(this._index), 2)) + string4);
            this._go.unusedTextLabel.setText(String.valueOf(Utility.getPrecision(Utility.getKBToGB(this._unused), 2)) + string4);
        }
    }
}

