/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.aseplugin.bo.prop;

import com.sybase.aseplugin.ASEImages;
import com.sybase.aseplugin.ASEUtils;
import com.sybase.aseplugin.bo.ContainerViewBO;
import com.sybase.aseplugin.bo.DatabaseBO;
import com.sybase.aseplugin.bo.ServerBO;
import com.sybase.aseplugin.bo.Support;
import com.sybase.aseplugin.bo.prop.ASEBasePropertiesPage2;
import com.sybase.aseplugin.bo.prop.GroupProperties;
import com.sybase.aseplugin.go.prop.PropColumnGOPermissionPage;
import com.sybase.aseplugin.so.GroupSO;
import com.sybase.aseplugin.util.perm.JPermissionGrid;
import com.sybase.aseplugin.util.ui.MyCellRenderer;
import com.sybase.aseplugin.util.ui.TableSelectionListener;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.sql.SQLException;
import java.util.Enumeration;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;

class GroupColumnPermissionPage
extends ASEBasePropertiesPage2
implements ActionListener {
    private JPermissionGrid _grid;
    private PropColumnGOPermissionPage _go = (PropColumnGOPermissionPage)((Object)this.getJPanel());

    public GroupColumnPermissionPage(GroupProperties groupProperties) {
        super(groupProperties, (JPanel)((Object)new PropColumnGOPermissionPage()), ASEUtils.getString("MSG_COLUMN_PERMISSION"));
        this.initComboBox();
        this._go.tableComboBox.addActionListener((ActionListener)this);
        this._go.propertiesButton.addActionListener((ActionListener)this);
    }

    @Override
    public String getHelpID() {
        return "HELP_GROUP_PROP_COLUMN_PERMISSIONS_1253";
    }

    @Override
    public void init() throws SQLException {
        this._grid = new JPermissionGrid(this.getParent().getJDialog(), ((GroupSO)this.getSO()).getConnection());
        this._go.objectsScrollPane.getViewport().setView(this._grid.getTable());
        this.addKeyboardActions();
        this.addMouseActions();
        TableSelectionListener tableSelectionListener = new TableSelectionListener(){

            @Override
            public void deSelectAction() {
                ((GroupColumnPermissionPage)GroupColumnPermissionPage.this)._go.propertiesButton.setEnabled(false);
            }

            @Override
            public void selectAction() {
                ((GroupColumnPermissionPage)GroupColumnPermissionPage.this)._go.propertiesButton.setEnabled(true);
            }
        };
        this._go.propertiesButton.setEnabled(false);
        this._grid.getTable().getSelectionModel().addListSelectionListener(tableSelectionListener);
        this.refreshScreen();
    }

    public void initComboBox() {
        try {
            this._go.tableComboBox.removeAllItems();
            this._go.tableComboBox.setRenderer((ListCellRenderer)new MyCellRenderer());
            ImageIcon imageIcon = new ImageIcon(ASEImages.getTableSmallImage());
            Enumeration enumeration = ((GroupSO)this.getSO()).getTableList();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                this._go.tableComboBox.addItem((Object)new JLabel(string, imageIcon, 2));
            }
        }
        catch (SQLException sQLException) {
            Support.showDetailsError(this.getConnection(), this.getClass(), (Container)this.getJDialog(), sQLException.getMessage(), sQLException);
        }
        this._go.tableComboBox.setSelectedIndex(0);
    }

    public void refreshScreen() {
        if (this._go.tableComboBox.getItemCount() == 0) {
            return;
        }
        String string = ((JLabel)this._go.tableComboBox.getSelectedItem()).getText();
        int n = string.indexOf(".");
        String string2 = string.substring(0, n);
        String string3 = string.substring(n + 1);
        try {
            ((GroupSO)this.getSO()).setPermissionLists(string3, string2, 0);
            this._grid.fillColumnList(((GroupSO)this.getSO()).getColumnGroupPermissionList(), ((GroupSO)this.getSO()).getColumnPublicPermissionList(), (GroupSO)this.getSO());
        }
        catch (SQLException sQLException) {
            Support.showDetailsError(this.getConnection(), this.getClass(), (Container)this.getJDialog(), sQLException.getMessage(), sQLException);
        }
        this._go.propertiesButton.setEnabled(false);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this._go.propertiesButton) {
            ServerBO serverBO = ContainerViewBO.getServerBO(this.getSO().getConnection());
            DatabaseBO databaseBO = ContainerViewBO.getDatabaseBO(serverBO, ((GroupSO)this.getSO()).getDatabaseName());
            String string = ((JLabel)this._go.tableComboBox.getSelectedItem()).getText();
            int n = string.indexOf(".");
            String string2 = string.substring(0, n);
            String string3 = string.substring(n + 1);
            int[] nArray = this._grid.getTable().getSelectedRows();
            for (int i = 0; i < nArray.length; ++i) {
                String string4 = (String)this._grid.getTable().getValueAt(nArray[i], 0);
                ContainerViewBO.openColumnProperties(ContainerViewBO.getTableBO(databaseBO, string2, string3), string4);
            }
        } else if (object == this._go.tableComboBox) {
            this.refreshScreen();
        }
    }

    private void addKeyboardActions() {
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = GroupColumnPermissionPage.this._grid.getTable().getSelectedRow();
                int n2 = GroupColumnPermissionPage.this._grid.getTable().getSelectedColumn();
                if (n2 > 0) {
                    GroupColumnPermissionPage.this._grid.onClickedCell(n, n2);
                    GroupColumnPermissionPage.this.enableApplyButton(true);
                }
            }
        };
        this._grid.getTable().registerKeyboardAction(actionListener, KeyStroke.getKeyStroke(10, 0), 0);
        this._grid.getTable().registerKeyboardAction(actionListener, KeyStroke.getKeyStroke(32, 0), 0);
    }

    private void addMouseActions() {
        MouseAdapter mouseAdapter = new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                int n = GroupColumnPermissionPage.this._grid.getTable().columnAtPoint(mouseEvent.getPoint());
                int n2 = GroupColumnPermissionPage.this._grid.getTable().rowAtPoint(mouseEvent.getPoint());
                if (n2 < 0 || n < 0) {
                    return;
                }
                if (n > 0) {
                    GroupColumnPermissionPage.this._grid.onClickedCell(n2, n);
                    GroupColumnPermissionPage.this.enableApplyButton(true);
                }
            }
        };
        this._grid.getTable().addMouseListener(mouseAdapter);
    }

    @Override
    public boolean deploy() {
        this._grid.savePermission((GroupSO)this.getSO(), ((GroupSO)this.getSO()).getDatabaseName());
        return true;
    }

    @Override
    public void releaseResources() {
        if (this._go != null) {
            this._go.tableComboBox.removeActionListener((ActionListener)this);
            this._go.propertiesButton.removeActionListener((ActionListener)this);
            this._go.releaseResources();
            this._go = null;
        }
        super.releaseResources();
    }
}

