/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.aseplugin.bo.prop;

import com.sybase.asa.ASAListCheckEvent;
import com.sybase.asa.ASAListCheckListener;
import com.sybase.aseplugin.ASEUtils;
import com.sybase.aseplugin.JSBaseInterface;
import com.sybase.aseplugin.bo.ASEBaseContainer2;
import com.sybase.aseplugin.bo.JobsCtrBO;
import com.sybase.aseplugin.bo.ScheduledJobsCtrBO;
import com.sybase.aseplugin.bo.Support;
import com.sybase.aseplugin.bo.dlg.JobTemplateTreeSelectionDialog;
import com.sybase.aseplugin.bo.prop.ASEBasePropDocPage;
import com.sybase.aseplugin.bo.prop.ASEBasePropertiesDialog2;
import com.sybase.aseplugin.bo.wiz.JobTemplateWizard;
import com.sybase.aseplugin.go.prop.JobPropGOCmdPage;
import com.sybase.aseplugin.go.prop.JobPropGOGenPage;
import com.sybase.aseplugin.go.prop.JobPropGOOptPage;
import com.sybase.aseplugin.so.JobSO;
import com.sybase.aseplugin.so.JobTemplateSO;
import com.sybase.aseplugin.so.SOItemInterface;
import com.sybase.central.SCContainer2;
import com.sybase.central.SCPageController;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JPanel;

public class JobProperties
extends ASEBasePropertiesDialog2
implements JSBaseInterface {
    private JobsCtrBO _parent;
    private boolean traceThis = false;

    public JobProperties(JobSO jobSO, ASEBaseContainer2 aSEBaseContainer2) {
        super((SOItemInterface)jobSO, (SCContainer2)aSEBaseContainer2);
        this._parent = (JobsCtrBO)aSEBaseContainer2;
        jobSO.convertListToProperties(jobSO.getColumn(6));
    }

    @Override
    public SCPageController[] getPages() {
        return new SCPageController[]{new JobPropGeneralPage(this), new JobPropCommandPage(this), new JobPropOptionsPage(this)};
    }

    @Override
    public boolean deploy() throws SQLException {
        ((JobSO)this.getSO()).update();
        return true;
    }

    @Override
    public boolean onOk() {
        ScheduledJobsCtrBO scheduledJobsCtrBO = (ScheduledJobsCtrBO)this._parent.getParent();
        if (!scheduledJobsCtrBO.isJSAuthorized()) {
            Support.showInfo(this.getConnection(), this.getClass(), ASEUtils.getString("ERR_JS_CLIENT_NO_PERMISSION"));
            return false;
        }
        boolean bl = super.onOk();
        scheduledJobsCtrBO.refresh();
        return bl;
    }

    @Override
    public void onApply() {
        ScheduledJobsCtrBO scheduledJobsCtrBO = (ScheduledJobsCtrBO)this._parent.getParent();
        if (!scheduledJobsCtrBO.isJSAuthorized()) {
            Support.showInfo(this.getConnection(), this.getClass(), ASEUtils.getString("ERR_JS_CLIENT_NO_PERMISSION"));
        } else {
            super.onApply();
        }
    }

    @Override
    public void releaseResources() {
        super.releaseResources();
    }

    class JobPropOptionsPage
    extends ASEBasePropDocPage
    implements ASAListCheckListener {
        private JobPropGOOptPage _optsPage;

        public JobPropOptionsPage(JobProperties jobProperties2) {
            super(jobProperties2, (JPanel)((Object)new JobPropGOOptPage()), ASEUtils.getString("MSG_OPTIONS"));
        }

        @Override
        public String getHelpID() {
            return "HELP_SJ_JOB_PROP_PARAMETERS_1252";
        }

        @Override
        public void init() {
            this._optsPage = (JobPropGOOptPage)((Object)this.getJPanel());
            this._optsPage.setDisplayPreviewButton(false);
            this._optsPage.clearOptions();
            JobSO jobSO = (JobSO)this.getSO();
            jobSO.convertListToProperties(jobSO.getColumn(6));
            if (JobProperties.this.traceThis) {
                System.out.println("properties list = " + jobSO.getColumn(6));
            }
            this._optsPage.addOption(ASEUtils.getString("JOB_PROP_CHKB_CONCURRENCY"), jobSO.getConcurrency());
            this._optsPage.addOption(ASEUtils.getString("JOB_PROP_CHKB_SHARED"), jobSO.getSharing());
            this._optsPage.addOption(ASEUtils.getString("JOB_PROP_CHKB_RUN_AS_OWNER"), jobSO.getRunAsOwner());
            if (jobSO.getConnection().isCluster()) {
                this._optsPage.addOption(ASEUtils.getString("JOB_PROP_CHKB_REDIRECT"), jobSO.getAllowRedirect());
            }
            this._optsPage.setTimeout(jobSO.getTimeout());
            this._optsPage.setEnabled(true);
            this._optsPage.setVisible(true);
            this._optsPage.addListeners(this);
        }

        public void valueChanged(ASAListCheckEvent aSAListCheckEvent) {
            this.enableApplyButton(true);
        }

        @Override
        public boolean deploy() {
            JobSO jobSO = (JobSO)this.getSO();
            boolean bl = false;
            boolean bl2 = false;
            bl = this._optsPage.getOptionValue(ASEUtils.getString("JOB_PROP_CHKB_CONCURRENCY"));
            if (jobSO.getConcurrency() != bl) {
                jobSO.setConcurrency(bl);
                bl2 = true;
            }
            bl = this._optsPage.getOptionValue(ASEUtils.getString("JOB_PROP_CHKB_RUN_AS_OWNER"));
            if (jobSO.getRunAsOwner() != bl) {
                jobSO.setRunAsOwner(bl);
                bl2 = true;
            }
            bl = this._optsPage.getOptionValue(ASEUtils.getString("JOB_PROP_CHKB_SHARED"));
            if (jobSO.getSharing() != bl) {
                jobSO.setSharing(bl);
                bl2 = true;
            }
            if (jobSO.getConnection().isCluster()) {
                bl = this._optsPage.getOptionValue(ASEUtils.getString("JOB_PROP_CHKB_REDIRECT"));
                if (jobSO.getAllowRedirect() != bl) {
                    jobSO.setAllowRedirect(bl);
                    bl2 = true;
                }
            }
            if (bl2) {
                jobSO.addUpdateFlag(6);
            }
            String string = this._optsPage.getTimeout();
            if (!jobSO.getTimeout().equals(string)) {
                jobSO.setTimeout(string);
                jobSO.addUpdateFlag(7);
            }
            return true;
        }
    }

    class JobPropCommandPage
    extends ASEBasePropDocPage
    implements ActionListener {
        private JobPropGOCmdPage _cmdPage;
        private JobProperties _controllerParent;

        public JobPropCommandPage(JobProperties jobProperties2) {
            super(jobProperties2, (JPanel)((Object)new JobPropGOCmdPage()), ASEUtils.getString("MSG_COMMANDS"));
            this._controllerParent = jobProperties2;
        }

        @Override
        public String getHelpID() {
            return "HELP_SJ_JOB_PROP_COMMANDS_1252";
        }

        @Override
        public void init() throws SQLException {
            this._cmdPage = (JobPropGOCmdPage)((Object)this.getJPanel());
            this._cmdPage.setDisplayPreviewButton(false);
            JobSO jobSO = (JobSO)this.getSO();
            this._cmdPage.setCommandText(jobSO.getSQL());
            this._cmdPage.addAllListener(this);
            this._cmdPage.enableTemplateBtn(true);
            this._cmdPage.setEnabled(true);
            this._cmdPage.setVisible(true);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.showTemplates();
        }

        private void showTemplates() {
            Hashtable hashtable = JobProperties.this._parent.getJSTemplates();
            Vector vector = new Vector();
            Object object = hashtable.elements();
            while (object.hasMoreElements()) {
                vector.add(object.nextElement());
            }
            object = null;
            object = new JobTemplateTreeSelectionDialog(Support.createDialogSupport(this.getJDialog()), JobProperties.this._parent, vector, ((JobSO)this.getSO()).getColumn(8));
            JobTemplateSO jobTemplateSO = ((JobTemplateTreeSelectionDialog)object).getSelectedTemplateSO();
            if (jobTemplateSO != null) {
                StringBuffer stringBuffer = new StringBuffer("");
                StringBuffer stringBuffer2 = new StringBuffer("");
                JobTemplateWizard jobTemplateWizard = new JobTemplateWizard(jobTemplateSO, JobProperties.this._parent, stringBuffer, stringBuffer2);
                JobTemplateWizard.showDialog((Container)this._controllerParent.getJDialog(), jobTemplateWizard);
                if (!stringBuffer2.toString().equals("")) {
                    this._cmdPage.setCommandText(stringBuffer2.toString());
                }
            }
        }

        @Override
        public boolean deploy() {
            String string = this._cmdPage.getCommandText();
            if (string.trim().length() == 0) {
                Support.showInfo(this.getConnection(), this.getClass(), ASEUtils.getString("ERR_NO_JOB_DEFINITION"));
                return false;
            }
            JobSO jobSO = (JobSO)this.getSO();
            String string2 = this._cmdPage.getCommandText();
            if (!jobSO.getJobSQLText().equals(string2)) {
                jobSO.setJobSQLText(string2);
                jobSO.addUpdateFlag(9);
            }
            return true;
        }
    }

    class JobPropGeneralPage
    extends ASEBasePropDocPage {
        private JobPropGOGenPage _genPage;

        public JobPropGeneralPage(JobProperties jobProperties2) {
            super(jobProperties2, (JPanel)((Object)new JobPropGOGenPage()), ASEUtils.getString("MSG_GENERAL"));
            this._genPage = null;
        }

        @Override
        public String getHelpID() {
            return "HELP_SJ_JOB_PROP_GENERAL_1252";
        }

        @Override
        public void init() {
            this._genPage = (JobPropGOGenPage)((Object)this.getJPanel());
            this._genPage.setDisplayPreviewButton(false);
            JobSO jobSO = (JobSO)this.getSO();
            this._genPage.setNameField(jobSO.getName());
            this._genPage.setIDField(jobSO.getColumn(0));
            this._genPage.setOwnerField(jobSO.getColumn(3));
            this._genPage.setCreatedField(jobSO.getColumn(4));
            this._genPage.setDescription(jobSO.getColumn(2));
            ScheduledJobsCtrBO scheduledJobsCtrBO = (ScheduledJobsCtrBO)JobProperties.this._parent.getParent();
            if (scheduledJobsCtrBO.isAdministrator()) {
                this._genPage.setOwnerEditable(true);
            } else {
                this._genPage.setOwnerEditable(false);
            }
            this._genPage.addAllListener(this);
        }

        @Override
        public boolean deploy() {
            boolean bl = this.handleNameChange();
            boolean bl2 = this.handleOwnerChange();
            if (bl && bl2) {
                JobSO jobSO = (JobSO)this.getSO();
                if (!this._genPage.getDescription().equals(jobSO.getDescription())) {
                    jobSO.setDescription(this._genPage.getDescription());
                    jobSO.addUpdateFlag(2);
                }
            }
            return bl && bl2;
        }

        private boolean handleNameChange() {
            JobSO jobSO = (JobSO)this.getSO();
            String string = this._genPage.getNameField();
            if (string == null) {
                return false;
            }
            if (string.equals(jobSO.getName())) {
                return true;
            }
            if (jobSO.isValidJSName(string, "DISP_JOB_TEXT", this.getJDialog())) {
                jobSO.setColumn(1, string);
                jobSO.addUpdateFlag(1);
                return true;
            }
            return false;
        }

        private boolean handleOwnerChange() {
            JobSO jobSO = (JobSO)this.getSO();
            String string = this._genPage.getOwnerField();
            if (string == null) {
                return false;
            }
            if (string.equals(jobSO.getColumn(3))) {
                return true;
            }
            jobSO.setColumn(3, string);
            jobSO.addUpdateFlag(3);
            return true;
        }

        @Override
        public void nameUpdate() {
            ((JobSO)this.getSO()).setName(this._genPage.getNameField());
            ((JobSO)this.getSO()).setOwner(this._genPage.getOwnerField());
            ((JobSO)this.getSO()).setDescription(this._genPage.getDescription());
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.enableApplyButton(true);
        }
    }
}

