/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.aseplugin.bo.prop;

import com.sybase.aseplugin.ASEImages;
import com.sybase.aseplugin.ASEUtils;
import com.sybase.aseplugin.bo.prop.ASEBasePropertiesDialog2;
import com.sybase.aseplugin.bo.prop.ASEBasePropertiesPage2;
import com.sybase.aseplugin.go.prop.LogPropGOGeneralPage;
import com.sybase.aseplugin.so.LogSO;
import com.sybase.aseplugin.so.RegExpression;
import com.sybase.aseplugin.so.SOItemInterface;
import com.sybase.central.SCDetailsContainer;
import com.sybase.central.SCPageController;
import java.awt.Color;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;

public class LogProperties
extends ASEBasePropertiesDialog2 {
    private LogSO _lso;

    public LogProperties(LogSO logSO, SCDetailsContainer sCDetailsContainer) {
        super((SOItemInterface)logSO, sCDetailsContainer);
        this._lso = logSO;
    }

    @Override
    public SCPageController[] getPages() {
        return new SCPageController[]{new LogPropGeneralPage(this)};
    }

    class LogPropGeneralPage
    extends ASEBasePropertiesPage2 {
        private LogPropGOGeneralPage _go;

        public LogPropGeneralPage(LogProperties logProperties2) {
            super(logProperties2, (JPanel)((Object)new LogPropGOGeneralPage()), ASEUtils.getString("MSG_GENERAL"));
            this._go = (LogPropGOGeneralPage)((Object)this.getJPanel());
            this._go.setDisplayPreviewButton(false);
        }

        @Override
        public void init() {
            if (LogProperties.this._lso.isCluster()) {
                this._go.instanceIdLabel.setVisible(true);
                this._go.instanceIdTextLabel.setVisible(true);
                this._go.instanceIdTextLabel.setText(LogProperties.this._lso.getSDCInstanceId());
            }
            this._go.dateTextLabel.setText(LogProperties.this._lso.getDate().toString());
            this._go.engineNumberTextLabel.setText(LogProperties.this._lso.getEngineId());
            this._go.familyIDTextLabel.setText(LogProperties.this._lso.getFamilyId());
            this._go.processIDTextLabel.setText(LogProperties.this._lso.getProcessId());
            this._go.sourceTextLabel.setText(LogProperties.this._lso.getSource());
            this._go.iconLabel.setIcon((Icon)(LogProperties.this._lso.hasMatches() ? new ImageIcon(ASEImages.getLogErrorLargeImage()) : new ImageIcon(ASEImages.getLogLargeImage())));
            String string = LogProperties.this._lso.getDescription();
            if (string != null && string.trim().length() > 0) {
                this._go.descriptionTextLabel.setText(LogProperties.this._lso.getDescription());
            } else {
                this._go.descriptionLabel.setVisible(false);
                this._go.descriptionTextLabel.setVisible(false);
            }
            this._go.messageEditor.setText(LogProperties.this._lso.getMessage());
            if (LogProperties.this._lso.hasMatches()) {
                StyledDocument styledDocument = this._go.messageEditor.getStyledDocument();
                Style style = this._go.messageEditor.addStyle("Blue", null);
                StyleConstants.setForeground(style, Color.blue);
                StyleConstants.setBold(style, true);
                ArrayList arrayList = LogProperties.this._lso.getServer().getServerLogsExps();
                for (RegExpression regExpression : arrayList) {
                    if (!regExpression.enabled) continue;
                    Pattern pattern = regExpression.ignoreCase ? Pattern.compile(regExpression.expression, 2) : Pattern.compile(regExpression.expression);
                    Matcher matcher = pattern.matcher(LogProperties.this._lso.getMessage());
                    while (matcher.find()) {
                        int n = matcher.start();
                        int n2 = matcher.end();
                        styledDocument.setCharacterAttributes(n, n2 - n, this._go.messageEditor.getStyle("Blue"), true);
                    }
                }
            }
        }

        @Override
        public String getHelpID() {
            return "HELP_LOG_PROP_GENERAL_15";
        }
    }
}

