/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.aseplugin.bo.prop;

import com.sybase.asa.ASAIconTextData;
import com.sybase.asa.ASASpinBoxChangeEvent;
import com.sybase.asa.ASASpinBoxChangeListener;
import com.sybase.aseplugin.ASEImages;
import com.sybase.aseplugin.ASEMessageText;
import com.sybase.aseplugin.ASEUtils;
import com.sybase.aseplugin.bo.ContainerViewBO;
import com.sybase.aseplugin.bo.DatabaseBO;
import com.sybase.aseplugin.bo.LoginsCtrBO;
import com.sybase.aseplugin.bo.RoleBO;
import com.sybase.aseplugin.bo.ServerBO;
import com.sybase.aseplugin.bo.Support;
import com.sybase.aseplugin.bo.dlg.AddObjectDialog;
import com.sybase.aseplugin.bo.dlg.ChangePasswordDialog;
import com.sybase.aseplugin.bo.prop.ASEBasePropDocPage;
import com.sybase.aseplugin.bo.prop.ASEBasePropertiesDialog2;
import com.sybase.aseplugin.bo.prop.ASEBasePropertiesPage2;
import com.sybase.aseplugin.go.ASETable;
import com.sybase.aseplugin.go.prop.LoginPropGOClientMappingPage;
import com.sybase.aseplugin.go.prop.LoginPropGODatabasesPage;
import com.sybase.aseplugin.go.prop.LoginPropGOGeneralPage;
import com.sybase.aseplugin.go.prop.LoginPropGOParamsPage;
import com.sybase.aseplugin.go.prop.LoginPropGORolesPage;
import com.sybase.aseplugin.go.prop.LoginPropGOUsersPage;
import com.sybase.aseplugin.so.DatabaseSO;
import com.sybase.aseplugin.so.LoginSO;
import com.sybase.aseplugin.so.SOItemInterface;
import com.sybase.aseplugin.util.ui.JLabelTableModel;
import com.sybase.aseplugin.util.ui.MyCellRenderer;
import com.sybase.aseplugin.util.ui.TableSelectionListener;
import com.sybase.central.SCContainer2;
import com.sybase.central.SCPageController;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.sql.SQLException;
import java.util.List;
import java.util.Vector;
import javax.swing.DefaultCellEditor;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;

public class LoginProperties
extends ASEBasePropertiesDialog2 {
    public LoginProperties(SOItemInterface sOItemInterface, SCContainer2 sCContainer2) {
        super(sOItemInterface, sCContainer2);
    }

    @Override
    public SCPageController[] getPages() {
        boolean bl = ((LoginSO)this.getSO()).isPAMSupportApplicable();
        if (bl) {
            return new SCPageController[]{new LoginPropGeneralPage(this), new LoginPropParamsPage(this), new LoginPropDatabasesPage(this), new LoginPropRolesPage(this), new LoginPropUsersPage(this), new LoginPropClientMappingPage(this)};
        }
        return new SCPageController[]{new LoginPropGeneralPage(this), new LoginPropParamsPage(this), new LoginPropDatabasesPage(this), new LoginPropRolesPage(this), new LoginPropUsersPage(this)};
    }

    class LoginPropClientMappingPage
    extends ASEBasePropertiesPage2
    implements ActionListener,
    ListSelectionListener {
        JLabelTableModel _tableModel;
        JTable _table;
        private LoginPropGOClientMappingPage _go;

        public LoginPropClientMappingPage(ASEBasePropertiesDialog2 aSEBasePropertiesDialog2) {
            super(aSEBasePropertiesDialog2, (JPanel)((Object)new LoginPropGOClientMappingPage()), ASEUtils.getString("DNAME_CLIENT_MAPPING"));
            this._go = (LoginPropGOClientMappingPage)((Object)this.getJPanel());
            this._go.addButton.addActionListener((ActionListener)this);
            this._go.removeButton.addActionListener((ActionListener)this);
        }

        @Override
        public String getHelpID() {
            return "HELP_LOGIN_PROP_CLIENT_MAPPING_1252";
        }

        @Override
        public void init() throws SQLException {
            Vector<String> vector = new Vector<String>();
            vector.addElement(ASEUtils.getString("LOGIN_PROP_HDR_CLIENT_USER"));
            vector.addElement(ASEUtils.getString("LOGIN_PROP_HDR_AUTHENTICATION"));
            this._tableModel = new JLabelTableModel(vector, ((LoginSO)this.getSO()).getClientMappings());
            final LoginSO loginSO = (LoginSO)this.getSO();
            this._table = new ASETable(this._tableModel){

                @Override
                public boolean isCellEditable(int n, int n2) {
                    if (n2 == 0) {
                        return true;
                    }
                    return loginSO.getAuthMechanism().equals("ANY");
                }
            };
            this._table.getSelectionModel().addListSelectionListener(this);
            this._go.removeButton.setEnabled(false);
            TableSelectionListener tableSelectionListener = new TableSelectionListener(){

                @Override
                public void deSelectAction() {
                    ((LoginPropClientMappingPage)LoginPropClientMappingPage.this)._go.removeButton.setEnabled(false);
                }

                @Override
                public void selectAction() {
                    ((LoginPropClientMappingPage)LoginPropClientMappingPage.this)._go.removeButton.setEnabled(true);
                }
            };
            this._table.getSelectionModel().addListSelectionListener(tableSelectionListener);
            TableColumn tableColumn = this._table.getColumn(ASEUtils.getString("LOGIN_PROP_HDR_CLIENT_USER"));
            DefaultCellEditor defaultCellEditor = new DefaultCellEditor(new JTextField());
            tableColumn.setCellEditor(defaultCellEditor);
            TableColumn tableColumn2 = this._table.getColumn(ASEUtils.getString("LOGIN_PROP_HDR_AUTHENTICATION"));
            JComboBox<String> jComboBox = new JComboBox<String>(new String[]{"ANY", "ASE", "LDAP", "PAM"});
            DefaultCellEditor defaultCellEditor2 = new DefaultCellEditor(jComboBox);
            tableColumn2.setCellEditor(defaultCellEditor2);
            this._go.mappingScrollPane.getViewport().setView(this._table);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.enableApplyButton(true);
            Object object = actionEvent.getSource();
            if (object == this._go.addButton) {
                Vector<String> vector = new Vector<String>();
                vector.addElement("");
                vector.addElement(((LoginSO)this.getSO()).getAuthMechanism());
                this._tableModel.addRow(vector);
                this._tableModel.fireTableDataChanged();
            } else if (object == this._go.removeButton) {
                int[] nArray = this._table.getSelectedRows();
                for (int i = nArray.length - 1; i >= 0; --i) {
                    this._tableModel.removeRow(nArray[i]);
                }
                this._tableModel.fireTableDataChanged();
                this._go.removeButton.setEnabled(false);
            }
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
            boolean bl = listSelectionModel.isSelectionEmpty();
            if (bl) {
                return;
            }
            this.enableApplyButton(true);
        }

        @Override
        public boolean deploy() throws SQLException {
            String string;
            String string2;
            Vector vector;
            int n;
            if (this._table.isEditing()) {
                this._table.getCellEditor().stopCellEditing();
            }
            Vector vector2 = ((LoginSO)this.getSO()).getClientMappings();
            Vector vector3 = (Vector)this._tableModel.getData().clone();
            for (n = 0; n < vector2.size(); ++n) {
                vector = (Vector)vector2.elementAt(n);
                if (vector3.contains(vector)) continue;
                string2 = (String)vector.elementAt(0);
                string = (String)vector.elementAt(1);
                ((LoginSO)this.getSO()).deleteClientLoginMapping(string2, string);
            }
            for (n = 0; n < vector3.size(); ++n) {
                vector = (Vector)vector3.elementAt(n);
                if (vector2.contains(vector)) continue;
                string2 = (String)vector.elementAt(0);
                string = (String)vector.elementAt(1);
                if (string2.equals("")) continue;
                ((LoginSO)this.getSO()).addClientLoginMapping(string2, string);
            }
            return true;
        }

        @Override
        public void releaseResources() {
            this._tableModel = null;
            this._table = null;
            this._go.releaseResources();
            this._go = null;
            super.releaseResources();
        }
    }

    class LoginPropUsersPage
    extends ASEBasePropertiesPage2
    implements ActionListener,
    ListSelectionListener {
        Vector tableItemsList;
        Vector dialogItemList;
        JLabelTableModel _tableModel;
        JTable _table;
        Vector heading;
        private LoginPropGOUsersPage _go;

        public LoginPropUsersPage(ASEBasePropertiesDialog2 aSEBasePropertiesDialog2) {
            super(aSEBasePropertiesDialog2, (JPanel)((Object)new LoginPropGOUsersPage()), ASEUtils.getString("DNAME_USERS"));
            this.tableItemsList = new Vector();
            this.dialogItemList = new Vector();
            this.heading = new Vector();
            this._go = (LoginPropGOUsersPage)((Object)this.getJPanel());
            this.heading.addElement(ASEUtils.getString("DISP_NAME_TEXT"));
            this.heading.addElement(ASEUtils.getString("DISP_DATABASE_TEXT"));
            this.heading.addElement(ASEUtils.getString("MSG_MAPPING"));
            this._go.propertiesButton.addActionListener((ActionListener)this);
            this._go.addButton.addActionListener((ActionListener)this);
            this._go.removeButton.addActionListener((ActionListener)this);
        }

        @Override
        public String getHelpID() {
            return "HELP_LOGIN_PROP_USERS_1252";
        }

        @Override
        public void init() throws SQLException {
            LoginSO loginSO = (LoginSO)this.getSO();
            Object[] objectArray = loginSO.getAliasDatabaseSOs();
            this.tableItemsList = new Vector();
            this.dialogItemList = new Vector();
            for (int i = 0; i < objectArray.length; ++i) {
                DatabaseSO databaseSO = (DatabaseSO)objectArray[i];
                String string = loginSO.isDirect(databaseSO.getConnection(), databaseSO.getName());
                String string2 = loginSO.isAlias(databaseSO.getConnection(), databaseSO.getName());
                if (string.length() > 0) {
                    this.tableItemsList.addElement(loginSO.rowByName(string, databaseSO.getName(), ASEUtils.getString("MSG_DIRECT")));
                    continue;
                }
                if (string2.length() > 0) {
                    this.tableItemsList.addElement(loginSO.rowByName(string2, databaseSO.getName(), ASEUtils.getString("MSG_ALIAS")));
                    continue;
                }
                String[] stringArray = loginSO.getAliasList(databaseSO.getConnection(), databaseSO.getName());
                for (int j = 0; j < stringArray.length; ++j) {
                    this.dialogItemList.addElement(loginSO.rowByName(stringArray[j], databaseSO.getName(), ASEUtils.getString("MSG_ALIAS")));
                }
            }
            this._tableModel = new JLabelTableModel(this.heading, this.tableItemsList);
            this._table = new ASETable(this._tableModel);
            this._table.setDefaultRenderer(new JLabel().getClass(), new MyCellRenderer());
            this._go.usersScrollPane.getViewport().setView(this._table);
            this._table.getSelectionModel().addListSelectionListener(this);
            this._go.removeButton.setEnabled(false);
            this._go.propertiesButton.setEnabled(false);
            TableSelectionListener tableSelectionListener = new TableSelectionListener(){

                @Override
                public void deSelectAction() {
                    ((LoginPropUsersPage)LoginPropUsersPage.this)._go.removeButton.setEnabled(false);
                    ((LoginPropUsersPage)LoginPropUsersPage.this)._go.propertiesButton.setEnabled(false);
                }

                @Override
                public void selectAction() {
                    ((LoginPropUsersPage)LoginPropUsersPage.this)._go.removeButton.setEnabled(true);
                    ((LoginPropUsersPage)LoginPropUsersPage.this)._go.propertiesButton.setEnabled(true);
                }
            };
            this._table.getSelectionModel().addListSelectionListener(tableSelectionListener);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.enableApplyButton(true);
            Object object = actionEvent.getSource();
            if (object == this._go.addButton) {
                ASEMessageText aSEMessageText = new ASEMessageText(ASEUtils.getString("MSG_ADD_ALIAS_TO_LOGIN"), ((LoginSO)this.getSO()).getName());
                AddObjectDialog addObjectDialog = AddObjectDialog.getDialog(this.getJDialog(), ASEUtils.getString("MSG_ADD_ALIAS"), aSEMessageText.toString(), this.heading, this.dialogItemList, "HELP_LOGIN_DLG_ADD_ALIAS_1252");
                boolean bl = addObjectDialog.render();
                if (bl) {
                    ASETable aSETable = addObjectDialog.getDataTable();
                    int[] nArray = aSETable.getSelectedRows();
                    Vector vector = new Vector();
                    AbstractTableModel abstractTableModel = (AbstractTableModel)aSETable.getModel();
                    for (int i = 0; i < nArray.length; ++i) {
                        Vector<Object> vector2 = new Vector<Object>();
                        vector2.add(abstractTableModel.getValueAt(nArray[i], 0));
                        vector2.add(abstractTableModel.getValueAt(nArray[i], 1));
                        vector2.add(abstractTableModel.getValueAt(nArray[i], 2));
                        this._tableModel.addRow(vector2);
                        vector.addElement(vector2);
                        vector2 = null;
                    }
                    this._table.tableChanged(new TableModelEvent(this._tableModel));
                    this.dialogItemList.removeAll(vector);
                    vector = null;
                    this._go.removeButton.setEnabled(false);
                }
            } else if (object == this._go.removeButton) {
                int[] nArray = this._table.getSelectedRows();
                Vector<Vector> vector = new Vector<Vector>();
                for (int i = 0; i < nArray.length; ++i) {
                    Vector vector3 = this._tableModel.getRow(nArray[i]);
                    this.dialogItemList.addElement(vector3);
                    vector.addElement(vector3);
                    vector3 = null;
                }
                this._table.tableChanged(new TableModelEvent(this._tableModel));
                this._tableModel.removeRows(vector);
                vector = null;
                this._go.removeButton.setEnabled(false);
                this._go.propertiesButton.setEnabled(false);
            } else if (object == this._go.propertiesButton) {
                ServerBO serverBO = (ServerBO)((LoginsCtrBO)this.getParent().getParent()).getParent();
                int[] nArray = this._table.getSelectedRows();
                for (int i = 0; i < nArray.length; ++i) {
                    String string = ((JLabel)this._tableModel.getValueAt(nArray[i], 0)).getText();
                    String string2 = (String)this._tableModel.getValueAt(nArray[i], 1);
                    DatabaseBO databaseBO = ContainerViewBO.getDatabaseBO(serverBO, string2);
                    ContainerViewBO.openUserProperties(databaseBO, string);
                }
            }
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
            boolean bl = listSelectionModel.isSelectionEmpty();
            if (bl) {
                return;
            }
        }

        @Override
        public boolean deploy() throws SQLException {
            Vector vector;
            int n;
            Vector vector2 = this.tableItemsList;
            Vector vector3 = (Vector)this._tableModel.getData().clone();
            for (n = 0; n < vector2.size(); ++n) {
                vector = (Vector)vector2.elementAt(n);
                if (vector3.contains(vector)) continue;
                if (((String)vector.elementAt(2)).equals(ASEUtils.getString("MSG_DIRECT"))) {
                    ((LoginSO)this.getSO()).dropDirect(((JLabel)vector.elementAt(0)).getText(), (String)vector.elementAt(1));
                    continue;
                }
                ((LoginSO)this.getSO()).dropAlias((String)vector.elementAt(1));
            }
            for (n = 0; n < vector3.size(); ++n) {
                vector = (Vector)vector3.elementAt(n);
                if (vector2.contains(vector)) continue;
                ((LoginSO)this.getSO()).addAlias((String)vector.elementAt(1), ((JLabel)vector.elementAt(0)).getText());
            }
            return true;
        }

        @Override
        public void releaseResources() {
            this._go.propertiesButton.removeActionListener((ActionListener)this);
            this._go.addButton.removeActionListener((ActionListener)this);
            this._go.removeButton.removeActionListener((ActionListener)this);
            this._go.releaseResources();
            this._go = null;
            super.releaseResources();
        }
    }

    class LoginPropRolesPage
    extends ASEBasePropertiesPage2
    implements ActionListener {
        Vector selections;
        JLabelTableModel _tableModel;
        JTable _table;
        Vector heading;
        private boolean _rolesChanged;
        private LoginPropGORolesPage _go;

        public LoginPropRolesPage(ASEBasePropertiesDialog2 aSEBasePropertiesDialog2) {
            super(aSEBasePropertiesDialog2, (JPanel)((Object)new LoginPropGORolesPage()), ASEUtils.getString("DNAME_ROLES"));
            this.selections = new Vector();
            this.heading = new Vector();
            this._go = (LoginPropGORolesPage)((Object)this.getJPanel());
            this.heading.addElement(ASEUtils.getString("MSG_ROLE_TYPE"));
            this.heading.addElement(ASEUtils.getString("DISP_ACTIVEBYDEFAULT_TEXT"));
            this._go.propertiesButton.addActionListener((ActionListener)this);
            this._go.addButton.addActionListener((ActionListener)this);
            this._go.removeButton.addActionListener((ActionListener)this);
            this._go.setDefaultButton.addActionListener((ActionListener)this);
            this._go.unsetDefaultButton.addActionListener((ActionListener)this);
        }

        @Override
        public String getHelpID() {
            return "HELP_LOGIN_PROP_ROLES_1252";
        }

        @Override
        public void init() throws SQLException {
            ((LoginSO)this.getSO()).setRoleStatus();
            this.selections = ((LoginSO)this.getSO()).getAddRolesItems();
            this._tableModel = new JLabelTableModel(this.heading, ((LoginSO)this.getSO()).getRoles());
            this._table = new ASETable(this._tableModel);
            this._table.setDefaultRenderer(new JLabel().getClass(), new MyCellRenderer());
            this._go.rolesScrollPane.getViewport().setView(this._table);
            ((LoginSO)this.getSO()).copyHashtable();
            this._go.removeButton.setEnabled(false);
            this._go.setDefaultButton.setEnabled(false);
            this._go.unsetDefaultButton.setEnabled(false);
            this._go.propertiesButton.setEnabled(false);
            TableSelectionListener tableSelectionListener = new TableSelectionListener(){

                @Override
                public void deSelectAction() {
                    ((LoginPropRolesPage)LoginPropRolesPage.this)._go.removeButton.setEnabled(false);
                    ((LoginPropRolesPage)LoginPropRolesPage.this)._go.propertiesButton.setEnabled(false);
                }

                @Override
                public void selectAction() {
                    ((LoginPropRolesPage)LoginPropRolesPage.this)._go.removeButton.setEnabled(true);
                    ((LoginPropRolesPage)LoginPropRolesPage.this)._go.propertiesButton.setEnabled(true);
                    if (!LoginPropRolesPage.this.getConnection().hasSSORole()) {
                        ((LoginPropRolesPage)LoginPropRolesPage.this)._go.setDefaultButton.setEnabled(false);
                        ((LoginPropRolesPage)LoginPropRolesPage.this)._go.unsetDefaultButton.setEnabled(false);
                        ((LoginPropRolesPage)LoginPropRolesPage.this)._go.setDefaultButton.setToolTipText(ASEUtils.getString("MSG_ASSISTANCE_FROM_SSO"));
                        ((LoginPropRolesPage)LoginPropRolesPage.this)._go.unsetDefaultButton.setToolTipText(ASEUtils.getString("MSG_ASSISTANCE_FROM_SSO"));
                    } else if (this.isDefaultRole()) {
                        ((LoginPropRolesPage)LoginPropRolesPage.this)._go.setDefaultButton.setEnabled(false);
                        ((LoginPropRolesPage)LoginPropRolesPage.this)._go.unsetDefaultButton.setEnabled(true);
                    } else {
                        ((LoginPropRolesPage)LoginPropRolesPage.this)._go.setDefaultButton.setEnabled(true);
                        ((LoginPropRolesPage)LoginPropRolesPage.this)._go.unsetDefaultButton.setEnabled(false);
                    }
                }

                private boolean isDefaultRole() {
                    Vector vector = LoginPropRolesPage.this._tableModel.getRow(LoginPropRolesPage.this._table.getSelectedRow());
                    if (vector.size() > 1) {
                        String string = (String)vector.elementAt(1);
                        if (ASEUtils.getString("MSG_YES").equals(string)) {
                            return true;
                        }
                    }
                    return false;
                }
            };
            this._table.getSelectionModel().addListSelectionListener(tableSelectionListener);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.enableApplyButton(true);
            Object object = actionEvent.getSource();
            if (object == this._go.addButton) {
                ASEMessageText aSEMessageText = new ASEMessageText(ASEUtils.getString("MSG_ADD_ROLE_TO_LOGIN"), ((LoginSO)this.getSO()).getName());
                AddObjectDialog addObjectDialog = AddObjectDialog.getDialog(this.getJDialog(), ASEUtils.getString("MSG_ADD_ROLE_LOGIN"), aSEMessageText.toString(), this.heading, this.getTblVectorToDlgVector(this.selections), "HELP_LOGIN_DLG_ADD_ROLE_TO_LOGIN_1252");
                boolean bl = addObjectDialog.render();
                if (bl) {
                    ASETable aSETable = addObjectDialog.getDataTable();
                    int[] nArray = aSETable.getSelectedRows();
                    AbstractTableModel abstractTableModel = (AbstractTableModel)aSETable.getModel();
                    Vector vector = new Vector();
                    for (int i = 0; i < nArray.length; ++i) {
                        Vector<Object> vector2 = new Vector<Object>();
                        vector2.add(abstractTableModel.getValueAt(nArray[i], 0));
                        vector2.add(abstractTableModel.getValueAt(nArray[i], 1));
                        this.selections.remove(((JLabel)abstractTableModel.getValueAt(nArray[i], 0)).getText());
                        this._tableModel.addRow(vector2);
                        vector.addElement(vector2);
                        vector2 = null;
                    }
                    this._table.tableChanged(new TableModelEvent(this._tableModel));
                    vector = null;
                    this._go.removeButton.setEnabled(false);
                    this._go.propertiesButton.setEnabled(false);
                    this._go.setDefaultButton.setEnabled(false);
                    this._go.unsetDefaultButton.setEnabled(false);
                }
            } else if (object == this._go.removeButton) {
                int[] nArray = this._table.getSelectedRows();
                Vector<Vector> vector = new Vector<Vector>();
                for (int i = 0; i < nArray.length; ++i) {
                    Vector vector3 = this._tableModel.getRow(nArray[i]);
                    this.selections.addElement(((JLabel)vector3.elementAt(0)).getText());
                    vector.addElement(vector3);
                    this._table.tableChanged(new TableModelEvent(this._tableModel));
                }
                this._tableModel.removeRows(vector);
                vector = null;
                this._go.removeButton.setEnabled(false);
                this._go.propertiesButton.setEnabled(false);
                this._go.setDefaultButton.setEnabled(false);
                this._go.unsetDefaultButton.setEnabled(false);
            } else if (object == this._go.setDefaultButton) {
                int[] nArray = this._table.getSelectedRows();
                for (int i = 0; i < nArray.length; ++i) {
                    Vector vector = this._tableModel.getRow(nArray[i]);
                    String string = ((JLabel)vector.elementAt(0)).getText();
                    ((LoginSO)this.getSO()).alterRoleStatus(string, ASEUtils.getString("MSG_YES"));
                    this._tableModel.setValueAt(ASEUtils.getString("MSG_YES"), nArray[i], 1);
                }
                this._table.tableChanged(new TableModelEvent(this._tableModel));
                this._go.setDefaultButton.setEnabled(false);
                this._go.unsetDefaultButton.setEnabled(false);
            } else if (object == this._go.unsetDefaultButton) {
                int[] nArray = this._table.getSelectedRows();
                for (int i = 0; i < nArray.length; ++i) {
                    Vector vector = this._tableModel.getRow(nArray[i]);
                    String string = ((JLabel)vector.elementAt(0)).getText();
                    ((LoginSO)this.getSO()).alterRoleStatus(string, ASEUtils.getString("MSG_NO"));
                    this._tableModel.setValueAt(ASEUtils.getString("MSG_NO"), nArray[i], 1);
                }
                this._table.tableChanged(new TableModelEvent(this._tableModel));
                this._go.setDefaultButton.setEnabled(false);
                this._go.unsetDefaultButton.setEnabled(false);
            } else if (object == this._go.propertiesButton) {
                int[] nArray = this._table.getSelectedRows();
                LoginsCtrBO loginsCtrBO = (LoginsCtrBO)this.getParentCtr();
                ServerBO serverBO = (ServerBO)loginsCtrBO.getParent();
                for (int i = 0; i < nArray.length; ++i) {
                    String string = ((JLabel)this._tableModel.getValueAt(nArray[i], 0)).getText();
                    ContainerViewBO.openRoleProperties(serverBO, string);
                }
            }
        }

        Vector getTblVectorToDlgVector(Vector vector) {
            Vector vector2 = new Vector();
            for (int i = 0; i < vector.size(); ++i) {
                Vector<Object> vector3 = new Vector<Object>();
                vector3.addElement(new JLabel((String)vector.elementAt(i), RoleBO.ROLE_ICON, 0));
                vector3.addElement(((LoginSO)this.getSO()).getRoleStatus((String)vector.elementAt(i)));
                vector2.addElement(vector3);
            }
            return vector2;
        }

        @Override
        public boolean deploy() throws SQLException {
            String string;
            int n;
            Vector<String> vector = new Vector<String>();
            Vector vector2 = ((LoginSO)this.getSO()).getRoles();
            if (this._rolesChanged) {
                ((LoginSO)this.getSO()).setRoleStatus();
                this._rolesChanged = false;
            }
            for (int i = 0; i < vector2.size(); ++i) {
                vector.addElement(((JLabel)((Vector)vector2.elementAt(i)).elementAt(0)).getText());
            }
            Vector<String> vector3 = new Vector<String>();
            for (n = 0; n < this._tableModel.getRowCount(); ++n) {
                vector3.addElement(((JLabel)this._tableModel.getRow(n).elementAt(0)).getText());
            }
            for (n = 0; n < vector.size(); ++n) {
                string = (String)vector.elementAt(n);
                if (vector3.contains(string)) continue;
                this._rolesChanged = true;
                ((LoginSO)this.getSO()).revokeRole(string, ((LoginSO)this.getSO()).getName());
            }
            for (n = 0; n < vector3.size(); ++n) {
                string = (String)vector3.elementAt(n);
                if (vector.contains(string)) continue;
                ((LoginSO)this.getSO()).grantRole(string, ((LoginSO)this.getSO()).getName());
                if (((LoginSO)this.getSO()).getRoleStatus(string).compareTo(ASEUtils.getString("MSG_NO")) != 0) continue;
                this._rolesChanged = true;
                ((LoginSO)this.getSO()).alterRole(string, ((LoginSO)this.getSO()).getName());
            }
            for (n = 0; n < vector3.size(); ++n) {
                string = (String)vector3.elementAt(n);
                for (int i = 0; i < vector.size(); ++i) {
                    String string2 = (String)vector.elementAt(i);
                    if (!string2.equals(string) || ((LoginSO)this.getSO()).getRoleStatus(string2).equals(((LoginSO)this.getSO()).getOldRoleStatus(string2))) continue;
                    this._rolesChanged = true;
                    ((LoginSO)this.getSO()).alterRole(string2, ((LoginSO)this.getSO()).getName());
                }
            }
            return true;
        }

        @Override
        public void releaseResources() {
            this._go.propertiesButton.removeActionListener((ActionListener)this);
            this._go.addButton.removeActionListener((ActionListener)this);
            this._go.removeButton.removeActionListener((ActionListener)this);
            this._go.setDefaultButton.removeActionListener((ActionListener)this);
            this._go.unsetDefaultButton.removeActionListener((ActionListener)this);
            this._go.releaseResources();
            this._go = null;
            super.releaseResources();
        }
    }

    class LoginPropDatabasesPage
    extends ASEBasePropertiesPage2
    implements ActionListener,
    ListSelectionListener,
    MouseListener {
        private LoginPropGODatabasesPage _go;

        public LoginPropDatabasesPage(ASEBasePropertiesDialog2 aSEBasePropertiesDialog2) {
            super(aSEBasePropertiesDialog2, (JPanel)((Object)new LoginPropGODatabasesPage()), ASEUtils.getString("MSG_DATABASES_OWNED"));
            this._go = (LoginPropGODatabasesPage)((Object)this.getJPanel());
            this._go.propertiesButton.addActionListener((ActionListener)this);
            this._go.dbsMultiList.addListSelectionListener((ListSelectionListener)this);
            this._go.dbsMultiList.addMouseListener((MouseListener)this);
        }

        @Override
        public String getHelpID() {
            return "HELP_LOGIN_PROP_DATABASE_OWNED_1252";
        }

        @Override
        public void init() throws SQLException {
            LoginSO loginSO = (LoginSO)this.getSO();
            ServerBO serverBO = ContainerViewBO.getServerBO(this.getConnection());
            List list = loginSO.getDatabasesOwned();
            for (Vector vector : list) {
                String string = (String)vector.elementAt(0);
                String string2 = (String)vector.elementAt(1);
                DatabaseBO databaseBO = ContainerViewBO.getDatabaseBO(serverBO, string);
                if (databaseBO == null) continue;
                Vector<Object> vector2 = new Vector<Object>();
                vector2.add(new ASAIconTextData(databaseBO.getImage(false), string));
                vector2.add(Float.valueOf(string2));
                this._go.dbsMultiList.addRow(vector2);
            }
            this._go.propertiesButton.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == this._go.propertiesButton) {
                this.showProperties();
            }
        }

        private void showProperties() {
            int[] nArray = this._go.dbsMultiList.getSelectedRows();
            for (int i = 0; i < nArray.length; ++i) {
                String string = this._go.dbsMultiList.getStringAt(nArray[i], 0);
                ServerBO serverBO = ContainerViewBO.getServerBO(this.getConnection());
                ContainerViewBO.openDatabaseProperties(serverBO, string);
            }
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            boolean bl = this._go.dbsMultiList.getSelectedRowCount() > 0;
            this._go.propertiesButton.setEnabled(bl);
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getClickCount() > 1) {
                this.showProperties();
            }
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
        }

        @Override
        public void releaseResources() {
            if (this._go != null) {
                this._go.propertiesButton.removeActionListener((ActionListener)this);
                this._go.propertiesButton.removeActionListener((ActionListener)this);
                this._go.dbsMultiList.removeListSelectionListener((ListSelectionListener)this);
                this._go.releaseResources();
                this._go = null;
            }
            super.releaseResources();
        }
    }

    class LoginPropParamsPage
    extends ASEBasePropDocPage
    implements ActionListener,
    ASASpinBoxChangeListener {
        private LoginPropGOParamsPage _go;
        private int _minLoginPasswordLength;
        private int _psexpire;
        private int _failedlogin;

        public LoginPropParamsPage(ASEBasePropertiesDialog2 aSEBasePropertiesDialog2) {
            super(aSEBasePropertiesDialog2, (JPanel)((Object)new LoginPropGOParamsPage()), ASEUtils.getString("MSG_PARAMETERS"));
            this._go = (LoginPropGOParamsPage)((Object)this.getJPanel());
            this._go.lockUnlockAccountButton.addActionListener((ActionListener)this);
            this._go.changePasswordButton.addActionListener((ActionListener)this);
            this._go.expirePasswordButton.addActionListener((ActionListener)this);
            this._go.maxFailedLoginsSpinBox.addSpinBoxChangeListener(this);
            this._go.minPasswordLengthSpinBox.addSpinBoxChangeListener(this);
            this._go.passwordExpirationSpinBox.addSpinBoxChangeListener(this);
        }

        @Override
        public String getHelpID() {
            return "HELP_LOGIN_PROP_PARAMETERS_1252";
        }

        @Override
        public void init() throws SQLException {
            this._minLoginPasswordLength = ((LoginSO)this.getSO()).getMinLoginPasswordLength();
            this._go.minPasswordLengthSpinBox.setValue(this._minLoginPasswordLength);
            this._go.accountLockedTextLabel.setText(((LoginSO)this.getSO()).getLockStatusYesNo());
            this.setLockUnlock(((LoginSO)this.getSO()).getLockStatus());
            this.enableExpireComponents();
            this._go.cpuTimeTextLabel.setText(((LoginSO)this.getSO()).getCPUTime());
            this._go.ioTimeTextLabel.setText(((LoginSO)this.getSO()).getIOTime());
            this._psexpire = ((LoginSO)this.getSO()).getPasswordExpireDays();
            this._go.passwordExpirationSpinBox.setValue(this._psexpire);
            this._failedlogin = ((LoginSO)this.getSO()).getMaxFailedLogins();
            this._go.maxFailedLoginsSpinBox.setValue(this._failedlogin);
        }

        private void setLockUnlock(boolean bl) {
            this._go.lockUnlockAccountButton.setText(bl ? ASEUtils.getString("LOGIN_PROP_LABC_ACCOUNT_UNLOCK") : ASEUtils.getString("LOGIN_PROP_LABC_ACCOUNT_LOCK"));
            this._go.lockUnlockAccountButton.setMnemonic(ASEUtils.getMnemonic("LOGIN_PROP_MNEM_ACCOUNT_LOCKED"));
        }

        private void enableExpireComponents() {
            try {
                this._go.passwordExpiredTextLabel.setText(((LoginSO)this.getSO()).getPasswordExpired());
            }
            catch (Exception exception) {
                Support.showDetailsError(this.getConnection(), this.getClass(), (Container)this.getJDialog(), exception.toString(), exception);
            }
            this._go.passwordLastSetTextLabel.setText(((LoginSO)this.getSO()).getLastSet());
            this._go.invalidPasswordTextLabel.setText(((LoginSO)this.getSO()).getPasswordNull());
            boolean bl = this.getConnection().getVersion().compareTo("15.0.2") >= 0 && !((LoginSO)this.getSO()).isPasswordExpired();
            this._go.expirePasswordButton.setVisible(bl);
        }

        public void valueChanged(ASASpinBoxChangeEvent aSASpinBoxChangeEvent) {
            this.activateApply();
        }

        public void activateApply() {
            boolean bl = this._minLoginPasswordLength != this._go.minPasswordLengthSpinBox.getValue() || this._psexpire != this._go.passwordExpirationSpinBox.getValue() || this._failedlogin != this._go.maxFailedLoginsSpinBox.getValue();
            this.enableApplyButton(bl);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == this._go.changePasswordButton) {
                ChangePasswordDialog changePasswordDialog = new ChangePasswordDialog(Support.createDialogSupport(this.getParent().getJDialog()), ASEUtils.getString("CHANGE_PASSWORD_FOR") + " ", (LoginSO)this.getSO(), this._minLoginPasswordLength);
                changePasswordDialog.start(ContainerViewBO.getLatestBO((LoginsCtrBO)this.getParentCtr(), ((LoginSO)this.getSO()).getName()));
            } else if (object == this._go.expirePasswordButton) {
                boolean bl;
                ASEMessageText aSEMessageText = new ASEMessageText(ASEUtils.getString("MSG_PROP_BTTN_EXPIRE_PASSWORD_CONFIRM"), ((LoginSO)this.getSO()).getName());
                boolean bl2 = bl = Support.showQuestionYesNo(this.getJDialog(), aSEMessageText.toString()) == 0;
                if (bl) {
                    try {
                        ((LoginSO)this.getSO()).expireLoginPasswords();
                        ((LoginSO)this.getSO()).updateColumns();
                        this.enableExpireComponents();
                    }
                    catch (SQLException sQLException) {
                        Support.showDetailsError(this.getConnection(), this.getClass(), (Container)this.getJDialog(), sQLException.toString(), sQLException);
                    }
                }
            } else if (object == this._go.lockUnlockAccountButton) {
                boolean bl;
                boolean bl3 = ((LoginSO)this.getSO()).getLockStatus();
                ASEMessageText aSEMessageText = new ASEMessageText(ASEUtils.getString(bl3 ? "MSG_LOGIN_PROP_UNLOCK_ACCOUNT_CONFIRM" : "MSG_LOGIN_PROP_LOCK_ACCOUNT_CONFIRM"), ((LoginSO)this.getSO()).getName());
                boolean bl4 = bl = Support.showQuestionYesNo(this.getJDialog(), aSEMessageText.toString()) == 0;
                if (bl) {
                    try {
                        ((LoginSO)this.getSO()).modifyLockStatus(!bl3);
                        this._go.accountLockedTextLabel.setText(((LoginSO)this.getSO()).getLockStatusYesNo());
                        this.setLockUnlock(!bl3);
                        ((LoginsCtrBO)this.getParentCtr()).refresh();
                    }
                    catch (SQLException sQLException) {
                        Support.showDetailsError(this.getConnection(), this.getClass(), (Container)this.getJDialog(), sQLException.toString(), sQLException);
                    }
                }
            } else {
                this.activateApply();
            }
        }

        @Override
        public boolean deploy() throws SQLException {
            if (this._minLoginPasswordLength != this._go.minPasswordLengthSpinBox.getValue()) {
                ((LoginSO)this.getSO()).setMinLoginPasswordLength(this._go.minPasswordLengthSpinBox.getValue());
            }
            if (this._psexpire != this._go.passwordExpirationSpinBox.getValue()) {
                ((LoginSO)this.getSO()).setPasswordExpireDays(this._go.passwordExpirationSpinBox.getValue());
            }
            if (this._failedlogin != this._go.maxFailedLoginsSpinBox.getValue()) {
                ((LoginSO)this.getSO()).setMaxFailedLogins(this._go.maxFailedLoginsSpinBox.getValue());
            }
            return true;
        }

        @Override
        public void releaseResources() {
            this._go.lockUnlockAccountButton.removeActionListener((ActionListener)this);
            this._go.changePasswordButton.removeActionListener((ActionListener)this);
            this._go.expirePasswordButton.removeActionListener((ActionListener)this);
            this._go.maxFailedLoginsSpinBox.removeSpinBoxChangeListener(this);
            this._go.minPasswordLengthSpinBox.removeSpinBoxChangeListener(this);
            this._go.passwordExpirationSpinBox.removeSpinBoxChangeListener(this);
            this._go.releaseResources();
            this._go = null;
            super.releaseResources();
        }
    }

    class LoginPropGeneralPage
    extends ASEBasePropDocPage
    implements ActionListener {
        private LoginPropGOGeneralPage _go;
        private String _tempDBName;

        public LoginPropGeneralPage(ASEBasePropertiesDialog2 aSEBasePropertiesDialog2) {
            super(aSEBasePropertiesDialog2, (JPanel)((Object)new LoginPropGOGeneralPage()), ASEUtils.getString("MSG_GENERAL"));
            this._tempDBName = "";
            this._go = (LoginPropGOGeneralPage)((Object)this.getJPanel());
            this._go.tempdbComboBox.setEnabled(false);
            this._go.groupComboBox.setEnabled(false);
            this._go.groupRadioButton.addActionListener((ActionListener)this);
            this._go.tempdbRadioButton.addActionListener((ActionListener)this);
            this._go.tempdbBindingCheckBox.addActionListener((ActionListener)this);
        }

        @Override
        public String getHelpID() {
            return "HELP_LOGIN_PROP_GENERAL_1252";
        }

        @Override
        public void init() throws SQLException {
            this._go.nameTextLabel.setText(((LoginSO)this.getSO()).getName());
            this._go.fullNameTextField.setText(((LoginSO)this.getSO()).getFullName());
            if (!((LoginSO)this.getSO()).getName().equals("sa") && ((LoginSO)this.getSO()).getConnection().getVersion().equals("12.5.0.3") || ((LoginSO)this.getSO()).getConnection().getVersion().compareTo("12.5.0.3") < 0) {
                this._go.tempdbBindingCheckBox.setVisible(false);
                this._go.groupComboBox.setVisible(false);
                this._go.tempdbComboBox.setVisible(false);
                this._go.groupRadioButton.setVisible(false);
                this._go.tempdbRadioButton.setVisible(false);
            } else {
                this.setTempDBBindings();
            }
            LoginsCtrBO loginsCtrBO = (LoginsCtrBO)this.getParentCtr();
            boolean bl = loginsCtrBO.isLastLoginEnabled();
            this._go.lastLoginLabel.setVisible(bl);
            this._go.lastLoginTextLabel.setVisible(bl);
            if (bl) {
                this._go.lastLoginTextLabel.setText(((LoginSO)this.getSO()).getLastLoginDate());
            }
            if (((LoginSO)this.getSO()).isPAMSupportApplicable()) {
                this._go.authenticationLabel.setVisible(true);
                this._go.authenticationComboBox.setVisible(true);
                this.setAvailableAuthentications();
            }
            this.setAvailableLanguages();
            int n = this._go.defaultLanguageComboBox.findItem(((LoginSO)this.getSO()).getDefaultLanguage());
            this._go.defaultLanguageComboBox.setSelectedIndex(n);
            this.setAvailableDatabases();
            n = this._go.defaultDatabaseComboBox.findItem(((LoginSO)this.getSO()).getDefaultDatabase());
            this._go.defaultDatabaseComboBox.setSelectedIndex(n);
            this._go.fullNameTextField.getDocument().addDocumentListener(this);
            this._go.defaultDatabaseComboBox.addActionListener((ActionListener)this);
            this._go.defaultLanguageComboBox.addActionListener((ActionListener)this);
            this._go.groupComboBox.addActionListener((ActionListener)this);
            this._go.tempdbComboBox.addActionListener((ActionListener)this);
            this._go.authenticationComboBox.addActionListener((ActionListener)this);
        }

        private void setAvailableAuthentications() throws SQLException {
            int n;
            Vector vector = ((LoginSO)this.getSO()).getAvailableAuthentications();
            this._go.authenticationComboBox.clear();
            for (n = 0; n < vector.size(); ++n) {
                this._go.authenticationComboBox.addItem(vector.elementAt(n));
            }
            n = this._go.authenticationComboBox.findItem(((LoginSO)this.getSO()).getAuthMechanism());
            this._go.authenticationComboBox.setSelectedIndex(n);
        }

        private void setTempDBBindings() throws SQLException {
            Vector vector = ((LoginSO)this.getSO()).getTempDBs();
            this._go.groupComboBox.clear();
            this._go.tempdbComboBox.clear();
            this._go.tempdbBindingCheckBox.setSelected(false);
            this._go.groupComboBox.addItem((Object)"Null");
            if (((LoginSO)this.getSO()).isTempDBGroupApplicable()) {
                this._go.groupComboBox.addItem((Object)"default");
            }
            this._go.tempdbComboBox.addItem((Object)"Null");
            for (int i = 0; i < vector.size(); ++i) {
                this._go.tempdbComboBox.addItem(vector.elementAt(i));
            }
            this._tempDBName = ((LoginSO)this.getSO()).getTempDBBinding();
            if (this._tempDBName.equals("default")) {
                this._go.groupRadioButton.setSelected(true);
                this._go.groupComboBox.setEnabled(true);
                this._go.groupComboBox.setSelectedItem(this._tempDBName);
                this._go.tempdbBindingCheckBox.setSelected(true);
            } else if (!this._tempDBName.equals("")) {
                this._go.tempdbRadioButton.setSelected(true);
                this._go.tempdbComboBox.setEnabled(true);
                this._go.tempdbComboBox.setSelectedItem(this._tempDBName);
                this._go.tempdbBindingCheckBox.setSelected(true);
            } else {
                this._go.groupRadioButton.setEnabled(false);
                this._go.tempdbRadioButton.setEnabled(false);
                this._go.tempdbComboBox.setEnabled(false);
                this._go.groupComboBox.setEnabled(false);
            }
        }

        private void setAvailableDatabases() throws SQLException {
            List list = ((LoginSO)this.getSO()).getAvailableDatabases();
            this._go.defaultDatabaseComboBox.clear();
            for (DatabaseSO databaseSO : list) {
                if (databaseSO.isSDCLocalTempDB()) continue;
                ASAIconTextData aSAIconTextData = new ASAIconTextData((Icon)DatabaseBO.getIcon(databaseSO), databaseSO.getName());
                this._go.defaultDatabaseComboBox.addItem((Object)aSAIconTextData);
            }
        }

        private void setAvailableLanguages() throws SQLException {
            String[] stringArray = ((LoginSO)this.getSO()).getAvailableLanguages();
            this._go.defaultLanguageComboBox.clear();
            ImageIcon imageIcon = new ImageIcon(ASEImages.getFolderClosedImage());
            for (int i = 0; i < stringArray.length; ++i) {
                ASAIconTextData aSAIconTextData = new ASAIconTextData((Icon)imageIcon, stringArray[i]);
                this._go.defaultLanguageComboBox.addItem((Object)aSAIconTextData);
            }
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == this._go.groupRadioButton) {
                this._go.groupComboBox.setEnabled(true);
                this._go.tempdbComboBox.setEnabled(false);
            } else if (object == this._go.tempdbRadioButton) {
                this._go.tempdbComboBox.setEnabled(true);
                this._go.groupComboBox.setEnabled(false);
            } else if (object == this._go.tempdbBindingCheckBox) {
                if (this._go.tempdbBindingCheckBox.isSelected()) {
                    this._go.groupRadioButton.setEnabled(true);
                    this._go.tempdbRadioButton.setEnabled(true);
                    this._go.groupRadioButton.setSelected(true);
                    this._go.groupComboBox.setEnabled(true);
                } else {
                    this._go.groupRadioButton.setEnabled(false);
                    this._go.tempdbRadioButton.setEnabled(false);
                    this._go.groupComboBox.setEnabled(false);
                    this._go.tempdbComboBox.setEnabled(false);
                }
            } else {
                this.shouldApplyOn();
            }
        }

        private void shouldApplyOn() {
            if (!((LoginSO)this.getSO()).getFullName().equals(this._go.fullNameTextField.getText())) {
                this.enableApplyButton(true);
                return;
            }
            if (!((LoginSO)this.getSO()).getDefaultLanguage().equals(this._go.defaultLanguageComboBox.getSelectedItem())) {
                this.enableApplyButton(true);
                return;
            }
            if (!((LoginSO)this.getSO()).getDefaultDatabase().equals(this._go.defaultDatabaseComboBox.getSelectedItem())) {
                this.enableApplyButton(true);
                return;
            }
            if (this._go.tempdbComboBox.isEnabled() && !this._tempDBName.equals(this._go.tempdbComboBox.getSelectedItem())) {
                this.enableApplyButton(true);
                return;
            }
            if (this._go.groupComboBox.isEnabled() && !this._tempDBName.equals(this._go.groupComboBox.getSelectedItem())) {
                this.enableApplyButton(true);
                return;
            }
            if (this._go.authenticationComboBox.isVisible() && !((LoginSO)this.getSO()).getAuthMechanism().equals(this._go.authenticationComboBox.getSelectedItem())) {
                this.enableApplyButton(true);
                return;
            }
        }

        @Override
        public boolean deploy() throws SQLException {
            if (((LoginSO)this.getSO()).getFullName().compareTo(this._go.fullNameTextField.getText()) != 0) {
                ((LoginSO)this.getSO()).modifyFullName(this._go.fullNameTextField.getText());
            }
            if (((LoginSO)this.getSO()).getDefaultLanguage().compareTo(this._go.defaultLanguageComboBox.getSelectedItem().toString()) != 0) {
                ((LoginSO)this.getSO()).modifyLang(this._go.defaultLanguageComboBox.getSelectedItem().toString());
            }
            if (((LoginSO)this.getSO()).getDefaultDatabase().compareTo(this._go.defaultDatabaseComboBox.getSelectedItem().toString()) != 0) {
                ((LoginSO)this.getSO()).modifyDB(this._go.defaultDatabaseComboBox.getSelectedItem().toString());
            }
            if (this._go.groupComboBox.isEnabled()) {
                ((LoginSO)this.getSO()).setTempDBBinding((String)this._go.groupComboBox.getSelectedItem());
            } else if (this._go.tempdbComboBox.isEnabled()) {
                ((LoginSO)this.getSO()).setTempDBBinding((String)this._go.tempdbComboBox.getSelectedItem());
            }
            if (this._go.authenticationComboBox.isVisible() && ((LoginSO)this.getSO()).getAuthMechanism().compareTo(this._go.authenticationComboBox.getSelectedItem().toString()) != 0) {
                ((LoginSO)this.getSO()).alterAuthMechanism(this._go.authenticationComboBox.getSelectedItem().toString());
            }
            return true;
        }

        @Override
        public void releaseResources() {
            this._go.groupRadioButton.removeActionListener((ActionListener)this);
            this._go.tempdbRadioButton.removeActionListener((ActionListener)this);
            this._go.tempdbBindingCheckBox.removeActionListener((ActionListener)this);
            this._go.releaseResources();
            this._go = null;
            super.releaseResources();
        }
    }
}

