/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.aseplugin.bo.prop;

import com.sybase.asa.ASAListCheckEvent;
import com.sybase.asa.ASAListCheckListener;
import com.sybase.asa.ASASpinBoxChangeEvent;
import com.sybase.asa.ASASpinBoxChangeListener;
import com.sybase.aseplugin.ASEUtils;
import com.sybase.aseplugin.bo.ContainerViewBO;
import com.sybase.aseplugin.bo.ServerBO;
import com.sybase.aseplugin.bo.Support;
import com.sybase.aseplugin.bo.prop.ASEBasePropDocPage;
import com.sybase.aseplugin.bo.prop.ASEBasePropertiesDialog2;
import com.sybase.aseplugin.bo.prop.ASEBasePropertiesPage2;
import com.sybase.aseplugin.bo.prop.CalendarHelper;
import com.sybase.aseplugin.go.prop.LoginConfigPasswordPropGOMiscPage;
import com.sybase.aseplugin.go.prop.LoginConfigPasswordPropGOOptionsPage;
import com.sybase.aseplugin.go.prop.LoginRoleConfigPasswordPropGOExpirationPage;
import com.sybase.aseplugin.so.LoginSO;
import com.sybase.aseplugin.so.LoginsCtrSO;
import com.sybase.aseplugin.so.PasswordConfigDataSO;
import com.sybase.aseplugin.so.PasswordConfigSO;
import com.sybase.aseplugin.so.RoleSO;
import com.sybase.aseplugin.so.RolesCtrSO;
import com.sybase.aseplugin.so.SOItemInterface;
import com.sybase.aseplugin.so.ServerSO;
import com.sybase.aseplugin.sql.ASConnection;
import com.sybase.aseplugin.util.ui.TableSelectionListener;
import com.sybase.central.SCContainer2;
import com.sybase.central.SCPageController;
import com.sybase.util.ds.ui.NumericsOnlyDocument;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import javax.swing.DefaultCellEditor;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.TableColumn;
import javax.swing.text.Document;

public class PasswordConfigProperties
extends ASEBasePropertiesDialog2 {
    private PasswordConfigDataSO _cpSO;
    private boolean _forLogins;

    public PasswordConfigProperties(PasswordConfigDataSO passwordConfigDataSO, SCContainer2 sCContainer2, boolean bl) {
        super((SOItemInterface)passwordConfigDataSO, sCContainer2);
        this._cpSO = passwordConfigDataSO;
        this._forLogins = bl;
    }

    @Override
    public SCPageController[] getPages() {
        if (this._forLogins) {
            if (this.getConnection().getVersion().compareTo("15.0.2") >= 0) {
                return new SCPageController[]{new LoginConfigPasswordOptionsPage(this, this._cpSO), new LoginRoleConfigPasswordExpirationPage(this, this._cpSO), new LoginConfigPasswordMiscPage(this, this._cpSO)};
            }
            return new SCPageController[]{new LoginConfigPasswordOptionsPage(this, this._cpSO)};
        }
        return new SCPageController[]{new LoginRoleConfigPasswordExpirationPage(this, this._cpSO)};
    }

    @Override
    public String getTitle() {
        if (this._forLogins) {
            return ASEUtils.getString("MSG_LOGIN_PASSWORD_CONFIGURATION_DLG_TITLE");
        }
        return ASEUtils.getString("MSG_ROLE_PASSWORD_CONFIGURATION_DLG_TITLE");
    }

    public static ASEBasePropertiesDialog2 getPropertiesDialog(ASConnection aSConnection, boolean bl) {
        PasswordConfigDataSO passwordConfigDataSO = new PasswordConfigDataSO(aSConnection, bl);
        return new PasswordConfigProperties(passwordConfigDataSO, null, bl);
    }

    class LoginConfigPasswordMiscPage
    extends ASEBasePropertiesPage2
    implements ActionListener,
    ASASpinBoxChangeListener {
        private LoginConfigPasswordPropGOMiscPage _go;
        private PasswordConfigDataSO _so;

        public LoginConfigPasswordMiscPage(ASEBasePropertiesDialog2 aSEBasePropertiesDialog2, PasswordConfigDataSO passwordConfigDataSO) {
            super(aSEBasePropertiesDialog2, (JPanel)((Object)new LoginConfigPasswordPropGOMiscPage()), ASEUtils.getString("LABC_LOGIN_PASSWORD_MISC"));
            this._so = passwordConfigDataSO;
            this._go = (LoginConfigPasswordPropGOMiscPage)((Object)this.getJPanel());
            this._go.endDowngradeButton.addActionListener((ActionListener)this);
            this._go.lockLoginsCheckBox.addActionListener((ActionListener)this);
            this._go.daysSpinBox.addSpinBoxChangeListener(this);
        }

        @Override
        public String getHelpID() {
            return "HELP_LOGIN_PWD_PROP_MISCELLANEOUS_1502";
        }

        @Override
        public void init() throws SQLException {
            this.enableDaysComponent();
            this.enableComponents();
            boolean bl = this._so.allowPasswordDowngrade();
            this.enableDowngradeComponents(bl);
        }

        private void enableDowngradeComponents(boolean bl) {
            this._go.separator.setVisible(bl);
            this._go.endDowngradeMultiLineLabel.setVisible(bl);
            this._go.endDowngradeButton.setVisible(bl);
        }

        @Override
        public void enableComponents() {
            boolean bl = this._go.lockLoginsCheckBox.isSelected();
            this.enableApplyButton(bl);
            boolean bl2 = this._so.isLastLoginEnabled();
            this._go.lockLoginsCheckBox.setEnabled(bl2);
            this._go.disbledLabel.setVisible(!bl2);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == this._go.lockLoginsCheckBox) {
                this.enableDaysComponent();
            } else if (object == this._go.endDowngradeButton) {
                boolean bl;
                boolean bl2 = bl = Support.showQuestionYesNo(this.getJDialog(), ASEUtils.getString("MSG_LOGIN_PASSWORD_MISC_END_DOWNGRADE_CONFIRM")) == 0;
                if (bl) {
                    try {
                        this._so.endPasswordDowngrade();
                        this.enableDowngradeComponents(false);
                    }
                    catch (SQLException sQLException) {
                        Support.showDetailsError(this.getConnection(), this.getClass(), (Container)this.getJDialog(), sQLException.toString(), sQLException);
                    }
                }
            }
            this.enableComponents();
        }

        public void valueChanged(ASASpinBoxChangeEvent aSASpinBoxChangeEvent) {
            this.enableApplyButton(true);
        }

        private void enableDaysComponent() {
            boolean bl = this._go.lockLoginsCheckBox.isSelected();
            this._go.daysSpinBox.setEnabled(bl);
        }

        @Override
        public boolean deploy() throws SQLException {
            if (this._go.lockLoginsCheckBox.isSelected()) {
                int n = this._go.daysSpinBox.getValue();
                this._so.lockInactiveLogins(n);
            }
            return true;
        }

        @Override
        public void releaseResources() {
            this._go.lockLoginsCheckBox.removeActionListener((ActionListener)this);
            this._go.endDowngradeButton.removeActionListener((ActionListener)this);
            this._go.daysSpinBox.removeSpinBoxChangeListener(this);
            this._go.releaseResources();
            this._go = null;
            super.releaseResources();
        }
    }

    class LoginRoleConfigPasswordExpirationPage
    extends ASEBasePropDocPage
    implements ActionListener {
        private LoginRoleConfigPasswordPropGOExpirationPage _go;
        private PasswordConfigDataSO _so;

        public LoginRoleConfigPasswordExpirationPage(ASEBasePropertiesDialog2 aSEBasePropertiesDialog2, PasswordConfigDataSO passwordConfigDataSO) {
            super(aSEBasePropertiesDialog2, (JPanel)((Object)new LoginRoleConfigPasswordPropGOExpirationPage(PasswordConfigProperties.this._forLogins)), ASEUtils.getString("LABC_LOGIN_PASSWORD_EXPIRATION"));
            this._so = passwordConfigDataSO;
            this._go = (LoginRoleConfigPasswordPropGOExpirationPage)((Object)this.getJPanel());
            this.setExpirePwdByNameEnabled(true);
            this.setExpirePwdByLoginRoleEnabled(true);
            this.initDateComboLists();
        }

        @Override
        public void init() throws SQLException, Exception {
            this._go.expirePasswordRadioButton.removeActionListener((ActionListener)this);
            this._go.expireByDateRadioButton.removeActionListener((ActionListener)this);
            this._go.expireByLoginRoleRadioButton.removeActionListener((ActionListener)this);
            this._go.expireByPatternRadioButton.removeActionListener((ActionListener)this);
            this._go.patternTextField.getDocument().removeDocumentListener(this);
            this._go.loginRolesComboBox.removeActionListener((ActionListener)this);
            this._go.monthsComboBox.removeActionListener((ActionListener)this);
            this._go.yearsSpinBox.getTextField().getDocument().removeDocumentListener(this);
            if (PasswordConfigProperties.this._forLogins) {
                this.fillLoginsComboList();
            } else {
                this.fillRolesComboList();
            }
            this._go.expirePasswordRadioButton.addActionListener((ActionListener)this);
            this._go.expireByDateRadioButton.addActionListener((ActionListener)this);
            this._go.expireByLoginRoleRadioButton.addActionListener((ActionListener)this);
            this._go.expireByPatternRadioButton.addActionListener((ActionListener)this);
            this._go.patternTextField.getDocument().addDocumentListener(this);
            this._go.loginRolesComboBox.addActionListener((ActionListener)this);
            this._go.monthsComboBox.addActionListener((ActionListener)this);
            this._go.yearsSpinBox.getTextField().getDocument().addDocumentListener(this);
        }

        @Override
        public void textValueChanged(DocumentEvent documentEvent) {
            this.enableComponents();
            Document document = documentEvent.getDocument();
            Document document2 = this._go.yearsSpinBox.getTextField().getDocument();
            if (document == document2) {
                this.updateDateComboLists();
            }
        }

        @Override
        public void enableComponents() {
            boolean bl = this._go.expirePasswordRadioButton.isSelected() && this._go.expireByPatternRadioButton.isSelected() && this._go.patternTextField.getText().trim().length() == 0;
            String string = this._go.loginRolesComboBox.getSelectedString();
            bl = bl || this._go.expirePasswordRadioButton.isSelected() && this._go.expireByLoginRoleRadioButton.isSelected() && (string == null || string.trim().length() == 0);
            this.enableApplyButton(!bl);
        }

        private void fillLoginsComboList() throws SQLException {
            LoginsCtrSO loginsCtrSO = new LoginsCtrSO(this.getConnection());
            List list = loginsCtrSO.open(1, null);
            this._go.loginRolesComboBox.removeAllItems();
            for (LoginSO loginSO : list) {
                if (loginSO.isPasswordExpired()) continue;
                this._go.loginRolesComboBox.addItem((Object)loginSO.getName());
            }
            this._go.loginRolesComboBox.setSelectedIndex(-1);
        }

        private void fillRolesComboList() throws Exception {
            ServerBO serverBO = ContainerViewBO.getServerBO(this._so.getConnection());
            RolesCtrSO rolesCtrSO = new RolesCtrSO(this.getConnection(), (ServerSO)serverBO.getSO());
            List list = rolesCtrSO.open(1, null);
            this._go.loginRolesComboBox.removeAllItems();
            for (RoleSO roleSO : list) {
                if (!roleSO.isPwdRequired() || roleSO.isPasswordExpired()) continue;
                this._go.loginRolesComboBox.addItem((Object)roleSO.getName());
            }
            this._go.loginRolesComboBox.setSelectedIndex(-1);
        }

        private void initDateComboLists() {
            int n = Calendar.getInstance().get(1);
            int n2 = Calendar.getInstance().get(2) + 1;
            this.setDateComboLists(n, n2, -1);
        }

        private void updateDateComboLists() {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (Thread.currentThread().isAlive()) {
                        int n = ((LoginRoleConfigPasswordExpirationPage)LoginRoleConfigPasswordExpirationPage.this)._go.yearsSpinBox.getValue();
                        String string = ((LoginRoleConfigPasswordExpirationPage)LoginRoleConfigPasswordExpirationPage.this)._go.monthsComboBox.getSelectedString();
                        int n2 = Integer.valueOf(string);
                        String string2 = ((LoginRoleConfigPasswordExpirationPage)LoginRoleConfigPasswordExpirationPage.this)._go.daysComboBox.getSelectedString();
                        int n3 = Integer.valueOf(string2);
                        LoginRoleConfigPasswordExpirationPage.this.setDateComboLists(n, n2, n3);
                    }
                }
            });
        }

        private synchronized void setDateComboLists(int n, int n2, int n3) {
            int n4;
            this._go.yearsSpinBox.getTextField().getDocument().removeDocumentListener(this);
            this._go.monthsComboBox.removeActionListener((ActionListener)this);
            this._go.monthsComboBox.removeActionListener((ActionListener)this);
            this._go.monthsComboBox.removeAllItems();
            for (n4 = 1; n4 <= 12; ++n4) {
                this._go.monthsComboBox.addItem((Object)String.valueOf(n4));
            }
            this._go.monthsComboBox.setSelectedIndex(n2 - 1);
            this._go.daysComboBox.removeAllItems();
            n4 = CalendarHelper.getDaysOfMonth(n2, n);
            for (int i = 1; i <= n4; ++i) {
                this._go.daysComboBox.addItem((Object)String.valueOf(i));
            }
            if (n3 == -1) {
                this._go.daysComboBox.setSelectedIndex(Calendar.getInstance().get(5) - 1);
            } else {
                if (n3 > n4) {
                    n3 = n4;
                }
                this._go.daysComboBox.setSelectedIndex(n3 - 1);
            }
            this._go.monthsComboBox.addActionListener((ActionListener)this);
            this._go.yearsSpinBox.getTextField().getDocument().addDocumentListener(this);
        }

        @Override
        public String getHelpID() {
            if (PasswordConfigProperties.this._forLogins) {
                return "HELP_LOGIN_PWD_PROP_EXPIRATION_1502";
            }
            return "HELP_ROLES_PWD_PROP_OPTIONS_1502";
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == this._go.expirePasswordRadioButton) {
                this.setExpirePwdByNameEnabled(true);
            } else if (object == this._go.expireByDateRadioButton) {
                this.setExpirePwdByNameEnabled(false);
                this._go.monthsComboBox.requestFocus();
            } else if (object == this._go.expireByLoginRoleRadioButton) {
                this.setExpirePwdByLoginRoleEnabled(true);
            } else if (object == this._go.expireByPatternRadioButton) {
                this.setExpirePwdByLoginRoleEnabled(false);
            } else if (object == this._go.monthsComboBox) {
                this.updateDateComboLists();
            }
            this.enableComponents();
        }

        private void setExpirePwdByNameEnabled(boolean bl) {
            this._go.expireByLoginRoleRadioButton.setEnabled(bl);
            this._go.loginRolesComboBox.setEnabled(bl);
            this._go.expireByPatternRadioButton.setEnabled(bl);
            this._go.patternTextField.setEnabled(bl);
            if (bl) {
                boolean bl2 = this._go.expireByLoginRoleRadioButton.isSelected();
                this.setExpirePwdByLoginRoleEnabled(bl2);
            }
            this._go.monthsComboBox.setEnabled(!bl);
            this._go.daysComboBox.setEnabled(!bl);
            this._go.yearsSpinBox.setEnabled(!bl);
        }

        private void setExpirePwdByLoginRoleEnabled(boolean bl) {
            this._go.loginRolesComboBox.setEnabled(bl);
            this._go.patternTextField.setEnabled(!bl);
            if (bl) {
                this._go.loginRolesComboBox.requestFocus();
            } else {
                this._go.patternTextField.requestFocus();
                this._go.patternTextField.selectAll();
            }
        }

        @Override
        public boolean deploy() throws SQLException, Exception {
            boolean bl;
            boolean bl2 = bl = Support.getEnableSQLPreview() && !Support.isSQLPreviewDlgShowing();
            if (this._go.expirePasswordRadioButton.isSelected()) {
                if (this._go.expireByLoginRoleRadioButton.isSelected()) {
                    String string = this._go.loginRolesComboBox.getSelectedString();
                    if (PasswordConfigProperties.this._forLogins) {
                        this._so.expireLoginPasswords(string);
                        if (!bl) {
                            this.fillLoginsComboList();
                        }
                    } else {
                        this._so.expireRolePasswords(string);
                        if (!bl) {
                            this.fillRolesComboList();
                        }
                    }
                } else {
                    String string = this._go.patternTextField.getText();
                    if (PasswordConfigProperties.this._forLogins) {
                        this._so.expireLoginPasswords(string);
                        if (!bl) {
                            this.fillLoginsComboList();
                        }
                    } else {
                        this._so.expireRolePasswords(string);
                        if (!bl) {
                            this.fillRolesComboList();
                        }
                    }
                }
            } else {
                String string = this.getDateTime();
                if (PasswordConfigProperties.this._forLogins) {
                    this._so.expireStaleLoginPasswords(string);
                } else {
                    this._so.expireStaleRolePasswords(string);
                }
            }
            return true;
        }

        private String getDateTime() {
            String string;
            String string2 = this._go.monthsComboBox.getSelectedString();
            if (string2.length() < 2) {
                string2 = "0" + string2;
            }
            if ((string = this._go.daysComboBox.getSelectedString()).length() < 2) {
                string = "0" + string;
            }
            int n = this._go.yearsSpinBox.getValue();
            return n + string2 + string;
        }

        @Override
        public void releaseResources() {
            this._go.expirePasswordRadioButton.removeActionListener((ActionListener)this);
            this._go.expireByDateRadioButton.removeActionListener((ActionListener)this);
            this._go.expireByLoginRoleRadioButton.removeActionListener((ActionListener)this);
            this._go.expireByPatternRadioButton.removeActionListener((ActionListener)this);
            this._go.patternTextField.getDocument().removeDocumentListener(this);
            this._go.loginRolesComboBox.removeActionListener((ActionListener)this);
            this._go.yearsSpinBox.getTextField().getDocument().removeDocumentListener(this);
            this._go.monthsComboBox.removeActionListener((ActionListener)this);
            this._go.releaseResources();
            this._go = null;
            super.releaseResources();
        }
    }

    class LoginConfigPasswordOptionsPage
    extends ASEBasePropertiesPage2
    implements DocumentListener,
    ASAListCheckListener {
        private LoginConfigPasswordPropGOOptionsPage _go;
        private PasswordConfigDataSO _so;
        private Vector _currentDisplayedData;
        private Vector _numericsOnlyDocuments;
        private int _curSelectedRow;

        public LoginConfigPasswordOptionsPage(ASEBasePropertiesDialog2 aSEBasePropertiesDialog2, PasswordConfigDataSO passwordConfigDataSO) {
            super(aSEBasePropertiesDialog2, (JPanel)((Object)new LoginConfigPasswordPropGOOptionsPage()), ASEUtils.getString("LABC_LOGIN_PASSWORD_OPTIONS"));
            this._currentDisplayedData = new Vector();
            this._numericsOnlyDocuments = new Vector();
            this._so = passwordConfigDataSO;
            this._go = (LoginConfigPasswordPropGOOptionsPage)((Object)this.getJPanel());
            this._curSelectedRow = -1;
        }

        @Override
        public String getHelpID() {
            return "HELP_LOGIN_PWD_PROP_OPTIONS_1502";
        }

        @Override
        public void init() throws SQLException {
            Enumeration enumeration = this._so.getConfigData();
            TableColumn tableColumn = this._go.configList.getColumn((Object)ASEUtils.getString("DISP_VALUE_TEXT"));
            this._go.configList.clear();
            JTextField jTextField = new JTextField();
            jTextField.setEnabled(false);
            jTextField.getDocument().addDocumentListener(this);
            DefaultCellEditor defaultCellEditor = new DefaultCellEditor(jTextField);
            tableColumn.setCellEditor(defaultCellEditor);
            this._go.configList.getSelectionModel().addListSelectionListener(new TableSelectionListener(){

                @Override
                public void selectAction() {
                    LoginConfigPasswordOptionsPage.this.tableSelectionChanged();
                }

                @Override
                public void deSelectAction() {
                }
            });
            this._currentDisplayedData.clear();
            while (enumeration.hasMoreElements()) {
                PasswordConfigSO passwordConfigSO = (PasswordConfigSO)enumeration.nextElement();
                this._currentDisplayedData.addElement(passwordConfigSO);
                String string = passwordConfigSO.getName();
                String string2 = passwordConfigSO.getValue();
                String string3 = passwordConfigSO.getMinimum();
                int n = Integer.valueOf(string3);
                String string4 = passwordConfigSO.getMaximum();
                int n2 = Integer.valueOf(string4);
                NumericsOnlyDocument numericsOnlyDocument = new NumericsOnlyDocument(true, true, (float)n, (float)n2);
                numericsOnlyDocument.addDocumentListener((DocumentListener)this);
                this._numericsOnlyDocuments.addElement(numericsOnlyDocument);
                this._go.configList.addRow(passwordConfigSO.isSelected(), new Object[]{string, string2});
                if (passwordConfigSO.isSelected()) continue;
                ((DefaultCellEditor)this._go.configList.getCellEditor(this._go.configList.getRowCount() - 1, 1)).getComponent().setEnabled(false);
            }
            this._go.configList.addListCheckListener((ASAListCheckListener)this);
            this._go.configList.setColumnWidthToFit(0);
            if (this._curSelectedRow != -1 && this._curSelectedRow < this._go.configList.getRowCount()) {
                this._go.configList.selectRow(this._curSelectedRow);
            }
        }

        private void updateCellEditorDocument(int n) {
            if (n < 0 || n >= this._numericsOnlyDocuments.size()) {
                return;
            }
            NumericsOnlyDocument numericsOnlyDocument = (NumericsOnlyDocument)this._numericsOnlyDocuments.get(n);
            TableColumn tableColumn = this._go.configList.getColumn((Object)ASEUtils.getString("DISP_VALUE_TEXT"));
            DefaultCellEditor defaultCellEditor = (DefaultCellEditor)tableColumn.getCellEditor();
            ((JTextField)defaultCellEditor.getComponent()).setDocument((Document)numericsOnlyDocument);
        }

        public void tableSelectionChanged() {
            int n = this._go.configList.getRowCount();
            int n2 = this._go.configList.getSelectedRow();
            int n3 = this._go.configList.getSelectedColumn();
            if (n < n2 || n2 == -1) {
                return;
            }
            this._curSelectedRow = n2;
            PasswordConfigSO passwordConfigSO = (PasswordConfigSO)this._currentDisplayedData.elementAt(n2);
            String string = passwordConfigSO.getMinimum();
            String string2 = passwordConfigSO.getMaximum();
            this._go.minValTextField.setText(string);
            this._go.maxValTextField.setText(string2);
            this._go.explanationTextArea.setText(passwordConfigSO.getMessage());
            if (string.equals("0") && string2.equals("1")) {
                if (n3 == 0) {
                    boolean bl = this._go.configList.isRowChecked(n2);
                    this._go.configList.setRow(n2, new Object[]{passwordConfigSO.getName(), bl ? "1" : "0"});
                }
                ((DefaultCellEditor)this._go.configList.getCellEditor(n2, 1)).getComponent().setEnabled(false);
            } else if (this._go.configList.isRowChecked(n2)) {
                ((DefaultCellEditor)this._go.configList.getCellEditor(n2, 1)).getComponent().setEnabled(true);
                this.updateCellEditorDocument(n2);
            } else {
                ((DefaultCellEditor)this._go.configList.getCellEditor(n2, 1)).getComponent().setEnabled(false);
            }
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
            this.enableConfigComponents(documentEvent);
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            this.enableConfigComponents(documentEvent);
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            this.enableConfigComponents(documentEvent);
        }

        public void enableConfigComponents(DocumentEvent documentEvent) {
            NumericsOnlyDocument numericsOnlyDocument;
            Document document = documentEvent.getDocument();
            if (document instanceof NumericsOnlyDocument && (numericsOnlyDocument = (NumericsOnlyDocument)document).isDocumentChanged()) {
                this.enableApplyButton(true);
            }
        }

        public void valueChanged(ASAListCheckEvent aSAListCheckEvent) {
            this.tableSelectionChanged();
            this.enableApplyButton(true);
        }

        @Override
        public boolean deploy() {
            try {
                this._go.configList.getCellEditor().stopCellEditing();
            }
            catch (Exception exception) {
                // empty catch block
            }
            boolean bl = false;
            try {
                for (int i = 0; i < this._go.configList.getRowCount(); ++i) {
                    String string;
                    PasswordConfigSO passwordConfigSO = (PasswordConfigSO)this._currentDisplayedData.elementAt(i);
                    if (passwordConfigSO.getName().equals("enable last login updates")) {
                        string = (String)this._go.configList.getValueAt(i, 1);
                        if (!string.equals(passwordConfigSO.getValue())) {
                            this._so.setOptionValue(passwordConfigSO.getName(), string);
                            ServerBO serverBO = ContainerViewBO.getServerBO(this._so.getConnection());
                            serverBO.refresh();
                        }
                        bl = true;
                        continue;
                    }
                    if (this._go.configList.isRowChecked(i)) {
                        string = (String)this._go.configList.getValueAt(i, 1);
                        if (passwordConfigSO.isSelected()) {
                            if (!string.equals(passwordConfigSO.getValue())) {
                                this._so.setOptionValue(passwordConfigSO.getName(), string);
                            }
                        } else {
                            this._so.setOptionValue(passwordConfigSO.getName(), string);
                        }
                    } else if (passwordConfigSO.isSelected()) {
                        this._so.clearOption(passwordConfigSO.getName());
                    }
                    bl = true;
                }
            }
            catch (SQLException sQLException) {
                bl = Support.showDetailsError(this.getConnection(), this.getClass(), (Container)this.getJDialog(), sQLException.getMessage(), sQLException);
            }
            return bl;
        }

        @Override
        public void releaseResources() {
            for (int i = 0; i < this._numericsOnlyDocuments.size(); ++i) {
                NumericsOnlyDocument numericsOnlyDocument = (NumericsOnlyDocument)this._numericsOnlyDocuments.get(i);
                numericsOnlyDocument.removeDocumentListener((DocumentListener)this);
            }
            this._go.releaseResources();
            this._go = null;
            super.releaseResources();
        }
    }
}

