/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.aseplugin.bo.prop;

import com.sybase.aseplugin.ASEUtils;
import com.sybase.aseplugin.bo.Support;
import com.sybase.aseplugin.bo.dlg.AddSDCLCFailoverDialog;
import com.sybase.aseplugin.bo.prop.ASEBasePropertiesPage2;
import com.sybase.aseplugin.bo.prop.SDCLogicalClusterProperties;
import com.sybase.aseplugin.go.prop.SDCLCFailoversPropGOPage;
import com.sybase.aseplugin.so.SDCInstanceSO;
import com.sybase.aseplugin.so.SDCLogicalClusterSO;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import java.util.List;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;

class SDCLCFailoversListPropBOPage
extends ASEBasePropertiesPage2
implements ActionListener,
ListSelectionListener,
TableModelListener {
    private SDCLCFailoversPropGOPage _go = (SDCLCFailoversPropGOPage)((Object)this.getJPanel());
    private Vector _headings = new Vector();
    private SDCLogicalClusterSO _lcSO;
    private SDCLogicalClusterSO _tempLCSO;

    public SDCLCFailoversListPropBOPage(SDCLogicalClusterProperties sDCLogicalClusterProperties) {
        super(sDCLogicalClusterProperties, (JPanel)((Object)new SDCLCFailoversPropGOPage()), ASEUtils.getString("DISP_SDC_LC_FAILOVER_INSTANCES"));
        this._headings.addElement(ASEUtils.getString("DISP_NAME_TEXT"));
        this._headings.addElement(ASEUtils.getString("DISP_SDC_INSTANCE_ID"));
        this._headings.addElement(ASEUtils.getString("DISP_SDC_STATE"));
        this._headings.addElement(ASEUtils.getString("DISP_SDC_FAILOVER_GROUP"));
        this._go.failoverList.setColumnHeadings(this._headings);
        this._go.removeButton.addActionListener((ActionListener)this);
        this._go.failoverList.addListSelectionListener((ListSelectionListener)this);
        this._go.addButton.addActionListener((ActionListener)this);
        this._go.failbackButton.addActionListener((ActionListener)this);
        this._go.failoverList.setColumnWidth(1, 30);
        this._go.failoverList.getSelectionModel().setSelectionMode(0);
        this._lcSO = (SDCLogicalClusterSO)this.getSO();
        this._tempLCSO = sDCLogicalClusterProperties.getTempLCSO();
        this._go.failbackButton.setEnabled(false);
    }

    @Override
    public String getHelpID() {
        return "HELP_LOGICAL_CLUSTER_PROP_FAILOVER_1501CE";
    }

    public void setAddButtonEnabled(boolean bl) {
        this._go.addButton.setEnabled(bl);
    }

    @Override
    public void init() throws SQLException {
        this._go.removeButton.setEnabled(false);
        if (this._lcSO.hasSystemRole() || this._tempLCSO.getAvailableInstances().size() == 0) {
            this._go.addButton.setEnabled(false);
        }
        List list = this._lcSO.getFailovers();
        this._go.failoverList.clear();
        for (int i = 0; i < list.size(); ++i) {
            SDCInstanceSO sDCInstanceSO = (SDCInstanceSO)list.get(i);
            this._go.failoverList.addRow(new Object[]{sDCInstanceSO.getName(), sDCInstanceSO.getId(), sDCInstanceSO.getState(), sDCInstanceSO.getFailoverGroup()});
        }
        this._go.failoverList.sort(3);
        this._go.failoverList.setSorting(true);
        this._go.setDisplayPreviewButton(false);
        this._go.failoverList.getModel().addTableModelListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this._go.removeButton) {
            this.doRemoveFailover();
            ((SDCLogicalClusterProperties)this.getParent()).resetAddButton();
        } else if (object == this._go.addButton) {
            this.doAddFailover();
            ((SDCLogicalClusterProperties)this.getParent()).resetAddButton();
        } else if (object == this._go.failbackButton) {
            this.doFailbackInstance();
        }
    }

    private void doAddFailover() {
        List list = this._tempLCSO.getAvailableInstances();
        AddSDCLCFailoverDialog.showDialog(((SDCLogicalClusterProperties)this.getParent()).getJDialog(), this._go.failoverList, list);
        for (int i = 0; i < this._go.failoverList.getRowCount(); ++i) {
            String string = (String)this._go.failoverList.getValueAt(i, 0);
            String string2 = (String)this._go.failoverList.getValueAt(i, 3);
            this._tempLCSO.addFailover(string, Integer.parseInt(string2));
        }
        ((SDCLogicalClusterProperties)this.getParent()).setChangePending(true);
    }

    private void doRemoveFailover() {
        int n = Support.showQuestionYesNo(this.getParent().getJDialog(), ASEUtils.getString("MSG_REMOVE_SDC_LC_FAILOVER"));
        if (n == 0) {
            int[] nArray = this._go.failoverList.getSelectedRows();
            String string = "";
            for (int i = nArray.length - 1; i >= 0; --i) {
                string = (String)this._go.failoverList.getRow(nArray[i]).elementAt(0);
                this._tempLCSO.removeFailover(string);
                this._go.failoverList.removeRow(nArray[i]);
            }
            this._go.removeButton.setEnabled(false);
        }
        ((SDCLogicalClusterProperties)this.getParent()).setChangePending(true);
    }

    public void doFailbackInstance() {
        if (((SDCLogicalClusterProperties)this.getParent()).isChangePending()) {
            Support.showInfo(this.getConnection(), this.getClass(), ASEUtils.getString("MSG_SDC_LOGICAL_CLUSTER_FAILBACK_WARNING"));
            return;
        }
        int n = this._go.failoverList.getSelectedRow();
        String string = "";
        string = (String)this._go.failoverList.getRow(n).elementAt(0);
        try {
            this._lcSO.failBack(string);
        }
        catch (SQLException sQLException) {
            Support.showDetailsError(this.getConnection(), this.getClass(), sQLException.getMessage(), sQLException);
        }
        SDCInstanceSO sDCInstanceSO = this._lcSO.getFailover(string);
        sDCInstanceSO.reloadLogicalFromDB(this._lcSO.getID());
        Vector vector = this._go.failoverList.getRow(n);
        vector.setElementAt(sDCInstanceSO.getState(), 2);
        this._go.failoverList.setRow(n, vector);
        this._go.failbackButton.setEnabled(false);
        ((SDCLogicalClusterProperties)this.getParent()).reInitPage("instances");
        this.enableApplyButton(true);
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (this._lcSO.hasSystemRole()) {
            return;
        }
        int[] nArray = this._go.failoverList.getSelectedRows();
        for (int i = nArray.length - 1; i >= 0; --i) {
            if (nArray.length > 0) {
                String string = (String)this._go.failoverList.getRow(nArray[i]).elementAt(2);
                if (string != null && (string.equals("offline") || string.equals("failed"))) {
                    this._go.removeButton.setEnabled(true);
                    this._go.failbackButton.setEnabled(false);
                    continue;
                }
                if (string != null && string.equals("online")) {
                    this._go.removeButton.setEnabled(false);
                    this._go.failbackButton.setEnabled(true);
                    continue;
                }
                if (string != null && string.length() == 0) {
                    this._go.removeButton.setEnabled(true);
                    this._go.failbackButton.setEnabled(false);
                    continue;
                }
                this._go.removeButton.setEnabled(false);
                this._go.failbackButton.setEnabled(false);
                continue;
            }
            this._go.removeButton.setEnabled(false);
            this._go.failbackButton.setEnabled(false);
        }
    }

    @Override
    public void tableChanged(TableModelEvent tableModelEvent) {
        if (tableModelEvent.getType() == 1 || tableModelEvent.getType() == -1) {
            this.enableApplyButton(true);
        }
    }
}

