/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.aseplugin.bo.prop;

import com.sybase.aseplugin.ASEUtils;
import com.sybase.aseplugin.bo.Support;
import com.sybase.aseplugin.bo.dlg.AddSDCLCInstanceDialog;
import com.sybase.aseplugin.bo.dlg.SDCLCStopConfirmDialog;
import com.sybase.aseplugin.bo.prop.ASEBasePropertiesPage2;
import com.sybase.aseplugin.bo.prop.SDCLogicalClusterProperties;
import com.sybase.aseplugin.go.prop.SDCLCInstancesPropGOPage;
import com.sybase.aseplugin.so.SDCInstanceSO;
import com.sybase.aseplugin.so.SDCLogicalClusterSO;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import java.util.List;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;

class SDCLCInstancesListPropBOPage
extends ASEBasePropertiesPage2
implements ActionListener,
ListSelectionListener,
TableModelListener {
    private SDCLCInstancesPropGOPage _go = (SDCLCInstancesPropGOPage)((Object)this.getJPanel());
    private SDCLogicalClusterSO _lcSO;
    private SDCLogicalClusterSO _tempLCSO;
    private Vector _headings = new Vector();

    public SDCLCInstancesListPropBOPage(SDCLogicalClusterProperties sDCLogicalClusterProperties) {
        super(sDCLogicalClusterProperties, (JPanel)((Object)new SDCLCInstancesPropGOPage()), ASEUtils.getString("DISP_SDC_LC_BASE_INSTANCES"));
        this._headings.addElement(ASEUtils.getString("DISP_NAME_TEXT"));
        this._headings.addElement(ASEUtils.getString("DISP_SDC_INSTANCE_ID"));
        this._headings.addElement(ASEUtils.getString("DISP_SDC_STATE"));
        this._go.instanceList.setColumnHeadings(this._headings);
        this._go.instanceList.addListSelectionListener((ListSelectionListener)this);
        this._go.addButton.addActionListener((ActionListener)this);
        this._go.removeButton.addActionListener((ActionListener)this);
        this._go.onlineButton.addActionListener((ActionListener)this);
        this._go.offlineButton.addActionListener((ActionListener)this);
        this._go.failoverButton.addActionListener((ActionListener)this);
        this._go.instanceList.setColumnWidth(1, 30);
        this._go.instanceList.getSelectionModel().setSelectionMode(0);
        this._go.instanceList.setColumnWidth(1, 30);
        this._go.instanceList.getSelectionModel().setSelectionMode(0);
        this._lcSO = (SDCLogicalClusterSO)this.getSO();
        this._tempLCSO = sDCLogicalClusterProperties.getTempLCSO();
        this._go.failoverButton.setEnabled(false);
    }

    @Override
    public String getHelpID() {
        return "HELP_LOGICAL_CLUSTER_PROP_INSTANCE_1501CE";
    }

    public void setAddButtonEnabled(boolean bl) {
        this._go.addButton.setEnabled(bl);
    }

    @Override
    public void init() throws SQLException {
        this._go.removeButton.setEnabled(false);
        this._go.onlineButton.setEnabled(false);
        this._go.offlineButton.setEnabled(false);
        this._go.instanceList.clear();
        if (this._lcSO.hasSystemRole() || this._tempLCSO.getAvailableInstances().size() == 0) {
            this._go.addButton.setEnabled(false);
        }
        List list = this._lcSO.getInstances();
        for (int i = 0; i < list.size(); ++i) {
            SDCInstanceSO sDCInstanceSO = (SDCInstanceSO)list.get(i);
            this._go.instanceList.addRow(new Object[]{sDCInstanceSO.getName(), sDCInstanceSO.getId(), sDCInstanceSO.getState()});
        }
        this._go.setDisplayPreviewButton(false);
        this._go.instanceList.getModel().addTableModelListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this._go.removeButton) {
            this.doRemoveInstance();
            ((SDCLogicalClusterProperties)this.getParent()).resetAddButton();
        } else if (object == this._go.addButton) {
            this.doAddInstance();
            ((SDCLogicalClusterProperties)this.getParent()).resetAddButton();
        } else if (object == this._go.onlineButton) {
            this.doOnlineInstance();
        } else if (object == this._go.offlineButton) {
            this.doOfflineInstance();
        } else if (object == this._go.failoverButton) {
            this.doFailoverInstance();
        }
    }

    private boolean isAbleToFailover() {
        List list = this._lcSO.getFailovers();
        if (list != null && list.size() > 0) {
            return true;
        }
        boolean bl = false;
        List list2 = this._lcSO.getAvailableInstances();
        if (list2 != null && list2.size() > 0) {
            bl = true;
        }
        return this._lcSO.isFailToAny() && bl;
    }

    private void doAddInstance() {
        List list = this._tempLCSO.getAvailableInstances();
        AddSDCLCInstanceDialog.showDialog(((SDCLogicalClusterProperties)this.getParent()).getJDialog(), this._go.instanceList, list);
        for (int i = 0; i < this._go.instanceList.getRowCount(); ++i) {
            String string = this._go.instanceList.getStringAt(i, 0);
            this._tempLCSO.addInstance(string);
        }
        ((SDCLogicalClusterProperties)this.getParent()).setChangePending(true);
    }

    private void doRemoveInstance() {
        int n = Support.showQuestionYesNo(this.getParent().getJDialog(), ASEUtils.getString("MSG_REMOVE_SDC_LC_INSTANCE"));
        if (n == 0) {
            int[] nArray = this._go.instanceList.getSelectedRows();
            String string = "";
            for (int i = nArray.length - 1; i >= 0; --i) {
                string = (String)this._go.instanceList.getRow(nArray[i]).elementAt(0);
                this._tempLCSO.removeInstance(string);
                this._go.instanceList.removeRow(nArray[i]);
            }
            this._go.removeButton.setEnabled(false);
        }
        ((SDCLogicalClusterProperties)this.getParent()).setChangePending(true);
    }

    private void doOnlineInstance() {
        int n = this._go.instanceList.getSelectedRow();
        String string = "";
        string = (String)this._go.instanceList.getRow(n).elementAt(0);
        try {
            this._lcSO.online(string);
        }
        catch (SQLException sQLException) {
            Support.showDetailsError(this.getConnection(), this.getClass(), sQLException.getMessage(), sQLException);
        }
        ((SDCLogicalClusterProperties)this.getParent()).onApply();
    }

    private void doOfflineInstance() {
        int n = this._go.instanceList.getSelectedRow();
        String string = "";
        string = (String)this._go.instanceList.getRow(n).elementAt(0);
        SDCLCStopConfirmDialog sDCLCStopConfirmDialog = SDCLCStopConfirmDialog.getDialog(this.getJDialog(), this._lcSO, string, 3004);
        if (sDCLCStopConfirmDialog.render()) {
            if (sDCLCStopConfirmDialog.isNoWait()) {
                try {
                    this._lcSO.offline(string);
                    Thread.sleep(5000L);
                    ((SDCLogicalClusterProperties)this.getParent()).onApply();
                    return;
                }
                catch (SQLException sQLException) {
                    Support.showDetailsError(this.getConnection(), this.getClass(), sQLException.getMessage(), sQLException);
                }
                catch (InterruptedException interruptedException) {}
            } else {
                int n2 = sDCLCStopConfirmDialog.getReminderMinutes();
                try {
                    this._lcSO.offline(string, n2);
                }
                catch (SQLException sQLException) {
                    Support.showDetailsError(this.getConnection(), this.getClass(), sQLException.getMessage(), sQLException);
                }
            }
            Vector vector = this._go.instanceList.getRow(n);
            vector.setElementAt(ASEUtils.getString("MSG_SDC_INSTANCE_PENDING_STATE_OFFLINE"), 2);
            this._go.instanceList.setRow(n, vector);
            this.enableApplyButton(true);
        }
    }

    public void doFailoverInstance() {
        if (((SDCLogicalClusterProperties)this.getParent()).isChangePending()) {
            Support.showInfo(this.getConnection(), this.getClass(), ASEUtils.getString("MSG_SDC_LOGICAL_CLUSTER_FAILOVER_WARNING"));
            return;
        }
        int n = this._go.instanceList.getSelectedRow();
        String string = "";
        string = (String)this._go.instanceList.getRow(n).elementAt(0);
        try {
            this._lcSO.failOver(string);
        }
        catch (SQLException sQLException) {
            Support.showDetailsError(this.getConnection(), this.getClass(), sQLException.getMessage(), sQLException);
        }
        SDCInstanceSO sDCInstanceSO = this._lcSO.getInstance(string);
        sDCInstanceSO.reloadLogicalFromDB(this._lcSO.getID());
        Vector vector = this._go.instanceList.getRow(n);
        vector.setElementAt(sDCInstanceSO.getState(), 2);
        this._go.instanceList.setRow(n, vector);
        ((SDCLogicalClusterProperties)this.getParent()).reInitPage("failovers");
        this.enableApplyButton(true);
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (this._lcSO.hasSystemRole()) {
            return;
        }
        int[] nArray = this._go.instanceList.getSelectedRows();
        if (nArray.length < 1) {
            this._go.removeButton.setEnabled(false);
            this._go.onlineButton.setEnabled(false);
            this._go.offlineButton.setEnabled(false);
            this._go.failoverButton.setEnabled(false);
            return;
        }
        int n = nArray.length - 1;
        if (n >= 0) {
            String string = (String)this._go.instanceList.getRow(nArray[n]).elementAt(2);
            if (string != null && string.equals("offline")) {
                this._go.removeButton.setEnabled(true);
                this._go.onlineButton.setEnabled(true);
                this._go.offlineButton.setEnabled(false);
                this._go.failoverButton.setEnabled(false);
                return;
            }
            if (string != null && string.equals("failed")) {
                this._go.removeButton.setEnabled(true);
                this._go.onlineButton.setEnabled(true);
                this._go.offlineButton.setEnabled(true);
                this._go.failoverButton.setEnabled(this.isAbleToFailover());
                return;
            }
            if (string != null && string.equals("timedwait")) {
                this._go.removeButton.setEnabled(false);
                this._go.onlineButton.setEnabled(false);
                this._go.offlineButton.setEnabled(false);
                this._go.failoverButton.setEnabled(false);
                return;
            }
            if (string != null && string.equals("inactive")) {
                this._go.removeButton.setEnabled(true);
                this._go.onlineButton.setEnabled(true);
                this._go.offlineButton.setEnabled(true);
                this._go.failoverButton.setEnabled(this.isAbleToFailover());
                return;
            }
            if (string != null && string.length() == 0) {
                this._go.removeButton.setEnabled(true);
                this._go.onlineButton.setEnabled(false);
                this._go.offlineButton.setEnabled(false);
                this._go.failoverButton.setEnabled(false);
                return;
            }
            this._go.removeButton.setEnabled(false);
            this._go.onlineButton.setEnabled(false);
            this._go.offlineButton.setEnabled(true);
            this._go.failoverButton.setEnabled(this.isAbleToFailover());
            return;
        }
    }

    @Override
    public void tableChanged(TableModelEvent tableModelEvent) {
        if (tableModelEvent.getType() == 1 || tableModelEvent.getType() == -1) {
            this.enableApplyButton(true);
        }
    }
}

