/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.aseplugin.bo.prop;

import com.sybase.aseplugin.ASEImages;
import com.sybase.aseplugin.ASEUtils;
import com.sybase.aseplugin.bo.Support;
import com.sybase.aseplugin.bo.dlg.AddObjectDialog;
import com.sybase.aseplugin.bo.dlg.SDCLCRouteAliasDialog;
import com.sybase.aseplugin.bo.dlg.SDCLCRouteApplicationDialog;
import com.sybase.aseplugin.bo.prop.ASEBasePropertiesPage2;
import com.sybase.aseplugin.bo.prop.SDCLogicalClusterProperties;
import com.sybase.aseplugin.go.prop.SDCLCRoutesPropGOPage;
import com.sybase.aseplugin.so.SDCLogicalClusterSO;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import java.util.List;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;

class SDCLCRoutesListPropBOPage
extends ASEBasePropertiesPage2
implements ActionListener,
ListSelectionListener,
TableModelListener {
    private SDCLCRoutesPropGOPage _go;
    private Vector _applications = new Vector();
    private Vector _removeApplications = new Vector();
    private Vector _removeLogins = new Vector();
    private Vector _logins = new Vector();
    private Vector _tempLogins = new Vector();
    private Vector _aliases = new Vector();
    private Vector _removeAliases = new Vector();
    private SDCLogicalClusterSO _lcSO;
    private SDCLogicalClusterSO _tempLCSO;

    public SDCLCRoutesListPropBOPage(SDCLogicalClusterProperties sDCLogicalClusterProperties) {
        super(sDCLogicalClusterProperties, (JPanel)((Object)new SDCLCRoutesPropGOPage()), ASEUtils.getString("DNAME_SDC_ROUTES"));
        this._go = (SDCLCRoutesPropGOPage)((Object)this.getJPanel());
        this._go.dropRouteButton.setEnabled(false);
        this._go.dropAllRoutesButton.setVisible(false);
        this._lcSO = (SDCLogicalClusterSO)this.getSO();
    }

    @Override
    public String getHelpID() {
        return "HELP_LOGICAL_CLUSTER_PROP_ROUTES_1501CE";
    }

    @Override
    public void init() throws SQLException {
        int n;
        this._go.removeAllListeners(this);
        this._applications.clear();
        this._aliases.clear();
        this._logins.clear();
        List list = this._lcSO.getRoutes();
        for (String[] stringArray : list) {
            if (stringArray[1].equals("application")) {
                this._applications.addElement(stringArray[0]);
                continue;
            }
            if (stringArray[1].equals("login")) {
                this._logins.addElement(stringArray[0]);
                continue;
            }
            if (!stringArray[1].equals("alias")) continue;
            this._aliases.addElement(stringArray[0]);
        }
        this._go.routesList.clear();
        for (n = 0; n < this._applications.size(); ++n) {
            this._go.routesList.addRow(new Object[]{this._applications.elementAt(n), ASEUtils.getString("DNAME_SDC_LC_ROUTE_TYPE_APPLICATION")});
        }
        for (n = 0; n < this._logins.size(); ++n) {
            this._go.routesList.addRow(new Object[]{this._logins.elementAt(n), ASEUtils.getString("DNAME_SDC_LC_ROUTE_TYPE_LOGIN")});
        }
        for (n = 0; n < this._aliases.size(); ++n) {
            this._go.routesList.addRow(new Object[]{this._aliases.elementAt(n), ASEUtils.getString("DNAME_SDC_LC_ROUTE_TYPE_ALIAS")});
        }
        this._go.setDisplayPreviewButton(false);
        this._tempLogins = (Vector)this._logins.clone();
        Vector vector = this._lcSO.getExistingRoutes("login");
        for (int i = 0; i < vector.size(); ++i) {
            if (this._tempLogins.contains(vector.get(i))) continue;
            this._tempLogins.addElement(vector.get(i));
        }
        this._go.addAllListeners(this);
    }

    @Override
    public boolean deploy() throws SQLException {
        int n;
        String string = "";
        String string2 = "";
        String string3 = "";
        String string4 = "";
        for (n = 0; n < this._removeApplications.size(); ++n) {
            string = (String)this._removeApplications.elementAt(n);
            this._lcSO.dropApplicationRoute(string);
        }
        for (n = 0; n < this._removeAliases.size(); ++n) {
            string2 = (String)this._removeAliases.elementAt(n);
            this._lcSO.dropAliasRoute(string2);
        }
        for (n = 0; n < this._removeLogins.size(); ++n) {
            string4 = (String)this._removeLogins.elementAt(n);
            if (!this._logins.contains(string4)) continue;
            this._lcSO.dropLoginRoute(string4);
            this._logins.removeElement(string4);
        }
        for (n = 0; n < this._go.routesList.getRowCount(); ++n) {
            string3 = (String)this._go.routesList.getValueAt(n, 1);
            if (string3.equals(ASEUtils.getString("DNAME_SDC_LC_ROUTE_TYPE_APPLICATION"))) {
                string = (String)this._go.routesList.getValueAt(n, 0);
                if (this._applications.contains(string) || this._lcSO.addApplicationRoute(string)) continue;
                Support.showInfo(this.getConnection(), this.getClass(), ASEUtils.getString("ERR_SDC_LC_ADDING_ROUTE"));
                return false;
            }
            if (string3.equals(ASEUtils.getString("DNAME_SDC_LC_ROUTE_TYPE_ALIAS"))) {
                string2 = (String)this._go.routesList.getValueAt(n, 0);
                if (this._aliases.contains(string2) || this._lcSO.addAliasRoute(string2)) continue;
                Support.showInfo(this.getConnection(), this.getClass(), ASEUtils.getString("ERR_SDC_LC_ADDING_ROUTE"));
                return false;
            }
            if (string3.equals(ASEUtils.getString("DNAME_SDC_LC_ROUTE_TYPE_LOGIN"))) {
                string4 = (String)this._go.routesList.getValueAt(n, 0);
                if (this._logins.contains(string4) || this._lcSO.addLoginRoute(string4)) continue;
                Support.showInfo(this.getConnection(), this.getClass(), ASEUtils.getString("ERR_SDC_LC_ADDING_ROUTE"));
                return false;
            }
            return false;
        }
        return true;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this._go.dropRouteButton) {
            this.doDropRoute();
        } else if (object == this._go.addApplicationRouteButton) {
            SDCLCRouteApplicationDialog.showDialog(this.getConnection(), ((SDCLogicalClusterProperties)this.getParent()).getJDialog(), this._go.routesList);
        } else if (object == this._go.addAliasRouteButton) {
            SDCLCRouteAliasDialog.showDialog(this.getConnection(), ((SDCLogicalClusterProperties)this.getParent()).getJDialog(), this._go.routesList);
        } else {
            this.doAddLoginRoute();
        }
    }

    private void doAddLoginRoute() {
        Object object;
        Vector<String> vector = new Vector<String>();
        vector.addElement(ASEUtils.getString("DISP_NAME_TEXT"));
        Vector vector2 = new Vector();
        Vector vector3 = new Vector();
        try {
            vector3 = this._lcSO.getLoginNameList();
        }
        catch (SQLException sQLException) {
            Support.showDetailsError(this.getConnection(), this.getClass(), (Container)this.getJDialog(), sQLException.getMessage(), sQLException);
        }
        ImageIcon imageIcon = new ImageIcon(ASEImages.getLoginSmallImage());
        Vector<JLabel> vector4 = null;
        vector3.removeAll(this._tempLogins);
        for (int i = 0; i < vector3.size(); ++i) {
            vector4 = new Vector<JLabel>();
            object = (String)vector3.elementAt(i);
            vector4.add(new JLabel((String)object, imageIcon, 2));
            vector2.add(vector4);
        }
        if (vector2.size() > 0) {
            AddObjectDialog addObjectDialog = AddObjectDialog.getDialog(this.getJDialog(), ASEUtils.getString("MSG_NEW_LOGIN_ROUTE"), ASEUtils.getString("MSG_SDC_LC_LOGIN_ROUTE_TEXT"), vector, vector2, "HELP_LC_ROUTE_LOGIN_DLG_1501CE");
            if (addObjectDialog.render()) {
                object = addObjectDialog.getDataTable();
                int[] nArray = ((JTable)object).getSelectedRows();
                AbstractTableModel abstractTableModel = (AbstractTableModel)((JTable)object).getModel();
                for (int i = 0; i < nArray.length; ++i) {
                    this._go.routesList.addRow(new Object[]{((JLabel)abstractTableModel.getValueAt(nArray[i], 0)).getText(), ASEUtils.getString("DNAME_SDC_LC_ROUTE_TYPE_LOGIN")});
                    String string = ((JLabel)abstractTableModel.getValueAt(nArray[i], 0)).getText();
                    if (this._tempLogins.contains(string)) continue;
                    this._tempLogins.addElement(string);
                }
            }
        } else {
            Support.showInfo(this.getConnection(), this.getClass(), ASEUtils.getString("MSG_INFO_LOGIN_NOT_AVAILABLE"));
        }
    }

    private void doDropRoute() {
        int n = Support.showQuestionYesNo(this.getParent().getJDialog(), ASEUtils.getString("MSG_SDC_LOGICAL_CLUSTER_UNROUTE_CONFIRM"));
        if (n == 0) {
            int[] nArray = this._go.routesList.getSelectedRows();
            String string = "";
            String string2 = "";
            String string3 = "";
            String string4 = "";
            for (int i = nArray.length - 1; i >= 0; --i) {
                string4 = (String)this._go.routesList.getRow(nArray[i]).elementAt(1);
                if (string4.equals("alias")) {
                    string = (String)this._go.routesList.getRow(nArray[i]).elementAt(0);
                    if (this._aliases.contains(string)) {
                        this._removeAliases.addElement(string);
                    }
                } else if (string4.equals("application")) {
                    string2 = (String)this._go.routesList.getRow(nArray[i]).elementAt(0);
                    if (this._applications.contains(string2)) {
                        this._removeApplications.addElement(string2);
                    }
                } else {
                    string3 = (String)this._go.routesList.getRow(nArray[i]).elementAt(0);
                    this._removeLogins.addElement(string3);
                    this._tempLogins.removeElement(string3);
                }
                this._go.routesList.removeRow(nArray[i]);
                this._go.dropRouteButton.setEnabled(false);
            }
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        boolean bl = this._go.routesList.getSelectedRowCount() > 0;
        this._go.dropRouteButton.setEnabled(bl);
    }

    @Override
    public void tableChanged(TableModelEvent tableModelEvent) {
        if (tableModelEvent.getType() == 1 || tableModelEvent.getType() == -1) {
            this.enableApplyButton(true);
        }
    }
}

