/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.aseplugin.bo.prop;

import com.sybase.asa.ASAComboBox;
import com.sybase.aseplugin.ASEImages;
import com.sybase.aseplugin.ASEMessageText;
import com.sybase.aseplugin.ASEUtils;
import com.sybase.aseplugin.bo.Support;
import com.sybase.aseplugin.bo.prop.ASEBasePropDocPage;
import com.sybase.aseplugin.bo.prop.ASEBasePropertiesDialog2;
import com.sybase.aseplugin.go.ASETextField;
import com.sybase.aseplugin.go.prop.SegmentPropGOAutoDBExpandPage;
import com.sybase.aseplugin.so.SegmentSO;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JPanel;

class SegmentPropAutoDBExpandPage
extends ASEBasePropDocPage
implements ActionListener,
ItemListener {
    private SegmentPropGOAutoDBExpandPage _go = (SegmentPropGOAutoDBExpandPage)((Object)this.getJPanel());
    private Hashtable _initialValues;
    private boolean _growByDefault;
    private boolean _maxSizeDefault;
    private boolean _thresholdSet;
    private boolean _policyDisabled;

    public SegmentPropAutoDBExpandPage(ASEBasePropertiesDialog2 aSEBasePropertiesDialog2) {
        super(aSEBasePropertiesDialog2, (JPanel)((Object)new SegmentPropGOAutoDBExpandPage()), ASEUtils.getString("AUTOMATIC_EXPANSION"));
    }

    @Override
    public String getHelpID() {
        return "HELP_SEGMENT_PROP_AUTOMATIC_EXPANSION_1252";
    }

    @Override
    public void init() throws SQLException {
        this.removeListeners();
        this._go.growByUnitComboBox.removeAllItems();
        Support.fillUnitList((JComboBox)this._go.growByUnitComboBox);
        this._go.growByUnitComboBox.addItem((Object)"%");
        this.initialize();
        this.setPolicies();
        this.addListeners();
    }

    private void initialize() {
        this._go.growByTextField.setText("");
        this._go.maxSizeTextField.setText("");
        this._go.spaceTextField.setText("");
        this._go.setCheckBox.setSelected(false);
        this._go.clearPolicyCheckBox.setEnabled(false);
        this._go.clearPolicyCheckBox.setSelected(false);
        this._go.disableCheckBox.setSelected(false);
        this._go.spaceLabel.setEnabled(false);
        this._go.spaceTextField.setEnabled(false);
        this._go.unitComboBox.setEnabled(false);
        this._go.disableCheckBox.setEnabled(true);
        this._go.expandButton.setEnabled(true);
    }

    private void addListeners() {
        this._go.checkButton.addActionListener((ActionListener)this);
        this._go.simulateButton.addActionListener((ActionListener)this);
        this._go.expandButton.addActionListener((ActionListener)this);
        this._go.setCheckBox.addActionListener((ActionListener)this);
        this._go.growByUnitComboBox.addItemListener((ItemListener)this);
        this._go.maxSizeUnitComboBox.addItemListener((ItemListener)this);
        this._go.growByTextField.getDocument().addDocumentListener(this);
        this._go.maxSizeTextField.getDocument().addDocumentListener(this);
        this._go.clearPolicyCheckBox.addActionListener((ActionListener)this);
        this._go.disableCheckBox.addActionListener((ActionListener)this);
    }

    private void removeListeners() {
        this._go.checkButton.removeActionListener((ActionListener)this);
        this._go.simulateButton.removeActionListener((ActionListener)this);
        this._go.expandButton.removeActionListener((ActionListener)this);
        this._go.setCheckBox.removeActionListener((ActionListener)this);
        this._go.growByUnitComboBox.removeItemListener((ItemListener)this);
        this._go.maxSizeUnitComboBox.removeItemListener((ItemListener)this);
        this._go.growByTextField.getDocument().removeDocumentListener(this);
        this._go.maxSizeTextField.getDocument().removeDocumentListener(this);
        this._go.clearPolicyCheckBox.removeActionListener((ActionListener)this);
        this._go.disableCheckBox.removeActionListener((ActionListener)this);
    }

    private void setPolicies() throws SQLException {
        Vector vector = ((SegmentSO)this.getSO()).getPolicies();
        this._initialValues = new Hashtable();
        this._growByDefault = true;
        this._maxSizeDefault = true;
        for (int i = 0; i < vector.size(); ++i) {
            String[] stringArray = (String[])vector.elementAt(i);
            char c = stringArray[0].charAt(0);
            switch (c) {
                case 't': {
                    this._go.spaceTextField.setText(stringArray[1]);
                    this._go.unitComboBox.setSelectedIndex(0);
                    this._go.setCheckBox.setSelected(true);
                    this._thresholdSet = true;
                    this._initialValues.put("t", stringArray[1] + "p");
                    break;
                }
                case 'g': {
                    this.setValues(stringArray[1], this._go.growByTextField, this._go.growByUnitComboBox);
                    if (stringArray[2].equals("disabled")) {
                        this._go.disableCheckBox.setSelected(true);
                        this._go.expandButton.setEnabled(false);
                        this._policyDisabled = true;
                    }
                    this._go.clearPolicyCheckBox.setEnabled(true);
                    this._initialValues.put("g", stringArray[1]);
                    this._growByDefault = false;
                    break;
                }
                case 'm': {
                    this.setValues(stringArray[1], this._go.maxSizeTextField, this._go.maxSizeUnitComboBox);
                    if (stringArray[2].equals("disabled")) {
                        this._go.disableCheckBox.setSelected(true);
                        this._go.expandButton.setEnabled(false);
                        this._policyDisabled = true;
                    }
                    this._go.clearPolicyCheckBox.setEnabled(true);
                    this._initialValues.put("m", stringArray[1]);
                    this._maxSizeDefault = false;
                    break;
                }
                case 'd': {
                    this.setValues(stringArray[1], this._go.growByTextField, this._go.growByUnitComboBox);
                    this._initialValues.put("g", stringArray[1]);
                }
            }
            if (!this._growByDefault || !this._maxSizeDefault) continue;
            this._go.disableCheckBox.setEnabled(false);
        }
    }

    private void setValues(String string, ASETextField aSETextField, ASAComboBox aSAComboBox) {
        char c = string.substring(string.length() - 1).toUpperCase().charAt(0);
        string = string.substring(0, string.length() - 1);
        aSETextField.setText(string);
        switch (c) {
            case 'P': {
                aSAComboBox.setSelectedIndex(0);
                break;
            }
            case 'K': {
                aSAComboBox.setSelectedIndex(1);
                break;
            }
            case 'M': {
                aSAComboBox.setSelectedIndex(2);
                break;
            }
            case 'G': {
                aSAComboBox.setSelectedIndex(3);
                break;
            }
            case '%': {
                aSAComboBox.setSelectedIndex(4);
            }
        }
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        this.enableApplyButton(true);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        try {
            String string;
            String string2 = string = Support.getFullTitle(ASEUtils.getString("AUTOMATIC_EXPANSION"), ((SegmentSO)this.getSO()).getConnection());
            if (actionEvent.getSource() == this._go.simulateButton) {
                Support.writeToExtendedLogFileEditor(string, ASEImages.getSegmentSmallImage(), ((SegmentSO)this.getSO()).simulateExpansion(), ((SegmentSO)this.getSO()).getConnection(), null, string2);
            } else if (actionEvent.getSource() == this._go.expandButton) {
                int n = Support.showQuestionYesNo(this.getJDialog(), new ASEMessageText(ASEUtils.getString("MSG_SEG_CONFIRM_EXPAND"), ((SegmentSO)this.getSO()).getName()).toString());
                if (n == 0) {
                    Support.writeToExtendedLogFileEditor(string, ASEImages.getSegmentSmallImage(), ((SegmentSO)this.getSO()).expand(), ((SegmentSO)this.getSO()).getConnection(), null, string2);
                }
            } else if (actionEvent.getSource() == this._go.checkButton) {
                String string3 = ((SegmentSO)this.getSO()).checkExpansion();
                if (string3.equals("")) {
                    return;
                }
                Support.writeToExtendedLogFileEditor(string, ASEImages.getSegmentSmallImage(), string3, ((SegmentSO)this.getSO()).getConnection(), null, string2);
            } else if (actionEvent.getSource() == this._go.setCheckBox) {
                boolean bl = this._go.setCheckBox.isSelected();
                this._go.spaceLabel.setEnabled(bl);
                this._go.spaceTextField.setEnabled(bl);
                this._go.unitComboBox.setEnabled(bl);
                if (bl) {
                    this._go.spaceTextField.requestFocus();
                    this._go.spaceTextField.selectAll();
                }
                this.enableApplyButton(true);
            } else {
                this.enableApplyButton(true);
            }
        }
        catch (SQLException sQLException) {
            Support.showDetailsError(this.getConnection(), this.getClass(), (Container)this.getJDialog(), sQLException.getMessage(), sQLException);
        }
    }

    @Override
    public boolean deploy() throws SQLException {
        if (this._go.setCheckBox.isSelected()) {
            if (!this._thresholdSet && !this._go.spaceTextField.getText().equals("")) {
                ((SegmentSO)this.getSO()).setAutoExpansionThresholdSpace(this._go.spaceTextField.getText() + this.getUnitSuffix(this._go.unitComboBox.getSelectedIndex()));
            }
        } else if (this._thresholdSet) {
            ((SegmentSO)this.getSO()).clearAutoExpansionThreshold();
        }
        if (this._go.clearPolicyCheckBox.isSelected()) {
            ((SegmentSO)this.getSO()).clearSegmentPolicy();
        }
        String string = "";
        String string2 = "";
        boolean bl = false;
        boolean bl2 = false;
        if (!this._go.growByTextField.getText().equals("") && !(string = this._go.growByTextField.getText() + this.getUnitSuffix(this._go.growByUnitComboBox.getSelectedIndex())).equals(this._initialValues.get("g"))) {
            bl = true;
        }
        if (!this._go.maxSizeTextField.getText().equals("") && !(string2 = this._go.maxSizeTextField.getText() + this.getUnitSuffix(this._go.maxSizeUnitComboBox.getSelectedIndex())).equals(this._initialValues.get("m"))) {
            bl2 = true;
        }
        if (bl || bl2) {
            if (bl) {
                if (this._growByDefault) {
                    ((SegmentSO)this.getSO()).setAutoExpansionAttributes("", string);
                } else {
                    ((SegmentSO)this.getSO()).modifyAutoExpansionAttributes("", string);
                }
            }
            if (bl2) {
                if (this._maxSizeDefault) {
                    ((SegmentSO)this.getSO()).setAutoExpansionAttributes(string2, "");
                } else {
                    ((SegmentSO)this.getSO()).modifyAutoExpansionAttributes(string2, "");
                }
            }
        }
        if (this._go.disableCheckBox.isSelected()) {
            if (!this._policyDisabled) {
                ((SegmentSO)this.getSO()).disableSegmentPolicy();
            }
        } else if (this._policyDisabled) {
            ((SegmentSO)this.getSO()).enableSegmentPolicy();
        }
        return true;
    }

    private String getUnitSuffix(int n) {
        String string = null;
        switch (n) {
            case 0: {
                string = "p";
                break;
            }
            case 1: {
                string = "k";
                break;
            }
            case 2: {
                string = "m";
                break;
            }
            case 3: {
                string = "g";
                break;
            }
            case 4: {
                string = "%";
            }
        }
        return string;
    }

    @Override
    public void releaseResources() {
        if (null != this._go) {
            this.removeListeners();
            this._go.releaseResources();
            this._go = null;
        }
        super.releaseResources();
    }
}

