/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.aseplugin.bo.prop;

import com.sybase.aseplugin.ASEUtils;
import com.sybase.aseplugin.bo.ContainerViewBO;
import com.sybase.aseplugin.bo.DatabaseBO;
import com.sybase.aseplugin.bo.DatabasesCtrBO;
import com.sybase.aseplugin.bo.GroupBO;
import com.sybase.aseplugin.bo.ProceduresCtrBO;
import com.sybase.aseplugin.bo.RoleBO;
import com.sybase.aseplugin.bo.ServerBO;
import com.sybase.aseplugin.bo.UserBO;
import com.sybase.aseplugin.bo.prop.ASEBasePropertiesPage2;
import com.sybase.aseplugin.bo.prop.StoredProcedureProperties;
import com.sybase.aseplugin.go.prop.PropGOPermissionPage;
import com.sybase.aseplugin.so.StoredProcedureSO;
import com.sybase.aseplugin.util.perm.JPermissionGrid;
import com.sybase.aseplugin.util.perm.PermissionHelper;
import com.sybase.aseplugin.util.ui.MyCellRenderer;
import com.sybase.aseplugin.util.ui.TableSelectionListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.sql.SQLException;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;

class StoredProcedurePropPermissionPage
extends ASEBasePropertiesPage2
implements ActionListener {
    private JPermissionGrid _grid;
    private PropGOPermissionPage _go = (PropGOPermissionPage)((Object)this.getJPanel());

    public StoredProcedurePropPermissionPage(StoredProcedureProperties storedProcedureProperties) {
        super(storedProcedureProperties, (JPanel)((Object)new PropGOPermissionPage()), ASEUtils.getString("MSG_PERMISSIONS"));
        this.initComboBox();
        this._go.permissionComboBox.addActionListener((ActionListener)this);
        this._go.propertiesButton.addActionListener((ActionListener)this);
    }

    @Override
    public String getHelpID() {
        return "HELP_STORED_PROCEDURE_PROP_PERMISSIONS_1252";
    }

    @Override
    public void init() throws SQLException {
        this._grid = new JPermissionGrid(this.getParent().getJDialog(), ((StoredProcedureSO)this.getSO()).getConnection());
        this._go.objectsScrollPane.getViewport().setView(this._grid.getTable());
        this.addKeyboardActions();
        this.addMouseActions();
        TableSelectionListener tableSelectionListener = new TableSelectionListener(){

            @Override
            public void deSelectAction() {
                ((StoredProcedurePropPermissionPage)StoredProcedurePropPermissionPage.this)._go.propertiesButton.setEnabled(false);
            }

            @Override
            public void selectAction() {
                ((StoredProcedurePropPermissionPage)StoredProcedurePropPermissionPage.this)._go.propertiesButton.setEnabled(true);
            }
        };
        this._go.propertiesButton.setEnabled(false);
        this._grid.getTable().getSelectionModel().addListSelectionListener(tableSelectionListener);
        ((StoredProcedureSO)this.getSO()).setUserPermissionList();
        ((StoredProcedureSO)this.getSO()).setGroupPermissionList();
        ((StoredProcedureSO)this.getSO()).setRolePermissionList();
        ((StoredProcedureSO)this.getSO()).setGroupListPermissionList();
        ((StoredProcedureSO)this.getSO()).setPublicListPermissionList();
        PermissionHelper.mergePublicPermission(((StoredProcedureSO)this.getSO()).getGroupListPermissionList(), ((StoredProcedureSO)this.getSO()).getPublicListPermissionList());
        this.refreshScreen();
    }

    private void initComboBox() {
        this._go.permissionComboBox.setRenderer((ListCellRenderer)new MyCellRenderer());
        ImageIcon imageIcon = UserBO.USER_ICON;
        ImageIcon imageIcon2 = GroupBO.GROUP_ICON;
        ImageIcon imageIcon3 = RoleBO.ROLE_ICON;
        this._go.permissionComboBox.clear();
        this._go.permissionComboBox.addItem((Object)new JLabel(ASEUtils.getString("DNAME_USERS"), imageIcon, 2));
        this._go.permissionComboBox.addItem((Object)new JLabel(ASEUtils.getString("DNAME_GROUPS"), imageIcon2, 2));
        this._go.permissionComboBox.addItem((Object)new JLabel(ASEUtils.getString("DNAME_ROLES"), imageIcon3, 2));
    }

    public void refreshScreen() {
        String string = ((JLabel)this._go.permissionComboBox.getSelectedItem()).getText();
        if (string.equals(ASEUtils.getString("DNAME_USERS"))) {
            this._grid.fillUserList(((StoredProcedureSO)this.getSO()).getUserPermissionList(), ((StoredProcedureSO)this.getSO()).getGroupListPermissionList());
        } else if (string.equals(ASEUtils.getString("DNAME_GROUPS"))) {
            this._grid.fillGroupList(((StoredProcedureSO)this.getSO()).getGroupPermissionList(), ((StoredProcedureSO)this.getSO()).getPublicListPermissionList());
        } else if (string.equals(ASEUtils.getString("DNAME_ROLES"))) {
            this._grid.fillRoleList(((StoredProcedureSO)this.getSO()).getRolePermissionList());
        }
        this._go.propertiesButton.setEnabled(false);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this._go.propertiesButton) {
            int n = this._go.permissionComboBox.getSelectedIndex();
            int[] nArray = this._grid.getTable().getSelectedRows();
            DatabaseBO databaseBO = (DatabaseBO)((ProceduresCtrBO)this.getParentCtr()).getParent();
            for (int i = 0; i < nArray.length; ++i) {
                String string;
                if (n == 0) {
                    string = (String)this._grid.getTable().getValueAt(nArray[i], 0);
                    ContainerViewBO.openUserProperties(databaseBO, string);
                } else if (n == 1) {
                    string = (String)this._grid.getTable().getValueAt(nArray[i], 0);
                    ContainerViewBO.openGroupProperties(databaseBO, string);
                }
                if (n != 2) continue;
                string = (String)this._grid.getTable().getValueAt(nArray[i], 0);
                ServerBO serverBO = (ServerBO)((DatabasesCtrBO)databaseBO.getParent()).getParent();
                ContainerViewBO.openRoleProperties(serverBO, string);
            }
        } else {
            this.refreshScreen();
        }
    }

    private void addKeyboardActions() {
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = StoredProcedurePropPermissionPage.this._grid.getTable().getSelectedRow();
                int n2 = StoredProcedurePropPermissionPage.this._grid.getTable().getSelectedColumn();
                if (n2 > 0) {
                    StoredProcedurePropPermissionPage.this._grid.onClickedCell(n, n2);
                    StoredProcedurePropPermissionPage.this.enableApplyButton(true);
                }
            }
        };
        this._grid.getTable().registerKeyboardAction(actionListener, KeyStroke.getKeyStroke(10, 0), 0);
        this._grid.getTable().registerKeyboardAction(actionListener, KeyStroke.getKeyStroke(32, 0), 0);
    }

    private void addMouseActions() {
        MouseAdapter mouseAdapter = new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                int n = StoredProcedurePropPermissionPage.this._grid.getTable().columnAtPoint(mouseEvent.getPoint());
                int n2 = StoredProcedurePropPermissionPage.this._grid.getTable().rowAtPoint(mouseEvent.getPoint());
                if (n2 < 0 || n < 0) {
                    return;
                }
                if (n > 0) {
                    StoredProcedurePropPermissionPage.this._grid.onClickedCell(n2, n);
                    StoredProcedurePropPermissionPage.this.enableApplyButton(true);
                }
            }
        };
        this._grid.getTable().addMouseListener(mouseAdapter);
    }

    @Override
    public boolean deploy() {
        this._grid.savePermission((StoredProcedureSO)this.getSO(), ((StoredProcedureSO)this.getSO()).getDatabaseName());
        return true;
    }

    @Override
    public void releaseResources() {
        if (null != this._go) {
            this._go.permissionComboBox.removeActionListener((ActionListener)this);
            this._go.propertiesButton.removeActionListener((ActionListener)this);
            this._go.releaseResources();
            this._go = null;
        }
        super.releaseResources();
    }
}

