/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.aseplugin.bo.prop;

import com.sybase.aseplugin.ASEUtils;
import com.sybase.aseplugin.bo.ContainerViewBO;
import com.sybase.aseplugin.bo.DatabaseBO;
import com.sybase.aseplugin.bo.DatabasesCtrBO;
import com.sybase.aseplugin.bo.GroupBO;
import com.sybase.aseplugin.bo.RoleBO;
import com.sybase.aseplugin.bo.ServerBO;
import com.sybase.aseplugin.bo.TablesCtrBO;
import com.sybase.aseplugin.bo.UserBO;
import com.sybase.aseplugin.bo.prop.ASEBasePropertiesPage2;
import com.sybase.aseplugin.bo.prop.TableProperties;
import com.sybase.aseplugin.go.prop.PropGOPermissionPage;
import com.sybase.aseplugin.so.TableSO;
import com.sybase.aseplugin.util.perm.JPermissionGrid;
import com.sybase.aseplugin.util.perm.PermissionHelper;
import com.sybase.aseplugin.util.ui.MyCellRenderer;
import com.sybase.aseplugin.util.ui.TableSelectionListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.sql.SQLException;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;

class TablePropPermissionPage
extends ASEBasePropertiesPage2
implements ActionListener {
    private static final int COMBO_USERS = 0;
    private static final int COMBO_GROUPS = 1;
    private static final int COMBO_ROLES = 2;
    private JPermissionGrid _grid;
    private PropGOPermissionPage _go = (PropGOPermissionPage)((Object)this.getJPanel());

    public TablePropPermissionPage(TableProperties tableProperties) {
        super(tableProperties, (JPanel)((Object)new PropGOPermissionPage()), ASEUtils.getString("MSG_PERMISSIONS"));
        this.initComboBox();
        this._go.permissionComboBox.addActionListener((ActionListener)this);
        this._go.propertiesButton.addActionListener((ActionListener)this);
    }

    @Override
    public void init() throws SQLException {
        this._grid = new JPermissionGrid(this.getParent().getJDialog(), ((TableSO)this.getSO()).getConnection());
        this._go.objectsScrollPane.getViewport().setView(this._grid.getTable());
        this.addKeyboardActions();
        this.addMouseActions();
        TableSelectionListener tableSelectionListener = new TableSelectionListener(){

            @Override
            public void deSelectAction() {
                ((TablePropPermissionPage)TablePropPermissionPage.this)._go.propertiesButton.setEnabled(false);
            }

            @Override
            public void selectAction() {
                ((TablePropPermissionPage)TablePropPermissionPage.this)._go.propertiesButton.setEnabled(true);
            }
        };
        this._go.propertiesButton.setEnabled(false);
        this._grid.getTable().getSelectionModel().addListSelectionListener(tableSelectionListener);
        ((TableSO)this.getSO()).setUserPermissionList();
        ((TableSO)this.getSO()).setGroupPermissionList();
        ((TableSO)this.getSO()).setRolePermissionList();
        ((TableSO)this.getSO()).setGroupListPermissionList();
        ((TableSO)this.getSO()).setPublicListPermissionList();
        PermissionHelper.mergePublicPermission(((TableSO)this.getSO()).getGroupListPermissionList(), ((TableSO)this.getSO()).getPublicListPermissionList());
        this.refreshScreen();
    }

    @Override
    public String getHelpID() {
        return "HELP_TABLE_PROP_PERMISSIONS_1252";
    }

    private void initComboBox() {
        this._go.permissionComboBox.setRenderer((ListCellRenderer)new MyCellRenderer());
        ImageIcon imageIcon = UserBO.USER_ICON;
        ImageIcon imageIcon2 = GroupBO.GROUP_ICON;
        ImageIcon imageIcon3 = RoleBO.ROLE_ICON;
        this._go.permissionComboBox.clear();
        this._go.permissionComboBox.addItem((Object)new JLabel(ASEUtils.getString("DNAME_USERS"), imageIcon, 2));
        this._go.permissionComboBox.addItem((Object)new JLabel(ASEUtils.getString("DNAME_GROUPS"), imageIcon2, 2));
        this._go.permissionComboBox.addItem((Object)new JLabel(ASEUtils.getString("DNAME_ROLES"), imageIcon3, 2));
        this._go.permissionComboBox.setSelectedIndex(0);
    }

    private void refreshScreen() {
        int n = this._go.permissionComboBox.getSelectedIndex();
        if (n == 0) {
            this._grid.fillUserList(((TableSO)this.getSO()).getUserPermissionList(), ((TableSO)this.getSO()).getGroupListPermissionList());
        } else if (n == 1) {
            this._grid.fillGroupList(((TableSO)this.getSO()).getGroupPermissionList(), ((TableSO)this.getSO()).getPublicListPermissionList());
        } else if (n == 2) {
            this._grid.fillRoleList(((TableSO)this.getSO()).getRolePermissionList());
        }
        this._go.propertiesButton.setEnabled(false);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this._go.propertiesButton) {
            String string;
            int n;
            int n2 = this._go.permissionComboBox.getSelectedIndex();
            int[] nArray = this._grid.getTable().getSelectedRows();
            TablesCtrBO tablesCtrBO = (TablesCtrBO)this.getParentCtr();
            DatabaseBO databaseBO = (DatabaseBO)tablesCtrBO.getParent();
            if (n2 == 0) {
                for (n = 0; n < nArray.length; ++n) {
                    string = (String)this._grid.getTable().getValueAt(nArray[n], 0);
                    ContainerViewBO.openUserProperties(databaseBO, string);
                }
            }
            if (n2 == 1) {
                for (n = 0; n < nArray.length; ++n) {
                    string = (String)this._grid.getTable().getValueAt(nArray[n], 0);
                    ContainerViewBO.openGroupProperties(databaseBO, string);
                }
            }
            if (n2 == 2) {
                for (n = 0; n < nArray.length; ++n) {
                    string = (String)this._grid.getTable().getValueAt(nArray[n], 0);
                    DatabasesCtrBO databasesCtrBO = (DatabasesCtrBO)databaseBO.getParent();
                    ServerBO serverBO = (ServerBO)databasesCtrBO.getParent();
                    ContainerViewBO.openRoleProperties(serverBO, string);
                }
            }
        } else {
            this.refreshScreen();
        }
    }

    private void addKeyboardActions() {
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = TablePropPermissionPage.this._grid.getTable().getSelectedRow();
                int n2 = TablePropPermissionPage.this._grid.getTable().getSelectedColumn();
                if (n2 > 0) {
                    TablePropPermissionPage.this._grid.onClickedCell(n, n2);
                    TablePropPermissionPage.this.enableApplyButton(true);
                }
            }
        };
        this._grid.getTable().registerKeyboardAction(actionListener, KeyStroke.getKeyStroke(10, 0), 0);
        this._grid.getTable().registerKeyboardAction(actionListener, KeyStroke.getKeyStroke(32, 0), 0);
    }

    private void addMouseActions() {
        MouseAdapter mouseAdapter = new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                int n = TablePropPermissionPage.this._grid.getTable().columnAtPoint(mouseEvent.getPoint());
                int n2 = TablePropPermissionPage.this._grid.getTable().rowAtPoint(mouseEvent.getPoint());
                if (n2 < 0 || n < 0) {
                    return;
                }
                if (n > 0) {
                    TablePropPermissionPage.this._grid.onClickedCell(n2, n);
                    TablePropPermissionPage.this.enableApplyButton(true);
                }
            }
        };
        this._grid.getTable().addMouseListener(mouseAdapter);
    }

    @Override
    public boolean deploy() {
        boolean bl = this._grid.savePermission((TableSO)this.getSO(), ((TableSO)this.getSO()).getDatabaseName());
        return bl;
    }

    @Override
    public void releaseResources() {
        if (null != this._go) {
            this._go.permissionComboBox.removeActionListener((ActionListener)this);
            this._go.propertiesButton.removeActionListener((ActionListener)this);
            this._go.releaseResources();
            this._go = null;
        }
        super.releaseResources();
    }
}

