/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.aseplugin.bo.prop;

import com.sybase.asa.ASAIconTextData;
import com.sybase.aseplugin.ASEUtils;
import com.sybase.aseplugin.bo.ContainerViewBO;
import com.sybase.aseplugin.bo.DatabaseBO;
import com.sybase.aseplugin.bo.SegmentBO;
import com.sybase.aseplugin.bo.Support;
import com.sybase.aseplugin.bo.TablesCtrBO;
import com.sybase.aseplugin.bo.prop.ASEBasePropertiesPage2;
import com.sybase.aseplugin.bo.prop.TableProperties;
import com.sybase.aseplugin.go.prop.TablePropGOUsagePage;
import com.sybase.aseplugin.so.SegmentSO;
import com.sybase.aseplugin.so.TableSO;
import com.sybase.aseplugin.so.Utility;
import com.sybase.aseplugin.sql.ASConnection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JPanel;

class TablePropUsagePage
extends ASEBasePropertiesPage2
implements ActionListener {
    private TablePropGOUsagePage _go = (TablePropGOUsagePage)((Object)this.getJPanel());
    private double _reservedNum;
    private double _dataNum;
    private double _indexNum;
    private double _unusedNum;

    public TablePropUsagePage(TableProperties tableProperties) {
        super(tableProperties, (JPanel)((Object)new TablePropGOUsagePage()), ASEUtils.getString("MSG_USAGE"));
    }

    @Override
    public String getHelpID() {
        return "HELP_TABLE_PROP_SPACE_1252";
    }

    @Override
    public void init() throws SQLException {
        this.removeListeners();
        Support.fillUnitList((JComboBox)this._go.showInComboBox);
        this._go.showInComboBox.setSelectedIndex(1);
        if (((TableSO)this.getSO()).isSystemTable()) {
            this._go.segmentComboBox.setEnabled(false);
        }
        ((TableSO)this.getSO()).refreshAllocations();
        String string = ((TableSO)this.getSO()).getReserveSpace();
        String string2 = ((TableSO)this.getSO()).getSpaceUsedByData();
        String string3 = ((TableSO)this.getSO()).getSpaceUsedByIndex();
        String string4 = ((TableSO)this.getSO()).getUnusedSpace();
        if (!string.equals("")) {
            this._reservedNum = Double.valueOf(string);
        }
        if (!string2.equals("")) {
            this._dataNum = Double.valueOf(string2);
        }
        if (!string3.equals("")) {
            this._indexNum = Double.valueOf(string3);
        }
        if (!string4.equals("")) {
            this._unusedNum = Double.valueOf(string4);
        }
        String string5 = " " + ASEUtils.getString("MSG_KB");
        this._go.spaceReservedTextLabel.setText(this._reservedNum + string5);
        this._go.usedByDataTextLabel.setText(this._dataNum + string5);
        this._go.usedByIndexTextLabel.setText(this._indexNum + string5);
        this._go.unusedTextLabel.setText(this._unusedNum + string5);
        this._go.rowsTextLabel.setText(((TableSO)this.getSO()).getRowCount());
        this.initSegments();
        this.addListeners();
    }

    private void removeListeners() {
        this._go.segmentComboBox.removeActionListener((ActionListener)this);
        this._go.showInComboBox.removeActionListener((ActionListener)this);
        this._go.propertiesButton.removeActionListener((ActionListener)this);
    }

    private void addListeners() {
        this._go.segmentComboBox.addActionListener((ActionListener)this);
        this._go.showInComboBox.addActionListener((ActionListener)this);
        this._go.propertiesButton.addActionListener((ActionListener)this);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this._go.showInComboBox) {
            this.updateSpaceText();
        } else if (actionEvent.getSource() == this._go.propertiesButton) {
            String string = this._go.segmentComboBox.getSelectedItem().toString();
            TablesCtrBO tablesCtrBO = (TablesCtrBO)this.getParentCtr();
            DatabaseBO databaseBO = (DatabaseBO)tablesCtrBO.getParent();
            ContainerViewBO.openSegmentProperties(databaseBO, string);
        } else if (actionEvent.getSource() == this._go.segmentComboBox) {
            this.enableApplyButton(true);
        }
    }

    private void updateSpaceText() {
        int n = this._go.showInComboBox.getSelectedIndex();
        String string = " " + ASEUtils.getString("MSG_PAGES");
        String string2 = " " + ASEUtils.getString("MSG_KB");
        String string3 = " " + ASEUtils.getString("MSG_MB");
        String string4 = " " + ASEUtils.getString("MSG_GB");
        ASConnection aSConnection = this.getConnection();
        if (n == 0) {
            this._go.spaceReservedTextLabel.setText(String.valueOf(Utility.getPrecision(Utility.getKBToPageSize(aSConnection, this._reservedNum), 2)) + string);
            this._go.usedByDataTextLabel.setText(String.valueOf(Utility.getPrecision(Utility.getKBToPageSize(aSConnection, this._dataNum), 2)) + string);
            this._go.usedByIndexTextLabel.setText(String.valueOf(Utility.getPrecision(Utility.getKBToPageSize(aSConnection, this._indexNum), 2)) + string);
            this._go.unusedTextLabel.setText(String.valueOf(Utility.getPrecision(Utility.getKBToPageSize(aSConnection, this._unusedNum), 2)) + string);
        } else if (n == 1) {
            this._go.spaceReservedTextLabel.setText(String.valueOf(Utility.getPrecision(this._reservedNum, 2)) + string2);
            this._go.usedByDataTextLabel.setText(String.valueOf(Utility.getPrecision(this._dataNum, 2)) + string2);
            this._go.usedByIndexTextLabel.setText(String.valueOf(Utility.getPrecision(this._indexNum, 2)) + string2);
            this._go.unusedTextLabel.setText(String.valueOf(Utility.getPrecision(this._unusedNum, 2)) + string2);
        } else if (n == 2) {
            this._go.spaceReservedTextLabel.setText(String.valueOf(Utility.getPrecision(Utility.getKBToMB(this._reservedNum), 2)) + string3);
            this._go.usedByDataTextLabel.setText(String.valueOf(Utility.getPrecision(Utility.getKBToMB(this._dataNum), 2)) + string3);
            this._go.usedByIndexTextLabel.setText(String.valueOf(Utility.getPrecision(Utility.getKBToMB(this._indexNum), 2)) + string3);
            this._go.unusedTextLabel.setText(String.valueOf(Utility.getPrecision(Utility.getKBToMB(this._unusedNum), 2)) + string3);
        } else {
            this._go.spaceReservedTextLabel.setText(String.valueOf(Utility.getPrecision(Utility.getKBToGB(this._reservedNum), 4)) + string4);
            this._go.usedByDataTextLabel.setText(String.valueOf(Utility.getPrecision(Utility.getKBToGB(this._dataNum), 4)) + string4);
            this._go.usedByIndexTextLabel.setText(String.valueOf(Utility.getPrecision(Utility.getKBToGB(this._indexNum), 4)) + string4);
            this._go.unusedTextLabel.setText(String.valueOf(Utility.getPrecision(Utility.getKBToGB(this._unusedNum), 4)) + string4);
        }
    }

    private void initSegments() throws SQLException {
        List list = ((TableSO)this.getSO()).getAvailableSegments();
        this._go.segmentComboBox.clear();
        for (SegmentSO segmentSO : list) {
            String string = segmentSO.getName();
            ASAIconTextData aSAIconTextData = new ASAIconTextData((Icon)SegmentBO.SEGMENT_ICON, string);
            this._go.segmentComboBox.addItem((Object)aSAIconTextData);
        }
        String string = ((TableSO)this.getSO()).getSegmentName();
        this._go.segmentComboBox.setSelectedItem(string);
    }

    @Override
    public boolean deploy() throws SQLException {
        String string;
        String string2 = ((TableSO)this.getSO()).getSegmentName();
        String string3 = this._go.segmentComboBox.getSelectedItem().toString();
        if (!string3.equals(string2) && (string = ((TableSO)this.getSO()).bindToSegment(string3)).length() > 0) {
            Support.showWarning(this.getConnection(), this.getClass(), this.getJDialog(), string);
        }
        return true;
    }

    @Override
    public void releaseResources() {
        if (null != this._go) {
            this.removeListeners();
            this._go.releaseResources();
            this._go = null;
        }
        super.releaseResources();
    }
}

