/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.aseplugin.bo.prop;

import com.sybase.aseplugin.ASEUtils;
import com.sybase.aseplugin.bo.ContainerViewBO;
import com.sybase.aseplugin.bo.DatabaseBO;
import com.sybase.aseplugin.bo.ServerBO;
import com.sybase.aseplugin.bo.Support;
import com.sybase.aseplugin.bo.TempDBGroupBO;
import com.sybase.aseplugin.bo.dlg.AddTempDBDialog;
import com.sybase.aseplugin.bo.prop.ASEBasePropertiesPage2;
import com.sybase.aseplugin.bo.prop.TempDBGroupProperties;
import com.sybase.aseplugin.go.prop.TempDBGroupDBsPropGOPage;
import com.sybase.aseplugin.so.TempDBGroupSO;
import com.sybase.aseplugin.so.TempDBSO;
import com.sybase.aseplugin.sql.ASConnection;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;

class TempDatabaseGroupDBsListBOPage
extends ASEBasePropertiesPage2
implements ActionListener,
ListSelectionListener,
TableModelListener {
    private TempDBGroupDBsPropGOPage _go = (TempDBGroupDBsPropGOPage)((Object)this.getJPanel());
    private Vector _databases;
    private Vector _removeDBs;
    private boolean _isCluster = false;
    private boolean _inited = false;

    public TempDatabaseGroupDBsListBOPage(TempDBGroupProperties tempDBGroupProperties) {
        super(tempDBGroupProperties, (JPanel)((Object)new TempDBGroupDBsPropGOPage()), ASEUtils.getString("DNAME_DATABASES"));
        ServerBO serverBO = ContainerViewBO.getServerBO(this.getConnection());
        this._isCluster = serverBO.isCluster();
        if (this._isCluster) {
            Vector<String> vector = new Vector<String>();
            vector.addElement(ASEUtils.getString("DISP_NAME_TEXT"));
            vector.addElement(ASEUtils.getString("DNAME_SDC_INSTANCE_NAME"));
            this._go.dbList.setColumnHeadings(vector);
        }
    }

    @Override
    public String getHelpID() {
        return "HELP_TEMPORARY_DATABASE_GROUP_PROP_DATABASES_1252";
    }

    @Override
    public void init() throws SQLException {
        this._go.removeButton.setEnabled(false);
        this._databases = ((TempDBGroupSO)this.getSO()).getDatabases();
        this._removeDBs = new Vector();
        this._go.dbList.clear();
        if (this._isCluster) {
            TempDBGroupBO tempDBGroupBO = (TempDBGroupBO)this.getParentCtr();
            if (!tempDBGroupBO.isOpened()) {
                tempDBGroupBO.open(1);
            }
            Enumeration enumeration = tempDBGroupBO.getItems();
            while (enumeration.hasMoreElements()) {
                DatabaseBO databaseBO = (DatabaseBO)enumeration.nextElement();
                TempDBSO tempDBSO = (TempDBSO)databaseBO.getSO();
                this._go.dbList.addRow(new Object[]{tempDBSO.getName(), tempDBSO.getSDCInstanceName()});
            }
        } else {
            for (int i = 0; i < this._databases.size(); ++i) {
                this._go.dbList.addRow(new Object[]{this._databases.elementAt(i)});
            }
        }
        if (!this._inited) {
            this._inited = true;
            this.addListeners();
        }
        this.enableButtonState();
    }

    private void addListeners() {
        this._go.dbList.getModel().addTableModelListener(this);
        this._go.removeButton.addActionListener((ActionListener)this);
        this._go.dbList.addListSelectionListener((ListSelectionListener)this);
        this._go.addButton.addActionListener((ActionListener)this);
    }

    private void removeListeners() {
        this._go.dbList.getModel().removeTableModelListener(this);
        this._go.removeButton.removeActionListener((ActionListener)this);
        this._go.dbList.removeListSelectionListener((ListSelectionListener)this);
        this._go.addButton.removeActionListener((ActionListener)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean deploy() throws SQLException {
        if (this._isCluster) {
            ASConnection aSConnection;
            TempDBSO tempDBSO;
            DatabaseBO databaseBO;
            ServerBO serverBO;
            String string;
            Object object;
            int n;
            for (n = 0; n < this._removeDBs.size(); ++n) {
                String string2;
                object = (Object[])this._removeDBs.elementAt(n);
                string = (String)object[0];
                if (this.isTempDBInGOList(string, string2 = (String)object[1])) continue;
                serverBO = ContainerViewBO.getServerBO(this.getConnection());
                databaseBO = ContainerViewBO.getSDCLocalTempDBBO(serverBO, string2, string);
                tempDBSO = (TempDBSO)databaseBO.getSO();
                aSConnection = tempDBSO.getConnection();
                try {
                    tempDBSO.setConnection(this.getConnection());
                    tempDBSO.removeDBFromGroup(this.getSO().getName());
                    continue;
                }
                finally {
                    tempDBSO.setConnection(aSConnection);
                }
            }
            for (n = 0; n < this._go.dbList.getRowCount(); ++n) {
                object = (String)this._go.dbList.getValueAt(n, 0);
                string = (String)this._go.dbList.getValueAt(n, 1);
                int n2 = this.arrayFoundInVector(new String[]{object, string}, this._databases);
                if (n2 >= 0) continue;
                serverBO = ContainerViewBO.getServerBO(this.getConnection());
                databaseBO = ContainerViewBO.getSDCLocalTempDBBO(serverBO, string, (String)object);
                tempDBSO = (TempDBSO)databaseBO.getSO();
                aSConnection = tempDBSO.getConnection();
                try {
                    tempDBSO.setConnection(this.getConnection());
                    tempDBSO.addDBToGroup(this.getSO().getName());
                    continue;
                }
                finally {
                    tempDBSO.setConnection(aSConnection);
                }
            }
            ((TempDBGroupBO)this.getParentCtr()).close();
        } else {
            String string;
            int n;
            for (n = 0; n < this._removeDBs.size(); ++n) {
                string = (String)this._removeDBs.elementAt(n);
                if (this.isTempDBInGOList(string, null)) continue;
                ((TempDBGroupSO)this.getSO()).removeDatabase(string);
            }
            for (n = 0; n < this._go.dbList.getRowCount(); ++n) {
                string = (String)this._go.dbList.getValueAt(n, 0);
                if (this._databases.contains(string)) continue;
                ((TempDBGroupSO)this.getSO()).addDatabase(string);
            }
        }
        return true;
    }

    boolean isTempDBInGOList(String string, String string2) {
        if (string2 == null) {
            for (int i = 0; i < this._go.dbList.getRowCount(); ++i) {
                String string3 = (String)this._go.dbList.getValueAt(i, 0);
                if (!string.equalsIgnoreCase(string3)) continue;
                return true;
            }
            return false;
        }
        for (int i = 0; i < this._go.dbList.getRowCount(); ++i) {
            String string4 = (String)this._go.dbList.getValueAt(i, 0);
            String string5 = (String)this._go.dbList.getValueAt(i, 1);
            if (!string.equalsIgnoreCase(string4) || !string2.equalsIgnoreCase(string5)) continue;
            return true;
        }
        return false;
    }

    private Vector getAvailableDatabases() {
        Vector vector = null;
        try {
            vector = ((TempDBGroupSO)this.getSO()).getAllTempDatabases();
        }
        catch (SQLException sQLException) {
            Support.showDetailsError(this.getConnection(), this.getClass(), (Container)this.getJDialog(), sQLException.getMessage(), sQLException);
        }
        if (this._isCluster) {
            for (int i = 0; i < this._go.dbList.getRowCount(); ++i) {
                String string = (String)this._go.dbList.getValueAt(i, 0);
                String string2 = (String)this._go.dbList.getValueAt(i, 1);
                Object[] objectArray = new String[]{string, string2};
                int n = this.arrayFoundInVector(objectArray, vector);
                if (n <= -1) continue;
                vector.remove(n);
            }
        } else {
            for (int i = 0; i < this._go.dbList.getRowCount(); ++i) {
                String string = (String)this._go.dbList.getValueAt(i, 0);
                Object[] objectArray = new String[]{string};
                int n = this.arrayFoundInVector(objectArray, vector);
                if (n <= -1) continue;
                vector.remove(n);
            }
        }
        return vector;
    }

    private void enableButtonState() {
        Vector vector = this.getAvailableDatabases();
        this._go.addButton.setEnabled(null != vector && vector.size() > 0);
        this._go.removeButton.setEnabled(this._go.dbList.getSelectedRows().length > 0);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this._go.removeButton) {
            this.doRemoveDB();
        } else if (object == this._go.addButton) {
            this.doAddDB();
        }
        this.enableButtonState();
    }

    private void doAddDB() {
        Vector vector = this.getAvailableDatabases();
        if (this._isCluster) {
            AddTempDBDialog.showDialog(((TempDBGroupProperties)this.getParent()).getJDialog(), this._go.dbList, vector, new String[]{ASEUtils.getString("DISP_NAME_TEXT"), ASEUtils.getString("DISP_SDC_INSTANCE_NAME")});
        } else {
            AddTempDBDialog.showDialog(((TempDBGroupProperties)this.getParent()).getJDialog(), this._go.dbList, vector);
        }
    }

    private void doRemoveDB() {
        int n = Support.showQuestionYesNo(this.getParent().getJDialog(), ASEUtils.getString("MSG_REMOVE_TEMPDB"));
        if (n == 0) {
            int[] nArray = this._go.dbList.getSelectedRows();
            for (int i = nArray.length - 1; i >= 0; --i) {
                String string = (String)this._go.dbList.getRow(nArray[i]).elementAt(0);
                if (this._isCluster) {
                    Vector vector = this._go.dbList.getRow(nArray[i]);
                    int n2 = this.arrayFoundInVector(vector.toArray(), this._databases);
                    if (n2 > -1 && this.arrayFoundInVector(vector.toArray(), this._removeDBs) == -1) {
                        this._removeDBs.addElement(vector.toArray());
                    }
                } else if (this._databases.contains(string) && !this._removeDBs.contains(string)) {
                    this._removeDBs.addElement(string);
                }
                this._go.dbList.removeRow(nArray[i]);
            }
            this._go.removeButton.setEnabled(false);
        }
    }

    private int arrayFoundInVector(Object[] objectArray, Vector vector) {
        if (vector.size() == 0) {
            return -1;
        }
        Object[] objectArray2 = (Object[])vector.elementAt(0);
        if (objectArray2.length != objectArray.length) {
            return -1;
        }
        for (int i = 0; i < vector.size(); ++i) {
            boolean bl = true;
            Object[] objectArray3 = (Object[])vector.elementAt(i);
            for (int j = 0; j < objectArray3.length; ++j) {
                if (objectArray[j].equals(objectArray3[j])) continue;
                bl = false;
            }
            if (!bl) continue;
            return i;
        }
        return -1;
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        int[] nArray = this._go.dbList.getSelectedRows();
        for (int i = nArray.length - 1; i >= 0; --i) {
            if (!((String)this._go.dbList.getRow(nArray[i]).elementAt(0)).equals("tempdb")) continue;
            this._go.removeButton.setEnabled(false);
            return;
        }
        this._go.removeButton.setEnabled(true);
    }

    @Override
    public void tableChanged(TableModelEvent tableModelEvent) {
        if (tableModelEvent.getType() == 1 || tableModelEvent.getType() == -1) {
            this.enableApplyButton(true);
        }
    }

    @Override
    public void releaseResources() {
        this.removeListeners();
        this._go.releaseResources();
        this._go = null;
        this._databases = null;
        this._removeDBs = null;
        super.releaseResources();
    }
}

