/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.aseplugin.bo.prop;

import com.sybase.asa.ASAIconTextUserData;
import com.sybase.aseplugin.ASEUtils;
import com.sybase.aseplugin.bo.ContainerViewBO;
import com.sybase.aseplugin.bo.LockBO;
import com.sybase.aseplugin.bo.RemoteServerBO;
import com.sybase.aseplugin.bo.ServerBO;
import com.sybase.aseplugin.bo.Support;
import com.sybase.aseplugin.bo.TransactionsCtrBO;
import com.sybase.aseplugin.bo.prop.ASEBasePropertiesDialog2;
import com.sybase.aseplugin.bo.prop.ASEBasePropertiesPage2;
import com.sybase.aseplugin.go.prop.TransactionPropGOPage1;
import com.sybase.aseplugin.go.prop.TransactionPropGOPage2;
import com.sybase.aseplugin.go.prop.TransactionPropGOPage3;
import com.sybase.aseplugin.go.prop.TransactionPropGOPage4;
import com.sybase.aseplugin.so.SOItemInterface;
import com.sybase.aseplugin.so.TransactionSO;
import com.sybase.central.SCContainer2;
import com.sybase.central.SCPageController;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class TransactionProperties
extends ASEBasePropertiesDialog2 {
    public TransactionProperties(TransactionSO transactionSO, SCContainer2 sCContainer2) {
        super((SOItemInterface)transactionSO, sCContainer2);
    }

    @Override
    public SCPageController[] getPages() {
        return new SCPageController[]{new TransactionPropGeneralPage(this), new TransactionPropStatePage(this), new TransactionPropRemoteServersPage(this), new TransactionPropLocksPage(this)};
    }

    class TransactionPropLocksPage
    extends ASEBasePropertiesPage2
    implements ActionListener,
    ListSelectionListener {
        private TransactionPropGOPage4 _go;

        public TransactionPropLocksPage(TransactionProperties transactionProperties2) {
            super(transactionProperties2, (JPanel)((Object)new TransactionPropGOPage4()), ASEUtils.getString("DNAME_LOCKS"));
            this._go = (TransactionPropGOPage4)((Object)this.getJPanel());
            this._go.propertiesButton.addActionListener((ActionListener)this);
            this._go.tableMultiList.addListSelectionListener((ListSelectionListener)this);
        }

        @Override
        public String getHelpID() {
            return "HELP_TRANSACTION_PROP_LOCKS_1252";
        }

        @Override
        public void init() throws SQLException {
            TransactionSO transactionSO = (TransactionSO)this.getSO();
            Vector vector = transactionSO.getLocks();
            for (int i = 0; i < vector.size(); ++i) {
                String[] stringArray = (String[])vector.elementAt(i);
                ASAIconTextUserData aSAIconTextUserData = new ASAIconTextUserData((Icon)LockBO.LOCK_ICON, stringArray[0]);
                this._go.tableMultiList.addRow(new Object[]{aSAIconTextUserData, stringArray[1], stringArray[2], stringArray[3]});
            }
            this._go.propertiesButton.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.showProperties();
        }

        private void showProperties() {
            int[] nArray = this._go.tableMultiList.getSelectedRows();
            TransactionsCtrBO transactionsCtrBO = (TransactionsCtrBO)this.getParentCtr();
            ServerBO serverBO = (ServerBO)transactionsCtrBO.getParent();
            for (int i = 0; i < nArray.length; ++i) {
                ContainerViewBO.openLockProperties(serverBO, (Object[])this._go.tableMultiList.getRowAsStringDataArray(nArray[i]));
            }
        }

        @Override
        public void enableComponents() {
            this.valueChanged(null);
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            boolean bl = this._go.tableMultiList.getSelectedRowCount() > 0;
            this._go.propertiesButton.setEnabled(bl);
        }

        @Override
        public void releaseResources() {
            this._go.propertiesButton.removeActionListener((ActionListener)this);
            this._go.tableMultiList.removeListSelectionListener((ListSelectionListener)this);
            this._go.releaseResources();
            this._go = null;
            super.releaseResources();
        }
    }

    class TransactionPropRemoteServersPage
    extends ASEBasePropertiesPage2
    implements ActionListener,
    ListSelectionListener {
        private TransactionPropGOPage3 _go;
        private String _sLocalServerName;

        public TransactionPropRemoteServersPage(TransactionProperties transactionProperties2) {
            super(transactionProperties2, (JPanel)((Object)new TransactionPropGOPage3()), ASEUtils.getString("DNAME_REMOTESERVERS"));
            this._go = (TransactionPropGOPage3)((Object)this.getJPanel());
            this._go.propertiesButton.addActionListener((ActionListener)this);
            this._go.tableMultiList.addListSelectionListener((ListSelectionListener)this);
        }

        @Override
        public String getHelpID() {
            return "HELP_TRANSACTION_PROP_REMOTE_SERVERS_1252";
        }

        @Override
        public void init() throws SQLException {
            TransactionsCtrBO transactionsCtrBO = (TransactionsCtrBO)this.getParentCtr();
            ServerBO serverBO = (ServerBO)transactionsCtrBO.getParent();
            this._sLocalServerName = serverBO.getSO().getName();
            Vector vector = ((TransactionSO)this.getSO()).getRemoteServers();
            for (int i = 0; i < vector.size(); ++i) {
                String string = (String)vector.elementAt(i);
                ASAIconTextUserData aSAIconTextUserData = string.equals("") ? new ASAIconTextUserData((Icon)ServerBO.SERVER_ICON, this._sLocalServerName) : new ASAIconTextUserData((Icon)RemoteServerBO.REMOTE_SERVER_ICON, string);
                this._go.tableMultiList.addRow(new Object[]{aSAIconTextUserData});
            }
            this._go.propertiesButton.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.showProperties();
        }

        private void showProperties() {
            int[] nArray = this._go.tableMultiList.getSelectedRows();
            TransactionsCtrBO transactionsCtrBO = (TransactionsCtrBO)this.getParentCtr();
            ServerBO serverBO = (ServerBO)transactionsCtrBO.getParent();
            for (int i = 0; i < nArray.length; ++i) {
                String string = this._go.tableMultiList.getStringAt(nArray[i], 0);
                if (string.equals(this._sLocalServerName)) {
                    ContainerViewBO.openServerProperties(serverBO);
                    continue;
                }
                ContainerViewBO.openRemoteServerProperties(serverBO, string);
            }
        }

        @Override
        public void enableComponents() {
            this.valueChanged(null);
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            boolean bl = this._go.tableMultiList.getSelectedRowCount() > 0;
            this._go.propertiesButton.setEnabled(bl);
        }

        @Override
        public void releaseResources() {
            this._go.propertiesButton.removeActionListener((ActionListener)this);
            this._go.tableMultiList.removeListSelectionListener((ListSelectionListener)this);
            this._go.releaseResources();
            this._go = null;
            super.releaseResources();
        }
    }

    class TransactionPropStatePage
    extends ASEBasePropertiesPage2
    implements ActionListener {
        private String _sAbort;
        private String _sCommit;
        private TransactionPropGOPage2 _go;

        public TransactionPropStatePage(TransactionProperties transactionProperties2) {
            super(transactionProperties2, (JPanel)((Object)new TransactionPropGOPage2()), ASEUtils.getString("DISP_STATE_TEXT"));
            this._sAbort = "Abort";
            this._sCommit = "Commit";
            this._go = (TransactionPropGOPage2)((Object)this.getJPanel());
            this._go.alterStateComboBox.addItem((Object)this._sAbort);
            this._go.alterStateComboBox.addItem((Object)this._sCommit);
            this._go.alterStateComboBox.addActionListener((ActionListener)this);
        }

        @Override
        public String getHelpID() {
            return "HELP_TRANSACTION_PROP_STATE_1252";
        }

        @Override
        public void init() {
            this._go.transactionStateTextLabel.setText(((TransactionSO)this.getSO()).getState());
            this._go.connectionTextLabel.setText(((TransactionSO)this.getSO()).getTransactionConnection());
            if (((TransactionSO)this.getSO()).getTransactionConnection().trim().compareTo("Attached") == 0) {
                this._go.alterStateComboBox.setEnabled(false);
                this.enableApplyButton(false);
            }
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.enableApplyButton(true);
        }

        @Override
        public boolean deploy() throws SQLException {
            int n = Support.showQuestionYesNoCancel((Container)((Object)this._go), ASEUtils.getString("ALTER_TRANS_STATE_WARN"));
            String string = (String)this._go.alterStateComboBox.getSelectedItem();
            if (string.equals(this._sAbort)) {
                switch (n) {
                    case 0: {
                        ((TransactionSO)this.getSO()).abortTransaction();
                        break;
                    }
                    case 1: {
                        ((TransactionSO)this.getSO()).abortTransaction();
                        ((TransactionSO)this.getSO()).cleanUpTransaction();
                    }
                }
            } else {
                switch (n) {
                    case 0: {
                        ((TransactionSO)this.getSO()).commitTransaction();
                        break;
                    }
                    case 1: {
                        ((TransactionSO)this.getSO()).abortTransaction();
                        ((TransactionSO)this.getSO()).cleanUpTransaction();
                    }
                }
            }
            return true;
        }

        @Override
        public void releaseResources() {
            this._go.alterStateComboBox.removeActionListener((ActionListener)this);
            this._go.releaseResources();
            this._go = null;
            super.releaseResources();
        }
    }

    class TransactionPropGeneralPage
    extends ASEBasePropertiesPage2 {
        private TransactionPropGOPage1 _go;

        public TransactionPropGeneralPage(TransactionProperties transactionProperties2) {
            super(transactionProperties2, (JPanel)((Object)new TransactionPropGOPage1()), ASEUtils.getString("MSG_GENERAL"));
            this._go = (TransactionPropGOPage1)((Object)this.getJPanel());
        }

        @Override
        public String getHelpID() {
            return "HELP_TRANSACTION_PROP_GENERAL_1252";
        }

        @Override
        public void init() {
            this._go.nameTextField.setText(((TransactionSO)this.getSO()).getXActName());
            this._go.coordinatorTextField.setText(((TransactionSO)this.getSO()).getCoordinator());
            this._go.transactionTypeTextField.setText(((TransactionSO)this.getSO()).getProgram());
            this._go.SPIDTextField.setText(((TransactionSO)this.getSO()).getSPID());
            this._go.startTimeTextField.setText(((TransactionSO)this.getSO()).getStartTime());
            this._go.LOIDTextField.setText(((TransactionSO)this.getSO()).getLOID());
            this._go.ownerTextField.setText("");
        }

        @Override
        public void releaseResources() {
            this._go.releaseResources();
            this._go = null;
            super.releaseResources();
        }
    }
}

