/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.aseplugin.bo.prop;

import com.sybase.aseplugin.ASEImages;
import com.sybase.aseplugin.ASEUtils;
import com.sybase.aseplugin.bo.ContainerViewBO;
import com.sybase.aseplugin.bo.DatabaseBO;
import com.sybase.aseplugin.bo.EncryptionKeysCtrBO;
import com.sybase.aseplugin.bo.UsersCtrBO;
import com.sybase.aseplugin.bo.prop.ASEBasePropertiesPage2;
import com.sybase.aseplugin.bo.prop.UserProperties;
import com.sybase.aseplugin.go.prop.PropGOPermissionPage;
import com.sybase.aseplugin.so.DatabaseSO;
import com.sybase.aseplugin.so.UserSO;
import com.sybase.aseplugin.util.perm.ESPPermission;
import com.sybase.aseplugin.util.perm.EncryptionKeyPermission;
import com.sybase.aseplugin.util.perm.JPermissionGrid;
import com.sybase.aseplugin.util.perm.PermissionHelper;
import com.sybase.aseplugin.util.perm.ProcedurePermission;
import com.sybase.aseplugin.util.perm.TablePermission;
import com.sybase.aseplugin.util.perm.ViewPermission;
import com.sybase.aseplugin.util.ui.MyCellRenderer;
import com.sybase.aseplugin.util.ui.TableSelectionListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.sql.SQLException;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;

class UserPropPermissionPage
extends ASEBasePropertiesPage2
implements ActionListener {
    private JPermissionGrid _grid;
    private PropGOPermissionPage _go = (PropGOPermissionPage)((Object)this.getJPanel());

    public UserPropPermissionPage(UserProperties userProperties) {
        super(userProperties, (JPanel)((Object)new PropGOPermissionPage()), ASEUtils.getString("MSG_OBJECT_PERMISSION"));
        this.initComboBox(this.getConnection().isEncryptedKeyEnabled());
        this._go.permissionComboBox.addActionListener((ActionListener)this);
        this._go.propertiesButton.addActionListener((ActionListener)this);
    }

    @Override
    public String getHelpID() {
        return "HELP_USER_PROP_OBJECT_PERMISSIONS_1253";
    }

    @Override
    public void init() throws SQLException {
        this._grid = new JPermissionGrid(this.getParent().getJDialog(), ((UserSO)this.getSO()).getConnection());
        this._go.objectsScrollPane.getViewport().setView(this._grid.getTable());
        this.addKeyboardActions();
        this.addMouseActions();
        TableSelectionListener tableSelectionListener = new TableSelectionListener(){

            @Override
            public void deSelectAction() {
                ((UserPropPermissionPage)UserPropPermissionPage.this)._go.propertiesButton.setEnabled(false);
            }

            @Override
            public void selectAction() {
                ((UserPropPermissionPage)UserPropPermissionPage.this)._go.propertiesButton.setEnabled(true);
            }
        };
        this._go.propertiesButton.setEnabled(false);
        this._grid.getTable().getSelectionModel().addListSelectionListener(tableSelectionListener);
        ((UserSO)this.getSO()).setPermissionLists(this.getConnection().isEncryptedKeyEnabled());
        ((UserSO)this.getSO()).setGroupPermissionList(this.getConnection().isEncryptedKeyEnabled());
        ((UserSO)this.getSO()).setPublicPermissionList();
        PermissionHelper.mergeTablePublicPermission(((UserSO)this.getSO()).getTableGroupPermissionList(), ((UserSO)this.getSO()).getPublicPermissionList());
        PermissionHelper.mergeProcedurePublicPermission(((UserSO)this.getSO()).getProcedureGroupPermissionList(), ((UserSO)this.getSO()).getPublicPermissionList());
        PermissionHelper.mergeViewPublicPermission(((UserSO)this.getSO()).getViewGroupPermissionList(), ((UserSO)this.getSO()).getPublicPermissionList());
        PermissionHelper.mergeESPPublicPermission(((UserSO)this.getSO()).getEspGroupPermissionList(), ((UserSO)this.getSO()).getPublicPermissionList());
        this.refreshScreen();
    }

    public void initComboBox(boolean bl) {
        this._go.permissionComboBox.setRenderer((ListCellRenderer)new MyCellRenderer());
        ImageIcon imageIcon = new ImageIcon(ASEImages.getTableSmallImage());
        ImageIcon imageIcon2 = new ImageIcon(ASEImages.getStoredProcedureSmallImage());
        ImageIcon imageIcon3 = new ImageIcon(ASEImages.getViewSmallImage());
        ImageIcon imageIcon4 = new ImageIcon(ASEImages.getEspSmallImage());
        ImageIcon imageIcon5 = new ImageIcon(ASEImages.getEncryptionKeySmallImage());
        this._go.permissionComboBox.clear();
        this._go.permissionComboBox.addItem((Object)new JLabel(ASEUtils.getString("DNAME_TABLES"), imageIcon, 2));
        this._go.permissionComboBox.addItem((Object)new JLabel(ASEUtils.getString("DNAME_STORED_PROCEDURES"), imageIcon2, 2));
        this._go.permissionComboBox.addItem((Object)new JLabel(ASEUtils.getString("DNAME_VIEWS"), imageIcon3, 2));
        this._go.permissionComboBox.addItem((Object)new JLabel(ASEUtils.getString("DNAME_ESPS"), imageIcon4, 2));
        if (bl) {
            this._go.permissionComboBox.addItem((Object)new JLabel(ASEUtils.getString("DNAME_ENCRYPTION_KEYS"), imageIcon5, 2));
        }
        this._go.permissionComboBox.setSelectedIndex(0);
    }

    public void refreshScreen() {
        int n = this._go.permissionComboBox.getSelectedIndex();
        if (n == 0) {
            this._grid.fillTableList(((UserSO)this.getSO()).getTablePermissionList(), ((UserSO)this.getSO()).getTableGroupPermissionList(), (UserSO)this.getSO());
        } else if (n == 1) {
            this._grid.fillProcedureList(((UserSO)this.getSO()).getProcedurePermissionList(), ((UserSO)this.getSO()).getProcedureGroupPermissionList(), (UserSO)this.getSO());
        } else if (n == 2) {
            this._grid.fillViewList(((UserSO)this.getSO()).getViewPermissionList(), ((UserSO)this.getSO()).getViewGroupPermissionList(), (UserSO)this.getSO());
        } else if (n == 3) {
            this._grid.fillESPList(((UserSO)this.getSO()).getEspPermissionList(), ((UserSO)this.getSO()).getEspGroupPermissionList(), (UserSO)this.getSO());
        } else if (n == 4) {
            this._grid.fillEncryptionKeyList(((UserSO)this.getSO()).getEncryptionKeyPermissionList(), ((UserSO)this.getSO()).getEncryptionKeyGroupPermissionList(), (UserSO)this.getSO());
        }
        this._go.propertiesButton.setEnabled(false);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this._go.propertiesButton) {
            int n = this._go.permissionComboBox.getSelectedIndex();
            int[] nArray = this._grid.getTable().getSelectedRows();
            DatabaseBO databaseBO = (DatabaseBO)((UsersCtrBO)this.getParentCtr()).getParent();
            if (n == 0) {
                for (int i = 0; i < nArray.length; ++i) {
                    String string = (String)this._grid.getTable().getValueAt(nArray[i], 0);
                    String string2 = ((TablePermission)((UserSO)this.getSO()).getTablePermissionList().elementAt(nArray[i])).getOwner();
                    ContainerViewBO.openTableProperties(databaseBO, string2, string);
                }
            } else if (n == 1) {
                for (int i = 0; i < nArray.length; ++i) {
                    String string = (String)this._grid.getTable().getValueAt(nArray[i], 0);
                    String string3 = ((ProcedurePermission)((UserSO)this.getSO()).getProcedurePermissionList().elementAt(nArray[i])).getOwner();
                    ContainerViewBO.openStoredProcedureProperties(databaseBO, string3, string);
                }
            } else if (n == 2) {
                for (int i = 0; i < nArray.length; ++i) {
                    String string = (String)this._grid.getTable().getValueAt(nArray[i], 0);
                    String string4 = ((ViewPermission)((UserSO)this.getSO()).getViewPermissionList().elementAt(nArray[i])).getOwner();
                    ContainerViewBO.openViewProperties(databaseBO, string4, string);
                }
            } else if (n == 3) {
                for (int i = 0; i < nArray.length; ++i) {
                    String string = (String)this._grid.getTable().getValueAt(nArray[i], 0);
                    String string5 = ((ESPPermission)((UserSO)this.getSO()).getEspPermissionList().elementAt(nArray[i])).getOwner();
                    ContainerViewBO.openESPProperties(databaseBO, string5, string);
                }
            } else if (n == 4) {
                for (int i = 0; i < nArray.length; ++i) {
                    String string = ((DatabaseSO)databaseBO.getSO()).getName();
                    String string6 = ((EncryptionKeyPermission)((UserSO)this.getSO()).getEncryptionKeyPermissionList().elementAt(nArray[i])).getOwner();
                    String string7 = (String)this._grid.getTable().getValueAt(nArray[i], 0);
                    EncryptionKeysCtrBO encryptionKeysCtrBO = new EncryptionKeysCtrBO(databaseBO);
                    ContainerViewBO.openEncryptionKeyProperties(encryptionKeysCtrBO, string, string6, string7);
                }
            }
        } else {
            this.refreshScreen();
        }
    }

    private void addKeyboardActions() {
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = UserPropPermissionPage.this._grid.getTable().getSelectedRow();
                int n2 = UserPropPermissionPage.this._grid.getTable().getSelectedColumn();
                if (n2 > 0) {
                    UserPropPermissionPage.this._grid.onClickedCell(n, n2);
                    UserPropPermissionPage.this.enableApplyButton(true);
                }
            }
        };
        this._grid.getTable().registerKeyboardAction(actionListener, KeyStroke.getKeyStroke(10, 0), 0);
        this._grid.getTable().registerKeyboardAction(actionListener, KeyStroke.getKeyStroke(32, 0), 0);
    }

    private void addMouseActions() {
        MouseAdapter mouseAdapter = new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                int n = UserPropPermissionPage.this._grid.getTable().columnAtPoint(mouseEvent.getPoint());
                int n2 = UserPropPermissionPage.this._grid.getTable().rowAtPoint(mouseEvent.getPoint());
                if (n2 < 0 || n < 0) {
                    return;
                }
                if (n > 0) {
                    UserPropPermissionPage.this._grid.onClickedCell(n2, n);
                    UserPropPermissionPage.this.enableApplyButton(true);
                }
            }
        };
        this._grid.getTable().addMouseListener(mouseAdapter);
    }

    @Override
    public boolean deploy() {
        this._grid.savePermission((UserSO)this.getSO(), ((UserSO)this.getSO()).getDatabaseName());
        return true;
    }

    @Override
    public void releaseResources() {
        if (null != this._go) {
            this._go.permissionComboBox.removeActionListener((ActionListener)this);
            this._go.propertiesButton.removeActionListener((ActionListener)this);
            this._go.releaseResources();
            this._go = null;
        }
        super.releaseResources();
    }
}

