/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.aseplugin.bo.wiz;

import com.sybase.aseplugin.ASEMessageText;
import com.sybase.aseplugin.ASEUtils;
import com.sybase.aseplugin.bo.BackupServersCtrBO;
import com.sybase.aseplugin.bo.ContainerViewBO;
import com.sybase.aseplugin.bo.SDCInstancesCtrBO;
import com.sybase.aseplugin.bo.ServerBO;
import com.sybase.aseplugin.bo.Support;
import com.sybase.aseplugin.bo.wiz.SDCClusterWizBOProgressPage;
import com.sybase.aseplugin.bo.wiz.SDCClusterWizard;
import com.sybase.aseplugin.bo.wiz.SDCClusterWizardSession;
import com.sybase.aseplugin.bo.wiz.SDCInstanceWizard;
import com.sybase.aseplugin.so.SDCClusterSO;
import com.sybase.aseplugin.so.SDCInstancesCtrSO;
import com.sybase.aseplugin.so.ServerSO;
import com.sybase.aseplugin.util.SDCMessageListener;
import javax.swing.SwingUtilities;

class AddInstanceThread
extends Thread {
    private SDCClusterWizard wizard;
    private SDCMessageListener messageListener;
    private SDCClusterWizBOProgressPage progressPage;
    private boolean running = false;

    protected void finalized() throws Throwable {
        this.wizard = null;
        this.messageListener = null;
        this.progressPage = null;
        super.finalize();
    }

    public boolean isRunning() {
        return this.running;
    }

    public AddInstanceThread(SDCInstanceWizard sDCInstanceWizard, SDCMessageListener sDCMessageListener, SDCClusterWizBOProgressPage sDCClusterWizBOProgressPage) {
        this.wizard = sDCInstanceWizard;
        this.messageListener = sDCMessageListener;
        this.progressPage = sDCClusterWizBOProgressPage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Object object;
        this.running = true;
        SDCClusterSO sDCClusterSO = (SDCClusterSO)this.wizard.getSO();
        SDCClusterWizardSession sDCClusterWizardSession = this.wizard.getClusterWizardSession();
        try {
            sDCClusterWizardSession.setMessageListener(this.messageListener);
            sDCClusterWizardSession.createInstance();
            object = (SDCInstancesCtrBO)this.wizard.getParent();
            SDCInstancesCtrSO sDCInstancesCtrSO = ((SDCInstancesCtrBO)object).getContainerSO();
            sDCInstancesCtrSO.refreshSDCInstances();
            ServerBO serverBO = ContainerViewBO.getServerBO(sDCInstancesCtrSO.getConnection());
            ServerSO serverSO = (ServerSO)serverBO.getSO();
            serverSO.refreshClusterConfiguration();
            serverSO.refreshBackupServer(false);
            serverSO.refreshMonitorServer(false);
            serverSO.refreshXPServer(false);
            final BackupServersCtrBO backupServersCtrBO = (BackupServersCtrBO)serverBO.getItem(ASEUtils.getString("DNAME_AUXILIARY_SERVERS"));
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    backupServersCtrBO.refresh();
                }
            });
        }
        catch (Exception exception) {
            this.progressPage.enableBackButton(true);
            this.progressPage.enableCancelButton(true);
            ASEMessageText aSEMessageText = new ASEMessageText(ASEUtils.getString("SDC_ERROR_CREATE_CLUSTER"), sDCClusterSO.getCluster().getName(), exception.getMessage());
            this.progressPage.addMessage(aSEMessageText.toString());
            Support.showError(null, this.getClass(), this.wizard.getJDialog(), aSEMessageText.toString());
            return;
        }
        finally {
            AddInstanceThread addInstanceThread = this;
            synchronized (addInstanceThread) {
                this.running = false;
            }
        }
        object = new ASEMessageText(ASEUtils.getString("SDC_MSG_INSTANCES_ADDED_SUCCESSFULLY"));
        Support.addLogEntry(2, this.getClass().getName(), ((ASEMessageText)object).toString(), ((ASEMessageText)object).toString());
        this.progressPage.addMessage(((ASEMessageText)object).toString());
        this.progressPage.enableFinishButton(true);
        this.progressPage.enableCancelButton(true);
    }
}

