/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.aseplugin.bo.wiz;

import com.sybase.asa.ASAMultiList;
import com.sybase.aseplugin.ASEImages;
import com.sybase.aseplugin.ASEMessageText;
import com.sybase.aseplugin.ASEUtils;
import com.sybase.aseplugin.bo.ASEBaseItem2;
import com.sybase.aseplugin.bo.Support;
import com.sybase.aseplugin.bo.TableBO;
import com.sybase.aseplugin.bo.wiz.ASEBaseWizDocPage;
import com.sybase.aseplugin.bo.wiz.ASEBaseWizardDialog2;
import com.sybase.aseplugin.bo.wiz.ASEBaseWizardPage2;
import com.sybase.aseplugin.go.ASETable;
import com.sybase.aseplugin.go.wiz.BCPWizGOCopyFormatPage;
import com.sybase.aseplugin.go.wiz.BCPWizGOFileFormatPage;
import com.sybase.aseplugin.go.wiz.BCPWizGOIdentityPage;
import com.sybase.aseplugin.go.wiz.BCPWizGOSelectObjectsPage;
import com.sybase.aseplugin.so.SOItemInterface;
import com.sybase.aseplugin.so.TableSO;
import com.sybase.aseplugin.so.Utility;
import com.sybase.aseplugin.so.ViewSO;
import com.sybase.aseplugin.sql.ASConnection;
import com.sybase.aseplugin.util.ui.JLabelTableModel;
import com.sybase.central.SCContainer2;
import com.sybase.central.SCDialogSupport;
import com.sybase.central.SCPageController;
import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;

public class BCPWizard
extends ASEBaseWizardDialog2 {
    private BCPWizObjectsPage _objectsPage;
    private BCPWizFileFormatPage _fileFormatPage;
    private BCPWizCopyFormatPage _copyFormatPage;
    private BCPWizIdentityPage _identityPage;
    private TableSO _tableSO = null;
    private ViewSO _viewSO = null;
    private ASConnection _asConn;
    private ArrayList _targets;
    private boolean _isPartition;
    private boolean _isBCPIn;
    public static final String CHAR_MODE = "-c";
    public static final String NATIVE_MODE = "-n";
    public static final String DEFAULT_FIELD_TERMINATOR = ",";
    public static final String DEFAULT_ROW_TERMINATOR = "\\n";
    public static final String BATCH_SIZE_FLAG = "-b";
    public static final String DISPLAY_CHARSET_FLAG = "-a";
    public static final String SIZE_FLAG = "-A";
    public static final String ERR_FILE_FLAG = "-e";
    public static final String FORMAT_FILE_FLAG = "-f";
    public static final String FIRST_ROW_FLAG = "-F";
    public static final String IDENTITY_START_VALUE_FLAG = "-g";
    public static final String INTERFACES_FILE_FLAG = "-I";
    public static final String CLIENT_CHARSET_FLAG = "-J";
    public static final String LAST_ROW_FLAG = "-L";
    public static final String MAX_ERRORS_FLAG = "-m";
    public static final String DATAFILE_CHARSET_FLAG = "-q";
    public static final String ROW_TERMINATOR_FLAG = "-r";
    public static final String REMOTE_SERVER_PRINCIPAL_FLAG = "R";
    public static final String FIELD_TERMINATOR_FLAG = "-t";
    public static final String TEXT_OR_IMAGE_SIZE_FLAG = "-T";
    public static final String LANGUAGE_FLAG = "-z";
    public static final String IDENTITY_FLAG = "-N";
    private String _sModeSpecifier = "-c";
    private String _sFieldTerminator = ",";
    private String _sRowTerminator = System.getProperty("line.separator");
    private String _sFirstRow = null;
    private String _sLastRow = null;
    private String _sNoOfRows = null;
    private String _sMaxError = null;
    private Vector _vObjects = new Vector();
    private String _sFormatFile = null;
    private String _sIdentityOption = null;
    private String _sIdentityStartValue = null;

    public BCPWizard(TableSO tableSO, ArrayList arrayList, SCContainer2 sCContainer2, boolean bl) {
        super((SOItemInterface)tableSO, sCContainer2, ASEUtils.getString("CONTEXT_MENU_BCP_TEXT") + " " + ASEUtils.getString(bl ? "CONTEXT_MENU_BCP_IN_TEXT" : "CONTEXT_MENU_BCP_OUT_TEXT"));
        this._tableSO = tableSO;
        this._asConn = this._tableSO.getConnection();
        this._targets = arrayList;
        this._isPartition = arrayList.size() == 1;
        this._isBCPIn = bl;
    }

    public BCPWizard(ViewSO viewSO, ArrayList arrayList, SCContainer2 sCContainer2) {
        super((SOItemInterface)viewSO, sCContainer2, ASEUtils.getString("CONTEXT_MENU_BCP_TEXT"));
        this._viewSO = viewSO;
        this._asConn = this._viewSO.getConnection();
        this._targets = arrayList;
    }

    @Override
    public SCPageController[] getPages() {
        this._objectsPage = new BCPWizObjectsPage(this, this._targets);
        this._fileFormatPage = new BCPWizFileFormatPage(this);
        this._copyFormatPage = new BCPWizCopyFormatPage(this);
        if (this._tableSO != null) {
            for (int i = 0; i < this._targets.size(); ++i) {
                TableBO tableBO = (TableBO)this._targets.get(i);
                TableSO tableSO = (TableSO)tableBO.getSO();
                if (!tableSO.hasIdentityColumn()) continue;
                this._identityPage = new BCPWizIdentityPage(this);
                return new SCPageController[]{this._objectsPage, this._fileFormatPage, this._copyFormatPage, this._identityPage};
            }
        }
        return new SCPageController[]{this._objectsPage, this._fileFormatPage, this._copyFormatPage};
    }

    public void setModeSpecifier(String string) {
        this._sModeSpecifier = string;
    }

    public void setMaxError(String string) {
        this._sMaxError = string;
    }

    public void setIdentityOption(String string) {
        this._sIdentityOption = string;
    }

    private Vector getBCPCommands(boolean bl) throws Exception {
        Vector<String[]> vector = new Vector<String[]>();
        for (int i = 0; i < this._vObjects.size(); ++i) {
            TableSO tableSO;
            String[] stringArray = new String[35];
            int n = 0;
            BCP bCP = (BCP)this._vObjects.elementAt(i);
            stringArray[n++] = TableSO.getBCPPath();
            stringArray[n++] = bCP.getObjectName();
            if (this._isPartition && bCP.getPartitionNames() != null) {
                stringArray[n++] = "partition";
                stringArray[n++] = bCP.getPartitionNames();
            }
            stringArray[n++] = this._isBCPIn ? "in" : "out";
            stringArray[n++] = bCP.getDataFileName();
            stringArray[n++] = this._sModeSpecifier;
            if (!this._sFieldTerminator.equals("")) {
                stringArray[n++] = FIELD_TERMINATOR_FLAG;
                stringArray[n++] = this._sFieldTerminator;
            }
            stringArray[n++] = ROW_TERMINATOR_FLAG;
            stringArray[n++] = this._sRowTerminator;
            stringArray[n++] = "-U";
            stringArray[n++] = this._tableSO != null ? this._tableSO.getConnection().getCurrentUser() : this._viewSO.getConnection().getCurrentUser();
            stringArray[n++] = "-P";
            if (bl) {
                stringArray[n++] = "<password>";
            } else {
                stringArray[n++] = this._tableSO != null ? this._tableSO.getConnection().getPassword() : this._viewSO.getConnection().getPassword();
            }
            stringArray[n++] = "-S";
            String string = stringArray[n++] = this._tableSO != null ? this._tableSO.getConnection().getServerName() : this._viewSO.getConnection().getServerName();
            if (this._sFormatFile != null) {
                stringArray[n++] = FORMAT_FILE_FLAG;
                stringArray[n++] = this._sFormatFile;
            }
            if (this._sFirstRow != null) {
                stringArray[n++] = FIRST_ROW_FLAG;
                stringArray[n++] = this._sFirstRow;
            }
            if (this._sLastRow != null) {
                stringArray[n++] = LAST_ROW_FLAG;
                stringArray[n++] = this._sLastRow;
            }
            if (this._sNoOfRows != null) {
                stringArray[n++] = BATCH_SIZE_FLAG;
                stringArray[n++] = this._sNoOfRows;
            }
            if (this._sMaxError != null) {
                stringArray[n++] = MAX_ERRORS_FLAG;
                stringArray[n++] = this._sMaxError;
            }
            if (bCP.getErrorFileName() != null) {
                stringArray[n++] = ERR_FILE_FLAG;
                stringArray[n++] = bCP.getErrorFileName();
            }
            if ((tableSO = new TableSO(this._tableSO != null ? this._tableSO.getConnection() : this._viewSO.getConnection(), bCP.getObjectName(), this._tableSO != null ? this._tableSO.getDatabaseSO() : this._viewSO.getDatabaseSO())).hasIdentityColumn() && this._sIdentityOption == null) {
                stringArray[n++] = IDENTITY_FLAG;
            }
            if (this._sIdentityStartValue != null) {
                stringArray[n++] = IDENTITY_START_VALUE_FLAG;
                stringArray[n++] = this._sIdentityStartValue;
            }
            String[] stringArray2 = new String[n];
            for (int j = 0; j < n; ++j) {
                stringArray2[j] = stringArray[j];
            }
            vector.addElement(stringArray2);
        }
        return vector;
    }

    public void setFormatFile(String string) {
        this._sFormatFile = string;
    }

    public void setFieldTerminator(String string) {
        this._sFieldTerminator = string;
    }

    public void setRowTerminator(String string) {
        this._sRowTerminator = string;
    }

    public void setIdentityStartValue(String string) {
        this._sIdentityStartValue = string;
    }

    public void setFirstRow(String string) {
        this._sFirstRow = string;
    }

    public void setLastRow(String string) {
        this._sLastRow = string;
    }

    public void setNoOfRows(String string) {
        this._sNoOfRows = string;
    }

    @Override
    public boolean deploy() {
        Object object;
        for (int i = 0; i < this._vObjects.size(); ++i) {
            object = ((BCP)this._vObjects.elementAt(i)).getDataFileName();
            String[] stringArray = ((String)object).split(DEFAULT_FIELD_TERMINATOR);
            for (int j = 0; j < stringArray.length; ++j) {
                File file = new File(stringArray[j]);
                if (!file.exists() || this._isBCPIn) continue;
                ASEMessageText aSEMessageText = new ASEMessageText(ASEUtils.getString("MSG_FILE_EXIST_CONTINUE"), stringArray[j]);
                int n = Support.showQuestionYesNo(this.getJDialog(), aSEMessageText.toString());
                if (0 == n) continue;
                return false;
            }
        }
        final SCDialogSupport sCDialogSupport = this.getDialogSupport();
        sCDialogSupport.startWait();
        object = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    final String string = Support.getFullTitle(ASEUtils.getString("BCP_EDITOR_TITLE"), BCPWizard.this._asConn);
                    final StringBuffer stringBuffer = new StringBuffer();
                    String[] stringArray = ASEUtils.execProcess(new String[]{TableSO.getBCPPath(), "-v"}, null);
                    if (stringArray[0] != null) {
                        stringBuffer.append(stringArray[0]);
                    } else if (stringArray[1] != null) {
                        stringBuffer.append(stringArray[1]);
                    }
                    stringBuffer.append("\n");
                    final String string2 = BCPWizard.this._asConn.getDisplayName() + " BCP";
                    Thread thread = new Thread(){

                        @Override
                        public void run() {
                            Support.writeToExtendedLogFileEditor(string, ASEImages.getTableSmallImage(), stringBuffer.toString(), BCPWizard.this._asConn, null, string2);
                        }
                    };
                    SwingUtilities.invokeLater(thread);
                    Vector vector = BCPWizard.this.getBCPCommands(false);
                    Vector vector2 = BCPWizard.this.getBCPCommands(true);
                    StringBuffer stringBuffer2 = new StringBuffer();
                    for (int i = 0; i < vector.size(); ++i) {
                        int n;
                        String[] stringArray2 = (String[])vector.elementAt(i);
                        Object[] objectArray = (String[])vector2.elementAt(i);
                        int n2 = Utility.stringArrayToString(objectArray, " ").length();
                        for (n = 0; n < n2; ++n) {
                            stringBuffer2.append('-');
                        }
                        stringBuffer2.append("\n");
                        stringBuffer2.append(Utility.stringArrayToString(objectArray, " "));
                        stringBuffer2.append("\n");
                        for (n = 0; n < n2; ++n) {
                            stringBuffer2.append('-');
                        }
                        stringBuffer2.append("\n\n");
                        String[] stringArray3 = ASEUtils.execProcess(stringArray2, null);
                        if (stringArray3[0] != null) {
                            stringBuffer2.append(stringArray3[0]);
                        }
                        if (stringArray3[1] != null) {
                            stringBuffer2.append(stringArray3[1]);
                        }
                        stringBuffer2.append("\n");
                    }
                    final String string3 = stringBuffer2.toString();
                    SwingUtilities.invokeLater(new Thread(){

                        @Override
                        public synchronized void run() {
                            Support.writeToExtendedLogFileEditor(string, ASEImages.getTableSmallImage(), string3 + "\n\n", BCPWizard.this._asConn, null, string2);
                        }
                    });
                }
                catch (Exception exception) {
                    Support.showDetailsError(BCPWizard.this.getConnection(), this.getClass(), (Container)BCPWizard.this.getJDialog(), exception.getMessage(), exception);
                }
                finally {
                    sCDialogSupport.endWait();
                }
            }
        };
        ((Thread)object).start();
        return true;
    }

    class BCP {
        private int _id;
        private String _sObjectName;
        private String _sPartitionNames;
        private String _sDataFileNames;
        private String _sErrorFileName;

        public BCP() {
        }

        public BCP(int n) {
            this._id = n;
        }

        public String getObjectName() {
            return this._sObjectName;
        }

        public void setObjectName(String string) {
            this._sObjectName = string == null || string.trim().equals("") ? null : string;
        }

        public String getDataFileName() {
            return this._sDataFileNames;
        }

        public void appendDataFileNames(String string) {
            this._sDataFileNames = string == null || string.trim().equals("") ? "" : (this._sDataFileNames == null ? string : this._sDataFileNames + BCPWizard.DEFAULT_FIELD_TERMINATOR + string);
        }

        public String getErrorFileName() {
            return this._sErrorFileName;
        }

        public void setErrorFileName(String string) {
            this._sErrorFileName = string == null || string.trim().equals("") ? null : string;
        }

        public String getPartitionNames() {
            return this._sPartitionNames;
        }

        public void appendPartitionNames(String string) {
            this._sPartitionNames = string == null || string.trim().equals("") ? null : (this._sPartitionNames == null ? string : this._sPartitionNames + BCPWizard.DEFAULT_FIELD_TERMINATOR + string);
        }
    }

    public class BCPWizIdentityPage
    extends ASEBaseWizDocPage
    implements ActionListener {
        private BCPWizGOIdentityPage _go;

        public BCPWizIdentityPage(BCPWizard bCPWizard2) {
            super(bCPWizard2, (JPanel)((Object)new BCPWizGOIdentityPage(BCPWizard.this._isBCPIn)), ASEUtils.getString("BCP_INOUT_WIZ_IDENTITY_PAGE_TITLE"));
            this._go = (BCPWizGOIdentityPage)((Object)this.getJPanel());
            this._go.ignoreButton.addActionListener((ActionListener)this);
            this._go.includeButton.addActionListener((ActionListener)this);
            this._go.specifyButton.addActionListener((ActionListener)this);
            this._go.startSpinBox.getTextField().getDocument().addDocumentListener(this);
            this.getGO().setDisplayPreviewButton(false);
            this.getGO().setDisplayScheduleButton(false);
        }

        @Override
        public void textValueChanged(DocumentEvent documentEvent) {
            BCPWizard.this.setIdentityStartValue(this._go.startSpinBox.getTextField().getText());
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == this._go.ignoreButton) {
                BCPWizard.this.setIdentityOption(null);
                BCPWizard.this.setIdentityStartValue(null);
                this._go.startSpinBox.setEnabled(false);
            } else if (actionEvent.getSource() == this._go.includeButton) {
                BCPWizard.this.setIdentityOption("");
                BCPWizard.this.setIdentityStartValue(null);
                this._go.startSpinBox.setEnabled(false);
            } else {
                BCPWizard.this.setIdentityOption(null);
                this._go.startSpinBox.setEnabled(true);
            }
        }
    }

    public class BCPWizCopyFormatPage
    extends ASEBaseWizDocPage
    implements ActionListener {
        private BCPWizGOCopyFormatPage _go;

        public BCPWizCopyFormatPage(BCPWizard bCPWizard2) {
            super(bCPWizard2, (JPanel)((Object)new BCPWizGOCopyFormatPage(BCPWizard.this._isBCPIn)), ASEUtils.getString("BCP_INOUT_WIZ_COPY_FORMAT_PAGE_TITLE"));
            this._go = (BCPWizGOCopyFormatPage)((Object)this.getJPanel());
            this._go.browseButton.addActionListener((ActionListener)this);
            this._go.formatFilePathTextField.getDocument().addDocumentListener(this);
            this._go.fieldTerminatorTextField.getDocument().addDocumentListener(this);
            this._go.rowTerminatorTextField.getDocument().addDocumentListener(this);
            this._go.firstRowSpinBox.getTextField().getDocument().addDocumentListener(this);
            this._go.lastRowSpinBox.getTextField().getDocument().addDocumentListener(this);
            this._go.batchSizeSpinBox.getTextField().getDocument().addDocumentListener(this);
            this._go.maxErrorSpinBox.getTextField().getDocument().addDocumentListener(this);
            this._go.fieldTerminatorTextField.setText(BCPWizard.DEFAULT_FIELD_TERMINATOR);
            this._go.rowTerminatorTextField.setText(BCPWizard.DEFAULT_ROW_TERMINATOR);
            this.getGO().setDisplayPreviewButton(false);
            this.getGO().setDisplayScheduleButton(false);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JFileChooser jFileChooser;
            int n;
            if (actionEvent.getSource() == this._go.browseButton && (n = (jFileChooser = new JFileChooser()).showOpenDialog((Component)((Object)this._go))) == 0) {
                try {
                    this._go.fieldTerminatorTextField.setText("");
                    this._go.rowTerminatorTextField.setText("");
                    this._go.formatFilePathTextField.setText(jFileChooser.getSelectedFile().getCanonicalPath());
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }

        @Override
        public void textValueChanged(DocumentEvent documentEvent) {
            String string;
            if (!(documentEvent == null || documentEvent.getDocument() != this._go.formatFilePathTextField.getDocument() || this._go.formatFilePathTextField.getText().equals("") || this._go.fieldTerminatorTextField.getText().equals("") && this._go.rowTerminatorTextField.getText().equals(""))) {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ((BCPWizCopyFormatPage)BCPWizCopyFormatPage.this)._go.fieldTerminatorTextField.setText("");
                        ((BCPWizCopyFormatPage)BCPWizCopyFormatPage.this)._go.rowTerminatorTextField.setText("");
                    }
                });
            }
            if (!(documentEvent == null || documentEvent.getDocument() != this._go.fieldTerminatorTextField.getDocument() && documentEvent.getDocument() != this._go.rowTerminatorTextField.getDocument() || this._go.fieldTerminatorTextField.getText().equals("") && this._go.rowTerminatorTextField.getText().equals("") || this._go.formatFilePathTextField.getText().equals(""))) {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ((BCPWizCopyFormatPage)BCPWizCopyFormatPage.this)._go.formatFilePathTextField.setText("");
                    }
                });
            }
            if (!(string = this._go.formatFilePathTextField.getText()).equals("")) {
                BCPWizard.this.setFormatFile(string);
            }
            string = this._go.fieldTerminatorTextField.getText();
            BCPWizard.this.setFieldTerminator(string);
            string = this._go.rowTerminatorTextField.getText();
            if (!string.equals("")) {
                BCPWizard.this.setRowTerminator(string);
            }
            if (!(string = this._go.firstRowSpinBox.getTextField().getText()).equals("") && !string.equals("0")) {
                BCPWizard.this.setFirstRow(string);
            }
            if (!(string = this._go.lastRowSpinBox.getTextField().getText()).equals("") && !string.equals("0")) {
                BCPWizard.this.setLastRow(string);
            }
            if (!(string = this._go.batchSizeSpinBox.getTextField().getText()).equals("") && !string.equals("0")) {
                BCPWizard.this.setNoOfRows(string);
            }
            if (!(string = this._go.maxErrorSpinBox.getTextField().getText()).equals("") && !string.equals("10")) {
                BCPWizard.this.setMaxError(string);
            }
        }
    }

    public class BCPWizFileFormatPage
    extends ASEBaseWizardPage2
    implements ActionListener {
        private BCPWizGOFileFormatPage _go;

        public BCPWizFileFormatPage(BCPWizard bCPWizard2) {
            super(bCPWizard2, (JPanel)((Object)new BCPWizGOFileFormatPage()), ASEUtils.getString("BCP_INOUT_WIZ_FILE_FORMAT_PAGE_TITLE"));
            this._go = (BCPWizGOFileFormatPage)((Object)this.getJPanel());
            this._go.characterButton.addActionListener((ActionListener)this);
            this._go.nativeButton.addActionListener((ActionListener)this);
            this.getGO().setDisplayPreviewButton(false);
            this.getGO().setDisplayScheduleButton(false);
        }

        @Override
        public void enableComponents() {
            this.enableFinishButton(true);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            BCPWizard.this.setModeSpecifier(actionEvent.getSource() == this._go.nativeButton ? BCPWizard.NATIVE_MODE : BCPWizard.CHAR_MODE);
        }
    }

    public class BCPWizObjectsPage
    extends ASEBaseWizDocPage
    implements ActionListener {
        private BCPWizGOSelectObjectsPage _go;
        public JTable _tblFiles;
        public JLabelTableModel tableModel;
        private Vector tableVector;
        private Vector headings;

        public BCPWizObjectsPage(BCPWizard bCPWizard2, ArrayList arrayList) {
            super(bCPWizard2, (JPanel)((Object)new BCPWizGOSelectObjectsPage()), ASEUtils.getString("BCP_INOUT_WIZ_INTRO_PAGE_TITLE_SENT_SPECIFY_DATA_FILE"));
            this.tableVector = new Vector();
            this.headings = new Vector();
            this._go = (BCPWizGOSelectObjectsPage)((Object)this.getJPanel());
            ASAMultiList aSAMultiList = new ASAMultiList();
            this._go.tablesScrollPane.add((Component)aSAMultiList);
            this.fillTable(arrayList);
            this.getGO().setDisplayPreviewButton(false);
            this.getGO().setDisplayScheduleButton(false);
        }

        @Override
        public void init() {
            this._go.outputFileEditor.setParentWindow(this.getJDialog());
            this._go.errorFileEditor.setParentWindow(this.getJDialog());
            this._go.outputFileEditor.addDocumentListener(this);
            this._go.errorFileEditor.addDocumentListener(this);
            if (BCPWizard.this._isPartition) {
                this._go.sameOutputFileRadioButton.doClick();
            }
            this.enableComponents();
        }

        private void hidePartition(boolean bl) {
            this._go.introLabel.setVisible(!bl);
            this._go.sameOutputFileRadioButton.setVisible(bl);
            this._go.separateOutputFileRadioButton.setVisible(bl);
            this._go.outputFileEditor.setVisible(bl);
            this._go.errorFilePathLabel.setVisible(bl);
            this._go.errorFileEditor.setVisible(bl);
        }

        @Override
        public void textValueChanged(DocumentEvent documentEvent) {
            this.enableComponents();
        }

        @Override
        public void enableComponents() {
            boolean bl = false;
            String string = this._go.outputFileEditor.getFileName();
            String string2 = null;
            BCPWizard.this._vObjects.removeAllElements();
            if (this._go.sameOutputFileRadioButton.isSelected()) {
                boolean bl2 = bl = string.equals("") || BCPWizard.this._isBCPIn && !ASEUtils.isReadableFile(string);
                if (!bl) {
                    BCP bCP = new BCP(0);
                    String string3 = null;
                    string3 = BCPWizard.this._tableSO != null ? BCPWizard.this._tableSO.getFullyQualifiedName() : BCPWizard.this._viewSO.getFullyQualifiedName();
                    bCP.setObjectName(string3);
                    bCP.appendDataFileNames(string);
                    bCP.setErrorFileName(this._go.errorFileEditor.getFileName());
                    BCPWizard.this._vObjects.addElement(bCP);
                }
            } else {
                int n;
                int n2 = BCPWizard.this._isPartition ? 1 : 2;
                BCP bCP = null;
                String string4 = null;
                int n3 = 0;
                for (n = 0; n < this.tableModel.getRowCount(); ++n) {
                    string = this.tableModel.getValueAt(n, n2).toString();
                    if (string.trim().equals("")) continue;
                    ++n3;
                }
                for (n = 0; n < this.tableModel.getRowCount(); ++n) {
                    string = this.tableModel.getValueAt(n, n2).toString();
                    string2 = this.tableModel.getValueAt(n, n2 - 1).toString();
                    if (string2.equals("") || BCPWizard.this._isBCPIn && (string.equals("") || !ASEUtils.isReadableFile(string)) || !BCPWizard.this._isBCPIn && n3 != 0 && n3 != this.tableModel.getRowCount()) {
                        bl = true;
                        break;
                    }
                    if (BCPWizard.this._isPartition) {
                        string4 = BCPWizard.this._tableSO != null ? BCPWizard.this._tableSO.getFullyQualifiedName() : BCPWizard.this._viewSO.getFullyQualifiedName();
                        if (bCP == null) {
                            bCP = new BCP(0);
                        }
                        bCP.setObjectName(string4);
                        bCP.appendDataFileNames(string);
                        bCP.appendPartitionNames(this.tableModel.getValueAt(n, 0).toString());
                        bCP.setErrorFileName(this._go.errorFileEditor.getFileName());
                        if (BCPWizard.this._vObjects.size() != 0) continue;
                        BCPWizard.this._vObjects.addElement(bCP);
                        continue;
                    }
                    string4 = BCPWizard.this._tableSO != null ? BCPWizard.this._tableSO.getDatabaseName() : BCPWizard.this._viewSO.getDatabaseName();
                    BCP bCP2 = new BCP(n);
                    bCP2.setObjectName(string4 + "." + this.tableModel.getValueAt(n, n2 - 1) + "." + this.tableModel.getValueAt(n, n2 - 2));
                    bCP2.setErrorFileName(this.tableModel.getValueAt(n, n2 + 1).toString());
                    bCP2.appendDataFileNames(string);
                    BCPWizard.this._vObjects.addElement(bCP2);
                }
            }
            this.enableNextButton(!bl);
            this.enableFinishButton(!bl);
        }

        private void fillTable(ArrayList arrayList) {
            this.headings = new Vector();
            this.hidePartition(BCPWizard.this._isPartition);
            this.tableVector = new Vector();
            if (BCPWizard.this._isPartition) {
                this.headings.addElement(ASEUtils.getString("MSG_PARTITION_TYPE") + " " + ASEUtils.getString("DISP_NAME_TEXT"));
                this.headings.addElement(ASEUtils.getString("MSG_DATA") + " " + ASEUtils.getString("DISP_FILENAME_TEXT"));
                Vector vector = new Vector();
                try {
                    vector = BCPWizard.this._tableSO.getPartitionNames();
                }
                catch (SQLException sQLException) {
                    Support.showDetailsError(this.getConnection(), this.getClass(), sQLException.getMessage(), sQLException);
                }
                for (int i = 0; i < vector.size(); ++i) {
                    Vector vector2 = new Vector();
                    vector2.add(vector.elementAt(i));
                    String string = Support.getInitDirectory();
                    string = string == null ? "" : string + File.separator;
                    vector2.add(string + ((TableSO)this.getSO()).getOwner() + "_" + vector.elementAt(i) + ".out");
                    this.tableVector.addElement(vector2);
                }
            } else {
                this.headings.addElement(ASEUtils.getString("MSG_TABLE_TYPE") + " " + ASEUtils.getString("DISP_NAME_TEXT"));
                this.headings.addElement(ASEUtils.getString("MSG_OWNER"));
                this.headings.addElement(ASEUtils.getString("MSG_DATA") + " " + ASEUtils.getString("DISP_FILENAME_TEXT"));
                this.headings.addElement(ASEUtils.getString("MSG_ERROR") + " " + ASEUtils.getString("DISP_FILENAME_TEXT"));
                for (int i = 0; i < arrayList.size(); ++i) {
                    Vector<String> vector = new Vector<String>();
                    String string = ((ASEBaseItem2)arrayList.get(i)).getDisplayName(1);
                    String string2 = ((ASEBaseItem2)arrayList.get(i)).getDisplayName(2);
                    vector.add(string);
                    vector.add(string2);
                    String string3 = Support.getInitDirectory();
                    string3 = string3 == null ? "" : string3 + File.separator;
                    vector.add(string3 + string2 + "_" + string + "_BCP.out");
                    vector.add("");
                    this.tableVector.addElement(vector);
                }
            }
            this.tableModel = new JLabelTableModel(this.headings, this.tableVector);
            this._tblFiles = new ASETable(this.tableModel){

                @Override
                public boolean isCellEditable(int n, int n2) {
                    return true;
                }

                @Override
                public void setValueAt(Object object, int n, int n2) {
                    super.setValueAt(object, n, n2);
                    BCPWizObjectsPage.this.enableComponents();
                    int n3 = object.toString().lastIndexOf(System.getProperty("file.separator"));
                    String string = n3 != -1 ? object.toString().substring(0, n3 + 1) : "";
                    for (int i = 0; i < BCPWizObjectsPage.this.tableModel.getRowCount(); ++i) {
                        if (i == n || BCPWizObjectsPage.this.tableModel.getValueAt(i, n2) != null && !BCPWizObjectsPage.this.tableModel.getValueAt(i, n2).equals("")) continue;
                        BCPWizObjectsPage.this.tableModel.setValueAt(string, i, n2);
                        BCPWizObjectsPage.this.tableModel.fireTableCellUpdated(i, n2);
                    }
                    BCPWizObjectsPage.this.tableModel.fireTableCellUpdated(n, n2);
                }
            };
            this._go.tablesScrollPane.getViewport().setView(this._tblFiles);
            this.setupColWidth();
            this._go.delButton.setEnabled(this._tblFiles.getRowCount() > 1);
            this._go.addButton.addActionListener((ActionListener)this);
            this._go.delButton.addActionListener((ActionListener)this);
            this._go.sameOutputFileRadioButton.addActionListener((ActionListener)this);
            this._go.separateOutputFileRadioButton.addActionListener((ActionListener)this);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (this._tblFiles.getCellEditor() != null) {
                this._tblFiles.getCellEditor().stopCellEditing();
            }
            if (actionEvent.getSource() == this._go.addButton) {
                Vector<String> vector = new Vector<String>();
                for (int i = 0; i < this.headings.size(); ++i) {
                    vector.addElement("");
                }
                this.tableModel.addRow(vector);
                this.tableModel.fireTableDataChanged();
                this._go.delButton.setEnabled(true);
            } else if (actionEvent.getSource() == this._go.delButton) {
                int n = this._tblFiles.getSelectedRow();
                int n2 = this._tblFiles.getRowCount();
                this.tableModel.removeRow(n == -1 || n >= n2 ? n2 - 1 : n);
                this.tableModel.fireTableDataChanged();
                this._go.delButton.setEnabled(--n2 > 1);
            } else {
                boolean bl = actionEvent.getSource() == this._go.sameOutputFileRadioButton;
                this._go.tablesScrollPane.setEnabled(!bl);
                this._tblFiles.setEnabled(!bl);
                this._go.addButton.setEnabled(!bl);
                this._go.delButton.setEnabled(!bl);
                this._go.outputFileEditor.setEnabled(bl);
                if (bl && this._go.outputFileEditor.getFileName().length() == 0) {
                    String string = this._go.outputFileEditor.getInitFilePath();
                    this._go.outputFileEditor.setFileName(string + File.separator + ((TableSO)this.getSO()).getOwner() + "_" + ((TableSO)this.getSO()).getName() + "_BCP.out");
                }
            }
            this.enableComponents();
        }

        public void setupColWidth() {
            int n = 0;
            this._tblFiles.getColumnModel().getColumn(n++).setPreferredWidth(80);
            if (BCPWizard.this._targets.size() != 1) {
                this._tblFiles.getColumnModel().getColumn(n++).setPreferredWidth(20);
            }
            this._tblFiles.getColumnModel().getColumn(n++).setPreferredWidth(80);
            if (!BCPWizard.this._isPartition) {
                this._tblFiles.getColumnModel().getColumn(n++).setPreferredWidth(80);
            }
        }
    }
}

