/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.aseplugin.bo.wiz;

import com.sybase.asa.ASAIconTextData;
import com.sybase.asa.ASAListCheckEvent;
import com.sybase.asa.ASAListCheckListener;
import com.sybase.ase.sdcadmin.config.ClusterConfigException;
import com.sybase.ase.sdcadmin.config.IServer;
import com.sybase.aseplugin.ASEImages;
import com.sybase.aseplugin.ASEMessageText;
import com.sybase.aseplugin.ASEUtils;
import com.sybase.aseplugin.bo.BackupServersCtrBO;
import com.sybase.aseplugin.bo.ContainerViewBO;
import com.sybase.aseplugin.bo.SDCInstanceBO;
import com.sybase.aseplugin.bo.Support;
import com.sybase.aseplugin.bo.wiz.ASEBaseWizDocPage;
import com.sybase.aseplugin.bo.wiz.ASEBaseWizardDialog2;
import com.sybase.aseplugin.bo.wiz.ASEBaseWizardPage2;
import com.sybase.aseplugin.bo.wiz.BackupServerWizardBase;
import com.sybase.aseplugin.bo.wiz.SummaryWizBOPage;
import com.sybase.aseplugin.go.wiz.ASEIntroWizGOPage;
import com.sybase.aseplugin.go.wiz.BackupServerWizGOHostsPage;
import com.sybase.aseplugin.so.BackupServerSO;
import com.sybase.aseplugin.so.SDCInstanceSO;
import com.sybase.aseplugin.so.SOItemInterface;
import com.sybase.aseplugin.so.ServerSO;
import com.sybase.central.SCContainer2;
import com.sybase.central.SCPageController;
import com.sybase.ua.AgentConnectionException;
import com.sybase.ua.plugin.AgentPluginException;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;

public class BackupServerWizard
extends BackupServerWizardBase {
    protected BackupServerSO _backupServerSO;
    private String _fileSeparator = "";

    public BackupServerWizard(BackupServerSO backupServerSO, BackupServersCtrBO backupServersCtrBO) {
        super((SOItemInterface)backupServerSO, (SCContainer2)backupServersCtrBO, ASEUtils.getString("BACKUP_SERVER_SERVER_CONFIGURE_TEXT"));
        this._backupServerSO = backupServerSO;
    }

    public BackupServerWizard(SOItemInterface sOItemInterface, SCContainer2 sCContainer2, String string) {
        super(sOItemInterface, sCContainer2, string);
        this._serverSO = (ServerSO)ContainerViewBO.getServerBO(this.getConnection()).getSO();
    }

    @Override
    public SCPageController[] getPages() {
        return new SCPageController[]{new BackupServerWizIntroPage(this), new BackupServerWizHostsPage(this), new BackupServerWizSummaryPage(this)};
    }

    protected String getFileSeparator() {
        if (this._fileSeparator == null || this._fileSeparator.equals("")) {
            try {
                this._fileSeparator = this._serverSO.getFileSeparator();
            }
            catch (Exception exception) {
                return "/";
            }
        }
        return this._fileSeparator;
    }

    class BackupServerWizSummaryPage
    extends SummaryWizBOPage {
        public BackupServerWizSummaryPage(BackupServerWizard backupServerWizard2) {
            super(backupServerWizard2, ASEImages.getRemoteServerWizardImage());
        }

        @Override
        public void enableComponents() {
            this._goPanel.getPreviewButton().setVisible(false);
            this._goPanel.getScheduleButton().setVisible(false);
            this.clearSummaryItems();
            this.addSummaryItem(ASEUtils.getString("AUXILIARY_SERVER_SERVER_NAME_HEADER"), BackupServerWizard.this._backupServerSO.getName());
            Vector vector = BackupServerWizard.this._backupServerSO.getNodes();
            Object[] objectArray = null;
            if (BackupServerWizard.this.installationMode == BackupServerWizardBase.SHARED_INSTALLATION_MODE) {
                this.addSummaryItem(ASEUtils.getString("AUXILIARY_SERVER_HOSTS_HEADER_ERROR_FILE"), BackupServerWizard.this._backupServerSO.getErrorLog());
                for (int i = 0; i < vector.size(); ++i) {
                    this.addSummaryItem("", "");
                    objectArray = (Object[])vector.get(i);
                    this.addSummaryItem(BackupServersCtrBO.HEADER_HOST, objectArray[0].toString());
                    this.addSummaryItem(BackupServersCtrBO.HEADER_PORT, objectArray[1].toString());
                }
            } else {
                for (int i = 0; i < vector.size(); ++i) {
                    this.addSummaryItem("", "");
                    objectArray = (Object[])vector.get(i);
                    this.addSummaryItem(BackupServersCtrBO.HEADER_HOST, objectArray[0].toString());
                    this.addSummaryItem(BackupServersCtrBO.HEADER_PORT, objectArray[1].toString());
                    this.addSummaryItem(BackupServersCtrBO.HEADER_ERROR_FILE, objectArray[2].toString());
                }
            }
            this.setSummaryInfo(this.getSummary());
        }

        @Override
        public boolean deploy() {
            BackupServerWizardBase.CreateServerTask createServerTask = new BackupServerWizardBase.CreateServerTask(){

                @Override
                void create() throws RemoteException, AgentPluginException, ClusterConfigException, IOException {
                    BackupServerWizard.this._backupServerSO.creatServer(BackupServerWizard.this.getCluster());
                }
            };
            JFrame jFrame = (JFrame)SwingUtilities.getAncestorOfClass(JFrame.class, (Component)((Object)this._go));
            String string = ASEUtils.getString("AUXILIARY_SERVER_CFG_BS_TASK_TITLE");
            return BackupServerWizard.this.createServer(createServerTask, jFrame, string);
        }
    }

    class BackupServerWizHostsPage
    extends ASEBaseWizDocPage
    implements ActionListener,
    ASAListCheckListener {
        protected BackupServerWizGOHostsPage _go;

        public BackupServerWizHostsPage(BackupServerWizard backupServerWizard2) {
            super(backupServerWizard2, (JPanel)((Object)new BackupServerWizGOHostsPage()), ASEUtils.getString("BACKUP_SERVER_WIZ_SELECT_HOSTS_TITLE"));
            this._go = (BackupServerWizGOHostsPage)((Object)this.getJPanel());
            if (BackupServerWizard.this.installationMode == BackupServerWizardBase.SHARED_INSTALLATION_MODE) {
                this._go.setErrLogColumnShow(false);
                this._go.errorLogTextField.getDocument().addDocumentListener(this);
            }
            this._go.backupServerNameTextField.getDocument().addDocumentListener(this);
            this._go.hostsMultiCheckList.addListCheckListener((ASAListCheckListener)this);
            this._go.selectAllButton.addActionListener((ActionListener)this);
            this._go.clearAllButton.addActionListener((ActionListener)this);
        }

        @Override
        public void textValueChanged(DocumentEvent documentEvent) {
            if (documentEvent.getDocument().equals(this._go.backupServerNameTextField.getDocument())) {
                this._go.errorLogTextField.setText(BackupServerWizard.this.getCluster().getAseHome() + BackupServerWizard.this.getFileSeparator() + "install" + BackupServerWizard.this.getFileSeparator() + this._go.backupServerNameTextField.getText() + ".log");
            }
            this.enableComponents();
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == this._go.selectAllButton) {
                this.checkAll();
            } else if (actionEvent.getSource() == this._go.clearAllButton) {
                this.uncheckAll();
            }
        }

        public void valueChanged(ASAListCheckEvent aSAListCheckEvent) {
            this.enableComponents();
        }

        private void checkAll() {
            this._go.hostsMultiCheckList.checkAllRows();
        }

        private void uncheckAll() {
            this._go.hostsMultiCheckList.uncheckAllRows();
        }

        protected void initGO() {
            this._go.hostsMultiCheckList.clear();
            this._go.backupServerNameTextField.setText(BackupServerWizard.this._backupServerSO.getName());
            this._go.errorLogTextField.setText(BackupServerWizard.this._backupServerSO.getErrorLog());
            String string = null;
            Integer n = null;
            SDCInstanceSO sDCInstanceSO = null;
            for (int i = 0; i < BackupServerWizard.this._backupServerSO.getNodes().size(); ++i) {
                string = ((Object[])BackupServerWizard.this._backupServerSO.getNodes().get(i))[0].toString();
                n = (Integer)((Object[])BackupServerWizard.this._backupServerSO.getNodes().get(i))[1];
                sDCInstanceSO = BackupServerWizard.this.getSDCInstanceSOByHost(string);
                this._go.hostsMultiCheckList.addRow(new Object[]{new ASAIconTextData((Icon)SDCInstanceBO.getIcon(this.getConnection().getServerServerName(), sDCInstanceSO), string), n});
            }
        }

        @Override
        public void init() throws Exception {
            this.initGO();
            this.checkAll();
        }

        @Override
        public void enableComponents() {
            if (this._go.backupServerNameTextField.getText().length() == 0 || this._go.errorLogTextField.getText().length() == 0 || this._go.hostsMultiCheckList.getCheckedRowCount() == 0) {
                this.enableNextButton(false);
                this.enableFinishButton(false);
            } else {
                this.enableNextButton(true);
                this.enableFinishButton(true);
                this._goPanel.getPreviewButton().setVisible(false);
                this._goPanel.getScheduleButton().setVisible(false);
            }
        }

        private boolean validateSO() throws AgentConnectionException, RemoteException {
            Vector vector = BackupServerWizard.this._backupServerSO.getNodes();
            if (!BackupServerWizard.this.validateErrorLog(BackupServerWizard.this._backupServerSO.getErrorLog())) {
                return false;
            }
            if (vector.size() > 1 && !BackupServerWizard.this.isSharedByAllNodes(BackupServerWizard.this._backupServerSO.getErrorLog(), vector)) {
                ASEMessageText aSEMessageText = new ASEMessageText(ASEUtils.getString("ERR_AUX_NODE_FILE_NOT_SHARED_PATH"), BackupServerWizard.this._backupServerSO.getErrorLog());
                Support.showError(this.getConnection(), this.getClass(), this.getJDialog(), aSEMessageText.toString());
                return false;
            }
            String string = null;
            Integer n = null;
            for (int i = 0; i < vector.size(); ++i) {
                string = ((Object[])vector.get(i))[0].toString();
                if (BackupServerWizard.this.validatePortForHost(string, n = (Integer)((Object[])vector.get(i))[1]) && !BackupServerWizard.this.isPortExists(string, n, BackupServerWizardBase.SERVER_TYPE_BACKUP)) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean deploy() {
            if (!BackupServerWizard.this.validateServerName(this._go.backupServerNameTextField.getText())) {
                return false;
            }
            if (this._go.errorLogTextField.getText().trim().length() > 255) {
                ASEMessageText aSEMessageText = new ASEMessageText(ASEUtils.getString("ERR_AUXILIARY_SERVER_LOG_TOO_LONG"));
                Support.showError(this.getConnection(), this.getClass(), this.getJDialog(), aSEMessageText.toString());
                return false;
            }
            BackupServerWizard.this._backupServerSO.setName(this._go.backupServerNameTextField.getText());
            BackupServerWizard.this._backupServerSO.setErrorLog(this._go.errorLogTextField.getText());
            BackupServerWizard.this._backupServerSO.clearNodes();
            Object[] objectArray = null;
            int[] nArray = this._go.hostsMultiCheckList.getCheckedRows();
            for (int i = 0; i < nArray.length; ++i) {
                objectArray = this._go.hostsMultiCheckList.getRow(nArray[i]).toArray();
                objectArray[0] = objectArray[0].toString();
                BackupServerWizard.this._backupServerSO.addNode(objectArray);
            }
            try {
                if (!this.validateSO()) {
                    return false;
                }
            }
            catch (Exception exception) {
                Support.showDetailsError(this.getConnection(), this.getClass(), (Container)this.getJDialog(), exception.getMessage(), exception);
                return false;
            }
            return true;
        }

        @Override
        public void releaseResources() {
            if (BackupServerWizard.this.installationMode == BackupServerWizardBase.SHARED_INSTALLATION_MODE) {
                this._go.errorLogTextField.getDocument().addDocumentListener(this);
            }
            this._go.backupServerNameTextField.getDocument().removeDocumentListener(this);
            this._go.hostsMultiCheckList.removeListCheckListener((ASAListCheckListener)this);
            this._go.selectAllButton.removeActionListener((ActionListener)this);
            this._go.clearAllButton.removeActionListener((ActionListener)this);
            this._go.releaseResources();
            this._go = null;
        }
    }

    class BackupServerWizIntroPage
    extends ASEBaseWizardPage2 {
        public BackupServerWizIntroPage(ASEBaseWizardDialog2 aSEBaseWizardDialog2, JPanel jPanel, String string) {
            super(aSEBaseWizardDialog2, jPanel, string);
        }

        public BackupServerWizIntroPage(BackupServerWizard backupServerWizard2) {
            super(backupServerWizard2, (JPanel)((Object)new ASEIntroWizGOPage(ASEImages.getRemoteServerWizardImage(), ASEUtils.getString("BACKUP_SERVER_WIZ_INTRO_WELCOME_TEXT"), ASEUtils.getString("BACKUP_SERVER_WIZ_INTRO_INTRO_TEXT"))), ASEUtils.getString("BACKUP_SERVER_WIZ_INTRO_TITLE"));
        }

        protected boolean initSO() {
            if (BackupServerWizard.this._isInited) {
                return BackupServerWizard.this._isInited;
            }
            BackupServerWizard.this._backupServerSO.clearNodes();
            BackupServerWizardBase.InitAuxiliaryServerTask initAuxiliaryServerTask = new BackupServerWizardBase.InitAuxiliaryServerTask(){

                @Override
                public void initSO() throws AgentConnectionException, RemoteException {
                    BackupServerWizard.this._backupServerSO.setName(BackupServerWizard.this.getCluster().getName() + "_BS");
                    BackupServerWizard.this._backupServerSO.setErrorLog(BackupServerWizard.this.getCluster().getAseHome() + BackupServerWizard.this.getFileSeparator() + "install" + BackupServerWizard.this.getFileSeparator() + BackupServerWizard.this._backupServerSO.getName() + ".log");
                }

                @Override
                public Hashtable<String, Integer[]> discoverUnusedPorts(boolean bl) throws Exception {
                    return this.findPortsEachNode(1, bl);
                }

                @Override
                public void initNode(IServer iServer, Hashtable<String, Integer[]> hashtable) throws Exception {
                    String string = iServer.getNode();
                    if (!BackupServerWizard.this._backupServerSO.isNodeExists(string)) {
                        String string2 = hashtable.get(string)[0].toString();
                        BackupServerWizard.this._backupServerSO.addNode(new Object[]{string, new Integer(string2)});
                    }
                }
            };
            BackupServerWizard.this._isInited = BackupServerWizard.this.discoveryUnusedPort(initAuxiliaryServerTask, this.getJDialog());
            return BackupServerWizard.this._isInited;
        }

        @Override
        public int onWizardNext() {
            if (!this.initSO()) {
                return -1;
            }
            return super.onWizardNext();
        }

        protected int parentOnWizardNext() {
            return super.onWizardNext();
        }
    }
}

