/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.aseplugin.bo.wiz;

import com.sybase.ase.sdcadmin.config.ICluster;
import com.sybase.ase.sdcadmin.config.IServer;
import com.sybase.aseplugin.ASEMessageText;
import com.sybase.aseplugin.ASEUtils;
import com.sybase.aseplugin.bo.BackupServerBO;
import com.sybase.aseplugin.bo.ContainerViewBO;
import com.sybase.aseplugin.bo.SDCInstanceBO;
import com.sybase.aseplugin.bo.ServerBO;
import com.sybase.aseplugin.bo.Support;
import com.sybase.aseplugin.bo.dlg.WorkingDialogRunnable;
import com.sybase.aseplugin.bo.dlg.WorkingDialogWithMsgChangable;
import com.sybase.aseplugin.bo.dlg.WorkingDialogWithSkipCancel;
import com.sybase.aseplugin.bo.wiz.ASEBaseWizardDialog2;
import com.sybase.aseplugin.bo.wiz.ASEBaseWizardPage2;
import com.sybase.aseplugin.bo.wiz.BackupServerWizard;
import com.sybase.aseplugin.so.SDCInstanceSO;
import com.sybase.aseplugin.so.SOItemInterface;
import com.sybase.aseplugin.so.ServerSO;
import com.sybase.aseplugin.util.PortsDiscoveryUtil;
import com.sybase.aseplugin.util.SDCClusterAgentProxy;
import com.sybase.central.SCContainer2;
import com.sybase.central.SCDetailsContainer;
import com.sybase.central.SCPageController;
import com.sybase.ua.AgentConnectionException;
import com.sybase.ua.AuthorizationException;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.rmi.RemoteException;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Vector;
import java.util.regex.Pattern;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;

public abstract class BackupServerWizardBase
extends ASEBaseWizardDialog2 {
    public static int SERVER_TYPE_BACKUP = 0;
    public static int SERVER_TYPE_XP = 1;
    public static int SERVER_TYPE_MONITOR = 2;
    public static int SERVER_TYPE_MULTIBACKUP = 3;
    public static int LOCAL_INSTALLATION_MODE = 0;
    public static int SHARED_INSTALLATION_MODE = 1;
    public static final int AUX_OK_IS_WRITABLE_LOG_FILE = 0;
    public static final int AUX_OK_EXIST_WRITABLE_LOG_FILE = 1;
    public static final int AUX_ERR_UNKNOWN = -1;
    public static final int AUX_ERR_NOT_ABSOLUTE_PATH = 100;
    public static final int AUX_ERR_FILE_IS_RAW_DEVICE = 101;
    public static final int AUX_ERR_FILE_NOT_WRITABLE = 200;
    public static final int AUX_ERR_FILE_IS_DIRECTORY = 201;
    public static final int AUX_ERR_PARENT_DIR_NOT_EXIST = 202;
    public static final int AUX_ERR_PARENT_DIRECTORY_NOT_READABLE = 203;
    public static final int AUX_ERR_PARENT_DIRECTORY_NOT_WRITABLE = 204;
    protected ServerSO _serverSO;
    public int installationMode = SHARED_INSTALLATION_MODE;
    protected boolean _isInited;

    public BackupServerWizardBase(SOItemInterface sOItemInterface, SCContainer2 sCContainer2, String string) {
        super(sOItemInterface, sCContainer2, string);
        this._serverSO = (ServerSO)ContainerViewBO.getServerBO(this.getConnection()).getSO();
        this.setInstallationMode();
    }

    public BackupServerWizardBase(SOItemInterface sOItemInterface, SCDetailsContainer sCDetailsContainer, String string) {
        super(sOItemInterface, sCDetailsContainer, string);
        this._serverSO = (ServerSO)ContainerViewBO.getServerBO(this.getConnection()).getSO();
        this.setInstallationMode();
    }

    public void setInstallationMode() {
        try {
            this.installationMode = this._serverSO.getInstallationMode().equals("private") ? LOCAL_INSTALLATION_MODE : SHARED_INSTALLATION_MODE;
        }
        catch (AuthorizationException authorizationException) {
            Support.showError(this.getConnection(), this.getClass(), ASEUtils.getString("MSG_NEED_AGENT_AUTHENTICATION"));
        }
        catch (Exception exception) {
            Support.showError(this.getConnection(), this.getClass(), this.getJDialog(), exception.toString());
        }
    }

    @Override
    public abstract SCPageController[] getPages();

    protected void disableAuxButton(ASEBaseWizardPage2 aSEBaseWizardPage2) {
        aSEBaseWizardPage2.getGO().getPreviewButton().setVisible(false);
        aSEBaseWizardPage2.getGO().getScheduleButton().setVisible(false);
    }

    protected void enabledNextFinish(ASEBaseWizardPage2 aSEBaseWizardPage2, boolean bl) {
        aSEBaseWizardPage2.enableNextButton(bl);
        aSEBaseWizardPage2.enableFinishButton(bl);
        this.disableAuxButton(aSEBaseWizardPage2);
    }

    protected void enabledNext(ASEBaseWizardPage2 aSEBaseWizardPage2, boolean bl) {
        aSEBaseWizardPage2.enableNextButton(bl);
    }

    protected void enabledFinish(ASEBaseWizardPage2 aSEBaseWizardPage2, boolean bl) {
        aSEBaseWizardPage2.enableFinishButton(bl);
        this.disableAuxButton(aSEBaseWizardPage2);
    }

    public ICluster getCluster() {
        try {
            return this._serverSO.getClusterConfiguration();
        }
        catch (Exception exception) {
            Support.showDetailsError(this.getConnection(), this.getClass(), exception.getMessage(), exception);
            return null;
        }
    }

    public IServer getInstance(String string) {
        IServer iServer = null;
        IServer[] iServerArray = this.getCluster().getServersArray();
        for (int i = 0; i < iServerArray.length; ++i) {
            if (!iServerArray[i].getName().equals(string)) continue;
            iServer = iServerArray[i];
        }
        return iServer;
    }

    public boolean isValidateServerName(String string) {
        String string2 = "([a-zA-Z])(((\\w)*)((\\w)$)){0,1}";
        return Pattern.compile(string2).matcher(string).matches();
    }

    public SDCInstanceSO getSDCInstanceSO(String string) {
        ServerBO serverBO = ContainerViewBO.getServerBO(this.getConnection());
        SDCInstanceBO sDCInstanceBO = ContainerViewBO.getSDCInstanceBO(serverBO, string);
        if (sDCInstanceBO == null) {
            return null;
        }
        return (SDCInstanceSO)sDCInstanceBO.getSO();
    }

    public SDCInstanceSO getSDCInstanceSOByHost(String string) {
        SDCInstanceSO sDCInstanceSO = null;
        IServer[] iServerArray = this.getCluster().getServersArray();
        for (int i = 0; !(i >= iServerArray.length || iServerArray[i].getNode().equals(string) && (sDCInstanceSO = this.getSDCInstanceSO(iServerArray[i].getName())).isUAFMonitored()); ++i) {
        }
        return sDCInstanceSO;
    }

    public String getClusterName() {
        ServerBO serverBO = ContainerViewBO.getServerBO(this.getConnection());
        try {
            return ((ServerSO)serverBO.getSO()).getClusterName();
        }
        catch (SQLException sQLException) {
            Support.showDetailsError(this.getConnection(), this.getClass(), (Container)this.getJDialog(), sQLException.getMessage(), sQLException);
            return "";
        }
    }

    public void showThreadInfo(final String string, final Container container) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Support.showInfo(BackupServerWizardBase.this.getConnection(), this.getClass(), container, string);
            }
        });
    }

    public void showThreadError(final String string, final Container container) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Support.showError(BackupServerWizardBase.this.getConnection(), this.getClass(), container, string);
            }
        });
    }

    public void showThreadDetailError(final String string, final Container container, final Exception exception) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Support.showDetailsError(BackupServerWizardBase.this.getConnection(), this.getClass(), container, string, exception);
            }
        });
    }

    public int validateFilePath(String string, ServerSO serverSO) throws RemoteException {
        SDCClusterAgentProxy sDCClusterAgentProxy = new SDCClusterAgentProxy(serverSO.getAgentConnection());
        Boolean bl = (Boolean)sDCClusterAgentProxy.invokeServiceMethod("FileTransferService", "isAbsolute", new Object[]{string}, new String[]{"java.lang.String"});
        if (!bl.booleanValue()) {
            return 100;
        }
        boolean bl2 = sDCClusterAgentProxy.fileExists(string);
        if (bl2) {
            Boolean bl3 = (Boolean)sDCClusterAgentProxy.invokeServiceMethod("FileTransferService", "isFile", new Object[]{string}, new String[]{"java.lang.String"});
            if (bl3.booleanValue()) {
                Boolean bl4 = (Boolean)sDCClusterAgentProxy.invokeServiceMethod("FileTransferService", "canWrite", new Object[]{string}, new String[]{"java.lang.String"});
                if (!bl4.booleanValue()) {
                    return 200;
                }
                return 1;
            }
            Boolean bl5 = (Boolean)sDCClusterAgentProxy.invokeServiceMethod("FileTransferService", "isDirectory", new Object[]{string}, new String[]{"java.lang.String"});
            if (bl5.booleanValue()) {
                return 201;
            }
            String[] stringArray = (String[])sDCClusterAgentProxy.invokeServiceMethod("EnvironmentDiscoveryService", "getRawDevices", null, null);
            for (int i = 0; i < stringArray.length; ++i) {
                if (!stringArray[i].trim().equals(string)) continue;
                return 101;
            }
        } else {
            String string2 = (String)sDCClusterAgentProxy.invokeServiceMethod("FileTransferService", "getParent", new Object[]{string}, new String[]{"java.lang.String"});
            if (string2 == null) {
                return 202;
            }
            boolean bl6 = sDCClusterAgentProxy.fileExists(string2);
            if (bl6) {
                Boolean bl7 = (Boolean)sDCClusterAgentProxy.invokeServiceMethod("FileTransferService", "canRead", new Object[]{string2}, new String[]{"java.lang.String"});
                if (!bl7.booleanValue()) {
                    return 203;
                }
                Boolean bl8 = (Boolean)sDCClusterAgentProxy.invokeServiceMethod("FileTransferService", "canWrite", new Object[]{string2}, new String[]{"java.lang.String"});
                if (!bl8.booleanValue()) {
                    return 204;
                }
                return 0;
            }
            return 202;
        }
        return -1;
    }

    protected boolean isSharedByAllNodes(String string, Vector vector) {
        String string2 = null;
        SDCInstanceSO sDCInstanceSO = null;
        for (int i = 0; i < vector.size(); ++i) {
            string2 = ((Object[])vector.get(i))[0].toString();
            sDCInstanceSO = this.getSDCInstanceSOByHost(string2);
            try {
                int n;
                if (!sDCInstanceSO.isUAFMonitored() || (n = this.validateFilePath(string, sDCInstanceSO)) == 0 || n == 1) continue;
                return false;
            }
            catch (RemoteException remoteException) {
                return false;
            }
        }
        return true;
    }

    protected String getPostPrefix(int n) {
        if (n == BackupServerWizard.SERVER_TYPE_BACKUP || n == BackupServerWizard.SERVER_TYPE_MULTIBACKUP) {
            return "_BS";
        }
        if (n == BackupServerWizard.SERVER_TYPE_MONITOR) {
            return "_MS";
        }
        return "_XP";
    }

    private boolean isClusterorInstanceName(String string) {
        if (string.trim().equals(this.getClusterName())) {
            return true;
        }
        return this.getSDCInstanceSO(string.trim()) != null;
    }

    public boolean validateServerName(String string) {
        if (string.length() > 30 || !this.isValidateServerName(string)) {
            ASEMessageText aSEMessageText = new ASEMessageText(ASEUtils.getString("ERR_INVALID_NAME_ENTRY"), string);
            Support.showError(this.getConnection(), this.getClass(), this.getJDialog(), aSEMessageText.toString());
            return false;
        }
        if (this.isClusterorInstanceName(string)) {
            ASEMessageText aSEMessageText = new ASEMessageText(ASEUtils.getString("ERRM_OBJECT_ALREADY_EXIST"), string);
            Support.showError(this.getConnection(), this.getClass(), this.getJDialog(), aSEMessageText.toString());
            return false;
        }
        return true;
    }

    public boolean validateErrorLog(String string) {
        ICluster iCluster = this.getCluster();
        IServer[] iServerArray = iCluster.getServersArray();
        return this.validateErrorLog(string, iServerArray[0].getNode(), SERVER_TYPE_BACKUP);
    }

    public boolean validateErrorLog(String string, String string2, int n) {
        int n2 = 0;
        SDCInstanceSO sDCInstanceSO = null;
        sDCInstanceSO = n == SERVER_TYPE_BACKUP ? this.getSDCInstanceSOByHost(string2) : this.getSDCInstanceSO(string2);
        if (!sDCInstanceSO.isUAFMonitored()) {
            return true;
        }
        try {
            n2 = this.validateFilePath(string, sDCInstanceSO);
            if (n2 == 0 || n2 == 1) {
                return true;
            }
            this.displayErrorLogFileError(n2, string, sDCInstanceSO, n);
        }
        catch (Exception exception) {
            ASEMessageText aSEMessageText = new ASEMessageText(ASEUtils.getString("SDC_ERROR"), exception.getMessage());
            Support.showError(this.getConnection(), this.getClass(), this.getJDialog(), aSEMessageText.toString());
        }
        return false;
    }

    public boolean validateDuplicateErrorLog(Vector vector, String string, String string2) {
        int n = 1;
        IServer iServer = this.getInstance(string);
        String string3 = iServer.getNode();
        String string4 = null;
        String string5 = null;
        for (int i = 0; i < vector.size(); ++i) {
            string4 = ((Object[])vector.get(i))[0].toString();
            if (string4.equals(string) || !(iServer = this.getInstance(string4)).getNode().equals(string3) || !((Object[])vector.get(i))[2].equals(string2)) continue;
            ++n;
            string5 = string4;
        }
        if (n > 1) {
            ASEMessageText aSEMessageText = new ASEMessageText(ASEUtils.getString("ERR_IDENTICAL_INSTANCE_ERROR_LOG"), string, string5);
            this.showThreadError(aSEMessageText.toString(), this.getJDialog());
            return false;
        }
        return true;
    }

    public void displayErrorLogFileError(int n, String string, SDCInstanceSO sDCInstanceSO, int n2) {
        ASEMessageText aSEMessageText = null;
        String string2 = this.getInstance(sDCInstanceSO.getName()).getNode();
        String string3 = sDCInstanceSO.getName();
        if (n2 == SERVER_TYPE_BACKUP) {
            switch (n) {
                case 100: {
                    aSEMessageText = new ASEMessageText(ASEUtils.getString("ERR_AUX_NODE_FILE_NOT_ABSOLUTE_PATH"), string, string2);
                    break;
                }
                case 101: {
                    aSEMessageText = new ASEMessageText(ASEUtils.getString("ERR_AUX_NODE_FILE_IS_RAW_DEVICE"), string, string2);
                    break;
                }
                case 200: {
                    aSEMessageText = new ASEMessageText(ASEUtils.getString("ERR_AUX_NODE_FILE_NOT_WRITABLE"), string, string2);
                    break;
                }
                case 201: {
                    aSEMessageText = new ASEMessageText(ASEUtils.getString("ERR_AUX_NODE_FILE_IS_DIRECTORY"), string, string2);
                    break;
                }
                case 202: {
                    aSEMessageText = new ASEMessageText(ASEUtils.getString("ERR_AUX_NODE_FILE_PARENT_DIR_NOT_EXIST"), string, string2);
                    break;
                }
                case 203: {
                    aSEMessageText = new ASEMessageText(ASEUtils.getString("ERR_AUX_NODE_FILE_PARENT_DIR_NOT_READABLE"), string, string2);
                    break;
                }
                case 204: {
                    aSEMessageText = new ASEMessageText(ASEUtils.getString("ERR_AUX_NODE_FILE_PARENT_DIR_NOT_WRITABLE"), string, string2);
                    break;
                }
                default: {
                    aSEMessageText = new ASEMessageText(ASEUtils.getString("SDC_ERROR_UNKNOWN"), string);
                    break;
                }
            }
        } else {
            switch (n) {
                case 100: {
                    aSEMessageText = new ASEMessageText(ASEUtils.getString("ERR_AUX_INS_FILE_NOT_ABSOLUTE_PATH"), string, string2, string3);
                    break;
                }
                case 101: {
                    aSEMessageText = new ASEMessageText(ASEUtils.getString("ERR_AUX_INS_FILE_IS_RAW_DEVICE"), string, string2, string3);
                    break;
                }
                case 200: {
                    aSEMessageText = new ASEMessageText(ASEUtils.getString("ERR_AUX_INS_FILE_NOT_WRITABLE"), string, string2, string3);
                    break;
                }
                case 201: {
                    aSEMessageText = new ASEMessageText(ASEUtils.getString("ERR_AUX_INS_FILE_IS_DIRECTORY"), string, string2, string3);
                    break;
                }
                case 202: {
                    aSEMessageText = new ASEMessageText(ASEUtils.getString("ERR_AUX_INS_FILE_PARENT_DIR_NOT_EXIST"), string, string2, string3);
                    break;
                }
                case 203: {
                    aSEMessageText = new ASEMessageText(ASEUtils.getString("ERR_AUX_INS_FILE_PARENT_DIR_NOT_READABLE"), string, string2, string3);
                    break;
                }
                case 204: {
                    aSEMessageText = new ASEMessageText(ASEUtils.getString("ERR_AUX_INS_FILE_PARENT_DIR_NOT_WRITABLE"), string, string2, string3);
                    break;
                }
                default: {
                    aSEMessageText = new ASEMessageText(ASEUtils.getString("SDC_ERROR_UNKNOWN"), string);
                }
            }
        }
        this.showThreadError(aSEMessageText.toString(), this.getJDialog());
    }

    public boolean discoveryUnusedPort(InitAuxiliaryServerTask initAuxiliaryServerTask, Dialog dialog) {
        ASEMessageText aSEMessageText = new ASEMessageText(ASEUtils.getString("AUXILIARY_SERVER_DISCOVER_CLUSTER_AVAILABLE_PORT"), this.getClusterName());
        WorkingDialogWithSkipCancel workingDialogWithSkipCancel = new WorkingDialogWithSkipCancel(dialog, initAuxiliaryServerTask, ASEUtils.getString("AUXILIARY_SERVER_DISCOVER_AVAILABLE_PORT_TITLE"), aSEMessageText.toString());
        if (workingDialogWithSkipCancel.isSkipped()) {
            initAuxiliaryServerTask.onSkipped();
        }
        workingDialogWithSkipCancel.dispose();
        return !workingDialogWithSkipCancel.isCancelled();
    }

    public boolean validateDuplicatePort(Vector vector, String string, Integer n) {
        int n2 = 1;
        IServer iServer = this.getInstance(string);
        String string2 = iServer.getNode();
        String string3 = null;
        String string4 = null;
        for (int i = 0; i < vector.size(); ++i) {
            string3 = ((Object[])vector.get(i))[0].toString();
            if (string3.equals(string) || !(iServer = this.getInstance(string3)).getNode().equals(string2) || !((Integer)((Object[])vector.get(i))[1]).equals(n)) continue;
            ++n2;
            string4 = string3;
        }
        if (n2 > 1) {
            ASEMessageText aSEMessageText = new ASEMessageText(ASEUtils.getString("ERR_IDENTICAL_INSTANCE_PORT_NUMBER"));
            Object[] objectArray = new Object[]{n.toString(), string, string4, iServer.getNode()};
            aSEMessageText.setArguments(objectArray);
            this.showThreadError(aSEMessageText.toString(), this.getJDialog());
            return false;
        }
        return true;
    }

    protected boolean isPortExists(String string, Integer n, int n2) throws AgentConnectionException, RemoteException {
        String string2 = n2 == SERVER_TYPE_BACKUP ? string : this.getInstance(string).getNode();
        ICluster iCluster = this.getCluster();
        if (this._serverSO.doesHostPortExistInInterface(iCluster, string2, n)) {
            ASEMessageText aSEMessageText = null;
            aSEMessageText = n2 == SERVER_TYPE_BACKUP ? new ASEMessageText(ASEUtils.getString("ERR_PORT_NUMBER_EXISTS"), n.toString(), string2) : new ASEMessageText(ASEUtils.getString("ERR_INSTANCE_PORT_NUMBER_EXISTS"), n.toString(), string);
            this.showThreadError(aSEMessageText.toString(), this.getJDialog());
            return true;
        }
        return false;
    }

    public boolean validatePortForHost(String string, Integer n) throws AgentConnectionException, RemoteException {
        boolean bl;
        SDCInstanceSO sDCInstanceSO = this.getSDCInstanceSOByHost(string);
        if (sDCInstanceSO.isUAFMonitored() && !(bl = sDCInstanceSO.isPortAvailable(1, string, n))) {
            ASEMessageText aSEMessageText = new ASEMessageText(ASEUtils.getString("ERR_INVALID_PORT_NUMBER"), n.toString(), string);
            this.showThreadError(aSEMessageText.toString(), this.getJDialog());
            return false;
        }
        return !this.isPortExists(string, n, SERVER_TYPE_BACKUP);
    }

    public boolean validatePortForInstance(String string, Integer n) throws AgentConnectionException, RemoteException {
        boolean bl;
        SDCInstanceSO sDCInstanceSO = this.getSDCInstanceSO(string);
        if (sDCInstanceSO.isUAFMonitored() && !(bl = sDCInstanceSO.isPortAvailable(1, this.getInstance(string).getNode(), n))) {
            ASEMessageText aSEMessageText = new ASEMessageText(ASEUtils.getString("ERR_INVALID_INSTANCE_PORT_NUMBER"), n.toString(), this.getInstance(string).getNode(), string);
            this.showThreadError(aSEMessageText.toString(), this.getJDialog());
            return false;
        }
        return !this.isPortExists(string, n, SERVER_TYPE_XP);
    }

    protected boolean createServer(CreateServerTask createServerTask, JFrame jFrame, String string) {
        ASEMessageText aSEMessageText = new ASEMessageText(ASEUtils.getString("AUXILIARY_SERVER_CFG_TASK_CONTENT"), this.getClusterName());
        WorkingDialogWithMsgChangable workingDialogWithMsgChangable = new WorkingDialogWithMsgChangable((Frame)jFrame, (WorkingDialogRunnable)createServerTask, string, aSEMessageText.toString());
        workingDialogWithMsgChangable.dispose();
        return createServerTask.isSucceed();
    }

    abstract class CreateServerTask
    implements WorkingDialogRunnable {
        protected WorkingDialogWithMsgChangable _dlg;
        protected boolean _isSucceed = false;

        CreateServerTask() {
        }

        public boolean isSucceed() {
            return this._isSucceed;
        }

        @Override
        public void setWorkingDialogWithMsgChangable(WorkingDialogWithMsgChangable workingDialogWithMsgChangable) {
            this._dlg = workingDialogWithMsgChangable;
        }

        abstract void create() throws Exception;

        @Override
        public void run() {
            try {
                this.create();
                this._isSucceed = true;
                BackupServerBO.refreshRemoteServers(BackupServerWizardBase.this.getConnection());
            }
            catch (Exception exception) {
                BackupServerWizardBase.this.showThreadDetailError(exception.getMessage(), BackupServerWizardBase.this.getJDialog(), exception);
            }
        }

        public void setNote(final String string) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    CreateServerTask.this._dlg.setNote(string);
                }
            });
        }
    }

    abstract class InitAuxiliaryServerTask
    implements Runnable {
        InitAuxiliaryServerTask() {
        }

        public abstract void initSO() throws Exception;

        public abstract Hashtable<String, Integer[]> discoverUnusedPorts(boolean var1) throws Exception;

        public abstract void initNode(IServer var1, Hashtable<String, Integer[]> var2) throws Exception;

        public void onSkipped() {
            this.init(false);
        }

        public Hashtable<String, Integer[]> findPortsEachNode(int n, boolean bl) throws Exception {
            return new PortsDiscoveryUtil(BackupServerWizardBase.this.getCluster(), ContainerViewBO.getServerBO(BackupServerWizardBase.this.getConnection())).discoverPortsEachNode(n, bl);
        }

        public Hashtable<String, Integer[]> findPortsEachInstance(int n, boolean bl) throws Exception {
            return new PortsDiscoveryUtil(BackupServerWizardBase.this.getCluster(), ContainerViewBO.getServerBO(BackupServerWizardBase.this.getConnection())).discoverPortsForEachInstance(n, bl);
        }

        @Override
        public void run() {
            this.init(true);
        }

        private void init(boolean bl) {
            try {
                this.initSO();
                Hashtable<String, Integer[]> hashtable = this.discoverUnusedPorts(bl);
                IServer[] iServerArray = BackupServerWizardBase.this.getCluster().getServersArray();
                for (int i = 0; i < iServerArray.length; ++i) {
                    this.initNode(iServerArray[i], hashtable);
                }
            }
            catch (Exception exception) {
                BackupServerWizardBase.this.showThreadDetailError(exception.getMessage(), BackupServerWizardBase.this.getJDialog(), exception);
            }
        }
    }
}

