/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.aseplugin.bo.wiz;

import com.sybase.aseplugin.ASEImages;
import com.sybase.aseplugin.ASEUtils;
import com.sybase.aseplugin.bo.Support;
import com.sybase.aseplugin.bo.dlg.DumpDeviceChoiceDialog;
import com.sybase.aseplugin.bo.wiz.ASEBaseWizardDialog2;
import com.sybase.aseplugin.bo.wiz.ASEBaseWizardPage2;
import com.sybase.aseplugin.go.ASETable;
import com.sybase.aseplugin.go.wiz.BackupWizGOBackupNamePage;
import com.sybase.aseplugin.go.wiz.BackupWizGODevicePage;
import com.sybase.aseplugin.go.wiz.BackupWizGOOptionPage;
import com.sybase.aseplugin.go.wiz.BackupWizGOTranTypePage;
import com.sybase.aseplugin.go.wiz.BackupWizGOTypePage;
import com.sybase.aseplugin.so.DatabaseSO;
import com.sybase.aseplugin.so.SOItemInterface;
import com.sybase.aseplugin.sql.ASConnection;
import com.sybase.aseplugin.sql.SQLs;
import com.sybase.aseplugin.util.ui.JLabelTableModel;
import com.sybase.aseplugin.util.ui.MyCellRenderer;
import com.sybase.aseplugin.util.ui.TableSelectionListener;
import com.sybase.central.SCContainer2;
import com.sybase.central.SCPageController;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;

public class BackupWizard
extends ASEBaseWizardDialog2 {
    private BackupWizTypePage _dlgTypeOfBackup;
    private BackupWizTranTypePage _dlgTypeofTransaction;
    private BackupWizDevicePage _dlgSelectDumpDevice;
    private BackupWizBackupNamePage _dlgSelectBackupDeviceName;
    private BackupWizOptionPage _dlgDumpPerformanceOption;
    private static Container _parent;
    private boolean withCommand = false;

    public BackupWizard(DatabaseSO databaseSO, SCContainer2 sCContainer2, Container container) {
        super((SOItemInterface)databaseSO, sCContainer2, databaseSO.getName() + " " + ASEUtils.getString("CONTEXT_MENU_BACKUP_TEXT"));
        _parent = container;
    }

    private boolean canSupportBackupTrans() {
        DatabaseSO databaseSO = (DatabaseSO)this.getSO();
        if (databaseSO.isInIMDBFamily()) {
            return false;
        }
        try {
            databaseSO.loadDurability();
        }
        catch (SQLException sQLException) {
            return true;
        }
        return databaseSO.getDurability().equalsIgnoreCase("FULL");
    }

    @Override
    public SCPageController[] getPages() {
        this._dlgTypeOfBackup = new BackupWizTypePage(this);
        this._dlgTypeofTransaction = new BackupWizTranTypePage(this);
        this._dlgSelectDumpDevice = new BackupWizDevicePage(this);
        this._dlgSelectBackupDeviceName = new BackupWizBackupNamePage(this);
        this._dlgDumpPerformanceOption = new BackupWizOptionPage(this);
        if (!this.canSupportBackupTrans()) {
            return new SCPageController[]{this._dlgSelectDumpDevice, this._dlgSelectBackupDeviceName, this._dlgDumpPerformanceOption};
        }
        return new SCPageController[]{this._dlgTypeOfBackup, this._dlgTypeofTransaction, this._dlgSelectDumpDevice, this._dlgSelectBackupDeviceName, this._dlgDumpPerformanceOption};
    }

    @Override
    public boolean deploy() {
        try {
            ASConnection aSConnection = this.getConnection();
            String string = Support.getFullTitle(ASEUtils.getString("BACKUP_EDITOR_TITLE"), aSConnection);
            String string2 = "\n---------------------------------------------------------- \n-- ";
            string2 = string2 + ((DatabaseSO)this.getSO()).getName() + " " + ASEUtils.getString("BACKUP_EDITOR_TITLE");
            string2 = string2 + "\n";
            string2 = string2 + "---------------------------------------------------------- \n";
            string2 = string2 + this.createBackupCommand();
            String string3 = aSConnection.getDisplayName() + this.getSO().getName() + " Dump";
            Support.writeToExtendedLogFileEditor(string, ASEImages.getDatabaseSmallImage(), string2, aSConnection, null, string3);
        }
        catch (SQLException sQLException) {
            Support.showDetailsError(this.getConnection(), this.getClass(), (Container)this.getJDialog(), sQLException.getMessage(), sQLException);
            return false;
        }
        return true;
    }

    public String CreateDumpPerformanceOption() throws SQLException {
        String string = "";
        String string2 = this.getConnection().getVersion();
        if (string2.compareTo("12.0") >= 0) {
            String string3 = "";
            String string4 = "exec sp_dumpoptimize ";
            if (this._dlgDumpPerformanceOption.isDefault()) {
                string3 = string3 + string4;
                string3 = string3 + "'archive_space=default' ";
            } else if (this._dlgDumpPerformanceOption.isMax()) {
                string3 = string3 + string4;
                string3 = string3 + "'archive_space=maximum' ";
            } else if (this._dlgDumpPerformanceOption.isMin()) {
                string3 = string3 + string4;
                string3 = string3 + "'archive_space=minimum' ";
            } else {
                string3 = string3 + string4;
                string3 = string3 + "'reserved_threshold, ";
                string3 = string3 + this._dlgDumpPerformanceOption.getReservedPage();
                string3 = string3 + "' , ";
                string3 = string3 + "'allocation_threshold, ";
                string3 = string3 + this._dlgDumpPerformanceOption.getAllocatedPage();
                string3 = string3 + "'";
            }
            string = string + this.getSO().getConnection().executeReturnWarningMsg("master", string3);
        }
        return string;
    }

    public String getDbBackupCommand() {
        String string = SQLs.getString("dump database {0} to ", this.getSO().getName());
        string = string + this.createStripeCommand();
        string = string + this.createWithCommand(this.withCommand);
        return string;
    }

    private String getTlogBackupCommand() {
        String string = SQLs.getString("dump transaction {0} ", this.getSO().getName());
        if (this._dlgTypeofTransaction.TruncAndLog()) {
            string = string + " with truncate_only ";
        } else if (this._dlgTypeofTransaction.TruncAndDoNotLog()) {
            string = string + " with no_log ";
        } else {
            string = string + " to ";
            string = string + this.createStripeCommand();
            if (this._dlgTypeofTransaction.BackupAndLog()) {
                string = string + " with no_truncate ";
                string = string + this.createWithCommand(false);
            } else {
                string = string + this.createWithCommand(this.withCommand);
            }
        }
        return string;
    }

    public String createBackupCommand() throws SQLException {
        String string = this.CreateDumpPerformanceOption();
        string = string + this.getBackupRestoreCommand();
        return string;
    }

    private String getBackupRestoreCommand() throws SQLException {
        boolean bl;
        String string = "";
        String string2 = "";
        ((DatabaseSO)this.getSO()).useMasterDB();
        string2 = this._dlgTypeOfBackup.isBackupAll() ? string2 + this.getDbBackupCommand() : string2 + this.getTlogBackupCommand();
        boolean bl2 = false;
        if (!((DatabaseSO)this.getSO()).getName().equals("tempdb") && (bl = ((DatabaseSO)this.getSO()).isDumpOrLoadInProgress())) {
            Support.showWarning(this.getConnection(), this.getClass(), this.getJDialog(), ((DatabaseSO)this.getSO()).getName() + ASEUtils.getString("MSG_SYB_DUMPLOAD_IN_PROGRESS"));
            bl2 = true;
        }
        if (!bl2) {
            string = string + this.getSO().getConnection().executeReturnWarningMsg("master", string2);
        }
        return string;
    }

    private String createWithCommand(boolean bl) {
        String string;
        String string2;
        String string3 = "";
        if (!bl) {
            return string3;
        }
        string3 = string3 + " with ";
        string3 = this._dlgSelectBackupDeviceName.PerformInit() ? string3 + " init " : string3 + " noinit ";
        string3 = string3 + ", ";
        string3 = this._dlgSelectBackupDeviceName.PerformRewind() ? string3 + " unload " : string3 + " nounload ";
        String string4 = this._dlgSelectBackupDeviceName.getDumpName();
        if (string4.length() > 0) {
            string3 = string3 + ", " + " file = " + string4;
        }
        if ((string2 = this._dlgSelectBackupDeviceName.getRetainDays()).length() > 0) {
            string3 = string3 + ", " + " retaindays = " + string2;
        }
        if ((string = this._dlgSelectBackupDeviceName.getPassword()).length() > 0) {
            string3 = string3 + ", " + " passwd = " + "'" + string + "'";
        }
        return string3;
    }

    private String createStripeCommand() {
        String string = "";
        JLabelTableModel jLabelTableModel = this._dlgSelectDumpDevice.getTableModel();
        boolean bl = true;
        for (int i = 0; i < jLabelTableModel.getRowCount(); ++i) {
            String string2;
            String string3;
            String string4;
            Vector vector = jLabelTableModel.getRow(i);
            String string5 = (String)vector.elementAt(4);
            String string6 = SQLs.getString(" ''{0}'' ", string5);
            if (bl) {
                bl = false;
                string = string + string6;
            } else {
                string = string + " stripe on  " + string6;
            }
            boolean bl2 = (Boolean)vector.elementAt(2);
            boolean bl3 = (Boolean)vector.elementAt(3);
            if (!bl2 && bl3) {
                JLabel jLabel = (JLabel)vector.elementAt(0);
                string4 = jLabel.getText();
                string = string + " at " + string4;
            }
            boolean bl4 = false;
            string4 = (String)vector.elementAt(5);
            if (string4.length() > 0) {
                string = string + " dumpvolume = " + string4;
                bl4 = true;
            }
            if ((string3 = (String)vector.elementAt(6)).length() > 0) {
                if (bl4) {
                    string = string + ", ";
                }
                string = string + " blocksize = " + string3;
                bl4 = true;
            }
            if ((string2 = (String)vector.elementAt(7)).length() <= 0) continue;
            if (bl4) {
                string = string + ", ";
            }
            string = string + " capacity = " + string2;
            bl4 = true;
        }
        return string;
    }

    @Override
    public void releaseResources() {
        this._dlgTypeOfBackup = null;
        this._dlgTypeofTransaction = null;
        this._dlgSelectDumpDevice = null;
        this._dlgSelectBackupDeviceName = null;
        this._dlgDumpPerformanceOption = null;
        _parent = null;
        super.releaseResources();
    }

    class BackupWizOptionPage
    extends ASEBaseWizardPage2
    implements ActionListener {
        BackupWizGOOptionPage _go;

        public BackupWizOptionPage(BackupWizard backupWizard2) {
            super(backupWizard2, (JPanel)((Object)new BackupWizGOOptionPage()), ASEUtils.getString("CHOOSE_DUMP_PERM_OPTION"));
            this._go = (BackupWizGOOptionPage)((Object)this.getJPanel());
            this._go.defaultRadioButton.addActionListener((ActionListener)this);
            this._go.maximumRadioButton.addActionListener((ActionListener)this);
            this._go.minimumRadioButton.addActionListener((ActionListener)this);
            this._go.advancedRadioButton.addActionListener((ActionListener)this);
            this.getGO().setDisplayPreviewButton(false);
            this.getGO().setDisplayScheduleButton(false);
        }

        void advancedSelected(boolean bl) {
            this._go.reservedPagesSpinBox.setEnabled(bl);
            this._go.allocatedPagesSpinBox.setEnabled(bl);
            this._go.reservedPagesLabel.setEnabled(bl);
            this._go.allocatedPagesLabel.setEnabled(bl);
            this._go.thresholdPanel.setEnabled(bl);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.advancedSelected(this._go.advancedRadioButton.isSelected());
        }

        @Override
        public void init() {
            this._go.defaultRadioButton.isSelected();
            this.advancedSelected(false);
        }

        public boolean isDefault() {
            return this._go.defaultRadioButton.isSelected();
        }

        public boolean isMax() {
            return this._go.maximumRadioButton.isSelected();
        }

        public boolean isMin() {
            return this._go.minimumRadioButton.isSelected();
        }

        public int getReservedPage() {
            return this._go.reservedPagesSpinBox.getValue();
        }

        public int getAllocatedPage() {
            return this._go.allocatedPagesSpinBox.getValue();
        }

        @Override
        public void releaseResources() {
            this._go.releaseResources();
            this._go = null;
            super.releaseResources();
        }
    }

    class BackupWizBackupNamePage
    extends ASEBaseWizardPage2 {
        BackupWizGOBackupNamePage _go;

        public BackupWizBackupNamePage(BackupWizard backupWizard2) {
            super(backupWizard2, (JPanel)((Object)new BackupWizGOBackupNamePage()), ASEUtils.getString("SELECT_BACKUP_NAME"));
            this._go = (BackupWizGOBackupNamePage)((Object)this.getJPanel());
            this.getGO().setDisplayPreviewButton(false);
            this.getGO().setDisplayScheduleButton(false);
        }

        @Override
        public boolean showPage() {
            this.enableFinishButton(true);
            DatabaseSO databaseSO = (DatabaseSO)((BackupWizard)this.getParent()).getSO();
            if (databaseSO.getConnection().getVersion().compareTo("12.5.2") < 0 || BackupWizard.this._dlgTypeOfBackup.isBackupTransactionLog()) {
                this._go.passwordMultiLineLabel.setVisible(false);
                this._go.passwordTextField.setVisible(false);
            }
            return !BackupWizard.this._dlgTypeofTransaction.TruncAndLog() && !BackupWizard.this._dlgTypeofTransaction.TruncAndDoNotLog();
        }

        @Override
        public void init() {
            this._go.appendCheckBox.setSelected(true);
            this._go.retentionTimeTextField.setText("0");
            BackupWizard.this.withCommand = true;
        }

        @Override
        public int onWizardNext() {
            try {
                Integer.parseInt(this._go.retentionTimeTextField.getText());
            }
            catch (NumberFormatException numberFormatException) {
                this._go.retentionTimeTextField.setText("0");
            }
            return super.onWizardNext();
        }

        public boolean PerformInit() {
            return !this._go.appendCheckBox.isSelected();
        }

        public boolean PerformRewind() {
            return this._go.rewindCheckBox.isSelected();
        }

        public String getDumpName() {
            return this._go.optionalNameTextField.getText();
        }

        public String getRetainDays() {
            return this._go.retentionTimeTextField.getText();
        }

        public String getPassword() {
            return this._go.passwordTextField.getText();
        }

        @Override
        public void releaseResources() {
            this._go.releaseResources();
            this._go = null;
            super.releaseResources();
        }
    }

    class BackupWizDevicePage
    extends ASEBaseWizardPage2
    implements ActionListener {
        BackupWizGODevicePage _go;
        Vector _dumpDeviceVector;
        Vector _removebackupServerVector;
        int _pageSizeBytes;
        Vector _tableVector;
        JTable _table;
        private JLabelTableModel _tableModel;

        public BackupWizDevicePage(BackupWizard backupWizard2) {
            super(backupWizard2, (JPanel)((Object)new BackupWizGODevicePage()), ASEUtils.getString("SELECT_DUMP_DEVICE"));
            this._dumpDeviceVector = new Vector();
            this._removebackupServerVector = new Vector();
            this._tableVector = new Vector();
            this._go = (BackupWizGODevicePage)((Object)this.getJPanel());
            this.getGO().setDisplayPreviewButton(false);
            this.getGO().setDisplayScheduleButton(false);
            this._go.removeButton.setEnabled(false);
            this._go.addButton.addActionListener((ActionListener)this);
            this._go.removeButton.addActionListener((ActionListener)this);
        }

        @Override
        public boolean showPage() {
            if (BackupWizard.this._dlgTypeofTransaction.TruncAndLog() || BackupWizard.this._dlgTypeofTransaction.TruncAndDoNotLog()) {
                return false;
            }
            this.enableNextButton(this._tableModel.getRowCount() > 0);
            return true;
        }

        @Override
        public void init() throws SQLException {
            this.getNamedDumpDevice();
            this.getRemoveBackupServer();
            this._pageSizeBytes = this.getpageSizeBytes();
            Vector<String> vector = new Vector<String>();
            vector.addElement(ASEUtils.getString("DISP_NAME_TEXT"));
            vector.addElement(ASEUtils.getString("MSG_DEFAULT_OPTIONS"));
            this._tableModel = new JLabelTableModel(vector, this._tableVector);
            this._table = new ASETable(this._tableModel);
            this._table.setDefaultRenderer(new JLabel().getClass(), new MyCellRenderer());
            this._go.dumpDeviceScrollPane.getViewport().setView(this._table);
            this._table.setSelectionMode(0);
            TableSelectionListener tableSelectionListener = new TableSelectionListener(){

                @Override
                public void deSelectAction() {
                    BackupWizDevicePage.this._go.removeButton.setEnabled(false);
                }

                @Override
                public void selectAction() {
                    BackupWizDevicePage.this._go.removeButton.setEnabled(true);
                }
            };
            this._table.getSelectionModel().addListSelectionListener(tableSelectionListener);
        }

        int getpageSizeBytes() {
            return this.getConnection().getPageSize();
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == this._go.addButton) {
                DumpDeviceChoiceDialog.showDialog(_parent, this._dumpDeviceVector, this._removebackupServerVector, this._pageSizeBytes, this._tableModel, this._table, true);
            } else if (object == this._go.removeButton) {
                int[] nArray = this._table.getSelectedRows();
                for (int i = 0; i < nArray.length; ++i) {
                    this._tableModel.removeRow(nArray[i]);
                }
                this._table.tableChanged(new TableModelEvent(this._tableModel));
                this._go.removeButton.setEnabled(false);
            }
            this.enableNextButton(this._tableModel.getRowCount() > 0);
            this.enableFinishButton(this._tableModel.getRowCount() > 0);
        }

        private void getNamedDumpDevice() throws SQLException {
            this._dumpDeviceVector = new Vector();
            ImageIcon imageIcon = new ImageIcon(ASEImages.getDeviceSmallImage());
            Vector vector = ((DatabaseSO)this.getSO()).getListDumpDevice();
            for (int i = 0; i < vector.size(); ++i) {
                String[] stringArray = (String[])vector.elementAt(i);
                this._dumpDeviceVector.addElement(new JLabel(stringArray[0], imageIcon, 2));
            }
        }

        private void getRemoveBackupServer() throws SQLException {
            this._removebackupServerVector = ((DatabaseSO)this.getSO()).getListRemoveBackupServer();
        }

        public JLabelTableModel getTableModel() {
            return this._tableModel;
        }

        @Override
        public void releaseResources() {
            this._go.addButton.removeActionListener((ActionListener)this);
            this._go.removeButton.removeActionListener((ActionListener)this);
            this._go.releaseResources();
            this._go = null;
            this._dumpDeviceVector = null;
            this._removebackupServerVector = null;
            this._tableVector = null;
            this._table = null;
            this._tableModel = null;
            super.releaseResources();
        }
    }

    class BackupWizTranTypePage
    extends ASEBaseWizardPage2 {
        BackupWizGOTranTypePage _go;

        public BackupWizTranTypePage(BackupWizard backupWizard2) {
            super(backupWizard2, (JPanel)((Object)new BackupWizGOTranTypePage()), ASEUtils.getString("CHOOSE_TYPE_OF_TRANSACTION"));
            this._go = (BackupWizGOTranTypePage)((Object)this.getJPanel());
            this.getGO().setDisplayPreviewButton(false);
            this.getGO().setDisplayScheduleButton(false);
        }

        @Override
        public boolean showPage() {
            return BackupWizard.this._dlgTypeOfBackup.isBackupTransactionLog();
        }

        public boolean BackupTruncAndLog() {
            return this._go.backupInactiveLogRadioButton.isSelected();
        }

        public boolean BackupAndLog() {
            return this._go.backupLogAddNewEntryRadioButton.isSelected();
        }

        public boolean TruncAndLog() {
            return this._go.removeLogAddNewEntryRadioButton.isSelected();
        }

        public boolean TruncAndDoNotLog() {
            return this._go.removeInactiveLogRadioButton.isSelected();
        }

        @Override
        public void releaseResources() {
            this._go.releaseResources();
            this._go = null;
            super.releaseResources();
        }
    }

    public class BackupWizTypePage
    extends ASEBaseWizardPage2 {
        BackupWizGOTypePage _go;

        public BackupWizTypePage(BackupWizard backupWizard2) {
            super(backupWizard2, (JPanel)((Object)new BackupWizGOTypePage()), ASEUtils.getString("SELECT_TYPE_BACKUP"));
            this._go = (BackupWizGOTypePage)((Object)this.getJPanel());
            this.getGO().setDisplayPreviewButton(false);
            this.getGO().setDisplayScheduleButton(false);
        }

        public boolean isBackupAll() {
            return this._go.databaseRadioButton.isSelected();
        }

        public boolean isBackupTransactionLog() {
            return this._go.logRadioButton.isSelected();
        }

        @Override
        public void releaseResources() {
            this._go.releaseResources();
            this._go = null;
            super.releaseResources();
        }
    }
}

