/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.aseplugin.bo.wiz;

import com.sybase.aseplugin.ASEImages;
import com.sybase.aseplugin.ASEMessageText;
import com.sybase.aseplugin.ASEUtils;
import com.sybase.aseplugin.bo.CachesCtrBO;
import com.sybase.aseplugin.bo.Support;
import com.sybase.aseplugin.bo.wiz.ASEBaseWizDocPage;
import com.sybase.aseplugin.bo.wiz.ASEBaseWizardDialog2;
import com.sybase.aseplugin.bo.wiz.ASEBaseWizardPage2;
import com.sybase.aseplugin.bo.wiz.NameWizBOPage;
import com.sybase.aseplugin.bo.wiz.SummaryWizBOPage;
import com.sybase.aseplugin.go.wiz.CacheWizGOPage2;
import com.sybase.aseplugin.go.wiz.CacheWizGOPage3;
import com.sybase.aseplugin.so.CacheSO;
import com.sybase.aseplugin.so.SOItemInterface;
import com.sybase.aseplugin.so.Utility;
import com.sybase.central.SCContainer2;
import com.sybase.central.SCPageController;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;

public class CacheWizard
extends ASEBaseWizardDialog2 {
    public CacheWizard(CacheSO cacheSO, CachesCtrBO cachesCtrBO, String string) {
        super((SOItemInterface)cacheSO, (SCContainer2)cachesCtrBO, string);
    }

    @Override
    public SCPageController[] getPages() {
        return new SCPageController[]{new CacheWizNamePage(this), new CacheWizSizePage(this), new CacheWizTypePage(this), new CacheWizSummaryPage(this)};
    }

    class CacheWizSummaryPage
    extends SummaryWizBOPage {
        public CacheWizSummaryPage(CacheWizard cacheWizard2) {
            super(cacheWizard2, ASEImages.getCacheWizardImage());
        }

        private String getCacheOptionValue() {
            CacheSO cacheSO = (CacheSO)this.getSO();
            String string = "";
            if (cacheSO.getCacheType() == "mixed") {
                string = ASEUtils.getString("CACHE_WIZ_PAGE3_RADB_DATA_AND_LOG");
            } else if (cacheSO.getCacheType() == "logonly") {
                string = ASEUtils.getString("CACHE_WIZ_PAGE3_RADB_LOG_ONLY");
            } else if (cacheSO.getCacheType() == "inmemory_storage") {
                string = ASEUtils.getString("CACHE_WIZ_PAGE3_RADB_IM_DATABASES");
            }
            int n = string.indexOf("(");
            if (n > -1) {
                return string.substring(0, n);
            }
            return string;
        }

        @Override
        public void enableComponents() {
            CacheSO cacheSO = (CacheSO)this.getSO();
            this.clearSummaryItems();
            this.addSummaryItem(ASEUtils.getString("DISP_NAME_TEXT"), cacheSO.getName());
            this.addSummaryItem(ASEUtils.getString("LABC_SIZE"), cacheSO.getCacheDisplaySize() + cacheSO.getCacheDisplayUnit());
            this.addSummaryItem(ASEUtils.getString("LABC_CACHE_TYPE"), this.getCacheOptionValue());
            this.setSummaryInfo(this.getSummary());
        }
    }

    class CacheWizTypePage
    extends ASEBaseWizardPage2 {
        private CacheWizGOPage3 _go;

        public CacheWizTypePage(CacheWizard cacheWizard2) {
            super(cacheWizard2, (JPanel)((Object)new CacheWizGOPage3()), ASEUtils.getString("MSG_CACHE_WIZ_PAGE3"));
            this._go = (CacheWizGOPage3)((Object)this.getJPanel());
        }

        @Override
        public void init() {
            if (this.getConnection().isIMDBApplicable()) {
                this._go.introCacheStorage.setText(ASEUtils.getString("CACHE_WIZ_PAGE3_SENT_INTRO_STORAGE") + "\n\n" + ASEUtils.getString("CACHE_WIZ_PAGE3_SENT_INTRO_STORAGE_POST155"));
                this._go.inMemoryDBRadioButton.setVisible(true);
            }
        }

        @Override
        public void enableComponents() {
            this.enableFinishButton(true);
        }

        private String getCacheType() {
            if (this._go.dataAndLogRadioButton.isSelected()) {
                return "mixed";
            }
            if (this._go.logOnlyRadioButton.isSelected()) {
                return "logonly";
            }
            if (this._go.inMemoryDBRadioButton.isSelected()) {
                return "inmemory_storage";
            }
            return "";
        }

        @Override
        public boolean deploy() {
            ((CacheSO)this.getSO()).setCacheType(this.getCacheType());
            return true;
        }

        @Override
        public void releaseResources() {
            this._go.releaseResources();
            this._go = null;
            super.releaseResources();
        }
    }

    class CacheWizSizePage
    extends ASEBaseWizDocPage
    implements ActionListener {
        private CacheWizGOPage2 _go;
        private int _leftSpace;
        private double _dActualSizeInKB;
        private CacheSO _cacheSO;

        public CacheWizSizePage(CacheWizard cacheWizard2) {
            super(cacheWizard2, (JPanel)((Object)new CacheWizGOPage2()), ASEUtils.getString("MSG_CACHE_WIZ_PAGE2"));
            this._dActualSizeInKB = 0.0;
            this._go = (CacheWizGOPage2)((Object)this.getJPanel());
            this._cacheSO = (CacheSO)this.getSO();
            Support.fillUnitList((JComboBox)this._go.sizeUnitComboBox);
        }

        @Override
        public void textValueChanged(DocumentEvent documentEvent) {
            this.enableComponents();
        }

        public double getCacheSizeInKB() {
            int n = this._go.sizeUnitComboBox.getSelectedIndex();
            double d = Double.valueOf(this._go.sizeTextField.getText());
            if (n == 0) {
                this._dActualSizeInKB = this._cacheSO.multipleByPage(d);
            } else if (n == 1) {
                this._dActualSizeInKB = d;
            } else if (n == 2) {
                this._dActualSizeInKB = this._cacheSO.multipleByMB(d);
            } else if (n == 3) {
                this._dActualSizeInKB = this._cacheSO.multipleByGB(d);
            }
            this.setPageModified(true);
            return this._dActualSizeInKB;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == this._go.sizeUnitComboBox) {
                int n = this._go.sizeUnitComboBox.getSelectedIndex();
                String string = ASEUtils.getString("MSG_PAGES");
                String string2 = ASEUtils.getString("MSG_KB");
                String string3 = ASEUtils.getString("MSG_MB");
                String string4 = ASEUtils.getString("MSG_GB");
                switch (n) {
                    case 0: {
                        this._go.availableSizeUnitLabel.setText(string);
                        double d = Utility.getPrecision(this._cacheSO.dividedByPage(this._leftSpace), 2);
                        this._go.availableSizeTextLabel.setText(String.valueOf(d));
                        double d2 = Utility.getPrecision(this._cacheSO.dividedByPage(this._dActualSizeInKB), 3);
                        this._go.sizeTextField.setText(String.valueOf(d2));
                        break;
                    }
                    case 1: {
                        this._go.availableSizeUnitLabel.setText(string2);
                        double d = Utility.getPrecision(this._leftSpace, 3);
                        this._go.availableSizeTextLabel.setText(String.valueOf(d));
                        double d3 = Utility.getPrecision(this._dActualSizeInKB, 3);
                        this._go.sizeTextField.setText(String.valueOf(d3));
                        break;
                    }
                    case 2: {
                        this._go.availableSizeUnitLabel.setText(string3);
                        double d = Utility.getPrecision(this._cacheSO.dividedByMB(this._leftSpace), 3);
                        this._go.availableSizeTextLabel.setText(String.valueOf(d));
                        double d4 = Utility.getPrecision(this._cacheSO.dividedByMB(this._dActualSizeInKB), 3);
                        this._go.sizeTextField.setText(String.valueOf(d4));
                        break;
                    }
                    case 3: {
                        this._go.availableSizeUnitLabel.setText(string4);
                        double d = Utility.getPrecision(this._cacheSO.dividedByGB(this._leftSpace), 4);
                        this._go.availableSizeTextLabel.setText(String.valueOf(d));
                        double d5 = Utility.getPrecision(this._cacheSO.dividedByGB(this._dActualSizeInKB), 4);
                        this._go.sizeTextField.setText(String.valueOf(d5));
                        break;
                    }
                }
            } else {
                try {
                    if (this._dActualSizeInKB <= 0.0) {
                        return;
                    }
                    int n = this._cacheSO.getOverheadInKB((int)this._dActualSizeInKB);
                    int n2 = this._go.sizeUnitComboBox.getSelectedIndex();
                    double d = 0.0;
                    switch (n2) {
                        case 0: {
                            d = Utility.getPrecision(this._cacheSO.dividedByPage(n), 3);
                            break;
                        }
                        case 1: {
                            d = Utility.getPrecision(n, 3);
                            break;
                        }
                        case 2: {
                            d = Utility.getPrecision(this._cacheSO.dividedByMB(n), 3);
                            break;
                        }
                        case 3: {
                            d = Utility.getPrecision(this._cacheSO.dividedByGB(n), 4);
                        }
                    }
                    String string = d + " " + this._go.sizeUnitComboBox.getSelectedItem();
                    String string5 = this._go.sizeTextField.getText() + " " + this._go.sizeUnitComboBox.getSelectedItem();
                    ASEMessageText aSEMessageText = new ASEMessageText(ASEUtils.getString("CACHE_OVERHEAD_DLG_ANSWER"), string5, string);
                    Support.getViewerSupport().messageBoxString((Container)((Object)this._go), aSEMessageText.toString(), 1);
                }
                catch (SQLException sQLException) {
                    Support.showDetailsError(this.getConnection(), this.getClass(), (Container)((Object)this._go), sQLException.getMessage(), sQLException);
                }
            }
        }

        @Override
        public boolean deploy() {
            if (this._dActualSizeInKB < 512.0) {
                String string = ASEUtils.getString("ERR_CACHE_LEAST_SPACE");
                String string2 = ASEUtils.getString("MSG_SYBASE_CENTRAL_TITLE");
                JOptionPane.showMessageDialog(new JFrame(), string, string2, 2);
                return false;
            }
            this._cacheSO.setCacheDisplaySize(this._go.sizeTextField.getText());
            this._cacheSO.setCacheDisplayUnit((String)this._go.sizeUnitComboBox.getSelectedItem());
            this._cacheSO.setCacheSize(String.valueOf(this._dActualSizeInKB));
            return true;
        }

        @Override
        public void enableComponents() {
            if (this._go.sizeTextField.getText().length() > 0) {
                this._dActualSizeInKB = this.getCacheSizeInKB();
                this.enableNextButton(this._dActualSizeInKB > 0.0);
                this.enableFinishButton(this._dActualSizeInKB > 0.0);
                this._go.overheadButton.setEnabled(this._dActualSizeInKB > 0.0);
            } else {
                this.enableNextButton(false);
                this.enableFinishButton(false);
                this._go.overheadButton.setEnabled(false);
            }
        }

        @Override
        public void init() throws SQLException {
            this._leftSpace = this._cacheSO.getRemainingSpace();
            double d = Utility.getPrecision(this._cacheSO.dividedByMB(this._leftSpace), 2);
            this._go.availableSizeTextLabel.setText(String.valueOf(d));
            this._go.sizeTextField.getDocument().addDocumentListener(this);
            this._go.sizeUnitComboBox.setSelectedIndex(2);
            this._go.sizeUnitComboBox.addActionListener((ActionListener)this);
            this._go.overheadButton.addActionListener((ActionListener)this);
        }

        @Override
        public void releaseResources() {
            this._go.sizeTextField.getDocument().removeDocumentListener(this);
            this._go.sizeUnitComboBox.removeActionListener((ActionListener)this);
            this._go.overheadButton.removeActionListener((ActionListener)this);
            this._go.releaseResources();
            this._go = null;
            this._cacheSO = null;
            super.releaseResources();
        }
    }

    class CacheWizNamePage
    extends NameWizBOPage {
        public CacheWizNamePage(CacheWizard cacheWizard2) {
            super(cacheWizard2, ASEImages.getCacheWizardImage(), ASEUtils.getString("CACHE_WIZ_SENT_WELCOME"), ASEUtils.getString("CACHE_WIZ_SENT_INTRO"), ASEUtils.getString("CACHE_WIZ_QUES_NAME"));
        }
    }
}

