/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.aseplugin.bo.wiz;

import com.sybase.aseplugin.ASEImages;
import com.sybase.aseplugin.ASEMessageText;
import com.sybase.aseplugin.ASEUtils;
import com.sybase.aseplugin.bo.ReplicationBO;
import com.sybase.aseplugin.bo.Support;
import com.sybase.aseplugin.bo.wiz.ASEBaseWizardDialog2;
import com.sybase.aseplugin.bo.wiz.ASEBaseWizardPage2;
import com.sybase.aseplugin.bo.wiz.SummaryWizBOPage;
import com.sybase.aseplugin.go.wiz.ConnWizGOPage1;
import com.sybase.aseplugin.go.wiz.ConnWizGOPage2;
import com.sybase.aseplugin.go.wiz.ConnWizGOPage3;
import com.sybase.aseplugin.so.ConnectionSO;
import com.sybase.aseplugin.so.SOItemInterface;
import com.sybase.aseplugin.sql.ASConnection;
import com.sybase.aseplugin.sql.RLMetaData;
import com.sybase.aseplugin.util.Debug;
import com.sybase.aseplugin.util.ui.MyCellRenderer;
import com.sybase.central.SCContainer2;
import com.sybase.central.SCDialogController;
import com.sybase.central.SCDialogSupport;
import com.sybase.central.SCPageController;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;

public class ConnectionWizard
extends ASEBaseWizardDialog2 {
    private ReplicationBO _repBO = (ReplicationBO)this.getParent();
    private ConnectionSO _connSO;

    public static boolean showDialog(Container container, ASEBaseWizardDialog2 aSEBaseWizardDialog2) {
        SCDialogSupport sCDialogSupport = Support.createDialogSupport(container);
        aSEBaseWizardDialog2.setDialogSupport(sCDialogSupport);
        sCDialogSupport.setDialogController((SCDialogController)aSEBaseWizardDialog2);
        sCDialogSupport.setResizable(true);
        sCDialogSupport.setStandardButtons(true);
        sCDialogSupport.setHelpButton(false);
        sCDialogSupport.setModal(true);
        return sCDialogSupport.render();
    }

    public ConnectionWizard(ConnectionSO connectionSO, SCContainer2 sCContainer2) {
        super((SOItemInterface)connectionSO, sCContainer2);
        this._connSO = connectionSO;
    }

    @Override
    public SCPageController[] getPages() {
        return new SCPageController[]{new ConnectionWizBOPage1(this), new ConnectionWizBOPage2(this), new ConnectionWizBOPage3(this), new ConnectionWizBOPage4(this)};
    }

    @Override
    public boolean deploy() {
        try {
            this._connSO.create();
            this._repBO.refresh();
        }
        catch (SQLException sQLException) {
            Support.showError(this.getConnection(), this.getClass(), this.getJDialog(), ASEMessageText.toString(sQLException).replace('\n', ' '));
            return false;
        }
        return true;
    }

    public ConnectionSO getMySO() {
        return this._connSO;
    }

    public ReplicationBO getParentBO() {
        return this._repBO;
    }

    @Override
    public void releaseResources() {
        this._repBO = null;
        this._connSO = null;
        super.releaseResources();
    }

    class ConnectionWizBOPage4
    extends SummaryWizBOPage {
        public ConnectionWizBOPage4(ConnectionWizard connectionWizard2) {
            super(connectionWizard2, ASEImages.getRemoteServerWizardImage());
        }

        @Override
        public void enableComponents() {
            String string = ASEUtils.getString("SUM_CONN_CONNECTION_TYPE");
            ASEMessageText aSEMessageText = new ASEMessageText(string, ConnectionWizard.this.getMySO().getTypeString());
            String string2 = aSEMessageText.toString();
            string = ASEUtils.getString("SUM_CONN_SERVER");
            aSEMessageText = new ASEMessageText(string, ConnectionWizard.this.getMySO().getServer());
            string2 = string2 + aSEMessageText.toString();
            string = ASEUtils.getString("SUM_CONN_DATABASE");
            aSEMessageText = new ASEMessageText(string, ConnectionWizard.this.getMySO().getDatabase());
            string2 = string2 + aSEMessageText.toString();
            string = ASEUtils.getString("SUM_CONN_MAINT_USER");
            aSEMessageText = new ASEMessageText(string, ConnectionWizard.this.getMySO().getMaintUser());
            string2 = string2 + aSEMessageText.toString();
            this.setSummaryInfo(string2);
        }
    }

    class ConnectionWizBOPage3
    extends ASEBaseWizardPage2 {
        private ConnWizGOPage3 _panel;

        public ConnectionWizBOPage3(ConnectionWizard connectionWizard2) {
            super(connectionWizard2, (JPanel)((Object)new ConnWizGOPage3()), ASEUtils.getString("MSG_ADD_CONN_WIZ_USER"));
            this._panel = (ConnWizGOPage3)((Object)this.getJPanel());
            this._panel.comboUser.setRenderer((ListCellRenderer)new MyCellRenderer());
        }

        @Override
        public void enableComponents() {
            try {
                ASConnection aSConnection = ConnectionWizard.this.getMySO().getConnection();
                if (ConnectionWizard.this.getMySO().isPrimary()) {
                    Vector vector = RLMetaData.getLogins(aSConnection, ConnectionWizard.this.getMySO().getDatabase());
                    vector.insertElementAt(new String(ASEUtils.getString("REP_CONN_DEFAULT_USER")), 0);
                    this.setUsers(vector);
                } else if (ConnectionWizard.this.getMySO().isReplicate()) {
                    Vector vector = RLMetaData.getRemoteLogins(aSConnection, ConnectionWizard.this.getMySO().getServer());
                    vector.insertElementAt(new String(ASEUtils.getString("REP_CONN_DEFAULT_USER")), 0);
                    this.setUsers(vector);
                } else {
                    Debug.wassert(false, this, "Invalid Connection Type");
                }
            }
            catch (SQLException sQLException) {
                Support.showDetailsError(this.getConnection(), this.getClass(), (Container)this.getJDialog(), ASEMessageText.toString(sQLException), sQLException);
            }
        }

        @Override
        public int onWizardNext() {
            String string = this.getUser();
            Debug.wassert(string != null && string.length() > 0, this, "Maintenance user is null or blank");
            ConnectionWizard.this.getMySO().setMaintUser(string);
            return super.onWizardNext();
        }

        @Override
        public boolean onWizardBack() {
            String string = this.getUser();
            ConnectionWizard.this.getMySO().setMaintUser(string);
            return super.onWizardBack();
        }

        private String getUser() {
            String string = null;
            JLabel jLabel = (JLabel)this._panel.comboUser.getSelectedItem();
            if (jLabel != null) {
                string = jLabel.getText();
            }
            return string;
        }

        private void setUsers(Vector vector) {
            String string;
            if (this._panel.comboUser.getItemCount() > 0) {
                this._panel.comboUser.removeAllItems();
            }
            if ((string = ConnectionWizard.this.getMySO().getMaintUser()) == null) {
                string = "";
            }
            JLabel jLabel = null;
            ImageIcon imageIcon = new ImageIcon(ASEImages.getUserSmallImage());
            for (int i = 0; i < vector.size(); ++i) {
                JLabel jLabel2 = new JLabel((String)vector.elementAt(i), imageIcon, 0);
                this._panel.comboUser.addItem((Object)jLabel2);
                if (!vector.elementAt(i).equals(string)) continue;
                jLabel = jLabel2;
            }
            if (jLabel != null) {
                this._panel.comboUser.setSelectedItem(jLabel);
            } else if (vector.size() > 0) {
                this._panel.comboUser.setSelectedIndex(0);
            }
        }

        @Override
        public void releaseResources() {
            this._panel.releaseResources();
            this._panel = null;
            super.releaseResources();
        }
    }

    class ConnectionWizBOPage2
    extends ASEBaseWizardPage2
    implements ActionListener {
        private ConnWizGOPage2 _panel;

        public ConnectionWizBOPage2(ConnectionWizard connectionWizard2) {
            super(connectionWizard2, (JPanel)((Object)new ConnWizGOPage2()), ASEUtils.getString("MSG_ADD_CONN_WIZ_SERVER"));
            this._panel = (ConnWizGOPage2)((Object)this.getJPanel());
            this._panel.comboServer.setRenderer((ListCellRenderer)new MyCellRenderer());
            this._panel.comboDatabase.setRenderer((ListCellRenderer)new MyCellRenderer());
            this._panel.comboDatabase.addActionListener((ActionListener)this);
            this._panel.comboServer.addActionListener((ActionListener)this);
        }

        @Override
        public void enableComponents() {
            String string = this.getServer();
            String string2 = this.getDatabase();
            this.enableNextButton(string != null && string.length() > 1 && string2 != null && string2.length() > 1);
            try {
                ASConnection aSConnection = ConnectionWizard.this.getMySO().getConnection();
                if (ConnectionWizard.this.getMySO().isPrimary()) {
                    Vector vector = RLMetaData.getLocalServers(aSConnection);
                    this.setServers(vector);
                } else if (ConnectionWizard.this.getMySO().isReplicate()) {
                    Vector vector = RLMetaData.getRemoteServers(aSConnection);
                    this.setServers(vector);
                } else {
                    Debug.wassert(false, this, "Invalid Connection Type");
                }
                this.LoadDatabases();
            }
            catch (SQLException sQLException) {
                Support.showDetailsError(this.getConnection(), this.getClass(), (Container)this.getJDialog(), ASEMessageText.toString(sQLException), sQLException);
            }
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == this._panel.comboServer) {
                this.LoadDatabases();
            }
            String string = this.getServer();
            String string2 = this.getDatabase();
            this.enableNextButton(string != null && string.length() > 1 && string2 != null && string2.length() > 1);
        }

        @Override
        public int onWizardNext() {
            String string = this.getServer();
            String string2 = this.getDatabase();
            Debug.wassert(string != null && string.length() > 0, this, "Server name is null or blank");
            Debug.wassert(string2 != null && string2.length() > 0, this, "Database name is null or blank");
            ConnectionWizard.this.getMySO().setServer(string);
            ConnectionWizard.this.getMySO().setDatabase(string2);
            return super.onWizardNext();
        }

        @Override
        public boolean onWizardBack() {
            String string = this.getServer();
            String string2 = this.getDatabase();
            if (string != null && string.length() > 0) {
                ConnectionWizard.this.getMySO().setServer(string);
            }
            if (string2 != null && string2.length() > 0) {
                ConnectionWizard.this.getMySO().setDatabase(string2);
            }
            return super.onWizardBack();
        }

        private void LoadDatabases() {
            try {
                ASConnection aSConnection = ConnectionWizard.this.getMySO().getConnection();
                if (ConnectionWizard.this.getMySO().isPrimary()) {
                    Vector vector = RLMetaData.getDatabases(aSConnection);
                    this.setDatabases(vector, this.getServer());
                } else if (ConnectionWizard.this.getMySO().isReplicate()) {
                    String string = this.getServer();
                    if (string != null && string.length() > 0) {
                        Vector vector = RLMetaData.getRemoteDatabases(aSConnection, string);
                        this.setDatabases(vector, string);
                    }
                } else {
                    Debug.wassert(false, this, "Invalid Connection Type");
                }
            }
            catch (SQLException sQLException) {
                Support.showDetailsError(this.getConnection(), this.getClass(), (Container)this.getJDialog(), ASEMessageText.toString(sQLException), sQLException);
            }
        }

        private String getServer() {
            String string = null;
            JLabel jLabel = (JLabel)this._panel.comboServer.getSelectedItem();
            if (jLabel != null) {
                string = jLabel.getText();
            }
            return string;
        }

        private void setServers(Vector vector) {
            String string;
            this._panel.comboServer.removeActionListener((ActionListener)this);
            if (this._panel.comboServer.getItemCount() > 0) {
                this._panel.comboServer.removeAllItems();
            }
            if ((string = ConnectionWizard.this.getMySO().getServer()) == null) {
                string = "";
            }
            JLabel jLabel = null;
            ImageIcon imageIcon = new ImageIcon(ASEImages.getServerSmallImage());
            for (int i = 0; i < vector.size(); ++i) {
                JLabel jLabel2 = new JLabel((String)vector.elementAt(i), imageIcon, 0);
                this._panel.comboServer.addItem((Object)jLabel2);
                if (!vector.elementAt(i).equals(string)) continue;
                jLabel = jLabel2;
            }
            if (jLabel != null) {
                this._panel.comboServer.setSelectedItem(jLabel);
            }
            this._panel.comboServer.addActionListener((ActionListener)this);
        }

        private String getDatabase() {
            String string = null;
            JLabel jLabel = (JLabel)this._panel.comboDatabase.getSelectedItem();
            if (jLabel != null) {
                string = jLabel.getText();
            }
            return string;
        }

        private void setDatabases(Vector vector, String string) {
            String string2;
            if (string == null || string.length() == 0) {
                return;
            }
            if (this._panel.comboDatabase.getItemCount() > 0) {
                this._panel.comboDatabase.removeAllItems();
            }
            if ((string2 = ConnectionWizard.this.getMySO().getDatabase()) == null) {
                string2 = "";
            }
            JLabel jLabel = null;
            ImageIcon imageIcon = new ImageIcon(ASEImages.getDatabaseSmallImage());
            for (int i = 0; i < vector.size(); ++i) {
                String string3 = ConnectionSO.formatName(string, (String)vector.elementAt(i));
                if (ConnectionWizard.this.getParentBO().childExists(string3)) continue;
                JLabel jLabel2 = new JLabel((String)vector.elementAt(i), imageIcon, 0);
                this._panel.comboDatabase.addItem((Object)jLabel2);
                if (!vector.elementAt(i).equals(string2)) continue;
                jLabel = jLabel2;
            }
            if (jLabel != null) {
                this._panel.comboDatabase.setSelectedItem(jLabel);
            }
        }

        @Override
        public void releaseResources() {
            this._panel.releaseResources();
            this._panel = null;
            super.releaseResources();
        }
    }

    class ConnectionWizBOPage1
    extends ASEBaseWizardPage2 {
        private ConnWizGOPage1 _panel;

        public ConnectionWizBOPage1(ConnectionWizard connectionWizard2) {
            super(connectionWizard2, (JPanel)((Object)new ConnWizGOPage1()), ASEUtils.getString("MSG_ADD_CONN_WIZ_TITLE"));
            this._panel = (ConnWizGOPage1)((Object)this.getJPanel());
        }

        @Override
        public int onWizardNext() {
            if (this._panel.radioPrimary.isSelected()) {
                ConnectionWizard.this.getMySO().setPrimaryConnType();
            } else if (this._panel.radioReplicate.isSelected()) {
                ConnectionWizard.this.getMySO().setReplicateConnType();
            } else {
                Debug.wassert(false, this, "Neither the primary or the replicate button is set");
            }
            return super.onWizardNext();
        }

        @Override
        public void releaseResources() {
            this._panel.releaseResources();
            this._panel = null;
            super.releaseResources();
        }
    }
}

