/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.aseplugin.bo.wiz;

import com.sybase.ase.logon.ASEConnectionInfo;
import com.sybase.aseplugin.ASEMessageText;
import com.sybase.aseplugin.ASEUtils;
import com.sybase.aseplugin.bo.Support;
import com.sybase.aseplugin.bo.wiz.SDCClusterWizBOProgressPage;
import com.sybase.aseplugin.bo.wiz.SDCClusterWizard;
import com.sybase.aseplugin.bo.wiz.SDCClusterWizardSession;
import com.sybase.aseplugin.so.SDCClusterSO;
import com.sybase.aseplugin.so.ServerGroupSO;
import com.sybase.aseplugin.so.ServerSO;
import com.sybase.aseplugin.util.Debug;
import com.sybase.aseplugin.util.SDCMessageListener;
import com.sybase.central.SCPageController;
import com.sybase.util.ds.uaf.SyUAFASEEntry;
import javax.swing.SwingUtilities;

class CreateClusterThread
extends Thread {
    private SDCClusterWizard wizard;
    private SDCMessageListener messageListener;
    private SDCClusterWizBOProgressPage progressPage;
    private boolean running = false;

    protected void finalized() throws Throwable {
        this.wizard = null;
        this.messageListener = null;
        this.progressPage = null;
        super.finalize();
    }

    public boolean isRunning() {
        return this.running;
    }

    public CreateClusterThread(SDCClusterWizard sDCClusterWizard, SDCMessageListener sDCMessageListener) {
        this.wizard = sDCClusterWizard;
        this.messageListener = sDCMessageListener;
        SCPageController[] sCPageControllerArray = sDCClusterWizard.getPages();
        this.progressPage = (SDCClusterWizBOProgressPage)sCPageControllerArray[sCPageControllerArray.length - 1];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.running = true;
        SDCClusterSO sDCClusterSO = (SDCClusterSO)this.wizard.getSO();
        SDCClusterWizardSession sDCClusterWizardSession = this.wizard.getClusterWizardSession();
        try {
            sDCClusterWizardSession.setMessageListener(this.messageListener);
            sDCClusterWizardSession.createCluster();
        }
        catch (Exception exception) {
            this.progressPage.enableBackButton(true);
            this.progressPage.enableCancelButton(true);
            ASEMessageText aSEMessageText = new ASEMessageText(ASEUtils.getString("SDC_ERROR_CREATE_CLUSTER"), sDCClusterSO.getCluster().getName(), exception.getMessage());
            this.progressPage.addMessage(aSEMessageText.toString());
            Support.showError(null, this.getClass(), this.wizard.getJDialog(), aSEMessageText.toString());
            return;
        }
        finally {
            CreateClusterThread createClusterThread = this;
            synchronized (createClusterThread) {
                this.running = false;
            }
        }
        Object object = new ASEMessageText(ASEUtils.getString("SDC_MSG_CLUSTER_CREATED_SUCCESSFULLY"), sDCClusterSO.getCluster().getName());
        this.writeProgressMessage(((ASEMessageText)object).toString(), 2);
        if (sDCClusterSO.isAutoStartCluster()) {
            object = new ASEMessageText(ASEUtils.getString("SDC_MSG_START_CLUSTER"), sDCClusterSO.getCluster().getName());
            this.writeProgressMessage(((ASEMessageText)object).toString(), 2);
            try {
                sDCClusterWizardSession.startCluster();
            }
            catch (Exception exception) {
                this.progressPage.enableBackButton(true);
                this.progressPage.enableCancelButton(true);
                object = new ASEMessageText(ASEUtils.getString("SDC_ERROR_START_CLUSTER"), sDCClusterSO.getCluster().getName(), exception.getMessage());
                this.writeProgressMessage(((ASEMessageText)object).toString(), 0);
                this.registerCluster(sDCClusterSO);
                return;
            }
            try {
                Thread.sleep(1000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            object = new ASEMessageText(ASEUtils.getString("SDC_MSG_CLUSTER_STARTED"), sDCClusterSO.getCluster().getName());
            this.writeProgressMessage(((ASEMessageText)object).toString(), 2);
        }
        this.registerCluster(sDCClusterSO);
    }

    private void writeProgressMessage(String string, int n) {
        this.progressPage.addMessage("\n" + string);
        Support.addLogEntry(n, this.getClass().getName(), string, string);
    }

    private void registerCluster(SDCClusterSO sDCClusterSO) {
        Object object;
        Support.getTopBO().initServerDiscovery(true);
        Support.getTopBO().updateServers();
        ASEConnectionInfo aSEConnectionInfo = null;
        try {
            aSEConnectionInfo = sDCClusterSO.createClusterConnectionInfo();
        }
        catch (Exception exception) {
            ASEMessageText aSEMessageText = new ASEMessageText(ASEUtils.getString("SDC_ERROR_ASE_CONNECTION"), exception.toString());
            Support.showError(null, this.getClass(), this.wizard.getJDialog(), aSEMessageText.toString());
            return;
        }
        sDCClusterSO.setConnectionInfo(aSEConnectionInfo);
        try {
            object = sDCClusterSO.getFirstUAFEntry();
            if (object != null) {
                sDCClusterSO.setUAFInfo((SyUAFASEEntry)object);
            }
            ServerSO.addDiscoveredServer(object.getHostName(), object.getPortNumber(), object);
        }
        catch (Exception exception) {
            ASEMessageText aSEMessageText = new ASEMessageText(ASEUtils.getString("SDC_ERROR_GET_UAF_ENTRY"), exception.toString());
            Support.showError(null, this.getClass(), this.wizard.getJDialog(), aSEMessageText.toString());
            return;
        }
        sDCClusterSO.setConnInfoServerName(sDCClusterSO.getName());
        object = Support.getTopBO().getDefaultServerGroup();
        sDCClusterSO.addToServerGroup((ServerGroupSO)object);
        Support.getTopBO().registerServer(sDCClusterSO);
        if (Debug.isOn()) {
            Support.addLogEntry(2, null, this.getClass(), "Added the server SO to TopBO's server list.", "");
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Support.getTopBO().refresh(true);
            }
        });
        try {
            Thread.sleep(10000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Support.getTopBO().refresh(true);
                CreateClusterThread.this.progressPage.enableFinishButton(true);
                CreateClusterThread.this.progressPage.enableCancelButton(true);
            }
        });
    }
}

