/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.aseplugin.bo.wiz;

import com.sybase.aseplugin.ASEImages;
import com.sybase.aseplugin.ASEUtils;
import com.sybase.aseplugin.bo.ASEBaseContainer2;
import com.sybase.aseplugin.bo.ASEBaseItem2;
import com.sybase.aseplugin.bo.Support;
import com.sybase.aseplugin.bo.wiz.ASEBaseWizardDialog2;
import com.sybase.aseplugin.bo.wiz.ASEBaseWizardPage2;
import com.sybase.aseplugin.go.wiz.DBCCWizGODatabasePage;
import com.sybase.aseplugin.go.wiz.DBCCWizGOIndexPage;
import com.sybase.aseplugin.go.wiz.DBCCWizGOIntroPage;
import com.sybase.aseplugin.go.wiz.DBCCWizGOTablePage;
import com.sybase.aseplugin.so.ASEBaseItemSO;
import com.sybase.aseplugin.so.DatabaseSO;
import com.sybase.aseplugin.so.IndexSO;
import com.sybase.aseplugin.so.SOItemInterface;
import com.sybase.aseplugin.so.TableSO;
import com.sybase.aseplugin.sql.ASConnection;
import com.sybase.aseplugin.sql.SQLs;
import com.sybase.central.SCContainer2;
import com.sybase.central.SCDialogSupport;
import com.sybase.central.SCPageController;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.JPanel;

public class DBCCWizard
extends ASEBaseWizardDialog2 {
    private static final String ALLOC_OPTION_FIX = "fix";
    private static final String ALLOC_OPTION_NOFIX = "nofix";
    private static final String TYPE_OPTION_OPT = "optimized";
    private static final String TYPE_OPTION_FAST = "fast";
    private static final String TYPE_OPTION_FULL = "full";
    private DBCCWizIntroPage _introPage;
    private DBCCWizDatabasePage _databasePage;
    private DBCCWizTablePage _tablePage;
    private DBCCWizIndexPage _indexPage;
    private DatabaseSO _dbSO = null;
    private TableSO _tableSO = null;
    private IndexSO _indexSO = null;
    private ASConnection _asConn;
    private ArrayList _targets;
    private boolean _isMaster;

    public DBCCWizard(DatabaseSO databaseSO, ArrayList arrayList, SCContainer2 sCContainer2) {
        super((SOItemInterface)databaseSO, sCContainer2, ASEUtils.getString("CONTEXT_MENU_CHECK_CONSISTENCY_TEXT"));
        this._dbSO = databaseSO;
        this._asConn = this._dbSO.getConnection();
        this._targets = arrayList;
        this._isMaster = this.hasMaster();
    }

    private boolean hasMaster() {
        for (int i = 0; i < this._targets.size(); ++i) {
            ASEBaseItem2 aSEBaseItem2 = (ASEBaseItem2)this._targets.get(i);
            DatabaseSO databaseSO = (DatabaseSO)aSEBaseItem2.getSO();
            if (!databaseSO.isMaster()) continue;
            return true;
        }
        return false;
    }

    public DBCCWizard(TableSO tableSO, ArrayList arrayList, SCContainer2 sCContainer2) {
        super((SOItemInterface)tableSO, sCContainer2, ASEUtils.getString("CONTEXT_MENU_CHECK_CONSISTENCY_TEXT"));
        this._tableSO = tableSO;
        this._asConn = this._tableSO.getConnection();
        this._targets = arrayList;
        this._isMaster = this._tableSO.getDatabaseSO().isMaster();
    }

    public DBCCWizard(IndexSO indexSO, ArrayList arrayList, SCContainer2 sCContainer2) {
        super((SOItemInterface)indexSO, sCContainer2, ASEUtils.getString("CONTEXT_MENU_CHECK_CONSISTENCY_TEXT"));
        this._indexSO = indexSO;
        this._asConn = this._indexSO.getConnection();
        this._targets = arrayList;
        this._isMaster = this._indexSO.getTableSO().getDatabaseSO().isMaster();
    }

    @Override
    public SCPageController[] getPages() {
        this._introPage = new DBCCWizIntroPage(this);
        if (this._dbSO != null) {
            this._databasePage = new DBCCWizDatabasePage(this);
            return new SCPageController[]{this._introPage, this._databasePage};
        }
        if (this._tableSO != null) {
            this._tablePage = new DBCCWizTablePage(this);
            return new SCPageController[]{this._introPage, this._tablePage};
        }
        this._indexPage = new DBCCWizIndexPage(this);
        return new SCPageController[]{this._introPage, this._indexPage};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean deploy() {
        SCDialogSupport sCDialogSupport = this.getDialogSupport();
        sCDialogSupport.startWait();
        try {
            String string = Support.getFullTitle(ASEUtils.getString("CC_EDITOR_TITLE"), this._asConn);
            String string2 = "";
            for (int i = 0; i < this._targets.size(); ++i) {
                ASEBaseItem2 aSEBaseItem2 = (ASEBaseItem2)this._targets.get(i);
                ASEBaseItemSO aSEBaseItemSO = (ASEBaseItemSO)aSEBaseItem2.getSO();
                String string3 = string2 + "--------------------------------------------------------------- \n-- ";
                string3 = string3 + aSEBaseItemSO.getFullyQualifiedName() + " " + ASEUtils.getString("CC_EDITOR_TITLE");
                string3 = string3 + "\n";
                string3 = string3 + "--------------------------------------------------------------- \n";
                string3 = string3 + this.getDBCCOutput(aSEBaseItemSO);
                string2 = "\n";
                String string4 = this._asConn.getDisplayName() + " DBCC";
                Support.writeToExtendedLogFileEditor(string, ASEImages.getDatabaseSmallImage(), string3, this._asConn, null, string4);
            }
        }
        catch (SQLException sQLException) {
            Support.showDetailsError(this.getConnection(), this.getClass(), (Container)this.getJDialog(), sQLException.getMessage(), sQLException);
            boolean bl = false;
            return bl;
        }
        finally {
            sCDialogSupport.endWait();
        }
        return true;
    }

    private String getDBCCOutput(ASEBaseItemSO aSEBaseItemSO) throws SQLException {
        String string = "";
        if (this._dbSO != null) {
            Vector vector = this._databasePage.getDBCCCommands(aSEBaseItemSO.getName());
            for (int i = 0; i < vector.size(); ++i) {
                String string2 = (String)vector.elementAt(i);
                string = string + this.formatOutput(string2, this._dbSO.checkDatabaseConsistency(string2));
            }
        } else if (this._tableSO != null) {
            Vector vector = this._tablePage.getDBCCCommands(aSEBaseItemSO.getFullyQualifiedName());
            for (int i = 0; i < vector.size(); ++i) {
                String string3 = (String)vector.elementAt(i);
                string = string + this.formatOutput(string3, this._tableSO.checkDatabaseConsistency(string3));
            }
        } else {
            Vector vector = this._indexPage.getDBCCCommands((IndexSO)aSEBaseItemSO);
            for (int i = 0; i < vector.size(); ++i) {
                String string4 = (String)vector.elementAt(i);
                string = string + this.formatOutput(string4, this._indexSO.checkDatabaseConsistency(string4));
            }
        }
        return string;
    }

    private String formatOutput(String string, String string2) {
        String string3 = "--\n-- " + string + "\n--\n";
        string3 = string3 + string2 + "\n";
        return string3;
    }

    @Override
    public void releaseResources() {
        this._introPage = null;
        this._databasePage = null;
        this._tablePage = null;
        this._indexPage = null;
        this._dbSO = null;
        this._tableSO = null;
        this._indexSO = null;
        this._asConn = null;
        this._targets = null;
        super.releaseResources();
    }

    public class DBCCWizIndexPage
    extends ASEBaseWizardPage2
    implements ActionListener {
        private DBCCWizGOIndexPage _go;

        public DBCCWizIndexPage(DBCCWizard dBCCWizard2) {
            super(dBCCWizard2, (JPanel)((Object)new DBCCWizGOIndexPage()), ASEUtils.getString("SELECT_DATABASE_CHECKS"));
            this._go = (DBCCWizGOIndexPage)((Object)this.getJPanel());
            this._go.allocationCheckbox.setSelected(true);
            if (DBCCWizard.this._isMaster) {
                this._go.fixAllocationCheckBox.setVisible(false);
            } else {
                this._go.fixAllocationCheckBox.setEnabled(false);
            }
            this._go.optimizedRadioButton.setEnabled(false);
            this._go.fullRadioButton.setEnabled(false);
            this._go.fastRadioButton.setEnabled(false);
            this._go.allocationCheckbox.addActionListener((ActionListener)this);
            this._go.fixAllocationCheckBox.addActionListener((ActionListener)this);
            this._go.optimizedRadioButton.addActionListener((ActionListener)this);
            this._go.fullRadioButton.addActionListener((ActionListener)this);
            this._go.fastRadioButton.addActionListener((ActionListener)this);
            this.getGO().setDisplayPreviewButton(false);
            this.getGO().setDisplayScheduleButton(false);
        }

        private void enableType(boolean bl) {
            this._go.typeMultiLineLabel.setEnabled(bl);
            this._go.optimizedRadioButton.setEnabled(bl);
            this._go.fullRadioButton.setEnabled(bl);
            this._go.fastRadioButton.setEnabled(bl);
        }

        @Override
        public void enableComponents() {
            this.enableFinishButton(this.checkAny());
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == this._go.allocationCheckbox) {
                this._go.fixAllocationCheckBox.setEnabled(this.checkAllocation());
            }
            this.enableType(this.checkAllocation());
            this.enableFinishButton(this.checkAny());
        }

        private boolean checkAny() {
            boolean bl = this.checkAllocation();
            return bl;
        }

        private boolean checkAllocation() {
            return this._go.allocationCheckbox.isSelected();
        }

        private boolean fixAllocation() {
            return this._go.fixAllocationCheckBox.isSelected();
        }

        public Vector getDBCCCommands(IndexSO indexSO) {
            Vector<String> vector = new Vector<String>();
            if (this.checkAllocation()) {
                String string = this.fixAllocation() ? DBCCWizard.ALLOC_OPTION_FIX : DBCCWizard.ALLOC_OPTION_NOFIX;
                String string2 = DBCCWizard.TYPE_OPTION_OPT;
                if (this._go.optimizedRadioButton.isSelected()) {
                    string2 = DBCCWizard.TYPE_OPTION_OPT;
                } else if (this._go.fullRadioButton.isSelected()) {
                    string2 = DBCCWizard.TYPE_OPTION_FULL;
                } else if (this._go.fastRadioButton.isSelected()) {
                    string2 = DBCCWizard.TYPE_OPTION_FAST;
                }
                String string3 = indexSO.getTableName();
                String string4 = indexSO.getIndexID();
                String string5 = SQLs.getString("dbcc indexalloc(''{0}'', {1}, {2}, {3})", string3, string4, string2, string);
                vector.add(string5);
            }
            return vector;
        }

        @Override
        public void releaseResources() {
            this._go.allocationCheckbox.removeActionListener((ActionListener)this);
            this._go.fixAllocationCheckBox.removeActionListener((ActionListener)this);
            this._go.optimizedRadioButton.removeActionListener((ActionListener)this);
            this._go.fullRadioButton.removeActionListener((ActionListener)this);
            this._go.fastRadioButton.removeActionListener((ActionListener)this);
            this._go.releaseResources();
            this._go = null;
            super.releaseResources();
        }
    }

    public class DBCCWizTablePage
    extends ASEBaseWizardPage2
    implements ActionListener {
        private DBCCWizGOTablePage _go;

        public DBCCWizTablePage(DBCCWizard dBCCWizard2) {
            super(dBCCWizard2, (JPanel)((Object)new DBCCWizGOTablePage()), ASEUtils.getString("SELECT_DATABASE_CHECKS"));
            this._go = (DBCCWizGOTablePage)((Object)this.getJPanel());
            this._go.overallCheckBox.setSelected(true);
            this._go.ignoreNonClusteredCheckBox.setEnabled(false);
            if (DBCCWizard.this._isMaster) {
                this._go.fixAllocationCheckBox.setVisible(false);
            } else {
                this._go.fixAllocationCheckBox.setEnabled(false);
            }
            this._go.typeMultiLineLabel.setEnabled(false);
            this._go.optimizedRadioButton.setEnabled(false);
            this._go.fullRadioButton.setEnabled(false);
            this._go.fastRadioButton.setEnabled(false);
            this._go.overallCheckBox.addActionListener((ActionListener)this);
            this._go.ignoreNonClusteredCheckBox.addActionListener((ActionListener)this);
            this._go.allocationCheckbox.addActionListener((ActionListener)this);
            this._go.fixAllocationCheckBox.addActionListener((ActionListener)this);
            this._go.reindexCheckBox.addActionListener((ActionListener)this);
            this._go.fixTextCheckBox.addActionListener((ActionListener)this);
            this._go.optimizedRadioButton.addActionListener((ActionListener)this);
            this._go.fullRadioButton.addActionListener((ActionListener)this);
            this._go.fastRadioButton.addActionListener((ActionListener)this);
            this.getGO().setDisplayPreviewButton(false);
            this.getGO().setDisplayScheduleButton(false);
        }

        @Override
        public void enableComponents() {
            this.enableFinishButton(this.checkAny());
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == this._go.overallCheckBox) {
                this._go.ignoreNonClusteredCheckBox.setEnabled(this.checkOverall());
            } else if (object == this._go.allocationCheckbox) {
                this._go.fixAllocationCheckBox.setEnabled(this.checkAllocation());
            }
            this.enableType(this.checkAllocation());
            this.enableFinishButton(this.checkAny());
        }

        private void enableType(boolean bl) {
            this._go.typeMultiLineLabel.setEnabled(bl);
            this._go.optimizedRadioButton.setEnabled(bl);
            this._go.fullRadioButton.setEnabled(bl);
            this._go.fastRadioButton.setEnabled(bl);
        }

        private boolean checkAny() {
            boolean bl = this.checkOverall() || this.checkAllocation() || this.checkReindex() || this.checkFixText();
            return bl;
        }

        private boolean checkOverall() {
            return this._go.overallCheckBox.isSelected();
        }

        private boolean ignoreNCIndexes() {
            return this._go.ignoreNonClusteredCheckBox.isSelected();
        }

        private boolean checkAllocation() {
            return this._go.allocationCheckbox.isSelected();
        }

        private boolean fixAllocation() {
            return this._go.fixAllocationCheckBox.isSelected();
        }

        private boolean checkReindex() {
            return this._go.reindexCheckBox.isSelected();
        }

        private boolean checkFixText() {
            return this._go.fixTextCheckBox.isSelected();
        }

        public Vector getDBCCCommands(String string) {
            Vector<String> vector = new Vector<String>();
            if (this.checkOverall()) {
                if (this.ignoreNCIndexes()) {
                    vector.add(SQLs.getString("dbcc checktable(''{0}'', skip_ncindex)", string));
                } else {
                    vector.add(SQLs.getString("dbcc checktable(''{0}'')", string));
                }
            }
            if (this.checkReindex()) {
                vector.add(SQLs.getString("dbcc reindex(''{0}'')", string));
            }
            if (this.checkFixText()) {
                vector.add(SQLs.getString("dbcc fix_text(''{0}'')", string));
            }
            if (this.checkAllocation()) {
                String string2 = this.fixAllocation() ? DBCCWizard.ALLOC_OPTION_FIX : DBCCWizard.ALLOC_OPTION_NOFIX;
                String string3 = DBCCWizard.TYPE_OPTION_OPT;
                if (this._go.optimizedRadioButton.isSelected()) {
                    string3 = DBCCWizard.TYPE_OPTION_OPT;
                } else if (this._go.fullRadioButton.isSelected()) {
                    string3 = DBCCWizard.TYPE_OPTION_FULL;
                } else if (this._go.fastRadioButton.isSelected()) {
                    string3 = DBCCWizard.TYPE_OPTION_FAST;
                }
                String string4 = SQLs.getString("dbcc tablealloc(''{0}'', {1}, {2})", string, string3, string2);
                vector.add(string4);
            }
            return vector;
        }

        @Override
        public void releaseResources() {
            this._go.overallCheckBox.removeActionListener((ActionListener)this);
            this._go.ignoreNonClusteredCheckBox.removeActionListener((ActionListener)this);
            this._go.allocationCheckbox.removeActionListener((ActionListener)this);
            this._go.fixAllocationCheckBox.removeActionListener((ActionListener)this);
            this._go.reindexCheckBox.removeActionListener((ActionListener)this);
            this._go.fixTextCheckBox.removeActionListener((ActionListener)this);
            this._go.optimizedRadioButton.removeActionListener((ActionListener)this);
            this._go.fullRadioButton.removeActionListener((ActionListener)this);
            this._go.fastRadioButton.removeActionListener((ActionListener)this);
            this._go.releaseResources();
            this._go = null;
            super.releaseResources();
        }
    }

    public class DBCCWizDatabasePage
    extends ASEBaseWizardPage2
    implements ActionListener {
        private DBCCWizGODatabasePage _go;

        public DBCCWizDatabasePage(DBCCWizard dBCCWizard2) {
            super(dBCCWizard2, (JPanel)((Object)new DBCCWizGODatabasePage()), ASEUtils.getString("SELECT_DATABASE_CHECKS"));
            this._go = (DBCCWizGODatabasePage)((Object)this.getJPanel());
            this._go.overallCheckBox.setSelected(true);
            this._go.ignoreNonClusteredCheckBox.setEnabled(false);
            if (DBCCWizard.this._isMaster) {
                this._go.fixAllocationCheckBox.setVisible(false);
            } else {
                this._go.fixAllocationCheckBox.setEnabled(false);
            }
            this._go.overallCheckBox.addActionListener((ActionListener)this);
            this._go.allocationCheckbox.addActionListener((ActionListener)this);
            this._go.systemCatalogCheckBox.addActionListener((ActionListener)this);
            this.getGO().setDisplayPreviewButton(false);
            this.getGO().setDisplayScheduleButton(false);
        }

        @Override
        public void enableComponents() {
            this.enableFinishButton(this.checkAny());
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == this._go.overallCheckBox) {
                this._go.ignoreNonClusteredCheckBox.setEnabled(this.checkOverall());
            } else if (object == this._go.allocationCheckbox) {
                this._go.fixAllocationCheckBox.setEnabled(this.checkAllocation());
            }
            this.enableFinishButton(this.checkAny());
        }

        private boolean checkAny() {
            boolean bl = this.checkOverall() || this.checkSystem() || this.checkAllocation();
            return bl;
        }

        private boolean checkOverall() {
            return this._go.overallCheckBox.isSelected();
        }

        private boolean ignoreNCIndexes() {
            return this._go.ignoreNonClusteredCheckBox.isSelected();
        }

        private boolean checkSystem() {
            return this._go.systemCatalogCheckBox.isSelected();
        }

        private boolean checkAllocation() {
            return this._go.allocationCheckbox.isSelected();
        }

        private boolean fixAllocation() {
            return this._go.fixAllocationCheckBox.isSelected();
        }

        protected Vector getDBCCCommands(String string) {
            Vector<String> vector = new Vector<String>();
            if (this.checkOverall()) {
                if (this.ignoreNCIndexes()) {
                    vector.add(SQLs.getString("dbcc checkdb ({0}, skip_ncindex)", string));
                } else {
                    vector.add(SQLs.getString("dbcc checkdb ({0})", string));
                }
            }
            if (this.checkSystem()) {
                vector.add(SQLs.getString("dbcc checkcatalog ({0})", string));
            }
            if (this.checkAllocation()) {
                String string2 = this.fixAllocation() ? DBCCWizard.ALLOC_OPTION_FIX : DBCCWizard.ALLOC_OPTION_NOFIX;
                vector.add(SQLs.getString("dbcc checkalloc ({0}, {1})", string, string2));
            }
            return vector;
        }

        @Override
        public void releaseResources() {
            this._go.overallCheckBox.removeActionListener((ActionListener)this);
            this._go.allocationCheckbox.removeActionListener((ActionListener)this);
            this._go.systemCatalogCheckBox.removeActionListener((ActionListener)this);
            this._go.releaseResources();
            this._go = null;
            super.releaseResources();
        }
    }

    public class DBCCWizIntroPage
    extends ASEBaseWizardPage2 {
        private DBCCWizGOIntroPage _go;

        public DBCCWizIntroPage(DBCCWizard dBCCWizard2) {
            super(dBCCWizard2, (JPanel)((Object)new DBCCWizGOIntroPage()), ASEUtils.getString("CONTEXT_MENU_CHECK_CONSISTENCY_TEXT"));
            this._go = (DBCCWizGOIntroPage)((Object)this.getJPanel());
            ASEBaseContainer2 aSEBaseContainer2 = ((ASEBaseItem2)DBCCWizard.this._targets.get(0)).getParent();
            Support.fillListWithItems(this._go.objectsMultiList, DBCCWizard.this._targets, DBCCWizard.this._tableSO != null, aSEBaseContainer2.getHeadings());
            this.getGO().setDisplayPreviewButton(false);
            this.getGO().setDisplayScheduleButton(false);
        }

        @Override
        public void releaseResources() {
            this._go.releaseResources();
            this._go = null;
            super.releaseResources();
        }
    }
}

