/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.aseplugin.bo.wiz;

import com.sybase.aseplugin.ASEImages;
import com.sybase.aseplugin.ASEMessageText;
import com.sybase.aseplugin.ASEUtils;
import com.sybase.aseplugin.bo.DBsCtrBO;
import com.sybase.aseplugin.bo.Support;
import com.sybase.aseplugin.bo.wiz.ASEBaseWizDocPage;
import com.sybase.aseplugin.bo.wiz.ASEBaseWizardDialog2;
import com.sybase.aseplugin.bo.wiz.ASEBaseWizardPage2;
import com.sybase.aseplugin.bo.wiz.SummaryWizBOPage;
import com.sybase.aseplugin.go.wiz.DBQuiesceHoldWizGODependencyMatrixPage;
import com.sybase.aseplugin.go.wiz.DBUnmountWizGOEvalDependencyPage;
import com.sybase.aseplugin.go.wiz.DBUnmountWizGOIntroPage;
import com.sybase.aseplugin.go.wiz.DBUnmountWizGOManifestPage;
import com.sybase.aseplugin.go.wiz.DBUnmountWizGOOptionsPage;
import com.sybase.aseplugin.so.DatabaseSO;
import com.sybase.aseplugin.so.SOItemInterface;
import com.sybase.central.SCContainer2;
import com.sybase.central.SCPageController;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;

public class DatabaseUnmountWizard
extends ASEBaseWizardDialog2 {
    private String _waitForDelayTime = "";
    private String _dbNameList;
    private String _autoSelectedDBList = "";
    private String _manifestFileName;
    private boolean _withOverride;
    private boolean _evaluateDependency = true;
    private boolean _skipToSummary;

    public DatabaseUnmountWizard(DatabaseSO databaseSO, DBsCtrBO dBsCtrBO, String string) {
        super((SOItemInterface)databaseSO, (SCContainer2)dBsCtrBO, ASEUtils.getString("DB_UNMOUNT_WIZ_TITLE"));
        this._dbNameList = string;
    }

    @Override
    public SCPageController[] getPages() {
        return new SCPageController[]{new DBUnmountWizBOIntroPage(this), new DBUnmountWizBOManifestPage(this), new DBUnmountWizBOEvalDependencyPage(this), new DBUnmountWizBODependencyMatrixPage(this), new DBUnmountWizBOOptionsPage(this), new DBUnmountWizBOSummaryPage(this)};
    }

    public void setWaitForTimeDelay(String string) {
        this._waitForDelayTime = string;
    }

    public void setManifestFileName(String string) {
        this._manifestFileName = string;
    }

    public void setWithOverride(boolean bl) {
        this._withOverride = bl;
    }

    public void setEvaluateDependency(boolean bl) {
        this._evaluateDependency = bl;
    }

    public boolean getEvaluateDependency() {
        return this._evaluateDependency;
    }

    public void setSkipToSummary(boolean bl) {
        this._skipToSummary = bl;
    }

    public boolean skipToSummary() {
        return this._skipToSummary;
    }

    public String getEnquotedDatabaseList() {
        String string = "";
        StringTokenizer stringTokenizer = new StringTokenizer(this._dbNameList, ", ");
        while (stringTokenizer.hasMoreTokens()) {
            string = string + "'" + stringTokenizer.nextToken() + "', ";
        }
        string = string.substring(0, string.length() - 2);
        return string;
    }

    public void setAutoSelectedDBList(String string) {
        this._autoSelectedDBList = string;
    }

    @Override
    public boolean deploy() {
        Object object;
        File file = new File(this._manifestFileName);
        if (file.exists()) {
            object = new ASEMessageText(ASEUtils.getString("MSG_FILE_EXIST_CONTINUE"), this._manifestFileName);
            int n = Support.showQuestionYesNo(this.getJDialog(), ((ASEMessageText)object).toString());
            if (0 != n) {
                return false;
            }
        }
        object = (DatabaseSO)this.getSO();
        try {
            String string = this._dbNameList;
            if (this._evaluateDependency && !this._autoSelectedDBList.equals("")) {
                string = string + ", " + this._autoSelectedDBList;
            }
            ((DatabaseSO)object).unMount(string, this._manifestFileName, this._withOverride, this._waitForDelayTime);
            ((DBsCtrBO)this.getParent()).refresh();
            return true;
        }
        catch (SQLException sQLException) {
            Support.showDetailsError(this.getConnection(), this.getClass(), (Container)this.getJDialog(), sQLException.getMessage(), sQLException);
            return false;
        }
    }

    class DBUnmountWizBOSummaryPage
    extends SummaryWizBOPage {
        public DBUnmountWizBOSummaryPage(DatabaseUnmountWizard databaseUnmountWizard2) {
            super(databaseUnmountWizard2, ASEImages.getDatabaseWizardImage());
        }

        @Override
        public void enableComponents() {
            this.clearSummaryItems();
            String string = DatabaseUnmountWizard.this._dbNameList;
            string = string + (DatabaseUnmountWizard.this._evaluateDependency && !DatabaseUnmountWizard.this._autoSelectedDBList.equals("") ? "," + DatabaseUnmountWizard.this._autoSelectedDBList : "");
            this.addSummaryItem(ASEUtils.getString("DATABASES"), string);
            this.addSummaryItem(ASEUtils.getString("MANIFEST_FILE"), DatabaseUnmountWizard.this._manifestFileName);
            this.addSummaryItem(ASEUtils.getString("MSG_WITH_OVERRIDE"), DatabaseUnmountWizard.this._withOverride);
            if (DatabaseUnmountWizard.this._waitForDelayTime.length() != 0) {
                this.addSummaryItem(ASEUtils.getString("WAIT_FOR_DELAY"), DatabaseUnmountWizard.this._waitForDelayTime + " " + ASEUtils.getString("HHMMSS"));
            }
            this.setSummaryInfo(this.getSummary());
        }
    }

    class DBUnmountWizBOOptionsPage
    extends ASEBaseWizardPage2
    implements ActionListener {
        private DBUnmountWizGOOptionsPage _go;

        public DBUnmountWizBOOptionsPage(DatabaseUnmountWizard databaseUnmountWizard2) {
            super(databaseUnmountWizard2, (JPanel)((Object)new DBUnmountWizGOOptionsPage()), ASEUtils.getString("DB_UNMOUNT_WIZ_PAGE5_TITLE"));
            this._go = (DBUnmountWizGOOptionsPage)((Object)this.getJPanel());
            this._go.withOverrideCheckBox.addActionListener((ActionListener)this);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            DatabaseUnmountWizard.this.setWithOverride(this._go.withOverrideCheckBox.isSelected());
        }

        @Override
        public boolean deploy() {
            String string = this._go.waitForDelayHrsTextField.getText().length() != 0 ? this._go.waitForDelayHrsTextField.getText() : "00";
            string = string + ":" + (this._go.waitForDelayMinTextField.getText().length() != 0 ? this._go.waitForDelayMinTextField.getText() : "00");
            string = string + ":" + (this._go.waitForDelaySecTextField.getText().length() != 0 ? this._go.waitForDelaySecTextField.getText() : "00");
            DatabaseUnmountWizard.this.setWaitForTimeDelay(string.equals("00:00:00") ? "" : string);
            return true;
        }

        @Override
        public void releaseResources() {
            this._go.withOverrideCheckBox.removeActionListener((ActionListener)this);
            this._go.releaseResources();
            this._go = null;
            super.releaseResources();
        }
    }

    class DBUnmountWizBODependencyMatrixPage
    extends ASEBaseWizardPage2 {
        private DBQuiesceHoldWizGODependencyMatrixPage _go;
        private String _strUnselectedDBs;

        public DBUnmountWizBODependencyMatrixPage(DatabaseUnmountWizard databaseUnmountWizard2) {
            super(databaseUnmountWizard2, (JPanel)((Object)new DBQuiesceHoldWizGODependencyMatrixPage()), ASEUtils.getString("DB_UNMOUNT_WIZ_PAGE4_TITLE"));
            this._strUnselectedDBs = "";
            this._go = (DBQuiesceHoldWizGODependencyMatrixPage)((Object)this.getJPanel());
        }

        @Override
        public void init() throws SQLException {
            DatabaseSO databaseSO = (DatabaseSO)this.getSO();
            TreeSet<String> treeSet = new TreeSet<String>();
            Vector vector = new Vector();
            vector = databaseSO.getDatabaseDeviceDatabaseList(DatabaseUnmountWizard.this.getEnquotedDatabaseList());
            for (int i = 0; i < vector.size(); ++i) {
                Object[] objectArray = (String[])vector.elementAt(i);
                this._go._tableMultiList.addRow(objectArray);
                if (((String)objectArray[2]).equals("")) continue;
                StringTokenizer stringTokenizer = new StringTokenizer((String)objectArray[2], ", ");
                while (stringTokenizer.hasMoreTokens()) {
                    String string = stringTokenizer.nextToken();
                    if (treeSet.contains(string)) continue;
                    treeSet.add(string);
                }
            }
            if (!treeSet.isEmpty()) {
                Iterator iterator = treeSet.iterator();
                while (iterator.hasNext()) {
                    this._strUnselectedDBs = this._strUnselectedDBs + iterator.next() + ",";
                }
                this._strUnselectedDBs = this._strUnselectedDBs.substring(0, this._strUnselectedDBs.length() - 1);
                DatabaseUnmountWizard.this.setAutoSelectedDBList(this._strUnselectedDBs);
                this._go._autoSelectLabel.setText(ASEUtils.getString("DB_WIZ_AUTO_SELECT_LABEL_DEPENDENCIES"));
            } else {
                this._go._autoSelectLabel.setText(ASEUtils.getString("DB_WIZ_AUTO_SELECT_LABEL_NO_DEPENDENCIES"));
            }
        }

        @Override
        public int onWizardNext() {
            if (!this._strUnselectedDBs.equals("")) {
                ASEMessageText aSEMessageText = new ASEMessageText(ASEUtils.getString("DB_WIZ_AUTO_SELECT_WARNING"), this._strUnselectedDBs);
                Support.showWarning(this.getConnection(), this.getClass(), this.getJDialog(), aSEMessageText.toString());
            }
            return 0;
        }

        @Override
        public boolean showPage() {
            return !DatabaseUnmountWizard.this.skipToSummary();
        }

        @Override
        public void releaseResources() {
            this._go.releaseResources();
            this._go = null;
            super.releaseResources();
        }
    }

    class DBUnmountWizBOEvalDependencyPage
    extends ASEBaseWizardPage2
    implements ActionListener {
        private DBUnmountWizGOEvalDependencyPage _go;

        public DBUnmountWizBOEvalDependencyPage(DatabaseUnmountWizard databaseUnmountWizard2) {
            super(databaseUnmountWizard2, (JPanel)((Object)new DBUnmountWizGOEvalDependencyPage()), ASEUtils.getString("DB_UNMOUNT_WIZ_PAGE3_TITLE"));
            this._go = (DBUnmountWizGOEvalDependencyPage)((Object)this.getJPanel());
            this._go.yesRadioButton.addActionListener((ActionListener)this);
            this._go.noRadioButton.addActionListener((ActionListener)this);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == this._go.noRadioButton) {
                DatabaseUnmountWizard.this.setEvaluateDependency(false);
                DatabaseUnmountWizard.this.setSkipToSummary(true);
            } else if (actionEvent.getSource() == this._go.yesRadioButton) {
                DatabaseUnmountWizard.this.setEvaluateDependency(true);
                DatabaseUnmountWizard.this.setSkipToSummary(false);
            }
        }

        @Override
        public void releaseResources() {
            this._go.yesRadioButton.removeActionListener((ActionListener)this);
            this._go.noRadioButton.removeActionListener((ActionListener)this);
            this._go.releaseResources();
            this._go = null;
            super.releaseResources();
        }
    }

    class DBUnmountWizBOManifestPage
    extends ASEBaseWizDocPage {
        private DBUnmountWizGOManifestPage _go;

        public DBUnmountWizBOManifestPage(DatabaseUnmountWizard databaseUnmountWizard2) {
            super(databaseUnmountWizard2, (JPanel)((Object)new DBUnmountWizGOManifestPage()), ASEUtils.getString("DB_UNMOUNT_WIZ_PAGE2_TITLE"));
            this._go = (DBUnmountWizGOManifestPage)((Object)this.getJPanel());
            this._go.manifestFileNameEditor.addDocumentListener(this);
        }

        @Override
        public void init() {
            boolean bl = this.getSO().getConnection().isLocal();
            this._go.manifestFileNameEditor.setConnectionLocal(bl);
            this._go.manifestFileNameEditor.setParentWindow(this.getJDialog());
        }

        @Override
        public void enableComponents() {
            this.textValueChanged(null);
        }

        @Override
        public void textValueChanged(DocumentEvent documentEvent) {
            String string = this._go.manifestFileNameEditor.getTextField().getText();
            this.enableNextButton(string.length() != 0);
            DatabaseUnmountWizard.this.setManifestFileName(string);
        }

        @Override
        public void releaseResources() {
            this._go.manifestFileNameEditor.removeDocumentListener(this);
            this._go.releaseResources();
            this._go = null;
            super.releaseResources();
        }
    }

    class DBUnmountWizBOIntroPage
    extends ASEBaseWizardPage2 {
        public DBUnmountWizBOIntroPage(DatabaseUnmountWizard databaseUnmountWizard2) {
            super(databaseUnmountWizard2, (JPanel)((Object)new DBUnmountWizGOIntroPage()), ASEUtils.getString("WIZ_INTRO_PAGE_TITLE"));
        }
    }
}

