/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.aseplugin.bo.wiz;

import com.sybase.aseplugin.ASEImages;
import com.sybase.aseplugin.ASEMessageText;
import com.sybase.aseplugin.ASEUtils;
import com.sybase.aseplugin.bo.ContainerViewBO;
import com.sybase.aseplugin.bo.DBsCtrBO;
import com.sybase.aseplugin.bo.DatabaseDeviceBO;
import com.sybase.aseplugin.bo.DatabaseDevicesCtrBO;
import com.sybase.aseplugin.bo.SDCInstanceBO;
import com.sybase.aseplugin.bo.ServerBO;
import com.sybase.aseplugin.bo.Support;
import com.sybase.aseplugin.bo.TempDBsCtrBO;
import com.sybase.aseplugin.bo.TempDBsListCtrBO;
import com.sybase.aseplugin.bo.dlg.AddDeviceToDatabaseDialog;
import com.sybase.aseplugin.bo.dlg.EditDeviceSizeOfDatabaseDialog;
import com.sybase.aseplugin.bo.wiz.ASEBaseWizardDialog2;
import com.sybase.aseplugin.bo.wiz.ASEBaseWizardPage2;
import com.sybase.aseplugin.bo.wiz.NameWizBOPage;
import com.sybase.aseplugin.bo.wiz.SummaryWizBOPage;
import com.sybase.aseplugin.go.ASETable;
import com.sybase.aseplugin.go.wiz.DatabaseWizDurabilityGOPage;
import com.sybase.aseplugin.go.wiz.DatabaseWizGOPage2;
import com.sybase.aseplugin.go.wiz.DatabaseWizGOPage3;
import com.sybase.aseplugin.go.wiz.DatabaseWizGOPage4;
import com.sybase.aseplugin.go.wiz.DatabaseWizGOPage5;
import com.sybase.aseplugin.go.wiz.DatabaseWizGOPage6;
import com.sybase.aseplugin.so.DatabaseDeviceSO;
import com.sybase.aseplugin.so.DatabaseDevicesCtrSO;
import com.sybase.aseplugin.so.DatabaseSO;
import com.sybase.aseplugin.so.DatabasesCtrSO;
import com.sybase.aseplugin.so.SOItemInterface;
import com.sybase.aseplugin.so.TempDBGroupSO;
import com.sybase.aseplugin.so.TempDBSO;
import com.sybase.aseplugin.so.TempDBsGroupsCtrSO;
import com.sybase.aseplugin.so.Utility;
import com.sybase.aseplugin.util.ui.JLabelTableModel;
import com.sybase.aseplugin.util.ui.MyCellRenderer;
import com.sybase.aseplugin.util.ui.TableSelectionListener;
import com.sybase.central.SCContainer2;
import com.sybase.central.SCPageController;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;

public class DatabaseWizard
extends ASEBaseWizardDialog2 {
    DatabaseSO _dbso;
    boolean enableFinish;
    boolean _isSDCLocal = false;
    Vector _ignoreDevList = new Vector();
    boolean _needEnableOverride = false;

    public DatabaseWizard(DatabaseSO databaseSO, DBsCtrBO dBsCtrBO, String string) {
        super((SOItemInterface)databaseSO, (SCContainer2)dBsCtrBO, string);
        this._dbso = databaseSO;
        try {
            this.enableFinish = ((DatabaseSO)this.getSO()).getAvailableDBDevice();
        }
        catch (SQLException sQLException) {
            this.enableFinish = false;
        }
        if (dBsCtrBO instanceof TempDBsListCtrBO && dBsCtrBO.getDatabaseCtrType() == 7) {
            TempDBsCtrBO tempDBsCtrBO = (TempDBsCtrBO)((TempDBsListCtrBO)dBsCtrBO).getParent();
            TempDBSO tempDBSO = (TempDBSO)databaseSO;
            SDCInstanceBO sDCInstanceBO = (SDCInstanceBO)tempDBsCtrBO.getParent();
            tempDBSO.setSDCInstanceName(sDCInstanceBO.getDisplayName(0));
            this._isSDCLocal = true;
        }
    }

    public boolean getEnableFinish() {
        return this.enableFinish;
    }

    @Override
    public SCPageController[] getPages() {
        boolean bl = false;
        boolean bl2 = false;
        try {
            bl = ((DatabaseSO)this.getSO()).isTempDBGroupApplicable();
            bl2 = ((DatabaseSO)this.getSO()).isAutoExpansionApplicable();
        }
        catch (SQLException sQLException) {
            Support.showDetailsError(this.getConnection(), this.getClass(), (Container)this.getJDialog(), sQLException.toString(), sQLException);
        }
        Vector<ASEBaseWizardPage2> vector = new Vector<ASEBaseWizardPage2>();
        vector.add(new DatabaseWizNamePage(this));
        vector.add(new DatabaseWizDevicePage(this));
        vector.add(new DatabaseWizOptionsPage(this));
        int n = ((DBsCtrBO)this.getParent()).getDatabaseCtrType();
        if (this._dbso.isDurabilityApplicable() && n != 12 && n != 3) {
            vector.add(new DatabaseWizDurabilityPage(this));
        }
        if (n == 3 && bl || n == 7 || n == 12) {
            vector.add(new DatabaseWizTempDBPage(this));
        } else if (n != 6) {
            vector.add(new DatabaseWizUserPage(this));
        }
        if (bl2) {
            vector.add(new DatabaseWizAutoExpandPage(this));
        }
        vector.add(new DatabaseWizSummaryPage(this));
        SCPageController[] sCPageControllerArray = new SCPageController[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            sCPageControllerArray[i] = (SCPageController)vector.elementAt(i);
        }
        return sCPageControllerArray;
    }

    public boolean isSDCLocal() {
        return this._isSDCLocal;
    }

    @Override
    public boolean deploy() {
        boolean bl = false;
        bl = super.deploy();
        if (this.isSDCLocal()) {
            ((TempDBsListCtrBO)this.getParent()).getParent().refresh();
        }
        return bl;
    }

    @Override
    public void refresh() {
        ServerBO serverBO = ContainerViewBO.getServerBO(this._dbso.getConnection());
        DatabaseDevicesCtrBO databaseDevicesCtrBO = ContainerViewBO.getDatabaseDevicesCtrBO(serverBO);
        if (null != databaseDevicesCtrBO) {
            databaseDevicesCtrBO.refresh();
        }
    }

    @Override
    public void releaseResources() {
        this._dbso = null;
        super.releaseResources();
    }

    protected boolean canAddSummaryForLoad(DatabaseSO databaseSO) {
        int n = ((DatabaseSO)this.getSO()).getDBType();
        return n != 3 && n != 13 && n != 7 && n != 6;
    }

    protected boolean canAddSummaryGuest(DatabaseSO databaseSO) {
        int n = ((DatabaseSO)this.getSO()).getDBType();
        return n != 3 && n != 13 && n != 7 && n != 6;
    }

    protected boolean canAddSummaryTemplate(DatabaseSO databaseSO) {
        return databaseSO.isTemplateDBAlterable();
    }

    protected boolean canAddSummaryDurability(DatabaseSO databaseSO) {
        if (databaseSO.isDurabilityApplicable()) {
            return !databaseSO.isInIMDBFamily() && !databaseSO.isTempDB();
        }
        return false;
    }

    protected boolean canAddSummaryGroupName(DatabaseSO databaseSO) {
        if (databaseSO instanceof TempDBSO) {
            TempDBSO tempDBSO = (TempDBSO)this.getSO();
            int n = tempDBSO.getDatabaseSubType();
            return n == 8 || n == 3 || n == 13;
        }
        return false;
    }

    class DatabaseWizSummaryPage
    extends SummaryWizBOPage {
        public DatabaseWizSummaryPage(DatabaseWizard databaseWizard2) {
            super(databaseWizard2, ASEImages.getDatabaseWizardImage());
        }

        @Override
        public void enableComponents() {
            this.clearSummaryItems();
            DatabaseSO databaseSO = (DatabaseSO)this.getSO();
            this.addSummaryItem(ASEUtils.getString("MSG_DATABASE_NAME"), databaseSO.getName());
            Vector vector = databaseSO.getDBDevice();
            if (vector != null && vector.size() > 0) {
                ArrayList<String> arrayList = new ArrayList<String>();
                for (int i = 0; i < vector.size(); ++i) {
                    Vector vector2 = (Vector)vector.get(i);
                    String string = ((JLabel)vector2.get(0)).getText();
                    arrayList.add(string);
                }
                this.addSummaryItem(ASEUtils.getString("DNAME_DATABASEDEVICES"), Utility.stringArrayToString(arrayList.toArray(), ", "));
            }
            if (DatabaseWizard.this.canAddSummaryGroupName(databaseSO)) {
                this.addSummaryItem(ASEUtils.getString("MSG_TMPDB_GRP_MEMBERSHIP"), ((TempDBSO)this.getSO()).getGroupName());
            }
            this.addSummaryItem(ASEUtils.getString("MSG_WITH_OVERRIDE"), databaseSO.isWithOverride());
            if (DatabaseWizard.this.canAddSummaryDurability(databaseSO)) {
                this.addSummaryItem(ASEUtils.getString("MSG_WITH_DURABILITY"), databaseSO.getDurability());
            }
            if (DatabaseWizard.this.canAddSummaryForLoad(databaseSO)) {
                this.addSummaryItem(ASEUtils.getString("MSG_FOR_LOAD"), databaseSO.isForLoad());
            }
            if (DatabaseWizard.this.canAddSummaryGuest(databaseSO)) {
                this.addSummaryItem(ASEUtils.getString("MSG_GUEST_ACCOUNT"), databaseSO.hasGuest());
            }
            if (DatabaseWizard.this.canAddSummaryTemplate(databaseSO)) {
                this.addSummaryItem(ASEUtils.getString("DNAME_DATABASE_WITH_TEMPLATE"), databaseSO.getTemplateDB());
            }
            this.setSummaryInfo(this.getSummary());
        }
    }

    class DatabaseWizAutoExpandPage
    extends ASEBaseWizardPage2 {
        private DatabaseWizGOPage6 _go;
        private String _initialGrowBy;
        private int _initialSelectedIndex;

        public DatabaseWizAutoExpandPage(DatabaseWizard databaseWizard2) {
            super(databaseWizard2, (JPanel)((Object)new DatabaseWizGOPage6()), ASEUtils.getString("MSG_SEGMENT_WIZ_PAGE2"));
            this._go = (DatabaseWizGOPage6)((Object)this.getJPanel());
        }

        @Override
        public void init() throws SQLException {
            Support.fillUnitList((JComboBox)this._go.growByUnitComboBox);
            this._go.growByUnitComboBox.addItem((Object)"%");
            this._initialGrowBy = DatabaseWizard.this._dbso.getDefaultGrowBySize();
            char c = this._initialGrowBy.substring(this._initialGrowBy.length() - 1).toUpperCase().charAt(0);
            this._initialGrowBy = this._initialGrowBy.substring(0, this._initialGrowBy.length() - 1);
            this._go.growByText.setText(this._initialGrowBy);
            switch (c) {
                case 'P': {
                    this._go.growByUnitComboBox.setSelectedIndex(0);
                    this._initialSelectedIndex = 0;
                    break;
                }
                case 'K': {
                    this._go.growByUnitComboBox.setSelectedIndex(1);
                    this._initialSelectedIndex = 1;
                    break;
                }
                case 'M': {
                    this._go.growByUnitComboBox.setSelectedIndex(2);
                    this._initialSelectedIndex = 2;
                    break;
                }
                case 'G': {
                    this._go.growByUnitComboBox.setSelectedIndex(3);
                    this._initialSelectedIndex = 3;
                    break;
                }
                case '%': {
                    this._go.growByUnitComboBox.setSelectedIndex(4);
                    this._initialSelectedIndex = 4;
                }
            }
        }

        @Override
        public void enableComponents() {
            this.enableFinishButton(true);
        }

        @Override
        public int onWizardNext() {
            String string = this._go.growByText.getText();
            int n = this._go.growByUnitComboBox.getSelectedIndex();
            if (!string.equals(this._initialGrowBy) || n != this._initialSelectedIndex) {
                String string2 = this.getUnitSuffix(this._go.growByUnitComboBox.getSelectedIndex());
                DatabaseWizard.this._dbso.setGrowBySize(string + string2);
            }
            if (this._go.migratePolicyCheckBox.isSelected()) {
                DatabaseWizard.this._dbso.migratePoliciesfromModel(true);
            }
            return 0;
        }

        private String getUnitSuffix(int n) {
            String string = null;
            switch (n) {
                case 0: {
                    string = "p";
                    break;
                }
                case 1: {
                    string = "k";
                    break;
                }
                case 2: {
                    string = "m";
                    break;
                }
                case 3: {
                    string = "g";
                    break;
                }
                case 4: {
                    string = "%";
                }
            }
            return string;
        }

        @Override
        public void releaseResources() {
            this._go.releaseResources();
            this._go = null;
            super.releaseResources();
        }
    }

    class DatabaseWizTempDBPage
    extends ASEBaseWizardPage2 {
        private TempDBSO _so;
        private DatabaseWizGOPage5 _go;

        public DatabaseWizTempDBPage(DatabaseWizard databaseWizard2) {
            super(databaseWizard2, (JPanel)((Object)new DatabaseWizGOPage5()), ASEUtils.getString("MSG_DB_WIZ_TEMP_DB"));
            this._so = (TempDBSO)this.getSO();
            this._go = (DatabaseWizGOPage5)((Object)this.getJPanel());
            this.setAvailableGroups();
        }

        @Override
        public void enableComponents() {
            this.enableFinishButton(true);
        }

        private void setAvailableGroups() {
            this._go.groupComboBox.addItem((Object)ASEUtils.getString("NONE_TEMP_DB"));
            TempDBsGroupsCtrSO tempDBsGroupsCtrSO = new TempDBsGroupsCtrSO(this.getConnection());
            Vector vector = null;
            try {
                vector = (Vector)tempDBsGroupsCtrSO.open(1);
            }
            catch (SQLException sQLException) {
                Support.showDetailsError(this.getConnection(), this.getClass(), (Container)this.getJDialog(), sQLException.toString(), sQLException);
            }
            if (vector != null) {
                for (TempDBGroupSO tempDBGroupSO : vector) {
                    this._go.groupComboBox.addItem((Object)tempDBGroupSO.getName());
                }
            }
        }

        @Override
        public boolean deploy() {
            String string = (String)this._go.groupComboBox.getSelectedItem();
            if (string == null || string.equals(ASEUtils.getString("NONE_TEMP_DB"))) {
                string = "";
            }
            this._so.setGroupName(string);
            return true;
        }

        @Override
        public void releaseResources() {
            this._go.releaseResources();
            this._go = null;
            this._so = null;
            super.releaseResources();
        }
    }

    class DatabaseWizUserPage
    extends ASEBaseWizardPage2 {
        private DatabaseWizGOPage4 _go;

        public DatabaseWizUserPage(DatabaseWizard databaseWizard2) {
            super(databaseWizard2, (JPanel)((Object)new DatabaseWizGOPage4()), ASEUtils.getString("MSG_DB_WIZ_PAGE4"));
            this._go = (DatabaseWizGOPage4)((Object)this.getJPanel());
        }

        @Override
        public void enableComponents() {
            this.enableFinishButton(true);
        }

        @Override
        public boolean deploy() {
            ((DatabaseSO)this.getSO()).setGuestAccount(this._go.guestAccountCheckBox.isSelected());
            return true;
        }

        @Override
        public void releaseResources() {
            this._go.releaseResources();
            this._go = null;
            super.releaseResources();
        }
    }

    class DatabaseWizDurabilityPage
    extends ASEBaseWizardPage2 {
        private DatabaseWizDurabilityGOPage _go;
        protected DatabaseSO _dbSO;

        public DatabaseWizDurabilityPage(DatabaseWizard databaseWizard2) {
            super(databaseWizard2, (JPanel)((Object)new DatabaseWizDurabilityGOPage()), ASEUtils.getString("MSG_DB_WIZ_DURABILITY"));
            this._dbSO = (DatabaseSO)this.getSO();
            this._go = (DatabaseWizDurabilityGOPage)((Object)this.getJPanel());
        }

        @Override
        public void init() {
            this.initDurabilityOption();
        }

        protected void initDurabilityOption() {
            this._go.fullRadioButton.setSelected(true);
        }

        @Override
        public void enableComponents() {
            this.enableFinishButton(true);
        }

        protected String getDurability() {
            if (this._go.noneRadioButton.isSelected()) {
                return "NO_RECOVERY";
            }
            if (this._go.shutdownRadioButton.isSelected()) {
                return "AT_SHUTDOWN";
            }
            return "FULL";
        }

        @Override
        public boolean deploy() {
            DatabaseSO databaseSO = (DatabaseSO)this.getSO();
            databaseSO.setDurability(this.getDurability());
            return true;
        }

        @Override
        public void releaseResources() {
            this._go.releaseResources();
            this._go = null;
            super.releaseResources();
        }
    }

    class DatabaseWizOptionsPage
    extends ASEBaseWizardPage2
    implements ActionListener {
        protected DatabaseWizGOPage3 _go;
        protected DatabaseSO _dbSO;
        protected DatabasesCtrSO _dbCtrlSO;

        public DatabaseWizOptionsPage(DatabaseWizard databaseWizard2) {
            super(databaseWizard2, (JPanel)((Object)new DatabaseWizGOPage3()), ASEUtils.getString("MSG_DB_WIZ_PAGE3"));
            this._dbSO = (DatabaseSO)this.getSO();
            this._dbCtrlSO = new DatabasesCtrSO(this._dbSO.getConnection());
            this._go = (DatabaseWizGOPage3)((Object)this.getJPanel());
            int n = ((DatabaseSO)this.getSO()).getDBType();
            switch (n) {
                case 3: 
                case 6: 
                case 7: 
                case 13: {
                    this._go.forLoadLabel.setVisible(false);
                    this._go.forLoadCheckBox.setVisible(false);
                }
            }
        }

        @Override
        public boolean onSetActive() {
            if (!this._go.overrideCheckBox.isSelected()) {
                this._go.overrideCheckBox.setSelected(DatabaseWizard.this._needEnableOverride);
            } else if (!this._go.overrideCheckBox.isEnabled()) {
                this._go.overrideCheckBox.setSelected(DatabaseWizard.this._needEnableOverride);
            }
            this._go.overrideCheckBox.setEnabled(!DatabaseWizard.this._needEnableOverride);
            this.enableComponents();
            return true;
        }

        public void addListeners() {
            this._go.forLoadCheckBox.addActionListener((ActionListener)this);
        }

        public void removeListeners() {
            this._go.forLoadCheckBox.removeActionListener((ActionListener)this);
        }

        protected void setTemplateDBOptionVisible(boolean bl) {
            this._go.templateDBDesc.setVisible(bl);
            this._go.specifyTemplateDBLabel.setVisible(bl);
            this._go.templateDBComboBox.setVisible(bl);
        }

        protected void initTemplateDBOption() {
            this.fillTemplateDBCombox();
            this._go.templateDBComboBox.setSelectedItem("NULL");
        }

        protected void fillTemplateDBCombox() {
            List<String> list = null;
            this._go.templateDBComboBox.clear();
            try {
                list = this._dbCtrlSO.getTemplateDBList();
            }
            catch (SQLException sQLException) {
                Support.showError(this.getConnection(), this.getClass(), this.getJDialog(), sQLException.toString());
            }
            for (String string : list) {
                this._go.templateDBComboBox.addItem((Object)string);
            }
        }

        @Override
        public void init() {
            this.removeListeners();
            if (this._dbSO.isTemplateDBApplicable()) {
                this.setTemplateDBOptionVisible(true);
                this.initTemplateDBOption();
            } else {
                this.setTemplateDBOptionVisible(false);
            }
            this.addListeners();
        }

        @Override
        public void enableComponents() {
            this.enableFinishButton(((DatabaseWizard)this.getParent()).getEnableFinish());
        }

        @Override
        public boolean deploy() {
            String string;
            DatabaseSO databaseSO = (DatabaseSO)this.getSO();
            databaseSO.setWithOverride(this._go.overrideCheckBox.isSelected());
            int n = databaseSO.getDBType();
            if (n != 3 && n != 6 && n != 7) {
                databaseSO.setForLoad(this._go.forLoadCheckBox.isSelected());
            }
            if (this._dbSO.isTemplateDBAlterable() && null != (string = this._go.templateDBComboBox.getSelectedString()) && string.length() > 0) {
                databaseSO.setTemplateDB(string);
            }
            return true;
        }

        @Override
        public void releaseResources() {
            this._go.releaseResources();
            this._go = null;
            super.releaseResources();
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this._go.templateDBComboBox.setEnabled(!this._go.forLoadCheckBox.isSelected());
            this.enableComponents();
        }
    }

    class DatabaseWizDevicePage
    extends ASEBaseWizardPage2
    implements ActionListener {
        JLabelTableModel _tableModel;
        JTable _tblDevices;
        Vector _tableVector;
        Vector headings;
        Dimension rectContain;
        Dimension rectHeader;
        protected DatabaseWizGOPage2 _go;
        protected Map _initDBSizeMap;

        public DatabaseWizDevicePage(DatabaseWizard databaseWizard2) {
            this(databaseWizard2, ASEUtils.getString("MSG_DB_WIZ_PAGE2"));
        }

        public DatabaseWizDevicePage(DatabaseWizard databaseWizard2, String string) {
            super(databaseWizard2, (JPanel)((Object)new DatabaseWizGOPage2()), string);
            this._initDBSizeMap = new HashMap();
            this.initGO();
        }

        protected void initGO() {
            this._go = (DatabaseWizGOPage2)((Object)this.getJPanel());
            this._tblDevices = new ASETable();
            this._go.scroll.getViewport().add(this._tblDevices);
            this.headings = new Vector();
            this.headings.addElement(ASEUtils.getString("DISP_NAME_TEXT"));
            this.headings.addElement(ASEUtils.getString("DISP_SIZE_MB_TEXT"));
            this.headings.addElement(ASEUtils.getString("MSG_FUTURE_ALLOCATIONS"));
            this._tableVector = new Vector();
            this._tableModel = new JLabelTableModel(this.headings, this._tableVector);
            this._tblDevices.setModel(this._tableModel);
            this._go.removeButton.addActionListener((ActionListener)this);
            this._go.editButton.addActionListener((ActionListener)this);
            this._go.addButton.addActionListener((ActionListener)this);
            this._go.addButton.setEnabled(true);
            this._go.removeButton.setEnabled(false);
            this._go.editButton.setEnabled(false);
        }

        @Override
        public void enableComponents() {
            this.enableNextButton(((DatabaseWizard)this.getParent()).getEnableFinish());
            this.enableFinishButton(((DatabaseWizard)this.getParent()).getEnableFinish());
        }

        @Override
        public void init() throws SQLException {
            int n;
            Object object;
            String string;
            Object object2;
            this.rectContain = this._tblDevices.getSize();
            this.rectHeader = this._tblDevices.getTableHeader().getSize();
            if (((DatabaseSO)this.getSO()).getConnection().getVersion().startsWith("12.0")) {
                object2 = new ASEMessageText(ASEUtils.getString("DATABASE_12_0_SIZE_INTRO"), ((DatabaseSO)this.getSO()).getDefaultDevicesList());
                this._go.introTextMultiLineLabel.setText(((ASEMessageText)object2).toString());
            } else {
                object2 = String.valueOf(((DatabaseSO)this.getSO()).getModelDBSize());
                string = String.valueOf(((DatabaseSO)this.getSO()).getDefaultDBSize());
                object = new ASEMessageText(ASEUtils.getString("DATABASE_12_5_SIZE_INTRO"), ((DatabaseSO)this.getSO()).getDefaultDevicesList(), Integer.parseInt((String)object2) > Integer.parseInt(string) ? object2 : string);
                this._go.introTextMultiLineLabel.setText(((ASEMessageText)object).toString());
            }
            for (n = 0; n < this._tblDevices.getRowCount(); ++n) {
                string = (String)this._tblDevices.getValueAt(n, 0);
                object = this._tblDevices.getValueAt(n, 1).toString();
                this._initDBSizeMap.put(string, object);
            }
            for (n = 0; n < this._tblDevices.getRowCount(); ++n) {
                string = (String)this._tblDevices.getValueAt(n, 0);
                object = this._tblDevices.getValueAt(n, 1).toString();
                this._initDBSizeMap.put(string, object);
            }
            this._tblDevices.setSelectionMode(0);
            TableSelectionListener tableSelectionListener = new TableSelectionListener(){

                @Override
                public void deSelectAction() {
                    DatabaseWizDevicePage.this._go.removeButton.setEnabled(false);
                    DatabaseWizDevicePage.this._go.editButton.setEnabled(false);
                }

                @Override
                public void selectAction() {
                    DatabaseWizDevicePage.this._go.removeButton.setEnabled(true);
                    DatabaseWizDevicePage.this._go.editButton.setEnabled(true);
                }
            };
            this._tblDevices.getSelectionModel().addListSelectionListener(tableSelectionListener);
            this._tblDevices.setDefaultRenderer(new JLabel().getClass(), new MyCellRenderer());
            this._tblDevices.setSize(this.rectContain);
            this._tblDevices.getTableHeader().setSize(this.rectHeader);
            for (int i = 0; i < this._tblDevices.getRowCount(); ++i) {
                object = (String)this._tblDevices.getValueAt(i, 0);
                String string2 = this._tblDevices.getValueAt(i, 1).toString();
                this._initDBSizeMap.put(object, string2);
            }
        }

        public Vector<DatabaseDeviceSO> getDatabaseDeviceList() throws SQLException {
            Vector<DatabaseDeviceSO> vector = new Vector<DatabaseDeviceSO>();
            DatabaseDevicesCtrSO databaseDevicesCtrSO = new DatabaseDevicesCtrSO(DatabaseWizard.this._dbso.getConnection());
            vector.addAll(databaseDevicesCtrSO.open(1));
            if (((DatabaseWizard)this.getParent()).isSDCLocal()) {
                TempDBSO tempDBSO = (TempDBSO)this.getSO();
                DatabaseDevicesCtrSO databaseDevicesCtrSO2 = new DatabaseDevicesCtrSO(tempDBSO.getConnection(), tempDBSO.getSDCInstanceName());
                vector.addAll(databaseDevicesCtrSO2.open(1));
            }
            return vector;
        }

        protected void doAddDevice(Vector vector) {
            new AddDeviceToDatabaseDialog(Support.createDialogSupport(this.getJDialog()), DatabaseWizard.this._dbso, vector, this._tableModel, this._tblDevices, false, this._initDBSizeMap, ((DatabaseWizard)this.getParent())._ignoreDevList);
        }

        protected void doEditDevice() {
            int[] nArray = this._tblDevices.getSelectedRows();
            for (int i = 0; i < nArray.length; ++i) {
                long l = ((Double)this._tableModel.getValueAt(nArray[i], 1)).longValue();
                String string = ((JLabel)this._tableModel.getValueAt(nArray[i], 0)).getText();
                String string2 = (String)this._initDBSizeMap.get(string);
                DatabaseDeviceSO databaseDeviceSO = null;
                databaseDeviceSO = this.getEditingDatabaseDevice(string);
                new EditDeviceSizeOfDatabaseDialog(Support.createDialogSupport(this.getJDialog()), string, databaseDeviceSO.getSize(), databaseDeviceSO.getUnusedSize(), l, this._tableModel, this._tblDevices, nArray[i], true, string2);
            }
        }

        protected void doRemoveDevice() {
            int[] nArray = this._tblDevices.getSelectedRows();
            for (int i = 0; i < nArray.length; ++i) {
                this._tableModel.removeRow(nArray[i]);
            }
            this._tblDevices.tableChanged(new TableModelEvent(this._tableModel));
            this._go.removeButton.setEnabled(false);
            this._go.editButton.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Vector vector = null;
            try {
                vector = (Vector)this.getDatabaseDeviceList().clone();
            }
            catch (SQLException sQLException) {
                Support.showDetailsError(this.getConnection(), this.getClass(), (Container)this.getJDialog(), sQLException.toString(), sQLException);
            }
            if (actionEvent.getSource() == this._go.addButton) {
                this.doAddDevice(vector);
            } else if (actionEvent.getSource() == this._go.removeButton) {
                this.doRemoveDevice();
            } else if (actionEvent.getSource() == this._go.editButton) {
                this.doEditDevice();
            }
            boolean bl = this._tableModel.getRowCount() > 0;
            this.enableNextButton(((DatabaseWizard)this.getParent()).getEnableFinish() || bl);
            this.enableFinishButton(((DatabaseWizard)this.getParent()).getEnableFinish() || bl);
        }

        protected DatabaseDeviceSO getEditingDatabaseDevice(String string) {
            ServerBO serverBO = ContainerViewBO.getServerBO(DatabaseWizard.this._dbso.getConnection());
            DatabaseDeviceBO databaseDeviceBO = ContainerViewBO.getDatabaseDeviceBO(serverBO, string);
            return (DatabaseDeviceSO)databaseDeviceBO.getSO();
        }

        @Override
        public boolean deploy() {
            Vector<Vector> vector = new Vector<Vector>();
            Vector<Vector> vector2 = new Vector<Vector>();
            for (int i = 0; i < this._tableModel.getRowCount(); ++i) {
                Vector vector3 = this._tableModel.getRow(i);
                String string = (String)vector3.elementAt(2);
                if (string.equals(ASEUtils.getString("MSG_DATA"))) {
                    vector.addElement(vector3);
                    continue;
                }
                vector2.addElement(vector3);
            }
            ((DatabaseSO)this.getSO()).setDBDevice(vector);
            ((DatabaseSO)this.getSO()).setDBLog(vector2);
            return true;
        }

        @Override
        public int onWizardNext() {
            Vector<String> vector = new Vector<String>();
            for (int i = 0; i < this._tableModel.getRowCount(); ++i) {
                Vector vector2 = this._tableModel.getRow(i);
                String string = ((JLabel)vector2.elementAt(0)).getText();
                if (vector.contains(string)) {
                    DatabaseWizard.this._needEnableOverride = true;
                    break;
                }
                vector.add(string);
                DatabaseWizard.this._needEnableOverride = false;
            }
            return super.onWizardNext();
        }

        @Override
        public void releaseResources() {
            this._tableModel = null;
            this._tblDevices = null;
            this._tableVector = null;
            this.headings = null;
            this.rectContain = null;
            this.rectHeader = null;
            this._go.addButton.removeActionListener((ActionListener)this);
            this._go.removeButton.removeActionListener((ActionListener)this);
            this._go.editButton.removeActionListener((ActionListener)this);
            this._go.releaseResources();
            this._go = null;
            super.releaseResources();
        }
    }

    class DatabaseWizNamePage
    extends NameWizBOPage {
        public DatabaseWizNamePage(DatabaseWizard databaseWizard2) {
            super(databaseWizard2, ASEImages.getDatabaseWizardImage(), databaseWizard2.getTitle().equals(ASEUtils.getString("MSG_ADD_TEMP_DATABASE")) ? ASEUtils.getString("DATABASE_WIZ_SENT_WELCOME_TEMPDB") : (databaseWizard2.getTitle().equals(ASEUtils.getString("MSG_ADD_TEMP_DATABASE_SDC_LOCAL")) ? ASEUtils.getString("DATABASE_WIZ_SENT_WELCOME_TEMPDB_SDC_LOCAL") : ASEUtils.getString("DATABASE_WIZ_SENT_WELCOME")), "", ASEUtils.getString("DATABASE_WIZ_QUES_NAME"));
        }

        public DatabaseWizNamePage(DatabaseWizard databaseWizard2, String string) {
            super(databaseWizard2, ASEImages.getDatabaseWizardImage(), string, "", ASEUtils.getString("DATABASE_WIZ_QUES_NAME"));
        }

        @Override
        public void enableComponents() {
            this.enableNextButton(this.hasName());
            this.enableFinishButton(((DatabaseWizard)this.getParent()).getEnableFinish() && this.hasName());
        }
    }
}

