/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.aseplugin.bo.wiz;

import com.sybase.aseplugin.ASEImages;
import com.sybase.aseplugin.ASEMessageText;
import com.sybase.aseplugin.ASEUtils;
import com.sybase.aseplugin.bo.ASEBaseItem2;
import com.sybase.aseplugin.bo.DatabaseBO;
import com.sybase.aseplugin.bo.EncryptionKeyBO;
import com.sybase.aseplugin.bo.EncryptionKeysCtrBO;
import com.sybase.aseplugin.bo.Support;
import com.sybase.aseplugin.bo.dlg.EncryptionPasswordDialog;
import com.sybase.aseplugin.bo.wiz.ASEBaseWizardDialog2;
import com.sybase.aseplugin.bo.wiz.ASEBaseWizardPage2;
import com.sybase.aseplugin.bo.wiz.NameOwnerWizBOPage;
import com.sybase.aseplugin.bo.wiz.SummaryWizBOPage;
import com.sybase.aseplugin.go.wiz.EncryptionKeyWizGONameAndAlgPage;
import com.sybase.aseplugin.go.wiz.EncryptionKeyWizGOParametersPage;
import com.sybase.aseplugin.so.EncryptionKeySO;
import com.sybase.aseplugin.so.SOItemInterface;
import com.sybase.central.SCContainer2;
import com.sybase.central.SCPageController;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class EncryptionKeyWizard
extends ASEBaseWizardDialog2 {
    private EncryptionKeySO _ekSO;

    public EncryptionKeyWizard(EncryptionKeySO encryptionKeySO, EncryptionKeysCtrBO encryptionKeysCtrBO) {
        super((SOItemInterface)encryptionKeySO, (SCContainer2)encryptionKeysCtrBO, ASEUtils.getString("MSG_ADD_ENCRYPTION_KEY"));
        this._ekSO = encryptionKeySO;
    }

    @Override
    public SCPageController[] getPages() {
        return new SCPageController[]{new CreateEKPage(this), new NameAndAlgorithmPage(this), new ParameterPage(this), new SummaryEncryptionKeyPage(this)};
    }

    @Override
    public void releaseResources() {
        this._ekSO = null;
        super.releaseResources();
    }

    @Override
    public void refresh() {
        ((DatabaseBO)((EncryptionKeysCtrBO)this.getParent()).getParent()).getParent().refresh();
    }

    class SummaryEncryptionKeyPage
    extends SummaryWizBOPage {
        public SummaryEncryptionKeyPage(EncryptionKeyWizard encryptionKeyWizard2) {
            super(encryptionKeyWizard2, ASEImages.getForeignKeyWizardImage());
        }

        @Override
        public void enableComponents() {
            this.clearSummaryItems();
            this.addSummaryItem(ASEUtils.getString("LABC_NAME"), EncryptionKeyWizard.this._ekSO.getName());
            this.addSummaryItem(ASEUtils.getString("LABC_OWNER"), EncryptionKeyWizard.this._ekSO.getOwner());
            this.addSummaryItem(ASEUtils.getString("LABC_KEY_LENGTH"), EncryptionKeyWizard.this._ekSO.getKeyLength());
            this.addSummaryItem(ASEUtils.getString("MSG_AS_DEFAULT_ENCRYPTION_KEY"), EncryptionKeyWizard.this._ekSO.getDefault());
            this.addSummaryItem(ASEUtils.getString("LABC_INIT_VECTOR"), EncryptionKeyWizard.this._ekSO.getInitVector());
            this.addSummaryItem(ASEUtils.getString("LABC_PAD"), EncryptionKeyWizard.this._ekSO.getPad());
            this.setSummaryInfo(this.getSummary());
        }
    }

    class ParameterPage
    extends ASEBaseWizardPage2 {
        private EncryptionKeyWizGOParametersPage _go;

        public ParameterPage(EncryptionKeyWizard encryptionKeyWizard2) {
            super(encryptionKeyWizard2, (JPanel)((Object)new EncryptionKeyWizGOParametersPage()), ASEUtils.getString("MSG_ENCRYPTION_KEY_WIZ_PARAMETER_PAGE_TITLE"));
            this._go = (EncryptionKeyWizGOParametersPage)((Object)this.getJPanel());
            this._go.keyValueLabel.setVisible(false);
            this._go.keyValueTextField.setVisible(false);
            this._go.keyValueCheckBox.setVisible(false);
        }

        @Override
        public void enableComponents() {
            this.enableFinishButton(true);
        }

        @Override
        public boolean deploy() {
            if (this._go.initNull.isSelected()) {
                EncryptionKeyWizard.this._ekSO.setInitVector("null");
            } else {
                EncryptionKeyWizard.this._ekSO.setInitVector("random");
            }
            if (this._go.padNull.isSelected()) {
                EncryptionKeyWizard.this._ekSO.setPad("null");
            } else {
                EncryptionKeyWizard.this._ekSO.setPad("random");
            }
            return true;
        }

        @Override
        public void releaseResources() {
            this._go.releaseResources();
            this._go = null;
            super.releaseResources();
        }
    }

    class NameAndAlgorithmPage
    extends ASEBaseWizardPage2
    implements ActionListener,
    DocumentListener {
        private EncryptionKeyWizGONameAndAlgPage _go;
        int minPasswordLength;

        public NameAndAlgorithmPage(EncryptionKeyWizard encryptionKeyWizard2) {
            super(encryptionKeyWizard2, (JPanel)((Object)new EncryptionKeyWizGONameAndAlgPage(EncryptionKeyWizard.this._ekSO.getPhase(), EncryptionKeyWizard.this._ekSO.getDatabaseSO().getMinPasswordLength())), ASEUtils.getString("MSG_ENCRYPTION_KEY_WIZ_NAME_AND_ALG_PAGE_TITLE"));
            this.minPasswordLength = EncryptionKeyWizard.this._ekSO.getDatabaseSO().getMinPasswordLength();
            this._go = (EncryptionKeyWizGONameAndAlgPage)((Object)this.getJPanel());
        }

        @Override
        public void init() throws SQLException {
            float f = EncryptionKeyWizard.this._ekSO.getPhase();
            String string = this.getDefaultEK();
            EncryptionKeyWizard.this._ekSO.setOrigDefaultEK(string);
            if (f == 1.0f || f == 2.0f && EncryptionKeyWizard.this._ekSO.getConnection().hasSSORole() || f == 2.0f && EncryptionKeyWizard.this._ekSO.getConnection().hasKeyCustodianRole() && (string.length() == 0 || string.length() > 0 && string.substring(string.indexOf(".") + 1, string.lastIndexOf(".")).equals(EncryptionKeyWizard.this._ekSO.getCurrentUser()))) {
                if (string.length() > 0) {
                    ASEMessageText aSEMessageText = new ASEMessageText(ASEUtils.getString("LABC_ENCRYPTION_KEY_DEFAULT_EXISTED"), string);
                    this._go.defaultLabel.setText(aSEMessageText.toString());
                }
            } else {
                this._go.defaultLabel.setVisible(false);
                this._go.defaultCheckBox.setVisible(false);
            }
            if (f == 2.0f) {
                if (!EncryptionKeyWizard.this._ekSO.getDatabaseSO().systemDefaultHasSet()) {
                    this._go.systemEncryptionPasswordRadioButton.setEnabled(false);
                    this._go.createSystemEncryptionPasswordButton.setVisible(true);
                } else {
                    this._go.systemEncryptionPasswordRadioButton.setEnabled(true);
                    this._go.createSystemEncryptionPasswordButton.setVisible(false);
                }
                this._go.userDefinedPasswordRadioButton.addActionListener((ActionListener)this);
                this._go.systemEncryptionPasswordRadioButton.addActionListener((ActionListener)this);
                this._go.createSystemEncryptionPasswordButton.addActionListener((ActionListener)this);
                this._go.userDefinedPasswordField.getDocument().addDocumentListener(this);
                this._go.userDefinedConfirmPasswordField.getDocument().addDocumentListener(this);
            }
        }

        public String getDefaultEK() {
            EncryptionKeysCtrBO encryptionKeysCtrBO = (EncryptionKeysCtrBO)((EncryptionKeyWizard)this.getParent()).getParent();
            Enumeration enumeration = encryptionKeysCtrBO.getItems();
            while (enumeration.hasMoreElements()) {
                EncryptionKeyBO encryptionKeyBO;
                EncryptionKeySO encryptionKeySO;
                ASEBaseItem2 aSEBaseItem2 = (ASEBaseItem2)enumeration.nextElement();
                if (!(aSEBaseItem2 instanceof EncryptionKeyBO) || !(encryptionKeySO = (EncryptionKeySO)(encryptionKeyBO = (EncryptionKeyBO)aSEBaseItem2).getSO()).getDefaultStatus()) continue;
                return encryptionKeySO.getFullyQualifiedName();
            }
            return "";
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
            this.enableComponents();
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            this.enableComponents();
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            this.enableComponents();
        }

        @Override
        public void enableComponents() {
            if (EncryptionKeyWizard.this._ekSO.getPhase() == 2.0f) {
                if (this._go.userDefinedPasswordRadioButton.isSelected()) {
                    String string = new String(this._go.userDefinedPasswordField.getPassword()).trim();
                    String string2 = new String(this._go.userDefinedConfirmPasswordField.getPassword()).trim();
                    if (string.length() < this.minPasswordLength || string2.length() < this.minPasswordLength || !string.equals(string2)) {
                        this.enableFinishButton(false);
                        this.enableNextButton(false);
                    } else {
                        this.enableFinishButton(true);
                        this.enableNextButton(true);
                    }
                } else if (this._go.systemEncryptionPasswordRadioButton.isSelected()) {
                    this.enableFinishButton(true);
                    this.enableNextButton(true);
                }
            } else {
                this.enableFinishButton(true);
                this.enableNextButton(true);
            }
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == this._go.userDefinedPasswordRadioButton) {
                this._go.userDefinedPasswordLabel.setEnabled(true);
                this._go.userDefinedPasswordField.setEnabled(true);
                this._go.userDefinedConfirmLabel.setEnabled(true);
                this._go.userDefinedConfirmPasswordField.setEnabled(true);
            } else if (actionEvent.getSource() == this._go.systemEncryptionPasswordRadioButton) {
                this._go.userDefinedPasswordLabel.setEnabled(false);
                this._go.userDefinedPasswordField.setEnabled(false);
                this._go.userDefinedConfirmLabel.setEnabled(false);
                this._go.userDefinedConfirmPasswordField.setEnabled(false);
            } else if (actionEvent.getSource() == this._go.createSystemEncryptionPasswordButton) {
                EncryptionPasswordDialog encryptionPasswordDialog = new EncryptionPasswordDialog(Support.createDialogSupport(Support.getViewerFrame()), EncryptionKeyWizard.this._ekSO.getDatabaseSO(), EncryptionKeyWizard.this._ekSO.getDatabaseSO().getMinPasswordLength(), 0);
                encryptionPasswordDialog.start((EncryptionKeysCtrBO)((EncryptionKeyWizard)this.getParent()).getParent());
                try {
                    if (!EncryptionKeyWizard.this._ekSO.getDatabaseSO().systemDefaultHasSet()) {
                        this._go.systemEncryptionPasswordRadioButton.setEnabled(false);
                        this._go.createSystemEncryptionPasswordButton.setVisible(true);
                    } else {
                        this._go.systemEncryptionPasswordRadioButton.setEnabled(true);
                        this._go.createSystemEncryptionPasswordButton.setVisible(false);
                        this._go.systemEncryptionPasswordRadioButton.setSelected(true);
                        this._go.userDefinedPasswordLabel.setEnabled(false);
                        this._go.userDefinedPasswordField.setEnabled(false);
                        this._go.userDefinedConfirmLabel.setEnabled(false);
                        this._go.userDefinedConfirmPasswordField.setEnabled(false);
                    }
                }
                catch (SQLException sQLException) {
                    this._go.systemEncryptionPasswordRadioButton.setEnabled(false);
                    this._go.createSystemEncryptionPasswordButton.setVisible(true);
                }
            }
            this.enableComponents();
        }

        @Override
        public boolean deploy() {
            if (this._go.keyLength128.isSelected()) {
                EncryptionKeyWizard.this._ekSO.setKeyLength("128");
            } else if (this._go.keyLength192.isSelected()) {
                EncryptionKeyWizard.this._ekSO.setKeyLength("192");
            } else {
                EncryptionKeyWizard.this._ekSO.setKeyLength("256");
            }
            EncryptionKeyWizard.this._ekSO.setDefault(new Boolean(this._go.defaultCheckBox.isSelected()));
            if (EncryptionKeyWizard.this._ekSO.getPhase() == 2.0f) {
                if (this._go.userDefinedPasswordRadioButton.isSelected()) {
                    EncryptionKeySO encryptionKeySO = EncryptionKeyWizard.this._ekSO;
                    EncryptionKeyWizard.this._ekSO;
                    encryptionKeySO.setPasswordType(EncryptionKeySO.USER);
                    EncryptionKeyWizard.this._ekSO.setPassword(new String(this._go.userDefinedPasswordField.getPassword()).trim());
                } else {
                    EncryptionKeySO encryptionKeySO = EncryptionKeyWizard.this._ekSO;
                    EncryptionKeyWizard.this._ekSO;
                    encryptionKeySO.setPasswordType(EncryptionKeySO.SYSTEM);
                }
            } else {
                EncryptionKeySO encryptionKeySO = EncryptionKeyWizard.this._ekSO;
                EncryptionKeyWizard.this._ekSO;
                encryptionKeySO.setPasswordType(EncryptionKeySO.SYSTEM);
            }
            return true;
        }

        @Override
        public void releaseResources() {
            this._go.releaseResources();
            this._go = null;
            super.releaseResources();
        }
    }

    class CreateEKPage
    extends NameOwnerWizBOPage {
        public CreateEKPage(EncryptionKeyWizard encryptionKeyWizard2) {
            super(encryptionKeyWizard2, ASEImages.getForeignKeyWizardImage(), "", ASEUtils.getString("ENCRYPTION_KEY_WIZ_INTRO"), ASEUtils.getString("LABC_ENCRYPTION_KEY_NAME"), ASEUtils.getString("ENCRYPTION_KEY_WIZ_QUES_CREATOR"));
        }

        @Override
        public List<String[]> getOwnerList() throws SQLException {
            this.setDefaultOwner(EncryptionKeyWizard.this._ekSO.getDatabaseSO().getCurrentUser());
            return EncryptionKeyWizard.this._ekSO.getDatabaseSO().getOwnerList();
        }
    }
}

