/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.aseplugin.bo.wiz;

import com.sybase.aseplugin.ASEImages;
import com.sybase.aseplugin.ASEUtils;
import com.sybase.aseplugin.ProfileHelper;
import com.sybase.aseplugin.bo.ServerBO;
import com.sybase.aseplugin.bo.Support;
import com.sybase.aseplugin.bo.wiz.ASEBaseWizDocPage;
import com.sybase.aseplugin.bo.wiz.ASEBaseWizardDialog2;
import com.sybase.aseplugin.bo.wiz.SummaryWizBOPage;
import com.sybase.aseplugin.go.wiz.FixStatsWizGOIntroPage;
import com.sybase.aseplugin.go.wiz.FixStatsWizGOOptionsPage;
import com.sybase.aseplugin.go.wiz.QPTuneWizGOApplicationPage;
import com.sybase.aseplugin.so.DatabaseSO;
import com.sybase.aseplugin.so.DatabasesCtrSO;
import com.sybase.aseplugin.so.QPTuneSO;
import com.sybase.aseplugin.so.SOItemInterface;
import com.sybase.central.SCContainer2;
import com.sybase.central.SCPageController;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;

public class FixStatsWizard
extends ASEBaseWizardDialog2 {
    private QPTuneSO _qso;

    public FixStatsWizard(QPTuneSO qPTuneSO, int n, ServerBO serverBO) {
        super((SOItemInterface)qPTuneSO, (SCContainer2)serverBO);
        this._qso = qPTuneSO;
        this._qso.setFixingStats(n == 3090);
    }

    private boolean isFixingStats() {
        return this._qso.isFixingStats();
    }

    @Override
    public String getTitle() {
        return this.isFixingStats() ? ASEUtils.getString("CONTEXT_MENU_FIX_MISSING_STATS") : ASEUtils.getString("CONTEXT_MENU_UNDO_MISSING_STATS");
    }

    @Override
    public SCPageController[] getPages() {
        return new SCPageController[]{new FixStatsWizIntroPage(this), new FixStatsWizApplicationPage(this), new FixStatsWizOptionsPage(this), new FixStatsWizSummaryPage(this)};
    }

    @Override
    public boolean deploy() {
        try {
            ArrayList<String> arrayList = this._qso.fixStats(false, this.getJDialog());
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < arrayList.size(); ++i) {
                stringBuffer.append(arrayList.get(i) + "\n");
            }
            String string = Support.getFullTitle(ASEUtils.getString("QPTUNE_EDITOR_TITLE"), this.getConnection());
            String string2 = this.getConnection().getDisplayName() + " QPTune";
            Support.writeToExtendedLogFileEditor(string, ASEImages.getTuningTaskSmallImage(), stringBuffer.toString(), this.getConnection(), null, string2);
            return true;
        }
        catch (Exception exception) {
            Support.showDetailsError(this.getConnection(), this.getClass(), (Container)this.getJDialog(), exception.getMessage(), exception);
            return false;
        }
    }

    public class FixStatsWizSummaryPage
    extends SummaryWizBOPage {
        public FixStatsWizSummaryPage(FixStatsWizard fixStatsWizard2) {
            super(fixStatsWizard2, ASEImages.getDefaultWizardImage());
            this._go.setDisplayPreviewButton(false);
            this._go.setDisplayScheduleButton(false);
        }

        @Override
        public void enableComponents() {
            this.clearSummaryItems();
            String string = this.getParent().getTitle();
            if (FixStatsWizard.this._qso.getFixStatsNoExec()) {
                string = string + " (" + ASEUtils.getString("FIX_STATS_WIZ_CHKB_EXPORT_ONLY") + ")";
            }
            this.addSummaryItem(ASEUtils.getString("LABC_ACTION"), string + "\n");
            this.addSummaryItem(ASEUtils.getString("LABC_THRESHOLD"), FixStatsWizard.this._qso.getFixStatsThreshold() + "\n");
            try {
                ArrayList<String> arrayList = FixStatsWizard.this._qso.fixStats(true, this.getJDialog());
                for (int i = 0; i < arrayList.size(); ++i) {
                    this.addSummaryItem(ASEUtils.getString("LABC_COMMAND"), arrayList.get(i) + "\n");
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.setSummaryInfo(this.getSummary());
            this._go.summaryTextEditor.setLineWrap(true);
            this._go.summaryTextEditor.setWrapStyleWord(true);
        }
    }

    public class FixStatsWizOptionsPage
    extends ASEBaseWizDocPage
    implements ActionListener {
        private FixStatsWizGOOptionsPage _go;

        public FixStatsWizOptionsPage(FixStatsWizard fixStatsWizard2) {
            super(fixStatsWizard2, (JPanel)((Object)new FixStatsWizGOOptionsPage()), ASEUtils.getString("MSG_OPTIONS"));
            this._go = (FixStatsWizGOOptionsPage)((Object)this.getJPanel());
            this._go.setDisplayPreviewButton(false);
            this._go.setDisplayScheduleButton(false);
            this._go.noexecCheckBox.addActionListener((ActionListener)this);
            this._go.scriptFileEditor.addDocumentListener(this);
        }

        @Override
        public void init() {
            this._go.noexecCheckBox.setSelected(false);
            this._go.scriptFileEditor.setParentWindow(this.getJDialog());
        }

        @Override
        public void textValueChanged(DocumentEvent documentEvent) {
            this.enableComponents();
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.enableComponents();
        }

        @Override
        public boolean deploy() {
            FixStatsWizard.this._qso.setFixStatsThreshold(this._go.thresholdSpinBox.getValue());
            boolean bl = this._go.noexecCheckBox.isSelected();
            FixStatsWizard.this._qso.setFixStatsNoExec(bl);
            if (bl) {
                FixStatsWizard.this._qso.setFixStatsNoExecScriptFile(this._go.scriptFileEditor.getFileName());
            }
            return true;
        }

        @Override
        public void enableComponents() {
            boolean bl = this._go.noexecCheckBox.isSelected();
            this._go.scriptFileLabel.setEnabled(bl);
            this._go.scriptFileEditor.setEnabled(bl);
            if (bl) {
                this._go.scriptFileEditor.getTextField().requestFocus();
            }
            this._go.noexecMultiLineLabel.setVisible(FixStatsWizard.this.isFixingStats());
            this._go.noexecCheckBox.setVisible(FixStatsWizard.this.isFixingStats());
            this._go.scriptFileLabel.setVisible(FixStatsWizard.this.isFixingStats());
            this._go.scriptFileEditor.setVisible(FixStatsWizard.this.isFixingStats());
            boolean bl2 = this._go.noexecCheckBox.isSelected();
            String string = this._go.scriptFileEditor.getFileName();
            boolean bl3 = string.length() > 0;
            boolean bl4 = !bl2 || bl2 && bl3;
            this.enableNextButton(bl4);
            this.enableFinishButton(bl4);
        }
    }

    class FixStatsWizApplicationPage
    extends ASEBaseWizDocPage
    implements ActionListener {
        private QPTuneWizGOApplicationPage _go;

        public FixStatsWizApplicationPage(FixStatsWizard fixStatsWizard2) {
            super(fixStatsWizard2, (JPanel)((Object)new QPTuneWizGOApplicationPage(ASEImages.getDefaultWizardImage(), ASEUtils.getString("FIX_STATS_WIZ_SENT_RUNNING_APPS"))), ASEUtils.getString("MSG_APPLICATION"));
            this._go = (QPTuneWizGOApplicationPage)((Object)this.getJPanel());
            this._go.setDisplayPreviewButton(false);
            this._go.setDisplayScheduleButton(false);
            this._go.isqlButton.addActionListener((ActionListener)this);
            this._go.runButton.addActionListener((ActionListener)this);
            this._go.appEditor.addDocumentListener(this);
            this._go.scriptFileEditor.addDocumentListener(this);
            this._go.appCheckBox.addActionListener((ActionListener)this);
            this._go.scriptFileCheckBox.addActionListener((ActionListener)this);
        }

        @Override
        public boolean showPage() {
            return FixStatsWizard.this.isFixingStats() && !ASEUtils.isExistingFile(FixStatsWizard.this._qso.getFixStatsFile());
        }

        @Override
        public void init() {
            this._go.appEditor.setParentWindow(this.getJDialog());
            this._go.scriptFileEditor.setParentWindow(this.getJDialog());
            String string = FixStatsWizard.this._qso.getAppPath() != null ? FixStatsWizard.this._qso.getAppPath() : FixStatsWizard.this._qso.getLastAppPath();
            String string2 = FixStatsWizard.this._qso.getScriptPath() != null ? FixStatsWizard.this._qso.getScriptPath() : FixStatsWizard.this._qso.getLastScriptPath();
            this._go.appEditor.setFileName(string);
            this._go.scriptFileEditor.setFileName(string2);
        }

        @Override
        public void textValueChanged(DocumentEvent documentEvent) {
            this.enableComponents();
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == this._go.runButton) {
                try {
                    String string = this._go.appEditor.getFileName();
                    FixStatsWizard.this._qso.runApp(string, true);
                    ProfileHelper.setPreference("Setting.LastTuningApp", string);
                }
                catch (IOException iOException) {
                    Support.showDetailsError(this.getConnection(), this.getClass(), (Container)this.getJDialog(), iOException.getMessage(), iOException);
                }
            } else if (object == this._go.isqlButton) {
                String string = this._go.scriptFileEditor.getFileName();
                try {
                    String string2 = Support.readSQLFile(string);
                    Support.getProvider().openDBISQL(this.getJDialog(), this.getConnection(), FixStatsWizard.this._qso.getDBName(), string2, false);
                    ProfileHelper.setPreference("Setting.LastTuningScript", string);
                }
                catch (IOException iOException) {
                    Support.showDetailsError(this.getConnection(), this.getClass(), (Container)this.getJDialog(), iOException.getMessage(), iOException);
                }
            } else if (object == this._go.appCheckBox) {
                if (this._go.appCheckBox.isSelected()) {
                    this._go.appEditor.getTextField().requestFocus();
                }
                this.enableComponents();
            } else if (object == this._go.scriptFileCheckBox) {
                if (this._go.scriptFileCheckBox.isSelected()) {
                    this._go.scriptFileEditor.getTextField().requestFocus();
                }
                this.enableComponents();
            }
        }

        @Override
        public boolean deploy() {
            FixStatsWizard.this._qso.setAppPath(this._go.appEditor.getFileName());
            FixStatsWizard.this._qso.setScriptPath(this._go.scriptFileEditor.getFileName());
            FixStatsWizard.this._qso.setAppEnabled(this._go.appCheckBox.isSelected());
            FixStatsWizard.this._qso.setScriptEnabled(this._go.scriptFileCheckBox.isSelected());
            return true;
        }

        @Override
        public void enableComponents() {
            boolean bl = this._go.appCheckBox.isSelected();
            this._go.appEditor.setEnabled(bl);
            String string = this._go.appEditor.getFileName();
            boolean bl2 = ASEUtils.isExistingFile(string);
            this._go.runButton.setEnabled(bl2);
            boolean bl3 = this._go.scriptFileCheckBox.isSelected();
            this._go.scriptFileEditor.setEnabled(bl3);
            string = this._go.scriptFileEditor.getFileName();
            boolean bl4 = ASEUtils.isExistingFile(string);
            this._go.isqlButton.setEnabled(bl4);
            boolean bl5 = bl && !bl2 || bl3 && !bl4;
            this.enableNextButton(!bl5);
        }
    }

    class FixStatsWizIntroPage
    extends ASEBaseWizDocPage {
        private FixStatsWizGOIntroPage _go;

        public FixStatsWizIntroPage(FixStatsWizard fixStatsWizard2) {
            super(fixStatsWizard2, (JPanel)((Object)new FixStatsWizGOIntroPage()), ASEUtils.getString("WIZ_INTRO_PAGE_TITLE"));
            this._go = (FixStatsWizGOIntroPage)((Object)this.getJPanel());
            this._go.setDisplayPreviewButton(false);
            this._go.setDisplayScheduleButton(false);
            this._go.statsFileEditor.addDocumentListener(this);
        }

        @Override
        public void textValueChanged(DocumentEvent documentEvent) {
            this.enableComponents();
        }

        @Override
        public boolean deploy() {
            FixStatsWizard.this._qso.setFixStatsFile(this._go.statsFileEditor.getFileName());
            FixStatsWizard.this._qso.setDBName(this._go.databaseComboBox.getSelectedItem().toString());
            FixStatsWizard.this._qso.setVerbose(this._go.verboseCheckBox.isSelected());
            return true;
        }

        @Override
        public void enableComponents() {
            this._go.messagePanel.setVisible(false);
            if (!this.getSO().getConnection().hasSARole()) {
                this.showErrorMessage(ASEUtils.getString("MSG_NEED_SA_ROLE_TO_QPTUNE"));
                return;
            }
            if (!this.getSO().getConnection().hasSSORole()) {
                this.showErrorMessage(ASEUtils.getString("MSG_NEED_SSO_ROLE_TO_QPTUNE"));
                return;
            }
            String string = QPTuneSO.init();
            if (string != null) {
                this.showErrorMessage(string);
                return;
            }
            String string2 = this._go.statsFileEditor.getFileName();
            boolean bl = string2.length() > 0 && (FixStatsWizard.this.isFixingStats() || !FixStatsWizard.this.isFixingStats() && ASEUtils.isExistingFile(string2));
            this.enableNextButton(bl);
        }

        @Override
        public void init() throws SQLException {
            this._go.statsFileEditor.setParentWindow(this.getJDialog());
            this._go.selectedActionLabel.setText(this.getParent().getTitle());
            this._go.missingStatsFileLabel.setText(FixStatsWizard.this.isFixingStats() ? ASEUtils.getString("FIX_STATS_WIZ_SENT_MISSING_STATS_FILE1") : ASEUtils.getString("FIX_STATS_WIZ_SENT_MISSING_STATS_FILE2"));
            if (FixStatsWizard.this.isFixingStats()) {
                this._go.statsFileEditor.setCheckExist(1);
                this._go.statsFileEditor.setAdditionalNote(ASEUtils.getString("FIX_STATS_WIZ_SENT_COLLECTION_SKIPPED"));
            } else {
                this._go.statsFileEditor.setCheckExist(0);
            }
            this.initDatabases();
        }

        private void initDatabases() throws SQLException {
            DatabasesCtrSO databasesCtrSO = new DatabasesCtrSO(this.getConnection());
            List<DatabaseSO> list = databasesCtrSO.getNormalDBList(1);
            Support.initDatabaseDropdown(list, this._go.databaseComboBox, true);
        }

        private void showErrorMessage(String string) {
            this._go.messagePanel.setVisible(true);
            this._go.messageMultiLineLabel.setText(string);
            this._go.welcomeMultiLineLabel.setEnabled(false);
            this._go.actionLabel.setEnabled(false);
            this._go.selectedActionLabel.setEnabled(false);
            this._go.missingStatsFileLabel.setEnabled(false);
            this._go.statsFileEditor.setEnabled(false);
            this._go.statsFileLabel.setEnabled(false);
            this._go.databaseLabel.setEnabled(false);
            this._go.databaseComboBox.setEnabled(false);
            this._go.verboseCheckBox.setEnabled(false);
            this.enableFinishButton(false);
            this.enableNextButton(false);
        }

        @Override
        public void releaseResources() {
            this._go.statsFileEditor.removeDocumentListener(this);
            this._go.releaseResources();
            this._go = null;
            super.releaseResources();
        }
    }
}

