/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.aseplugin.bo.wiz;

import com.sybase.aseplugin.ASEImages;
import com.sybase.aseplugin.ASEMessageText;
import com.sybase.aseplugin.ASEUtils;
import com.sybase.aseplugin.bo.ASEBaseCodeContainer;
import com.sybase.aseplugin.bo.ASEBaseContainer2;
import com.sybase.aseplugin.bo.ASEProvider;
import com.sybase.aseplugin.bo.FunctionBO;
import com.sybase.aseplugin.bo.FunctionsCtrBO;
import com.sybase.aseplugin.bo.Support;
import com.sybase.aseplugin.bo.TableFunctionBO;
import com.sybase.aseplugin.bo.wiz.ASEBaseWizardDialog2;
import com.sybase.aseplugin.bo.wiz.ASEBaseWizardPage2;
import com.sybase.aseplugin.bo.wiz.FuncWizReturnTypePage;
import com.sybase.aseplugin.bo.wiz.NameOwnerTemplateWizPage;
import com.sybase.aseplugin.bo.wiz.SummaryWizBOPage;
import com.sybase.aseplugin.go.wiz.StoredProcedureWizGORecompilePage;
import com.sybase.aseplugin.go.wiz.WizEditorGOPage;
import com.sybase.aseplugin.so.FunctionSO;
import com.sybase.aseplugin.so.SOItemInterface;
import com.sybase.aseplugin.so.TableFunctionSO;
import com.sybase.aseplugin.sql.ASConnection;
import com.sybase.central.SCContainer2;
import com.sybase.central.SCPageController;
import com.sybase.central.editor.EditorEvent;
import com.sybase.central.editor.EditorListener;
import com.sybase.central.editor.SCEditorFrame;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JPanel;

public class FunctionWizard
extends ASEBaseWizardDialog2 {
    public boolean _eventAlt;
    private FunctionWizNamePage _namePage;
    private FunctionSO _fso;

    public FunctionWizard(FunctionSO functionSO, FunctionsCtrBO functionsCtrBO) {
        super((SOItemInterface)functionSO, (SCContainer2)functionsCtrBO, functionSO.getType().equals("SF") ? ASEUtils.getString("MSG_ADD_SCALAR_FUNCTION") : ASEUtils.getString("MSG_ADD_TABLE_FUNCTION"));
        this._fso = functionSO;
    }

    private boolean isScalarFunction() {
        return this._fso.getType().equals("SF");
    }

    @Override
    public SCPageController[] getPages() {
        ArrayList<ASEBaseWizardPage2> arrayList = new ArrayList<ASEBaseWizardPage2>();
        this._namePage = new FunctionWizNamePage(this);
        arrayList.add(this._namePage);
        if (this.isScalarFunction()) {
            arrayList.add(new FunctionWizReturnTypePage(this));
        }
        arrayList.add(new FunctionWizRecompilePage(this));
        arrayList.add(new FunctionWizSQLPage(this));
        arrayList.add(new FunctionWizSummaryPage(this));
        return arrayList.toArray(new SCPageController[arrayList.size()]);
    }

    public boolean getEventAlt() {
        return this._eventAlt;
    }

    public void setEventAlt(boolean bl) {
        this._eventAlt = bl;
    }

    @Override
    public boolean deploy() {
        if (this._namePage.usingTemplate()) {
            this._fso.setSQLText(this._fso.getTemplateText());
            ASEBaseCodeContainer aSEBaseCodeContainer = this.isScalarFunction() ? new FunctionBO(this._fso, (FunctionsCtrBO)this.getParent()) : new TableFunctionBO((TableFunctionSO)this._fso, (ASEBaseContainer2)this.getParent());
            aSEBaseCodeContainer.openEditor(false);
            return true;
        }
        return super.deploy();
    }

    @Override
    public void releaseResources() {
        this._namePage = null;
        this._fso = null;
        super.releaseResources();
    }

    class FunctionWizSummaryPage
    extends SummaryWizBOPage {
        public FunctionWizSummaryPage(FunctionWizard functionWizard2) {
            super(functionWizard2, ASEImages.getEspWizardImage());
        }

        @Override
        public void enableComponents() {
            this.clearSummaryItems();
            this.addSummaryItem(ASEUtils.getString("DISP_NAME_TEXT"), FunctionWizard.this._fso.getName());
            this.addSummaryItem(ASEUtils.getString("DISP_RETURN_TYPE"), FunctionWizard.this._fso.getReturnType());
            this.addSummaryItem();
            this.addSummaryItem(ASEUtils.getString("LOG_SQL_EDIT_TITLE"), "\n" + FunctionWizard.this._fso.getSQLText());
            this.setSummaryInfo(this.getSummary());
        }
    }

    class FunctionWizSQLPage
    extends ASEBaseWizardPage2
    implements ActionListener,
    EditorListener {
        private WizEditorGOPage _go;
        FunctionBO _bo;

        public FunctionWizSQLPage(FunctionWizard functionWizard2) {
            super(functionWizard2, (JPanel)((Object)new WizEditorGOPage(ASEImages.getEspWizardImage())), ASEUtils.getString("MSG_EDITOR_WIZ_PAGE"));
            this._go = (WizEditorGOPage)((Object)this.getJPanel());
            FunctionWizard.this._fso = (FunctionSO)this.getSO();
            this._bo = new FunctionBO(FunctionWizard.this._fso, (FunctionsCtrBO)this.getParent().getParent());
            this._bo.setMenuToolTipText(ASEUtils.getString("EDIT_MENU_SAVE_SQL"), Support.getMnemonic("EDIT_MNEM_SAVE_SQL"), ASEUtils.getString("EDIT_TTIP_SAVE_SQL"), FunctionSO.TMPL_DEFAULT_NAME);
            this._go.sqlEditorButton.addActionListener((ActionListener)this);
            this._go.loadButton.addActionListener((ActionListener)this);
        }

        @Override
        public void enableComponents() {
            ASEMessageText aSEMessageText = new ASEMessageText(ASEUtils.getString("LABC_PROVIDE_SQL"), FunctionWizard.this._fso.getName());
            this._go.introLabel.setText(aSEMessageText.toString());
            this.setWizardText();
            this.enableNextButton(true);
            this.enableFinishButton(true);
        }

        private void setWizardText() {
            if (FunctionWizard.this.getEventAlt()) {
                this._go.sqlEditor.setText(this.getWizardText());
                FunctionWizard.this.setEventAlt(false);
            } else {
                this._go.sqlEditor.setText(FunctionWizard.this._fso.getSQLText());
            }
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == this._go.sqlEditorButton) {
                FunctionWizard.this._fso.setSQLText(this._go.sqlEditor.getText());
                if (this._bo.getEditor() == null) {
                    this.setComponentsEnabled(false);
                    this._bo.openEditor(false);
                    this._bo.getEditor().addEditorListener((EditorListener)this);
                } else {
                    this.setComponentsEnabled(true);
                    ((SCEditorFrame)this._bo.getEditor()).exitActionPerformed();
                }
            } else {
                try {
                    int n = 2;
                    String string = Support.browseForFile(Support.getViewerFrame(), ASEProvider.getSybaseOrSybrootDir(), null, n);
                    if (string != null) {
                        this._go.sqlEditor.setText(Support.readSQLFile(string));
                    }
                }
                catch (IOException iOException) {
                    Support.showDetailsError(this.getConnection(), this.getClass(), (Container)this.getJDialog(), iOException.getMessage(), iOException);
                }
            }
        }

        private String getWizardText() {
            String string = this._go.sqlEditor.getText();
            Pattern pattern = Pattern.compile("[/\\s]+[aA][sS][/\\s]+");
            Matcher matcher = pattern.matcher(string);
            string = matcher.find() ? (string.charAt(matcher.end() - 1) == '/' ? "/" : "") + string.substring(matcher.end()) : "begin\n\nend";
            String string2 = "create function " + FunctionWizard.this._fso.getTemplateOwnerDotName() + "( )\n";
            string2 = FunctionWizard.this.isScalarFunction() ? string2 + "returns " + FunctionWizard.this._fso.getReturnType() + "\n" : string2 + "returns table\n";
            if (FunctionWizard.this._fso.getRecompile()) {
                string2 = string2 + "with recompile\n";
            }
            string2 = string2 + "as\n";
            string2 = string2 + string;
            return string2;
        }

        public void editorClosed(EditorEvent editorEvent) {
            this.setComponentsEnabled(true);
            this._bo.editorClosed(editorEvent);
        }

        public void editorSaveRequested(EditorEvent editorEvent) {
            this._go.sqlEditor.setText(editorEvent.getEditor().getText());
            this.setComponentsEnabled(true);
            this._bo.setSaveObject(false);
        }

        @Override
        public boolean deploy() {
            FunctionWizard.this._fso.setSQLText(this._go.sqlEditor.getText());
            return true;
        }

        @Override
        public void releaseResources() {
            if (this._bo.getEditor() != null) {
                ((SCEditorFrame)this._bo.getEditor()).setChanged(false);
                ((SCEditorFrame)this._bo.getEditor()).exitActionPerformed();
            }
            this._go.sqlEditorButton.removeActionListener((ActionListener)this);
            this._go.loadButton.removeActionListener((ActionListener)this);
            this._go.releaseResources();
            this._go = null;
            super.releaseResources();
        }

        private void setComponentsEnabled(boolean bl) {
            if (bl) {
                this._go.sqlEditorButton.setText(ASEUtils.getString("BTTN_SQL_EDITOR"));
                this._go.sqlEditorButton.setMnemonic(ASEUtils.getMnemonic("MNEM_SQL_EDITOR"));
            } else {
                this._go.sqlEditorButton.setText(ASEUtils.getString("BTTN_CLOSE_SQL_EDITOR"));
                this._go.sqlEditorButton.setMnemonic(ASEUtils.getMnemonic("MNEM_CLOSE_SQL_EDITOR"));
            }
            this._go.sqlEditor.setEnabled(bl);
            this._go.loadButton.setEnabled(bl);
            this._go.setEnabledPreviewButton(bl);
            this._go.setEnabledScheduleButton(bl);
            this.enableBackButton(bl);
            this.enableNextButton(bl);
            this.enableFinishButton(bl);
        }
    }

    class FunctionWizRecompilePage
    extends ASEBaseWizardPage2 {
        private StoredProcedureWizGORecompilePage _go;

        public FunctionWizRecompilePage(FunctionWizard functionWizard2) {
            super(functionWizard2, (JPanel)((Object)new StoredProcedureWizGORecompilePage(false)), ASEUtils.getString("MSG_PROCEDURE_WIZ_PAGE2"));
            this._go = (StoredProcedureWizGORecompilePage)((Object)this.getJPanel());
        }

        @Override
        public boolean deploy() {
            FunctionWizard.this._fso.setRecompile(this._go.recompileCheckBox.isSelected());
            FunctionWizard.this.setEventAlt(true);
            return true;
        }

        @Override
        public void releaseResources() {
            this._go.releaseResources();
            this._go = null;
            super.releaseResources();
        }
    }

    class FunctionWizReturnTypePage
    extends FuncWizReturnTypePage {
        public FunctionWizReturnTypePage(FunctionWizard functionWizard2) {
            super(functionWizard2);
        }

        @Override
        protected String getDatabaseName() {
            return FunctionWizard.this._fso.getDatabaseName();
        }

        @Override
        protected void setComboBoxContext() {
            try {
                ASConnection aSConnection = FunctionWizard.this._fso.getConnection();
                this._baseTypes = aSConnection.getDomainDatatypes();
                Vector vector = this._baseTypes.getAllDomainTypes(this.getDatabaseName());
                for (int i = 0; i < vector.size(); ++i) {
                    Object e = vector.elementAt(i);
                    if (e.equals("timestamp") || e.equals("image") || e.equals("text") || e.equals("unitext")) continue;
                    this._go.dataTypeComboBox.addItem(e);
                }
            }
            catch (SQLException sQLException) {
                Support.showDetailsError(this.getConnection(), this.getClass(), (Container)this.getJDialog(), sQLException.getMessage(), sQLException);
            }
        }

        @Override
        public boolean deploy() {
            FunctionWizard.this._fso.setReturnType(this.getReturnValue());
            FunctionWizard.this.setEventAlt(true);
            return true;
        }
    }

    class FunctionWizNamePage
    extends NameOwnerTemplateWizPage {
        public FunctionWizNamePage(FunctionWizard functionWizard2) {
            super(functionWizard2, ASEImages.getEspWizardImage(), FunctionWizard.this.isScalarFunction() ? ASEUtils.getString("FUNCTION_WIZ_SENT_WELCOME_SCALAR_FUNC") : ASEUtils.getString("FUNCTION_WIZ_SENT_WELCOME_TABLE_FUNC"), ASEUtils.getString("FUNCTION_WIZ_SENT_INTRO"), ASEUtils.getString("FUNCTION_WIZ_SENT_NAME"), ASEUtils.getString("FUNCTION_WIZ_SENT_OWNER"), FunctionWizard.this._fso);
        }

        @Override
        public List<String[]> getOwnerList() throws SQLException {
            this.setDefaultOwner(FunctionWizard.this._fso.getDatabaseSO().getCurrentUser());
            return FunctionWizard.this._fso.getOwnerList();
        }
    }
}

