/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.aseplugin.bo.wiz;

import com.sybase.aseplugin.ASEUtils;
import com.sybase.aseplugin.bo.IMDatabaseDevicesCtrBO;
import com.sybase.aseplugin.bo.Support;
import com.sybase.aseplugin.bo.dlg.AddCacheToIMDBDeviceDialog;
import com.sybase.aseplugin.bo.dlg.EditCacheOfIMDBDeviceDialog;
import com.sybase.aseplugin.bo.wiz.ASEBaseWizardPage2;
import com.sybase.aseplugin.bo.wiz.DatabaseDeviceWizard;
import com.sybase.aseplugin.go.ASETable;
import com.sybase.aseplugin.go.wiz.DatabaseDeviceWizGONamePage;
import com.sybase.aseplugin.go.wiz.DatabaseWizGOPage2;
import com.sybase.aseplugin.so.CacheSO;
import com.sybase.aseplugin.so.CachesCtrSO;
import com.sybase.aseplugin.so.DatabaseDeviceSO;
import com.sybase.aseplugin.util.ui.JLabelTableModel;
import com.sybase.aseplugin.util.ui.MyCellRenderer;
import com.sybase.aseplugin.util.ui.TableSelectionListener;
import com.sybase.central.SCPageController;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.text.JTextComponent;

public class IMDatabaseDeviceWizard
extends DatabaseDeviceWizard {
    public IMDatabaseDeviceWizard(DatabaseDeviceSO databaseDeviceSO, IMDatabaseDevicesCtrBO iMDatabaseDevicesCtrBO, String string) {
        this(databaseDeviceSO, iMDatabaseDevicesCtrBO, string, false);
    }

    public IMDatabaseDeviceWizard(DatabaseDeviceSO databaseDeviceSO, IMDatabaseDevicesCtrBO iMDatabaseDevicesCtrBO, String string, boolean bl) {
        super(databaseDeviceSO, iMDatabaseDevicesCtrBO, string, bl);
        this._dso.setDatabaseDeviceType(2);
    }

    @Override
    public SCPageController[] getPages() {
        IMDatabaseDeviceWizNamePage iMDatabaseDeviceWizNamePage = new IMDatabaseDeviceWizNamePage(this);
        IMDatabaseDeviceCachePage iMDatabaseDeviceCachePage = new IMDatabaseDeviceCachePage(this);
        IMDatabaseDeviceWizSummaryPage iMDatabaseDeviceWizSummaryPage = new IMDatabaseDeviceWizSummaryPage(this);
        return new SCPageController[]{iMDatabaseDeviceWizNamePage, iMDatabaseDeviceCachePage, iMDatabaseDeviceWizSummaryPage};
    }

    @Override
    public void releaseResources() {
        this._dso = null;
        super.releaseResources();
    }

    class IMDatabaseDeviceWizSummaryPage
    extends DatabaseDeviceWizard.DatabaseDeviceWizSummaryPage {
        public IMDatabaseDeviceWizSummaryPage(IMDatabaseDeviceWizard iMDatabaseDeviceWizard2) {
            super(iMDatabaseDeviceWizard2);
        }

        @Override
        public void enableComponents() {
            this.clearSummaryItems();
            this.addSummaryItem(ASEUtils.getString("DISP_NAME_TEXT"), IMDatabaseDeviceWizard.this._dso.getDatabaseDeviceName());
            this.addSummaryItem(ASEUtils.getString("IM_DATABASE_DEVICES_WIZ_SUMMARY_PHYSNAME"), IMDatabaseDeviceWizard.this._dso.getDatabaseDevicePhysicalName());
            this.addSummaryItem(ASEUtils.getString("MSG_SIZE"), IMDatabaseDeviceWizard.this._dso.getDatabaseDeviceSize());
            this.setSummaryInfo(this.getSummary());
        }
    }

    class IMDatabaseDeviceCachePage
    extends ASEBaseWizardPage2
    implements ActionListener {
        JLabelTableModel _tableModel;
        JTable _tblCaches;
        Vector _tableVector;
        Vector headings;
        Dimension rectContain;
        Dimension rectHeader;
        protected DatabaseWizGOPage2 _go;
        protected Map _initCacheSizeMap;

        public IMDatabaseDeviceCachePage(IMDatabaseDeviceWizard iMDatabaseDeviceWizard2) {
            super(iMDatabaseDeviceWizard2, (JPanel)((Object)new DatabaseWizGOPage2()), ASEUtils.getString("IM_DATABASE_DEVICES_WIZ_CACHE_TITLE"));
            this._initCacheSizeMap = new HashMap();
            this.initGO();
        }

        protected void initGO() {
            this._go = (DatabaseWizGOPage2)((Object)this.getJPanel());
            this._go.introTextMultiLineLabel.setText(ASEUtils.getString("IM_DATABASE_DEVICES_WIZ_CACHE_INTRO"));
            this._tblCaches = new ASETable();
            this._go.scroll.getViewport().add(this._tblCaches);
            this.headings = new Vector();
            this.headings.addElement(ASEUtils.getString("DISP_NAME_TEXT"));
            this.headings.addElement(ASEUtils.getString("DISP_SIZE_MB_TEXT"));
            this._tableVector = new Vector();
            this._tableModel = new JLabelTableModel(this.headings, this._tableVector);
            this._tblCaches.setModel(this._tableModel);
            this._go.removeButton.addActionListener((ActionListener)this);
            this._go.editButton.addActionListener((ActionListener)this);
            this._go.addButton.addActionListener((ActionListener)this);
            this._go.addButton.setEnabled(true);
            this._go.removeButton.setEnabled(false);
            this._go.editButton.setEnabled(false);
        }

        @Override
        public void enableComponents() {
            this.enableNextButton(this._tblCaches.getRowCount() > 0);
            this.enableFinishButton(this._tblCaches.getRowCount() > 0);
            this._go.addButton.setEnabled(this._tblCaches.getRowCount() == 0);
        }

        @Override
        public void init() throws SQLException {
            this.rectContain = this._tblCaches.getSize();
            this.rectHeader = this._tblCaches.getTableHeader().getSize();
            this._tblCaches.setSelectionMode(0);
            TableSelectionListener tableSelectionListener = new TableSelectionListener(){

                @Override
                public void deSelectAction() {
                    IMDatabaseDeviceCachePage.this._go.removeButton.setEnabled(false);
                    IMDatabaseDeviceCachePage.this._go.editButton.setEnabled(false);
                }

                @Override
                public void selectAction() {
                    IMDatabaseDeviceCachePage.this._go.removeButton.setEnabled(true);
                    IMDatabaseDeviceCachePage.this._go.editButton.setEnabled(true);
                }
            };
            this._tblCaches.getSelectionModel().addListSelectionListener(tableSelectionListener);
            this._tblCaches.setDefaultRenderer(new JLabel().getClass(), new MyCellRenderer());
            this._tblCaches.setSize(this.rectContain);
            this._tblCaches.getTableHeader().setSize(this.rectHeader);
            for (int i = 0; i < this._tblCaches.getRowCount(); ++i) {
                String string = (String)this._tblCaches.getValueAt(i, 0);
                String string2 = this._tblCaches.getValueAt(i, 1).toString();
                this._initCacheSizeMap.put(string, string2);
            }
        }

        public Vector<CacheSO> getIMCacheList() throws SQLException {
            Vector<CacheSO> vector = new Vector<CacheSO>();
            CachesCtrSO cachesCtrSO = new CachesCtrSO(IMDatabaseDeviceWizard.this._dso.getConnection());
            cachesCtrSO.setCacheScope(CacheSO.IM_CACHE_SCOPE_SMP);
            vector.addAll(cachesCtrSO.open(1));
            return vector;
        }

        protected void doAddCache(Vector<CacheSO> vector) {
            new AddCacheToIMDBDeviceDialog(Support.createDialogSupport(this.getJDialog()), IMDatabaseDeviceWizard.this._dso, vector, this._tableModel, this._tblCaches, false, this._initCacheSizeMap, ((DatabaseDeviceWizard)this.getParent())._ignoreDevList);
        }

        protected void doEditCache() {
            int[] nArray = this._tblCaches.getSelectedRows();
            for (int i = 0; i < nArray.length; ++i) {
                long l = ((Double)this._tableModel.getValueAt(nArray[i], 1)).longValue();
                String string = ((JLabel)this._tableModel.getValueAt(nArray[i], 0)).getText();
                String string2 = (String)this._initCacheSizeMap.get(string);
                CacheSO cacheSO = this.getEditingCacheSO(string);
                if (null == cacheSO) continue;
                new EditCacheOfIMDBDeviceDialog(Support.createDialogSupport(this.getJDialog()), string, cacheSO.getConfiguredSize(), cacheSO.getUnUsedSize(), l, this._tableModel, this._tblCaches, nArray[i], true, string2);
            }
        }

        protected void doRemoveDevice() {
            int[] nArray = this._tblCaches.getSelectedRows();
            for (int i = 0; i < nArray.length; ++i) {
                this._tableModel.removeRow(nArray[i]);
            }
            this._tblCaches.tableChanged(new TableModelEvent(this._tableModel));
            this._go.removeButton.setEnabled(false);
            this._go.editButton.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Vector vector = null;
            try {
                vector = (Vector)this.getIMCacheList().clone();
            }
            catch (SQLException sQLException) {
                Support.showDetailsError(this.getConnection(), this.getClass(), (Container)this.getJDialog(), sQLException.toString(), sQLException);
            }
            if (actionEvent.getSource() == this._go.addButton) {
                this.doAddCache(vector);
            } else if (actionEvent.getSource() == this._go.removeButton) {
                this.doRemoveDevice();
            } else if (actionEvent.getSource() == this._go.editButton) {
                this.doEditCache();
            }
            this.enableComponents();
        }

        private CacheSO getEditingCacheSO(String string) {
            CachesCtrSO cachesCtrSO = new CachesCtrSO(this.getConnection());
            Object[] objectArray = new Object[]{string};
            cachesCtrSO.setCacheScope(CacheSO.IM_CACHE_SCOPE_SMP);
            try {
                List list = null;
                list = cachesCtrSO.open(1, objectArray);
                return list.isEmpty() ? null : (CacheSO)list.get(0);
            }
            catch (SQLException sQLException) {
                Support.showDetailsError(this.getConnection(), this.getClass(), (Container)this.getJDialog(), sQLException.toString(), sQLException);
                return null;
            }
        }

        @Override
        public boolean deploy() {
            Vector vector = this._tableModel.getRow(0);
            String string = ((JLabel)vector.elementAt(0)).getText();
            String string2 = new Integer(((Double)vector.elementAt(1)).intValue()).toString() + "M";
            IMDatabaseDeviceWizard.this._dso.setDatabaseDevicePhysicalName(string);
            IMDatabaseDeviceWizard.this._dso.setDatabaseDeviceSize(string2);
            return true;
        }

        @Override
        public void releaseResources() {
            this._tableModel = null;
            this._tblCaches = null;
            this._tableVector = null;
            this.headings = null;
            this.rectContain = null;
            this.rectHeader = null;
            this._go.addButton.removeActionListener((ActionListener)this);
            this._go.removeButton.removeActionListener((ActionListener)this);
            this._go.editButton.removeActionListener((ActionListener)this);
            this._go.releaseResources();
            this._go = null;
            super.releaseResources();
        }
    }

    class IMDatabaseDeviceWizNamePage
    extends DatabaseDeviceWizard.DatabaseDeviceWizNamePage {
        public IMDatabaseDeviceWizNamePage(IMDatabaseDeviceWizard iMDatabaseDeviceWizard2) {
            super(iMDatabaseDeviceWizard2, (JPanel)((Object)new DatabaseDeviceWizGONamePage()), ASEUtils.getString("IM_DATABASE_DEVICES_WIZ_NAME_TITLE"));
            this._go = (DatabaseDeviceWizGONamePage)((Object)this.getJPanel());
            this._go.welcomeMultiLineLabel.setText(ASEUtils.getString("IM_DATABASE_DEVICE_WIZ_WELCOME"));
            this._go.introMultiLineLabel.setText(ASEUtils.getString("IM_DATABASE_DEVICE_WIZ_INTRO"));
            this._go.noteVCSLabel.setVisible(false);
            this.setDevicePathVisible(false);
        }

        private void setDevicePathVisible(boolean bl) {
            this._go.physicalNameMultiLineLabel.setVisible(bl);
            this._go.deviceFileNameLabel.setVisible(bl);
            this._go.deviceFileNameEditor.setVisible(bl);
        }

        @Override
        public int onWizardNext() {
            String string = this.getDeviceName();
            try {
                this._so.setName(string);
                boolean bl = Support.verifyObjectName(this._so, this.getJDialog(), (JTextComponent)((Object)this._go.nameTextField));
                if (!bl) {
                    return -1;
                }
                IMDatabaseDeviceWizard.this._dso.setDatabaseDeviceName(string);
                return 0;
            }
            catch (SQLException sQLException) {
                Support.showDetailsError(this.getConnection(), this.getClass(), (Container)this.getJDialog(), sQLException.getMessage(), sQLException);
                return -1;
            }
        }

        @Override
        public void releaseResources() {
            this._go.releaseResources();
            this._go = null;
            super.releaseResources();
        }
    }
}

