/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.aseplugin.bo.wiz;

import com.sybase.aseplugin.ASEUtils;
import com.sybase.aseplugin.bo.ContainerViewBO;
import com.sybase.aseplugin.bo.DBsCtrBO;
import com.sybase.aseplugin.bo.IMDatabaseDevicesCtrBO;
import com.sybase.aseplugin.bo.IMDatabasesCtrBO;
import com.sybase.aseplugin.bo.IMTempDBsListCtrBO;
import com.sybase.aseplugin.bo.ServerBO;
import com.sybase.aseplugin.bo.Support;
import com.sybase.aseplugin.bo.wiz.ASEBaseWizDocPage;
import com.sybase.aseplugin.bo.wiz.ASEBaseWizardPage2;
import com.sybase.aseplugin.bo.wiz.DatabaseWizard;
import com.sybase.aseplugin.so.CachesCtrSO;
import com.sybase.aseplugin.so.DatabaseDeviceSO;
import com.sybase.aseplugin.so.DatabaseDevicesCtrSO;
import com.sybase.aseplugin.so.DatabaseSO;
import com.sybase.central.SCPageController;
import java.awt.Container;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import java.util.List;
import java.util.Vector;
import javax.swing.JLabel;

public class IMDatabaseWizard
extends DatabaseWizard {
    public IMDatabaseWizard(DatabaseSO databaseSO, IMDatabasesCtrBO iMDatabasesCtrBO) {
        super(databaseSO, iMDatabasesCtrBO, ASEUtils.getString("MSG_ADD_IM_DATABASE"));
        databaseSO.setDBType(12);
        databaseSO.setDurability("NO_RECOVERY");
    }

    public IMDatabaseWizard(DatabaseSO databaseSO, IMTempDBsListCtrBO iMTempDBsListCtrBO) {
        super(databaseSO, iMTempDBsListCtrBO, ASEUtils.getString("MSG_ADD_TEMP_IM_DATABASE"));
        databaseSO.setDBType(13);
        databaseSO.setDurability("NO_RECOVERY");
    }

    private ASEBaseWizDocPage getWizNamePage() {
        IMDatabaseWizNamePage iMDatabaseWizNamePage = new IMDatabaseWizNamePage((DatabaseWizard)this);
        if (((DatabaseSO)this.getSO()).isTempInMemoryDB()) {
            iMDatabaseWizNamePage._go.welcomeTextMultiLineLabel.setText(ASEUtils.getString("TEMP_IM_DATABASE_WIZ_SENT_WELCOME"));
        }
        return iMDatabaseWizNamePage;
    }

    @Override
    public SCPageController[] getPages() {
        Vector<ASEBaseWizardPage2> vector = new Vector<ASEBaseWizardPage2>();
        vector.add(this.getWizNamePage());
        vector.add(new IMDatabaseWizDevicePage((DatabaseWizard)this));
        vector.add(new IMDatabaseWizOptionsPage((DatabaseWizard)this));
        int n = ((DBsCtrBO)this.getParent()).getDatabaseCtrType();
        try {
            if (n == 13 && ((DatabaseSO)this.getSO()).isTempDBGroupApplicable()) {
                vector.add(new DatabaseWizard.DatabaseWizTempDBPage(this));
            } else {
                vector.add(new DatabaseWizard.DatabaseWizUserPage(this));
            }
        }
        catch (SQLException sQLException) {
            Support.showDetailsError(this.getConnection(), this.getClass(), (Container)this.getJDialog(), sQLException.toString(), sQLException);
        }
        vector.add(new DatabaseWizard.DatabaseWizSummaryPage(this));
        SCPageController[] sCPageControllerArray = new SCPageController[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            sCPageControllerArray[i] = (SCPageController)vector.elementAt(i);
        }
        return sCPageControllerArray;
    }

    @Override
    public void refresh() {
        ServerBO serverBO = ContainerViewBO.getServerBO(this._dbso.getConnection());
        IMDatabaseDevicesCtrBO iMDatabaseDevicesCtrBO = ContainerViewBO.getIMDatabaseDevicesCtrBO(serverBO);
        if (null != iMDatabaseDevicesCtrBO) {
            iMDatabaseDevicesCtrBO.refresh();
        }
    }

    @Override
    public boolean getEnableFinish() {
        return false;
    }

    class IMDatabaseWizOptionsPage
    extends DatabaseWizard.DatabaseWizOptionsPage
    implements ActionListener {
        public IMDatabaseWizOptionsPage(DatabaseWizard databaseWizard) {
            super(databaseWizard);
        }

        @Override
        public void enableComponents() {
            this.enableFinishButton(true);
        }

        @Override
        public void init() {
            super.init();
            this._go.forLoadLabel.setText(ASEUtils.getString("IMDB_WIZ_LOAD_OPTION_DESC"));
            this._go.templateDBDesc.setText(ASEUtils.getString("IMDB_WIZ_TEMPLATE_OPTION_DESC"));
            this._go.introMultiLineLabel.setText(ASEUtils.getString("IMDB_WIZ_OVERRIDE_OPTION_DESC"));
        }
    }

    class IMDatabaseWizDevicePage
    extends DatabaseWizard.DatabaseWizDevicePage {
        public IMDatabaseWizDevicePage(DatabaseWizard databaseWizard) {
            super(databaseWizard);
        }

        @Override
        public void init() throws SQLException {
            super.init();
            this._go.introTextMultiLineLabel.setText(ASEUtils.getString("IM_DATABASE_WIZ_DEVICE_INTRO"));
        }

        @Override
        public boolean onSetActive() {
            this.enableComponents();
            return true;
        }

        @Override
        public void enableComponents() {
            this.enableNextButton(this._tblDevices.getRowCount() > 0);
            this.enableFinishButton(this._tblDevices.getRowCount() > 0);
        }

        private String getSelectedPhysicalName() {
            String string = null;
            if (this._tblDevices.getRowCount() > 0) {
                String string2 = ((JLabel)this._tblDevices.getValueAt(0, 0)).getText();
                DatabaseDeviceSO databaseDeviceSO = null;
                databaseDeviceSO = this.getEditingDatabaseDevice(string2);
                string = databaseDeviceSO.getPhysicalName();
            }
            return string;
        }

        @Override
        public Vector<DatabaseDeviceSO> getDatabaseDeviceList() throws SQLException {
            Vector vector = new Vector();
            DatabaseDevicesCtrSO databaseDevicesCtrSO = new DatabaseDevicesCtrSO(IMDatabaseWizard.this._dbso.getConnection());
            databaseDevicesCtrSO.setDatabaseDeviceType(2);
            vector.addAll(databaseDevicesCtrSO.open(1));
            List<String> list = this.getCachesUsedByIMDB();
            String string = this.getSelectedPhysicalName();
            Vector<DatabaseDeviceSO> vector2 = new Vector<DatabaseDeviceSO>();
            for (DatabaseDeviceSO databaseDeviceSO : vector) {
                if (list.contains(databaseDeviceSO.getPhysicalName()) || null != string && (null == string || !databaseDeviceSO.getPhysicalName().equals(string))) continue;
                vector2.add(databaseDeviceSO);
            }
            return vector2;
        }

        List<String> getCachesUsedByIMDB() throws SQLException {
            CachesCtrSO cachesCtrSO = new CachesCtrSO(this.getSO().getConnection());
            return cachesCtrSO.getCachesNameUsedByIMDB();
        }

        @Override
        public int onWizardNext() {
            Vector<String> vector = new Vector<String>();
            for (int i = 0; i < this._tableModel.getRowCount(); ++i) {
                Vector vector2 = this._tableModel.getRow(i);
                String string = ((JLabel)vector2.elementAt(0)).getText();
                if (vector.contains(string)) {
                    IMDatabaseWizard.this._needEnableOverride = true;
                    break;
                }
                vector.add(string);
                IMDatabaseWizard.this._needEnableOverride = false;
            }
            return super.onWizardNext();
        }
    }

    class IMDatabaseWizNamePage
    extends DatabaseWizard.DatabaseWizNamePage {
        public IMDatabaseWizNamePage(DatabaseWizard databaseWizard) {
            super(databaseWizard, ASEUtils.getString("IM_DATABASE_WIZ_SENT_WELCOME"));
        }
    }
}

