/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.aseplugin.bo.wiz;

import com.sybase.asa.ASAComboBox;
import com.sybase.asa.ASAIconTextData;
import com.sybase.asa.ASAIconTextUserData;
import com.sybase.asa.ASAMultiList;
import com.sybase.aseplugin.ASEImages;
import com.sybase.aseplugin.ASEMessageText;
import com.sybase.aseplugin.ASEUtils;
import com.sybase.aseplugin.bo.CacheBO;
import com.sybase.aseplugin.bo.ColumnBO;
import com.sybase.aseplugin.bo.ContainerViewBO;
import com.sybase.aseplugin.bo.DatabaseBO;
import com.sybase.aseplugin.bo.DatabasesCtrBO;
import com.sybase.aseplugin.bo.IndexesCtrBO;
import com.sybase.aseplugin.bo.SegmentBO;
import com.sybase.aseplugin.bo.ServerBO;
import com.sybase.aseplugin.bo.Support;
import com.sybase.aseplugin.bo.TableBO;
import com.sybase.aseplugin.bo.TablesCtrBO;
import com.sybase.aseplugin.bo.dlg.AddIndexExpressionDialog;
import com.sybase.aseplugin.bo.wiz.ASEBaseWizardDialog2;
import com.sybase.aseplugin.bo.wiz.ASEBaseWizardPage2;
import com.sybase.aseplugin.bo.wiz.NameWizBOPage;
import com.sybase.aseplugin.bo.wiz.SummaryWizBOPage;
import com.sybase.aseplugin.go.wiz.IndexWizGOCachePage;
import com.sybase.aseplugin.go.wiz.IndexWizGOClusteredPage;
import com.sybase.aseplugin.go.wiz.IndexWizGOColumnsPage;
import com.sybase.aseplugin.go.wiz.IndexWizGODuplicatePage;
import com.sybase.aseplugin.go.wiz.IndexWizGOPartitionIntroPage;
import com.sybase.aseplugin.go.wiz.IndexWizGOSegmentPage;
import com.sybase.aseplugin.go.wiz.IndexWizGOSpacePage;
import com.sybase.aseplugin.go.wiz.IndexWizGOStrategyPage;
import com.sybase.aseplugin.go.wiz.PartitionWizGOSpecPage;
import com.sybase.aseplugin.so.CacheSO;
import com.sybase.aseplugin.so.ColumnSO;
import com.sybase.aseplugin.so.ColumnsCtrSO;
import com.sybase.aseplugin.so.IndexSO;
import com.sybase.aseplugin.so.SOItemInterface;
import com.sybase.aseplugin.so.SegmentSO;
import com.sybase.aseplugin.so.Utility;
import com.sybase.aseplugin.util.ui.JComboBoxEditor;
import com.sybase.aseplugin.util.ui.JComboBoxRenderer;
import com.sybase.aseplugin.util.ui.TableSelectionListener;
import com.sybase.central.SCContainer2;
import com.sybase.central.SCPageController;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import javax.swing.DefaultCellEditor;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;

public class IndexWizard
extends ASEBaseWizardDialog2 {
    private static final ImageIcon ICON_ASCENDING = new ImageIcon(ASEImages.getAscendingImage());
    private static final ImageIcon ICON_DESCENDING = new ImageIcon(ASEImages.getDescendingImage());
    private IndexWizClusteredPage _clusteredPage;
    private IndexSO _index;
    private List _segments;

    public IndexWizard(IndexSO indexSO, IndexesCtrBO indexesCtrBO) {
        super((SOItemInterface)indexSO, (SCContainer2)indexesCtrBO, ASEUtils.getString("MSG_ADD_INDEX"));
        this._index = indexSO;
    }

    @Override
    public SCPageController[] getPages() {
        IndexWizNamePage indexWizNamePage = new IndexWizNamePage(this);
        IndexWizColumnsPage indexWizColumnsPage = new IndexWizColumnsPage(this);
        IndexWizSegmentPage indexWizSegmentPage = new IndexWizSegmentPage(this);
        IndexWizCachePage indexWizCachePage = new IndexWizCachePage(this);
        this._clusteredPage = new IndexWizClusteredPage(this);
        IndexWizDuplicatePage indexWizDuplicatePage = new IndexWizDuplicatePage(this);
        IndexWizSpacePage indexWizSpacePage = new IndexWizSpacePage(this);
        IndexWizStrategyPage indexWizStrategyPage = new IndexWizStrategyPage(this);
        IndexWizSummaryPage indexWizSummaryPage = new IndexWizSummaryPage(this);
        if (((IndexSO)this.getSO()).getConnection().isPartitionsApplicable()) {
            IndexWizPartitionIntroPage indexWizPartitionIntroPage = new IndexWizPartitionIntroPage(this);
            IndexWizPartitionSpecPage indexWizPartitionSpecPage = new IndexWizPartitionSpecPage(this);
            return new SCPageController[]{indexWizNamePage, indexWizColumnsPage, indexWizSegmentPage, indexWizCachePage, this._clusteredPage, indexWizDuplicatePage, indexWizSpacePage, indexWizStrategyPage, indexWizPartitionIntroPage, indexWizPartitionSpecPage, indexWizSummaryPage};
        }
        return new SCPageController[]{indexWizNamePage, indexWizColumnsPage, indexWizSegmentPage, indexWizCachePage, this._clusteredPage, indexWizDuplicatePage, indexWizSpacePage, indexWizStrategyPage, indexWizSummaryPage};
    }

    @Override
    public void releaseResources() {
        this._clusteredPage = null;
        this._index = null;
        super.releaseResources();
    }

    private void setSegments(ASAComboBox aSAComboBox) {
        try {
            if (this._segments == null) {
                this._segments = this._index.getAvailableSegments();
            }
            for (SegmentSO segmentSO : this._segments) {
                String string = segmentSO.getName();
                if (string.equals("logsegment")) continue;
                ASAIconTextData aSAIconTextData = new ASAIconTextData((Icon)SegmentBO.SEGMENT_ICON, string);
                aSAComboBox.addItem((Object)aSAIconTextData);
            }
        }
        catch (SQLException sQLException) {
            Support.showDetailsError(this.getConnection(), this.getClass(), (Container)this.getJDialog(), sQLException.getMessage(), sQLException);
        }
    }

    class IndexWizSummaryPage
    extends SummaryWizBOPage {
        public IndexWizSummaryPage(IndexWizard indexWizard2) {
            super(indexWizard2, ASEImages.getIndexWizardImage());
        }

        @Override
        public void enableComponents() {
            this.clearSummaryItems();
            this.addSummaryItem(ASEUtils.getString("DISP_NAME_TEXT"), IndexWizard.this._index.getName());
            this.addSummaryItem(ASEUtils.getString("MSG_COLUMNS"), Utility.stringArrayToString(IndexWizard.this._index.getColumns(), ", "));
            this.addSummaryItem(ASEUtils.getString("MSG_SEGMENT_TYPE"), IndexWizard.this._index.getSegmentName());
            this.addSummaryItem(ASEUtils.getString("MSG_CACHE_TYPE"), IndexWizard.this._index.getCacheName());
            this.addSummaryItem(ASEUtils.getString("DISP_TYPE_TEXT"), ASEUtils.getString(IndexWizard.this._index.isUniqueIndex() ? "MSG_UNIQUE_TYPE" : "MSG_NOT_UNIQUE_TYPE") + ", " + ASEUtils.getString(IndexWizard.this._index.isClustered() ? "MSG_CLUSTERED_TYPE" : "MSG_NOT_CLUSTERED_TYPE"));
            String string = !IndexWizard.this._index.isUniqueIndex() ? ASEUtils.getString("MSG_NOT_APPLICABLE") : (IndexWizard.this._index.isDuplicateKey() ? ASEUtils.getString("MSG_IGNORE") : ASEUtils.getString("MSG_DO_NOT_IGNORE"));
            this.addSummaryItem(ASEUtils.getString("MSG_DUPLICATE_KEYS"), string);
            if (IndexWizard.this._index.isUniqueIndex() || !IndexWizard.this._index.isClustered()) {
                string = ASEUtils.getString("MSG_NOT_APPLICABLE");
            } else if (IndexWizard.this._index.isClustered() && IndexWizard.this._index.isAllowDuplicateRow()) {
                string = ASEUtils.getString("MSG_ALLOW");
            } else if (IndexWizard.this._index.isClustered() && IndexWizard.this._index.isNotAllowDuplicateRow()) {
                string = ASEUtils.getString("MSG_NOT_ALLOW");
            } else if (IndexWizard.this._index.isClustered() && IndexWizard.this._index.isAllowDuplicateRow()) {
                string = ASEUtils.getString("MSG_IGNORE");
            }
            this.addSummaryItem(ASEUtils.getString("MSG_DUPLICATE_ROWS"), string);
            this.setSummaryInfo(this.getSummary());
        }
    }

    class IndexWizPartitionSpecPage
    extends ASEBaseWizardPage2
    implements ActionListener,
    DocumentListener {
        private PartitionWizGOSpecPage _go;
        private String _name;
        private String _segment;
        private ASAMultiList _specList;
        private int _tablePartitionCount;

        public IndexWizPartitionSpecPage(IndexWizard indexWizard2) {
            super(indexWizard2, (JPanel)((Object)new PartitionWizGOSpecPage()), ASEUtils.getString("MSG_INDEX_WIZ_PAGE3"));
            this._go = (PartitionWizGOSpecPage)((Object)this.getJPanel());
        }

        @Override
        public void init() {
            this._go.setImage(ASEImages.getIndexWizardImage());
            this._name = ASEUtils.getString("DISP_NAME_TEXT");
            this._segment = ASEUtils.getString("MSG_SEGMENT_TYPE");
            try {
                this._tablePartitionCount = IndexWizard.this._index.getTableSO().getNumberPartitions();
            }
            catch (SQLException sQLException) {
                Support.showDetailsError(this.getConnection(), this.getClass(), (Container)this.getJDialog(), sQLException.getMessage(), sQLException);
            }
            this._specList = new ASAMultiList(){

                public boolean isCellEditable(int n, int n2) {
                    return true;
                }
            };
            this._specList.setColumnHeadings((Object[])new String[]{this._name, this._segment});
            this._go.tableScrollPane.getViewport().setView((Component)this._specList);
            this._specList.setPreferredSize(this._go.tableScrollPane.getPreferredSize());
            TableColumn tableColumn = this._specList.getColumn((Object)this._segment);
            tableColumn.setCellRenderer(new JComboBoxRenderer());
            tableColumn.setCellEditor(new JComboBoxEditor((JComboBox)new ASAComboBox()));
            TableColumn tableColumn2 = this._specList.getColumn((Object)this._name);
            tableColumn2.setCellRenderer(new DefaultTableCellRenderer());
            tableColumn2.setCellEditor(new DefaultCellEditor(new JTextField()));
            ((JTextField)((DefaultCellEditor)tableColumn2.getCellEditor()).getComponent()).getDocument().addDocumentListener(this);
            this._go.addButton.addActionListener((ActionListener)this);
            this._go.deleteButton.setEnabled(false);
            this._go.deleteButton.addActionListener((ActionListener)this);
            this._go.upButton.addActionListener((ActionListener)this);
            this._go.downButton.addActionListener((ActionListener)this);
            this._go.explainationLabel.setVisible(false);
            TableSelectionListener tableSelectionListener = new TableSelectionListener(){

                @Override
                public void deSelectAction() {
                    ((IndexWizPartitionSpecPage)IndexWizPartitionSpecPage.this)._go.deleteButton.setEnabled(false);
                    this.enableComponents();
                }

                @Override
                public void selectAction() {
                    ((IndexWizPartitionSpecPage)IndexWizPartitionSpecPage.this)._go.deleteButton.setEnabled(true);
                    this.enableComponents();
                }

                private void enableComponents() {
                    try {
                        IndexWizPartitionSpecPage.this._specList.getCellEditor().stopCellEditing();
                    }
                    catch (NullPointerException nullPointerException) {
                        // empty catch block
                    }
                    boolean bl = IndexWizPartitionSpecPage.this._specList.getSelectedRowCount() > 0;
                    ((IndexWizPartitionSpecPage)IndexWizPartitionSpecPage.this)._go.upButton.setEnabled(bl && IndexWizPartitionSpecPage.this._specList.getMinSelectionIndex() > 0);
                    int n = IndexWizPartitionSpecPage.this._specList.getRowCount();
                    ((IndexWizPartitionSpecPage)IndexWizPartitionSpecPage.this)._go.downButton.setEnabled(bl && IndexWizPartitionSpecPage.this._specList.getMaxSelectionIndex() < n - 1);
                }
            };
            this._specList.addListSelectionListener((ListSelectionListener)tableSelectionListener);
            this._go.addButton.setText(ASEUtils.getString("BTTN_ADD"));
            this._go.addButton.setMnemonic(Support.getMnemonic("MNEM_ADD"));
            this._go.downButton.setEnabled(false);
            this._go.upButton.setEnabled(false);
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            this.enableNext();
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
            this.enableNext();
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            this.enableNext();
        }

        @Override
        public void enableComponents() {
            this.enableNext();
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == this._go.addButton) {
                if (this._specList.getRowCount() >= this._tablePartitionCount) {
                    ASEMessageText aSEMessageText = new ASEMessageText(ASEUtils.getString("MSG_INDEX_NUMBER_PARTITIONS"), this._tablePartitionCount + "", IndexWizard.this._index.getTableSO().getName());
                    Support.showError(this.getConnection(), this.getClass(), this.getJDialog(), aSEMessageText.toString());
                } else {
                    ASAComboBox aSAComboBox = new ASAComboBox();
                    IndexWizard.this.setSegments(aSAComboBox);
                    this._specList.addRow(new Object[]{new ASAIconTextUserData(""), aSAComboBox});
                    this.enableNext();
                }
            } else if (actionEvent.getSource() == this._go.deleteButton) {
                int[] nArray = this._specList.getSelectedRows();
                try {
                    this._specList.getCellEditor().stopCellEditing();
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                for (int i = nArray.length - 1; i >= 0; --i) {
                    this._specList.removeRow(nArray[i]);
                }
                this._specList.tableChanged(new TableModelEvent(this._specList.getModel()));
                this._go.tableScrollPane.validate();
                this._go.tableScrollPane.repaint();
                this.enableNext();
            } else if (actionEvent.getSource() == this._go.upButton) {
                Support.moveRows(true, this._specList);
            } else if (actionEvent.getSource() == this._go.downButton) {
                Support.moveRows(false, this._specList);
            }
        }

        private void enableNext() {
            try {
                this._specList.getCellEditor().stopCellEditing();
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            boolean bl = this._specList.getRowCount() >= 0;
            for (int i = 0; i < this._specList.getRowCount(); ++i) {
                if (!this._specList.getStringAt(i, 0).equals("")) continue;
                bl = false;
                break;
            }
            this.enableNextButton(bl);
            this.enableFinishButton(bl);
        }

        @Override
        public boolean deploy() {
            if (IndexWizard.this._index.isIndexPartition()) {
                int n = this._specList.getRowCount();
                String string = "";
                for (int i = 0; i < n; ++i) {
                    string = string + this._specList.getStringAt(i, 0) + (((ASAComboBox)this._specList.getValueAt(i, 1)).getSelectedString().equals("") ? "" : " on '" + ((ASAComboBox)this._specList.getValueAt(i, 1)).getSelectedString() + "'") + ", \n";
                }
                if (!string.equals("")) {
                    string = string.substring(0, string.lastIndexOf(","));
                }
                IndexWizard.this._index.setPartitionSpec(string);
            } else {
                IndexWizard.this._index.setPartitionSpec(null);
            }
            return true;
        }

        @Override
        public void releaseResources() {
            this._go.addButton.removeActionListener((ActionListener)this);
            this._go.deleteButton.removeActionListener((ActionListener)this);
            this._go.upButton.removeActionListener((ActionListener)this);
            this._go.downButton.removeActionListener((ActionListener)this);
            this._go.releaseResources();
            this._go = null;
            super.releaseResources();
        }
    }

    class IndexWizPartitionIntroPage
    extends ASEBaseWizardPage2
    implements ActionListener {
        private IndexWizGOPartitionIntroPage _go;

        public IndexWizPartitionIntroPage(IndexWizard indexWizard2) {
            super(indexWizard2, (JPanel)((Object)new IndexWizGOPartitionIntroPage()), ASEUtils.getString("INDEX_WIZ_PT_PAGE_TITLE"));
            this._go = (IndexWizGOPartitionIntroPage)((Object)this.getJPanel());
            this._go.localCheckBox.addActionListener((ActionListener)this);
        }

        @Override
        public void enableComponents() {
            this.enableFinishButton(!this._go.localCheckBox.isSelected());
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (this._go.localCheckBox.isSelected()) {
                IndexWizard.this._index.setIndexPartition(true);
                this.enableFinishButton(false);
            } else {
                IndexWizard.this._index.setIndexPartition(false);
                this.enableFinishButton(true);
            }
        }

        @Override
        public int onWizardNext() {
            if (this._go.localCheckBox.isSelected()) {
                return 10;
            }
            return 11;
        }

        @Override
        public void releaseResources() {
            this._go.localCheckBox.removeActionListener((ActionListener)this);
            this._go.releaseResources();
            this._go = null;
            super.releaseResources();
        }
    }

    class IndexWizStrategyPage
    extends ASEBaseWizardPage2 {
        private IndexWizGOStrategyPage _go;

        public IndexWizStrategyPage(IndexWizard indexWizard2) {
            super(indexWizard2, (JPanel)((Object)new IndexWizGOStrategyPage()), ASEUtils.getString("MSG_INDEX_WIZ_PAGE7"));
            this._go = (IndexWizGOStrategyPage)((Object)this.getJPanel());
        }

        @Override
        public void enableComponents() {
            this.enableFinishButton(true);
        }

        private boolean isRUR() {
            return this._go.mostRecentCheckBox.isSelected();
        }

        private boolean isBufferPrefetch() {
            return this._go.bufferPrefetchCheckBox.isSelected();
        }

        private boolean isDataSorted() {
            return this._go.dataSortedCheckBox.isSelected();
        }

        @Override
        public boolean deploy() {
            IndexWizard.this._index.setMRUCacheStrategy(this.isRUR());
            IndexWizard.this._index.setBufferPrefetch(this.isBufferPrefetch());
            IndexWizard.this._index.setDataSorted(this.isDataSorted());
            return true;
        }

        @Override
        public void releaseResources() {
            this._go.releaseResources();
            this._go = null;
            super.releaseResources();
        }
    }

    class IndexWizSpacePage
    extends ASEBaseWizardPage2
    implements ActionListener {
        private IndexWizGOSpacePage _go;

        public IndexWizSpacePage(IndexWizard indexWizard2) {
            super(indexWizard2, (JPanel)((Object)new IndexWizGOSpacePage()), ASEUtils.getString("MSG_INDEX_WIZ_PAGE6"));
            this._go = (IndexWizGOSpacePage)((Object)this.getJPanel());
        }

        @Override
        public void init() {
            this._go.rowPerPageCheckBox.addActionListener((ActionListener)this);
            this._go.fillFactorCheckBox.addActionListener((ActionListener)this);
            this._go.fillFactorSpinBox.setValue(0);
            this._go.rowPerPageSpinBox.setValue(0);
            this._go.reservePageGapSpinBox.setValue(0);
            this._go.fillFactorSpinBox.setEnabled(false);
            this._go.rowPerPageSpinBox.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            boolean bl;
            if (actionEvent.getSource() == this._go.rowPerPageCheckBox) {
                bl = this._go.rowPerPageCheckBox.isSelected();
                this._go.rowPerPageSpinBox.setEnabled(bl);
                if (bl) {
                    this._go.rowPerPageSpinBox.requestFocusInWindow();
                }
            }
            if (actionEvent.getSource() == this._go.fillFactorCheckBox) {
                bl = this._go.fillFactorCheckBox.isSelected();
                this._go.fillFactorSpinBox.setEnabled(bl);
                if (bl) {
                    this._go.fillFactorSpinBox.requestFocusInWindow();
                }
            }
        }

        @Override
        public boolean deploy() {
            IndexWizard.this._index.setReservePageGap(this._go.reservePageGapSpinBox.getValue());
            if (this.isRowPerPage()) {
                IndexWizard.this._index.setMaxRowsPerPage(this._go.rowPerPageSpinBox.getValue());
            } else {
                IndexWizard.this._index.setMaxRowsPerPage(0);
            }
            if (this.isFillFactor()) {
                IndexWizard.this._index.setFillFactor(this._go.fillFactorSpinBox.getValue());
            } else {
                IndexWizard.this._index.setFillFactor(0);
            }
            return true;
        }

        @Override
        public void enableComponents() {
            this.enableFinishButton(true);
        }

        private boolean isFillFactor() {
            return this._go.fillFactorCheckBox.isSelected() && this._go.fillFactorCheckBox.isEnabled();
        }

        private boolean isRowPerPage() {
            return this._go.rowPerPageCheckBox.isSelected() && this._go.rowPerPageCheckBox.isEnabled();
        }

        @Override
        public void releaseResources() {
            this._go.rowPerPageCheckBox.removeActionListener((ActionListener)this);
            this._go.fillFactorCheckBox.removeActionListener((ActionListener)this);
            this._go.releaseResources();
            this._go = null;
            super.releaseResources();
        }
    }

    class IndexWizDuplicatePage
    extends ASEBaseWizardPage2 {
        private IndexWizGODuplicatePage _go;

        public IndexWizDuplicatePage(IndexWizard indexWizard2) {
            super(indexWizard2, (JPanel)((Object)new IndexWizGODuplicatePage()), ASEUtils.getString("MSG_INDEX_WIZ_PAGE5A"));
            this._go = (IndexWizGODuplicatePage)((Object)this.getJPanel());
            this._go.notAllowDuplicateRadioButton.setSelected(true);
        }

        private boolean isUnique() {
            return IndexWizard.this._clusteredPage.isUniqueIndex();
        }

        private boolean isClustered() {
            return IndexWizard.this._clusteredPage.isClusteredIndex();
        }

        @Override
        public void enableComponents() {
            boolean bl = this.isUnique();
            boolean bl2 = this.isClustered();
            this._go.ignoreDuplicateCheckBox.setEnabled(bl);
            this._go.ignoreDupliateMultiLineLabel.setEnabled(bl);
            boolean bl3 = bl2 && !bl;
            this._go.notAllowDuplicateRadioButton.setEnabled(bl3);
            this._go.allowDuplicateRadioButton.setEnabled(bl3);
            this._go.ignoreDuplicateRadioButton.setEnabled(bl3);
            this._go.nonUniqueMultiLineLabel.setEnabled(bl3);
            boolean bl4 = bl || bl2;
            this.enableFinishButton(bl4);
        }

        @Override
        public boolean showPage() {
            return this.isUnique() || this.isClustered();
        }

        private boolean ignoreDuplicateKeys() {
            boolean bl = this._go.ignoreDuplicateCheckBox.isSelected() && this.ignoreDuplicateKeysEnabled();
            return bl;
        }

        private boolean ignoreDuplicateKeysEnabled() {
            return this._go.ignoreDuplicateCheckBox.isEnabled();
        }

        private boolean isClusteringEnabled() {
            return this._go.notAllowDuplicateRadioButton.isEnabled();
        }

        private boolean isAllow() {
            return this._go.allowDuplicateRadioButton.isSelected() && this.isClusteringEnabled();
        }

        private boolean isIgnore() {
            return this._go.ignoreDuplicateRadioButton.isSelected() && this.isClusteringEnabled();
        }

        @Override
        public boolean deploy() {
            IndexWizard.this._index.setDuplicateKey(this.ignoreDuplicateKeys());
            IndexWizard.this._index.setDuplicateRow(this.isAllow(), this.isIgnore());
            return true;
        }

        @Override
        public void releaseResources() {
            this._go.releaseResources();
            this._go = null;
            super.releaseResources();
        }
    }

    class IndexWizClusteredPage
    extends ASEBaseWizardPage2 {
        private IndexWizGOClusteredPage _go;

        public IndexWizClusteredPage(IndexWizard indexWizard2) {
            super(indexWizard2, (JPanel)((Object)new IndexWizGOClusteredPage()), ASEUtils.getString("MSG_INDEX_WIZ_PAGE5"));
            this._go = (IndexWizGOClusteredPage)((Object)this.getJPanel());
        }

        @Override
        public void enableComponents() {
            try {
                boolean bl = IndexWizard.this._index.clusteredIndexExists();
                this._go.clusteredExistsMultiLineLabel.setVisible(bl);
                this._go.clusteredCheckBox.setEnabled(!bl);
            }
            catch (SQLException sQLException) {
                Support.showDetailsError(this.getConnection(), this.getClass(), (Container)this.getJDialog(), sQLException.getMessage(), sQLException);
            }
            this.enableFinishButton(true);
        }

        public boolean isClusteredIndex() {
            boolean bl = this._go.clusteredCheckBox.isSelected();
            return bl;
        }

        public boolean isUniqueIndex() {
            boolean bl = this._go.uniqueCheckBox.isSelected();
            return bl;
        }

        @Override
        public boolean deploy() {
            IndexWizard.this._index.setUniqueIndex(this.isUniqueIndex());
            IndexWizard.this._index.setClusteredIndex(this.isClusteredIndex());
            return true;
        }

        @Override
        public void releaseResources() {
            this._go.releaseResources();
            this._go = null;
            super.releaseResources();
        }
    }

    class IndexWizCachePage
    extends ASEBaseWizardPage2
    implements ActionListener {
        private IndexWizGOCachePage _go;

        public IndexWizCachePage(IndexWizard indexWizard2) {
            super(indexWizard2, (JPanel)((Object)new IndexWizGOCachePage()), ASEUtils.getString("MSG_INDEX_WIZ_PAGE4"));
            this._go = (IndexWizGOCachePage)((Object)this.getJPanel());
            this._go.propertiesButton.addActionListener((ActionListener)this);
            this.getAvailableCaches();
        }

        @Override
        public void enableComponents() {
            this.enableFinishButton(true);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            String string = this._go.cacheComboBox.getSelectedItem().toString();
            TableBO tableBO = (TableBO)((IndexesCtrBO)this.getParentCtr()).getParent();
            DatabaseBO databaseBO = (DatabaseBO)((TablesCtrBO)tableBO.getParent()).getParent();
            ServerBO serverBO = (ServerBO)((DatabasesCtrBO)databaseBO.getParent()).getParent();
            ContainerViewBO.openCacheProperties(serverBO, string);
        }

        private void getAvailableCaches() {
            try {
                List list = IndexWizard.this._index.getAvailableCaches();
                for (CacheSO cacheSO : list) {
                    ASAIconTextData aSAIconTextData = new ASAIconTextData((Icon)CacheBO.CACHE_ICON, cacheSO.getName());
                    this._go.cacheComboBox.addItem((Object)aSAIconTextData);
                }
            }
            catch (SQLException sQLException) {
                Support.showDetailsError(this.getConnection(), this.getClass(), (Container)this.getJDialog(), sQLException.getMessage(), sQLException);
            }
        }

        @Override
        public boolean deploy() {
            String string = this._go.cacheComboBox.getSelectedItem().toString();
            IndexWizard.this._index.setCacheName(string);
            return true;
        }

        @Override
        public void releaseResources() {
            this._go.propertiesButton.removeActionListener((ActionListener)this);
            this._go.releaseResources();
            this._go = null;
            super.releaseResources();
        }
    }

    class IndexWizSegmentPage
    extends ASEBaseWizardPage2
    implements ActionListener {
        private IndexWizGOSegmentPage _go;

        public IndexWizSegmentPage(IndexWizard indexWizard2) {
            super(indexWizard2, (JPanel)((Object)new IndexWizGOSegmentPage()), ASEUtils.getString("MSG_INDEX_WIZ_PAGE3"));
            this._go = (IndexWizGOSegmentPage)((Object)this.getJPanel());
            IndexWizard.this.setSegments(this._go.segmentComboBox);
            this._go.propertiesButton.addActionListener((ActionListener)this);
        }

        @Override
        public void enableComponents() {
            this.enableFinishButton(true);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            String string = this._go.segmentComboBox.getSelectedItem().toString();
            TableBO tableBO = (TableBO)((IndexesCtrBO)this.getParentCtr()).getParent();
            DatabaseBO databaseBO = (DatabaseBO)((TablesCtrBO)tableBO.getParent()).getParent();
            ContainerViewBO.openSegmentProperties(databaseBO, string);
        }

        @Override
        public boolean deploy() {
            String string = this._go.segmentComboBox.getSelectedItem().toString();
            IndexWizard.this._index.setSegmentName(string);
            return true;
        }

        @Override
        public void releaseResources() {
            this._go.propertiesButton.removeActionListener((ActionListener)this);
            this._go.releaseResources();
            this._go = null;
            super.releaseResources();
        }
    }

    class IndexWizColumnsPage
    extends ASEBaseWizardPage2
    implements ActionListener,
    ListSelectionListener,
    MouseListener {
        private static final String ACTN_ADD_ASC = "0";
        private static final String ACTN_ADD_DESC = "1";
        private static final String ACTN_REMOVE = "2";
        private static final String ACTN_MOVE_UP = "3";
        private static final String ACTN_MOVE_DOWN = "4";
        private IndexWizGOColumnsPage _go;
        private boolean _processListSelectionEvents;

        public IndexWizColumnsPage(IndexWizard indexWizard2) {
            super(indexWizard2, (JPanel)((Object)new IndexWizGOColumnsPage()), ASEUtils.getString("MSG_INDEX_WIZ_PAGE2"));
            this._processListSelectionEvents = true;
            this._go = (IndexWizGOColumnsPage)((Object)this.getJPanel());
            this._go.tableColumnsMultiList.addListSelectionListener((ListSelectionListener)this);
            this._go.tableColumnsMultiList.addMouseListener((MouseListener)this);
            this._go.tableColumnsMultiList.registerKeyboardAction((ActionListener)this, ACTN_ADD_ASC, KeyStroke.getKeyStroke(155, 0), 0);
            this._go.tableColumnsMultiList.registerKeyboardAction((ActionListener)this, ACTN_ADD_DESC, KeyStroke.getKeyStroke(155, 1), 0);
            this._go.indexColumnsMultiList.addListSelectionListener((ListSelectionListener)this);
            this._go.indexColumnsMultiList.addMouseListener((MouseListener)this);
            this._go.indexColumnsMultiList.registerKeyboardAction((ActionListener)this, ACTN_REMOVE, KeyStroke.getKeyStroke(127, 0), 0);
            this._go.indexColumnsMultiList.registerKeyboardAction((ActionListener)this, ACTN_MOVE_UP, KeyStroke.getKeyStroke(38, 2), 0);
            this._go.indexColumnsMultiList.registerKeyboardAction((ActionListener)this, ACTN_MOVE_DOWN, KeyStroke.getKeyStroke(40, 2), 0);
            this._go.propertiesButton.addActionListener((ActionListener)this);
            this._go.addAscendingButton.addActionListener((ActionListener)this);
            this._go.addDescendingButton.addActionListener((ActionListener)this);
            this._go.removeButton.addActionListener((ActionListener)this);
            this._go.moveUpButton.addActionListener((ActionListener)this);
            this._go.moveDownButton.addActionListener((ActionListener)this);
            this._go.indexExpressionButton.addActionListener((ActionListener)this);
            this._go.propertiesButton.setEnabled(false);
        }

        @Override
        public void init() throws SQLException {
            if (this.getConnection().getVersion().compareTo("15") < 0) {
                this._go.indexExpressionButton.setVisible(false);
                this._go.indexExpressionMultiLineLabel.setVisible(false);
            }
            ColumnsCtrSO columnsCtrSO = new ColumnsCtrSO(IndexWizard.this._index.getConnection(), IndexWizard.this._index.getTableSO());
            Hashtable<String, Boolean> hashtable = new Hashtable<String, Boolean>();
            Boolean bl = null;
            List list = columnsCtrSO.open(1);
            for (ColumnSO columnSO : list) {
                String string;
                if (columnSO.getTmpEncrypt()) {
                    string = hashtable.get(columnSO.getTmpKey());
                    if (string == null) {
                        bl = new Boolean(columnSO.isPlainKey(columnSO.getTmpKey()));
                        hashtable.put(columnSO.getTmpKey(), bl);
                    } else {
                        bl = (Boolean)((Object)string);
                    }
                    if (!bl.booleanValue()) continue;
                }
                if ((string = columnSO.getDatatype()).equals("text") || string.equals("image") || string.equals("unitext") || string.equals("bit")) continue;
                ASAIconTextUserData aSAIconTextUserData = new ASAIconTextUserData((Icon)ColumnBO.getIcon(columnSO), columnSO.getName(), (Object)columnSO);
                this._go.tableColumnsMultiList.addRow(new Object[]{aSAIconTextUserData});
            }
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (this._processListSelectionEvents) {
                this.enableComponents();
            }
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            Object object = mouseEvent.getSource();
            int n = mouseEvent.getClickCount();
            if (n == 1) {
                if (object == this._go.tableColumnsMultiList) {
                    this._go.indexColumnsMultiList.clearSelection();
                } else if (object == this._go.indexColumnsMultiList) {
                    this._go.tableColumnsMultiList.clearSelection();
                }
            } else if (n > 1) {
                if (object == this._go.tableColumnsMultiList) {
                    this.addColumns(!mouseEvent.isShiftDown());
                } else if (object == this._go.indexColumnsMultiList) {
                    this.toggleColumns();
                }
            }
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            String string = actionEvent.getActionCommand();
            if (object == this._go.tableColumnsMultiList) {
                if (string != null) {
                    if (string.equals(ACTN_ADD_ASC)) {
                        this.addColumns(true);
                    } else if (string.equals(ACTN_ADD_DESC)) {
                        this.addColumns(false);
                    }
                }
            } else if (object == this._go.propertiesButton) {
                this.showColumnDetails();
            } else if (object == this._go.addAscendingButton) {
                this.addColumns(true);
            } else if (object == this._go.addDescendingButton) {
                this.addColumns(false);
            } else if (object == this._go.removeButton) {
                this.removeColumns();
            } else if (object == this._go.indexColumnsMultiList) {
                if (string != null) {
                    if (string.equals(ACTN_REMOVE)) {
                        this.removeColumns();
                    } else if (string.equals(ACTN_MOVE_UP)) {
                        this._processListSelectionEvents = false;
                        Support.moveRows(true, this._go.indexColumnsMultiList);
                        this.setActionAfterMove();
                    } else if (string.equals(ACTN_MOVE_DOWN)) {
                        this._processListSelectionEvents = false;
                        Support.moveRows(false, this._go.indexColumnsMultiList);
                        this.setActionAfterMove();
                    }
                }
            } else if (object == this._go.moveUpButton) {
                this._processListSelectionEvents = false;
                Support.moveRows(true, this._go.indexColumnsMultiList);
                this.setActionAfterMove();
            } else if (object == this._go.moveDownButton) {
                this._processListSelectionEvents = false;
                Support.moveRows(false, this._go.indexColumnsMultiList);
                this.setActionAfterMove();
            } else if (object == this._go.indexExpressionButton) {
                this.enableComponents();
                AddIndexExpressionDialog addIndexExpressionDialog = AddIndexExpressionDialog.getDialog(this.getJDialog(), ASEUtils.getString("MSG_ADD_IND_EXPR"), ASEUtils.getString("LABC_IND_EXPR"));
                if (addIndexExpressionDialog.render()) {
                    this.addColumnsToIndexList(addIndexExpressionDialog.getText(), addIndexExpressionDialog.getOrder());
                }
            }
        }

        private void setActionAfterMove() {
            this._go.indexColumnsMultiList.selectRows(this._go.indexColumnsMultiList.getSelectedRows());
            this._processListSelectionEvents = true;
            this.enableComponents();
        }

        private void showColumnDetails() {
            int[] nArray = this._go.tableColumnsMultiList.getSelectedRows();
            for (int i = 0; i < nArray.length; ++i) {
                String string = this._go.tableColumnsMultiList.getStringAt(nArray[i], 0);
                TableBO tableBO = (TableBO)((IndexesCtrBO)this.getParentCtr()).getParent();
                ContainerViewBO.openColumnProperties(tableBO, string);
            }
        }

        private void addColumns(boolean bl) {
            int[] nArray = this._go.tableColumnsMultiList.getSelectedRows();
            String string = "";
            if (nArray.length > 0) {
                for (int i = 0; i < nArray.length; ++i) {
                    string = this._go.tableColumnsMultiList.getStringAt(nArray[i], 0);
                    this.addColumnsToIndexList(string, bl);
                }
            }
        }

        private void addColumnsToIndexList(String string, boolean bl) {
            int n = 0;
            n = this._go.indexColumnsMultiList.findRow(new String[]{string});
            if (n == -1) {
                ASAIconTextData aSAIconTextData = new ASAIconTextData((Icon)(bl ? ICON_ASCENDING : ICON_DESCENDING), string);
                this._go.indexColumnsMultiList.addRow(new Object[]{aSAIconTextData});
            } else {
                this._go.indexColumnsMultiList.setIconAt((Icon)(bl ? ICON_ASCENDING : ICON_DESCENDING), n, 0);
            }
            this.enableComponents();
        }

        private void removeColumns() {
            int[] nArray = this._go.indexColumnsMultiList.getSelectedRows();
            for (int i = nArray.length - 1; i >= 0; --i) {
                this._go.indexColumnsMultiList.removeRow(nArray[i]);
            }
            this.enableComponents();
        }

        private void toggleColumns() {
            int[] nArray = this._go.indexColumnsMultiList.getSelectedRows();
            for (int i = 0; i < nArray.length; ++i) {
                int n = nArray[i];
                boolean bl = this._go.indexColumnsMultiList.getIconAt(n, 0) == ICON_ASCENDING;
                this._go.indexColumnsMultiList.setIconAt((Icon)(bl ? ICON_DESCENDING : ICON_ASCENDING), n, 0);
            }
        }

        @Override
        public void enableComponents() {
            boolean bl = this._go.tableColumnsMultiList.getSelectedRowCount() > 0;
            this._go.propertiesButton.setEnabled(bl);
            this._go.addAscendingButton.setEnabled(bl);
            this._go.addDescendingButton.setEnabled(bl);
            boolean bl2 = this._go.indexColumnsMultiList.getSelectedRowCount() > 0;
            this._go.removeButton.setEnabled(bl2);
            this._go.moveUpButton.setEnabled(bl2 && this._go.indexColumnsMultiList.getMinSelectionIndex() > 0);
            int n = this._go.indexColumnsMultiList.getRowCount();
            this._go.moveDownButton.setEnabled(bl2 && this._go.indexColumnsMultiList.getMaxSelectionIndex() < n - 1);
            boolean bl3 = n > 0;
            this.enableNextButton(bl3);
            this.enableFinishButton(bl3);
        }

        @Override
        public boolean deploy() {
            int n = this._go.indexColumnsMultiList.getRowCount();
            Vector<String> vector = new Vector<String>();
            Vector<String> vector2 = new Vector<String>();
            for (int i = 0; i < n; ++i) {
                ASAIconTextData aSAIconTextData = (ASAIconTextData)this._go.indexColumnsMultiList.getValueAt(i, 0);
                String string = aSAIconTextData.text;
                String string2 = aSAIconTextData.icon == ICON_ASCENDING ? "asc" : "desc";
                vector.add(string);
                vector2.add(string2);
            }
            IndexWizard.this._index.setColumns(vector);
            IndexWizard.this._index.setColumnsOrder(vector2);
            return true;
        }

        @Override
        public void releaseResources() {
            this._go.indexColumnsMultiList.removeListSelectionListener((ListSelectionListener)this);
            this._go.indexColumnsMultiList.removeMouseListener((MouseListener)this);
            this._go.indexColumnsMultiList.unregisterKeyboardAction(KeyStroke.getKeyStroke(127, 0));
            this._go.indexColumnsMultiList.unregisterKeyboardAction(KeyStroke.getKeyStroke(38, 2));
            this._go.indexColumnsMultiList.unregisterKeyboardAction(KeyStroke.getKeyStroke(40, 2));
            this._go.propertiesButton.removeActionListener((ActionListener)this);
            this._go.addAscendingButton.removeActionListener((ActionListener)this);
            this._go.addDescendingButton.removeActionListener((ActionListener)this);
            this._go.removeButton.removeActionListener((ActionListener)this);
            this._go.moveUpButton.removeActionListener((ActionListener)this);
            this._go.moveDownButton.removeActionListener((ActionListener)this);
            this._go.indexExpressionButton.removeActionListener((ActionListener)this);
            this._go.releaseResources();
            this._go = null;
            super.releaseResources();
        }
    }

    class IndexWizNamePage
    extends NameWizBOPage {
        public IndexWizNamePage(IndexWizard indexWizard2) {
            super(indexWizard2, ASEImages.getIndexWizardImage(), ASEUtils.getString("INDEX_WIZ_SENT_WELCOME_INDEX"), ASEUtils.getString("INDEX_WIZ_SENT_INTRO_INDEX"), ASEUtils.getString("INDEX_WIZ_QUES_NAME_INDEX"));
        }
    }
}

