/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.aseplugin.bo.wiz;

import com.sybase.aseplugin.ASEException;
import com.sybase.aseplugin.ASEImages;
import com.sybase.aseplugin.ASEMessageText;
import com.sybase.aseplugin.ASEUtils;
import com.sybase.aseplugin.bo.ASEBaseContainer2;
import com.sybase.aseplugin.bo.ASEProvider;
import com.sybase.aseplugin.bo.Support;
import com.sybase.aseplugin.bo.wiz.ASEBaseWizDocPage;
import com.sybase.aseplugin.bo.wiz.ASEBaseWizardDialog2;
import com.sybase.aseplugin.bo.wiz.SummaryWizBOPage;
import com.sybase.aseplugin.go.wiz.JavaWizGOInstallJavaPage;
import com.sybase.aseplugin.go.wiz.JavaWizGONamePage;
import com.sybase.aseplugin.so.JavaJarSO;
import com.sybase.aseplugin.so.SOItemInterface;
import com.sybase.central.SCContainer2;
import com.sybase.central.SCPageController;
import com.sybase.util.ds.Utils;
import java.awt.Container;
import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;

public class JavaWizard
extends ASEBaseWizardDialog2 {
    private JavaWizNamePage _namePage;
    private JavaWizSummaryPage _summaryPage;
    private JavaWizInstallJavaPage _instjPage;
    private JavaJarSO _jso = (JavaJarSO)this.getSO();

    public JavaWizard(JavaJarSO javaJarSO, SCContainer2 sCContainer2) {
        super((SOItemInterface)javaJarSO, sCContainer2, ASEUtils.getString("MSG_ADD_JAR"));
    }

    @Override
    public SCPageController[] getPages() {
        this._namePage = new JavaWizNamePage(this);
        this._instjPage = new JavaWizInstallJavaPage(this, this._jso.getInstallJavaCommand().toString());
        this._summaryPage = new JavaWizSummaryPage(this);
        return new SCPageController[]{this._namePage, this._instjPage, this._summaryPage};
    }

    @Override
    public boolean deploy() {
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        try {
            this._jso.setName(this._namePage.getJarName());
            Process process = this._jso.install(this._instjPage.getFileName(), this._namePage.getFileName(), this._namePage.doUpdate());
            if (process != null) {
                ASEUtils.handleProcess(process, stringBuffer, stringBuffer2);
            }
            ((ASEBaseContainer2)this.getParent()).refresh();
        }
        catch (IOException iOException) {
            Support.showDetailsError(this.getConnection(), this.getClass(), (Container)this.getJDialog(), iOException.getMessage(), iOException);
            return false;
        }
        if (stringBuffer2.toString().length() > 0) {
            Support.showDetailsError(this.getConnection(), this.getClass(), (Container)this.getJDialog(), stringBuffer2.toString(), new ASEException(stringBuffer2.toString()));
            return false;
        }
        if (stringBuffer.toString().length() > 0) {
            Support.showDetailsError(this.getConnection(), this.getClass(), (Container)this.getJDialog(), stringBuffer.toString(), new ASEException(stringBuffer.toString()));
            return false;
        }
        return true;
    }

    @Override
    public void releaseResources() {
        this._namePage = null;
        this._summaryPage = null;
        this._instjPage = null;
        this._jso = null;
        super.releaseResources();
    }

    class JavaWizSummaryPage
    extends SummaryWizBOPage {
        public JavaWizSummaryPage(JavaWizard javaWizard2) {
            super(javaWizard2, ASEImages.getJavaWizardImage());
            this.getGO().setDisplayPreviewButton(false);
            this.getGO().setDisplayScheduleButton(false);
        }

        @Override
        public void enableComponents() {
            this.clearSummaryItems();
            this.addSummaryItem(ASEUtils.getString("MSG_JAR_FILE_NAME"), JavaWizard.this._namePage.getFileName());
            this.addSummaryItem(ASEUtils.getString("MSG_JAR_NAME"), JavaWizard.this._namePage.getJarName());
            this.addSummaryItem(ASEUtils.getString("DISP_COMMAND_TEXT"), JavaWizard.this._jso.getInstallCommand(JavaWizard.this._instjPage.getFileName(), JavaWizard.this._namePage.getFileName(), JavaWizard.this._namePage.doUpdate()));
            this.setSummaryInfo(this.getSummary());
        }
    }

    class JavaWizInstallJavaPage
    extends ASEBaseWizDocPage {
        private JavaWizGOInstallJavaPage _go;
        private String _errorMsg;

        public JavaWizInstallJavaPage(JavaWizard javaWizard2, String string) {
            super(javaWizard2, (JPanel)((Object)new JavaWizGOInstallJavaPage()), new ASEMessageText(ASEUtils.getString("INDICATE_LOCATION"), string).toString());
            this._go = (JavaWizGOInstallJavaPage)((Object)this.getJPanel());
            this.getGO().setDisplayPreviewButton(false);
            this.getGO().setDisplayScheduleButton(false);
        }

        @Override
        public void init() {
            String string = ASEProvider.getSybasePath();
            this._go.utilFileNameEditor.setParentWindow(this.getJDialog());
            this._go.utilFileNameEditor.addDocumentListener(this);
            ASEMessageText aSEMessageText = new ASEMessageText(ASEUtils.getString("MSG_INSTJAVA_NOT_FOUND"));
            String string2 = Utils.getEnVariable((String)"SYBASE_OCS");
            Object[] objectArray = new Object[]{JavaWizard.this._jso.getInstallJavaCommand(), ASEUtils.OS_WINDOWS ? "%SYBASE%\\%SYBASE_OCS%\\bin" : "$SYBASE/$SYBASE_OCS/bin", ASEUtils.OS_WINDOWS ? "%SYBASE%" : "$SYBASE", "'" + string + "'", ASEUtils.OS_WINDOWS ? "%SYBASE_OCS%" : "$SYBASE_OCS", string2 == null ? string2 : "'" + string2 + "'"};
            aSEMessageText.setArguments(objectArray);
            this._go.messageMultiLineLabel.setText(aSEMessageText.toString());
            this._errorMsg = this._go.messageMultiLineLabel.getText();
            aSEMessageText = new ASEMessageText(ASEUtils.getString("MSG_SPECIFY_LOCATION"), JavaWizard.this._jso.getInstallJavaCommand());
            this._go.locationMultiLineLabel.setText(aSEMessageText.toString());
        }

        private boolean installJavaExists() {
            String string = JavaWizard.this._jso.getInstallJavaPath();
            boolean bl = string != null && string.length() > 0;
            return bl;
        }

        @Override
        public boolean showPage() {
            return !this.installJavaExists();
        }

        @Override
        public void textValueChanged(DocumentEvent documentEvent) {
            this.enableComponents();
        }

        @Override
        public void enableComponents() {
            String string = this.getFileName();
            boolean bl = string.length() > 0 && string.endsWith(JavaWizard.this._jso.getInstallJavaCommand());
            this._go.iconLabel.setVisible(!bl);
            String string2 = bl ? ASEUtils.getString("MSG_UTILITY_TO_BE_USED") : this._errorMsg;
            this._go.messageMultiLineLabel.setText(string2);
            this.enableNextButton(bl);
        }

        public String getFileName() {
            String string = this._go.utilFileNameEditor.getFileName();
            return string;
        }

        @Override
        public int onWizardNext() {
            File file = new File(this.getFileName());
            if (!file.exists() || !file.isFile()) {
                ASEMessageText aSEMessageText = new ASEMessageText(ASEUtils.getString("ERR_FILE_NOT_EXIST"), this.getFileName());
                Support.showError(this.getConnection(), this.getClass(), this.getJDialog(), aSEMessageText.toString());
                this._go.utilFileNameEditor.selectAll();
                return -1;
            }
            return 0;
        }

        @Override
        public void releaseResources() {
            this._go.utilFileNameEditor.removeDocumentListener(this);
            this._go.releaseResources();
            this._go = null;
            super.releaseResources();
        }
    }

    class JavaWizNamePage
    extends ASEBaseWizDocPage {
        private JavaWizGONamePage _go;
        private boolean _update;

        public JavaWizNamePage(JavaWizard javaWizard2) {
            super(javaWizard2, (JPanel)((Object)new JavaWizGONamePage()), ASEUtils.getString("MSG_JAR_FILE_LOCATION"));
            this._update = false;
            this._go = (JavaWizGONamePage)((Object)this.getJPanel());
            this.getGO().setDisplayPreviewButton(false);
            this.getGO().setDisplayScheduleButton(false);
        }

        private void showErrorMessage(String string) {
            this._go.messagePanel.setVisible(true);
            this._go.messageMultiLineLabel.setText(string);
            this._go.jarFileNameLabel.setEnabled(false);
            this._go.jarFileNameEditor.setEnabled(false);
            this._go.nameMultiLineLabel.setEnabled(false);
            this._go.nameTextField.setEnabled(false);
            this._go.welcomeTextMultiLineLabel.setEnabled(false);
        }

        private boolean isServerNameValid() {
            return !JavaWizard.this._jso.getConnection().hasAdHocServerName();
        }

        @Override
        public void init() {
            this._go.jarFileNameEditor.setParentWindow(this.getJDialog());
            this._go.nameTextField.getDocument().addDocumentListener(this);
            this._go.jarFileNameEditor.addDocumentListener(this);
        }

        @Override
        public void textValueChanged(DocumentEvent documentEvent) {
            Document document;
            Document document2 = documentEvent.getDocument();
            if (document2 == (document = this._go.jarFileNameEditor.getTextField().getDocument())) {
                File file = new File(this.getFileName());
                String string = file.getName();
                String string2 = string.toLowerCase();
                int n = string2.indexOf(".jar");
                String string3 = n == -1 ? Support.getIdFromFileName(string) : Support.getIdFromFileName(string.substring(0, n));
                this._go.nameTextField.setText(string3);
            }
            this.enableComponents();
        }

        @Override
        public void enableComponents() {
            ASEMessageText aSEMessageText;
            this._go.messagePanel.setVisible(false);
            String string = ASEProvider.getSybasePath();
            if (string == null) {
                aSEMessageText = new ASEMessageText(ASEUtils.getString("MSG_ENV_REQUIRED_FOR_EXTERNAL_UTILITY"), "SYBASE", JavaWizard.this._jso.getInstallJavaCommand());
                this.showErrorMessage(aSEMessageText.toString());
            } else if (!this.isServerNameValid()) {
                aSEMessageText = new ASEMessageText(ASEUtils.getString("MSG_NOT_VALID_SERVER_NAME_FOR_EXTERNAL_UTILITY"), JavaWizard.this._jso.getConnection().getServerName(), JavaWizard.this._jso.getInstallJavaCommand());
                String string2 = aSEMessageText.toString();
                if (!ASEUtils.OS_MAC_OS_X) {
                    string2 = string2 + ASEUtils.getString("MSG_DEFINE_SERVER_ENTRY");
                }
                this.showErrorMessage(string2);
            }
            boolean bl = this.getFileName().trim().length() > 0;
            boolean bl2 = this.getJarName().trim().length() > 0;
            boolean bl3 = bl && bl2 && this.isServerNameValid();
            this.enableNextButton(bl3);
            this.enableFinishButton(bl3);
            this.setPageModified(bl3);
        }

        @Override
        public int onWizardNext() {
            try {
                File file = new File(this.getFileName());
                if (!file.exists() || !file.isFile()) {
                    ASEMessageText aSEMessageText = new ASEMessageText(ASEUtils.getString("ERR_FILE_NOT_EXIST"), this.getFileName());
                    Support.showError(this.getConnection(), this.getClass(), this.getJDialog(), aSEMessageText.toString());
                    this._go.jarFileNameEditor.selectAll();
                    return -1;
                }
                JavaWizard.this._jso.setName(this.getJarName());
                boolean bl = Support.verifyObjectName(JavaWizard.this._jso, this.getJDialog(), (JTextComponent)((Object)this._go.nameTextField));
                if (!bl) {
                    return -1;
                }
                if (JavaWizard.this._jso.isJarInDB(this.getJarName())) {
                    ASEMessageText aSEMessageText = new ASEMessageText(ASEUtils.getString("MSG_JAR_EXIST"), this.getJarName());
                    int n = Support.showQuestionYesNoCancel(this.getJDialog(), aSEMessageText.toString());
                    if (n != 0) {
                        this._update = false;
                        return -1;
                    }
                    this._update = true;
                }
                return 0;
            }
            catch (SQLException sQLException) {
                Support.showDetailsError(this.getConnection(), this.getClass(), (Container)this.getJDialog(), sQLException.getMessage(), sQLException);
                return -1;
            }
        }

        public boolean doUpdate() {
            return this._update;
        }

        public String getFileName() {
            return this._go.jarFileNameEditor.getFileName();
        }

        public String getJarName() {
            return this._go.nameTextField.getText();
        }

        @Override
        public void releaseResources() {
            this._go.releaseResources();
            this._go = null;
            super.releaseResources();
        }
    }
}

