/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.aseplugin.bo.wiz;

import com.sybase.asa.ASAComboBox;
import com.sybase.asa.ASAIconTextData;
import com.sybase.aseplugin.ASEImages;
import com.sybase.aseplugin.ASEMessageText;
import com.sybase.aseplugin.ASEUtils;
import com.sybase.aseplugin.bo.DatabaseBO;
import com.sybase.aseplugin.bo.LoginsCtrBO;
import com.sybase.aseplugin.bo.Support;
import com.sybase.aseplugin.bo.wiz.ASEBaseWizDocPage;
import com.sybase.aseplugin.bo.wiz.ASEBaseWizardDialog2;
import com.sybase.aseplugin.bo.wiz.ASEBaseWizardPage2;
import com.sybase.aseplugin.bo.wiz.SummaryWizBOPage;
import com.sybase.aseplugin.go.wiz.LoginWizGODefaultPage;
import com.sybase.aseplugin.go.wiz.LoginWizGONamePage;
import com.sybase.aseplugin.go.wiz.LoginWizGOUsersPage;
import com.sybase.aseplugin.so.DatabaseSO;
import com.sybase.aseplugin.so.LoginSO;
import com.sybase.aseplugin.so.SOItemInterface;
import com.sybase.central.SCContainer2;
import com.sybase.central.SCPageController;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import java.util.List;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.text.JTextComponent;

public class LoginWizard
extends ASEBaseWizardDialog2 {
    private LoginWizDefaultPage _wizDefault;
    private LoginSO _lso;

    public LoginWizard(LoginSO loginSO, LoginsCtrBO loginsCtrBO) {
        super((SOItemInterface)loginSO, (SCContainer2)loginsCtrBO, ASEUtils.getString("MSG_ADD_LOGIN"));
        this._lso = loginSO;
    }

    @Override
    public SCPageController[] getPages() {
        SCPageController[] sCPageControllerArray = new SCPageController[4];
        sCPageControllerArray[0] = new LoginWizNamePage(this);
        this._wizDefault = new LoginWizDefaultPage(this);
        sCPageControllerArray[1] = this._wizDefault;
        sCPageControllerArray[2] = new LoginWizUsersPage(this);
        sCPageControllerArray[3] = new LoginWizSummaryPage(this);
        return sCPageControllerArray;
    }

    @Override
    public void releaseResources() {
        this._lso = null;
        super.releaseResources();
    }

    class LoginWizSummaryPage
    extends SummaryWizBOPage {
        public LoginWizSummaryPage(LoginWizard loginWizard2) {
            super(loginWizard2, ASEImages.getLoginWizardImage());
        }

        @Override
        public void enableComponents() {
            this.clearSummaryItems();
            this.addSummaryItem(ASEUtils.getString("MSG_LOGIN_NAME"), LoginWizard.this._lso.getName());
            this.addSummaryItem(ASEUtils.getString("MSG_FULL_NAME"), LoginWizard.this._lso.getFullName());
            this.addSummaryItem(ASEUtils.getString("MSG_DEFAULT_DATABASE_NAME"), LoginWizard.this._lso.getDefaultDatabase());
            this.addSummaryItem(ASEUtils.getString("MSG_DEFAULT_LANGUAGE"), LoginWizard.this._lso.getDefaultLanguage());
            String[] stringArray = LoginWizard.this._lso.getUserDBNames();
            if (stringArray.length > 0) {
                this.addSummaryItem();
                this.addSummaryItem(ASEUtils.getString("DNAME_USERS"), "");
                String[] stringArray2 = LoginWizard.this._lso.getUserNames();
                for (int i = 0; i < stringArray.length; ++i) {
                    this.addSummaryItem("    " + ASEUtils.getString("DISP_DATABASE_TEXT") + "/" + ASEUtils.getString("MSG_USER_NAME"), stringArray[i] + "/" + stringArray2[i]);
                }
            }
            this.setSummaryInfo(this.getSummary());
        }
    }

    class LoginWizUsersPage
    extends ASEBaseWizardPage2
    implements ActionListener {
        private LoginWizGOUsersPage _go;
        private boolean _isDefaultDBPreSelect;

        public LoginWizUsersPage(LoginWizard loginWizard2) {
            super(loginWizard2, (JPanel)((Object)new LoginWizGOUsersPage()), ASEUtils.getString("MSG_LOGIN_WIZ_PAGE3"));
            this._go = (LoginWizGOUsersPage)((Object)this.getJPanel());
            this._go.selectAllButton.addActionListener((ActionListener)this);
            this._go.clearAllButton.addActionListener((ActionListener)this);
        }

        @Override
        public void init() throws SQLException {
            int n = 0;
            List list = LoginWizard.this._lso.getAvailableDatabases();
            this._go.usersMultiCheckList.clear();
            for (DatabaseSO databaseSO : list) {
                ASAIconTextData aSAIconTextData = new ASAIconTextData((Icon)DatabaseBO.getIcon(databaseSO), databaseSO.getName());
                ASAComboBox aSAComboBox = new ASAComboBox();
                Vector vector = databaseSO.isSDCLocalTempDB() ? databaseSO.getAvailableUserGroups() : LoginWizard.this._lso.getAvailableUserGroups(databaseSO.getName());
                for (int i = 0; i < vector.size(); ++i) {
                    aSAComboBox.addItem(vector.elementAt(i));
                }
                aSAComboBox.setSelectedItem("public");
                this._go.usersMultiCheckList.addRow(new Object[]{aSAIconTextData, LoginWizard.this._lso.getName(), aSAComboBox});
                if (databaseSO.isSystem()) {
                    if (databaseSO.getName().equals("master")) {
                        this._go.usersMultiCheckList.setRowChecked(n, true);
                    } else {
                        this._go.usersMultiCheckList.setRowChecked(n, false);
                    }
                } else if (databaseSO.getName().startsWith("sybsys") || databaseSO.getName().equals("sybmgmtdb") || databaseSO.getOption("DB_OP_READ_ONLY")) {
                    this._go.usersMultiCheckList.setRowChecked(n, false);
                } else {
                    this._go.usersMultiCheckList.setRowChecked(n, true);
                }
                ++n;
            }
            this._go.usersMultiCheckList.setColumnWidthToFit(0);
        }

        @Override
        public void enableComponents() {
            this.enableFinishButton(true);
            if (this._go.usersMultiCheckList.getRowCount() == 0) {
                return;
            }
            int n = this._go.usersMultiCheckList.findRow(LoginWizard.this._wizDefault.getDefaultDatabase());
            this._isDefaultDBPreSelect = this._go.usersMultiCheckList.isRowChecked(n);
            if (!this._isDefaultDBPreSelect) {
                this._go.usersMultiCheckList.setRowChecked(n, true);
            }
            if (LoginWizard.this._lso.getName().equals(LoginWizard.this._lso.getTmpUserName())) {
                return;
            }
            LoginWizard.this._lso.setTmpUserName(LoginWizard.this._lso.getName());
            for (int i = 0; i < this._go.usersMultiCheckList.getRowCount(); ++i) {
                this._go.usersMultiCheckList.setValueAt((Object)LoginWizard.this._lso.getName(), i, 1);
            }
        }

        @Override
        public boolean onWizardBack() {
            if (!this._isDefaultDBPreSelect) {
                int n = this._go.usersMultiCheckList.findRow(LoginWizard.this._wizDefault.getDefaultDatabase());
                this._go.usersMultiCheckList.setRowChecked(n, false);
            }
            return true;
        }

        private void selectAllColumns() {
            this._go.usersMultiCheckList.checkAllRows();
        }

        private void clearAllColumns() {
            this._go.usersMultiCheckList.uncheckAllRows();
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == this._go.selectAllButton) {
                this.selectAllColumns();
            } else if (object == this._go.clearAllButton) {
                this.clearAllColumns();
            }
        }

        @Override
        public boolean deploy() {
            try {
                this._go.usersMultiCheckList.getCellEditor().stopCellEditing();
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            int[] nArray = this._go.usersMultiCheckList.getCheckedRows();
            int n = nArray.length;
            String[] stringArray = new String[n];
            String[] stringArray2 = new String[n];
            String[] stringArray3 = new String[n];
            for (int i = 0; i < n; ++i) {
                stringArray[i] = this._go.usersMultiCheckList.getStringAt(nArray[i], 0);
                stringArray2[i] = this._go.usersMultiCheckList.getStringAt(nArray[i], 1);
                stringArray3[i] = (String)((JComboBox)this._go.usersMultiCheckList.getValueAt(nArray[i], 2)).getSelectedItem();
            }
            LoginWizard.this._lso.setUserDBNames(stringArray);
            LoginWizard.this._lso.setUserNames(stringArray2);
            LoginWizard.this._lso.setUserGroups(stringArray3);
            return true;
        }

        @Override
        public void releaseResources() {
            this._go.selectAllButton.removeActionListener((ActionListener)this);
            this._go.clearAllButton.removeActionListener((ActionListener)this);
            this._go.releaseResources();
            this._go = null;
            super.releaseResources();
        }
    }

    class LoginWizDefaultPage
    extends ASEBaseWizardPage2 {
        private LoginWizGODefaultPage _go;

        public LoginWizDefaultPage(LoginWizard loginWizard2) {
            super(loginWizard2, (JPanel)((Object)new LoginWizGODefaultPage()), ASEUtils.getString("MSG_LOGIN_WIZ_PAGE2"));
            this._go = (LoginWizGODefaultPage)((Object)this.getJPanel());
        }

        @Override
        public void enableComponents() {
            this.enableFinishButton(true);
        }

        @Override
        public void init() throws SQLException {
            this.setAvailableDatabases();
            this.setAvailableLanguages();
            this.setAvailableAuthentications();
        }

        private void setAvailableDatabases() throws SQLException {
            List list = LoginWizard.this._lso.getAvailableDatabases();
            Support.initDatabaseDropdown(list, this._go.databaseComboBox, true);
        }

        private void setAvailableLanguages() throws SQLException {
            String[] stringArray = LoginWizard.this._lso.getAvailableLanguages();
            ImageIcon imageIcon = new ImageIcon(ASEImages.getFolderClosedImage());
            for (int i = 0; i < stringArray.length; ++i) {
                ASAIconTextData aSAIconTextData = new ASAIconTextData((Icon)imageIcon, stringArray[i]);
                this._go.languageComboBox.addItem((Object)aSAIconTextData);
            }
            String string = ((LoginSO)this.getSO()).getConnection().getLanguage();
            this._go.languageComboBox.setSelectedItem(string);
        }

        private void setAvailableAuthentications() throws SQLException {
            if (LoginWizard.this._lso.isPAMSupportApplicable()) {
                this._go.authenticationLabel.setVisible(true);
                this._go.authenticationComboBox.setVisible(true);
                Vector vector = LoginWizard.this._lso.getAvailableAuthentications();
                for (int i = 0; i < vector.size(); ++i) {
                    this._go.authenticationComboBox.addItem(vector.elementAt(i));
                }
            }
        }

        public String getFullName() {
            return this._go.fullNameTextField.getText();
        }

        public String getDefaultDatabase() {
            String string = "master";
            Object object = this._go.databaseComboBox.getSelectedItem();
            if (object != null) {
                string = object.toString();
            }
            return string;
        }

        public String getDefaultLanguage() {
            String string = "";
            Object object = this._go.languageComboBox.getSelectedItem();
            if (object != null) {
                string = object.toString();
            }
            return string;
        }

        private String getAuthMechanism() {
            String string = (String)this._go.authenticationComboBox.getSelectedItem();
            return string == null || string.equals("ANY") ? null : string;
        }

        @Override
        public boolean deploy() {
            LoginWizard.this._lso.setDefaultDatabase(this.getDefaultDatabase());
            LoginWizard.this._lso.setDefaultLanguage(this.getDefaultLanguage());
            LoginWizard.this._lso.setFullName(this.getFullName());
            LoginWizard.this._lso.setAuthMechanism(this.getAuthMechanism());
            return true;
        }

        @Override
        public void releaseResources() {
            this._go.releaseResources();
            this._go = null;
            super.releaseResources();
        }
    }

    class LoginWizNamePage
    extends ASEBaseWizDocPage {
        private LoginWizGONamePage _go;
        private int _minPasswdLength;

        public LoginWizNamePage(LoginWizard loginWizard2) {
            super(loginWizard2, (JPanel)((Object)new LoginWizGONamePage()), ASEUtils.getString("MSG_LOGIN_WIZ_PAGE1"));
            this._go = (LoginWizGONamePage)((Object)this.getJPanel());
            this._go.nameTextField.getDocument().addDocumentListener(this);
            this._go.passwordField.getDocument().addDocumentListener(this);
            this._go.confirmPasswordField.getDocument().addDocumentListener(this);
        }

        @Override
        public void init() throws SQLException {
            this._minPasswdLength = LoginWizard.this._lso.getConfigMinPasswordLength();
            ASEMessageText aSEMessageText = new ASEMessageText(ASEUtils.getString("LOGIN_PASSWORD_REQUIRE"), String.valueOf(this._minPasswdLength));
            this._go.passwordMultiLineLabel.setText(aSEMessageText.toString());
        }

        @Override
        public void textValueChanged(DocumentEvent documentEvent) {
            this.enableComponents();
        }

        @Override
        public void enableComponents() {
            boolean bl = this._go.nameTextField.getText().trim().length() > 0 && this.isPasswordOk();
            this.enableNextButton(bl);
            this.enableFinishButton(bl);
        }

        public String getLoginName() {
            return this._go.nameTextField.getText();
        }

        @Override
        public boolean deploy() {
            if (!this.isPasswordOk()) {
                if (this.getPassword().length() < 1) {
                    Support.showError(this.getConnection(), this.getClass(), this.getJDialog(), ASEUtils.getString("ERR_NEED_PASSWORD"));
                } else {
                    Support.showError(this.getConnection(), this.getClass(), this.getJDialog(), ASEUtils.getString("MSG_PASSWD_DONT_MATCH"));
                }
                return false;
            }
            LoginWizard.this._lso.setPassword(this.getPassword());
            String string = this.getLoginName();
            LoginWizard.this._lso.setName(string);
            try {
                boolean bl = Support.verifyObjectName(LoginWizard.this._lso, this.getJDialog(), (JTextComponent)((Object)this._go.nameTextField));
                return bl;
            }
            catch (SQLException sQLException) {
                Support.showDetailsError(this.getConnection(), this.getClass(), (Container)this.getJDialog(), sQLException.getMessage(), sQLException);
                return false;
            }
        }

        private boolean isPasswordOk() {
            return this.getPassword().equals(this.getConfirmation()) && this.getPassword().length() >= this._minPasswdLength;
        }

        String getPassword() {
            return new String(this._go.passwordField.getPassword());
        }

        private String getConfirmation() {
            return new String(this._go.confirmPasswordField.getPassword());
        }

        @Override
        public void releaseResources() {
            this._go.nameTextField.getDocument().removeDocumentListener(this);
            this._go.passwordField.getDocument().removeDocumentListener(this);
            this._go.confirmPasswordField.getDocument().removeDocumentListener(this);
            this._go.releaseResources();
            this._go = null;
            super.releaseResources();
        }
    }
}

